/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingBase;
import com.ibm.ws.webservices.engine.encoding.TypeMappingDelegate;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMappingRegistry;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.xml.rpc.encoding.TypeMapping;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private Hashtable mapTM = new Hashtable();
    private TypeMappingDelegate defaultDelTM = (TypeMappingDelegate)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

        public Object run() {
            if (Constants.URI_DEFAULT_SOAP_ENC.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
                return new TypeMappingDelegate(DefaultTypeMappingImpl.getSingleton());
            }
            return new TypeMappingDelegate(DefaultSOAP12TypeMappingImpl.getSingleton());
        }
    });

    public TypeMapping register(String string, TypeMapping typeMapping) {
        if (typeMapping == null || !(typeMapping instanceof TypeMappingBase)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (string == null) {
            throw new IllegalArgumentException(Messages.getMessage("nullNamespaceURI"));
        }
        TypeMappingDelegate typeMappingDelegate = (TypeMappingDelegate)this.mapTM.get(string);
        if (typeMappingDelegate == null) {
            typeMappingDelegate = new TypeMappingDelegate((TypeMappingBase)typeMapping);
            this.mapTM.put(string, typeMappingDelegate);
        } else {
            typeMappingDelegate.setDelegate((TypeMappingBase)typeMapping);
        }
        return null;
    }

    public void registerDefault(TypeMapping typeMapping) {
        if (typeMapping == null || !(typeMapping instanceof TypeMappingBase)) {
            throw new IllegalArgumentException(Messages.getMessage("badTypeMapping"));
        }
        if (this.defaultDelTM.getDelegate() instanceof TypeMappingDelegate) {
            throw new IllegalArgumentException(Messages.getMessage("defaultTypeMappingSet"));
        }
        this.defaultDelTM.setDelegate((TypeMappingBase)typeMapping);
    }

    public TypeMapping getTypeMapping(String string) {
        TypeMappingBase typeMappingBase = null;
        if (string != null) {
            typeMappingBase = (TypeMappingBase)this.mapTM.get(string);
        }
        TypeMappingBase typeMappingBase2 = null;
        if (typeMappingBase != null) {
            typeMappingBase2 = typeMappingBase.getDelegate();
        }
        if (typeMappingBase2 == null) {
            typeMappingBase2 = (TypeMappingBase)this.getDefaultTypeMapping();
        }
        return typeMappingBase2;
    }

    public TypeMapping unregisterTypeMapping(String string) {
        TypeMappingBase typeMappingBase = null;
        if (string != null) {
            typeMappingBase = (TypeMappingBase)this.mapTM.get(string);
        }
        TypeMappingBase typeMappingBase2 = null;
        if (typeMappingBase != null) {
            typeMappingBase2 = typeMappingBase.getDelegate();
            typeMappingBase.setDelegate(null);
        }
        return typeMappingBase2;
    }

    public boolean removeTypeMapping(TypeMapping typeMapping) {
        String[] stringArray = this.getRegisteredEncodingStyleURIs();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.getTypeMapping(stringArray[i]) != typeMapping) continue;
            bl = true;
            this.unregisterTypeMapping(stringArray[i]);
        }
        return bl;
    }

    public TypeMapping createTypeMapping() {
        return new TypeMappingImpl(this.defaultDelTM);
    }

    public String[] getRegisteredEncodingStyleURIs() {
        Set set = this.mapTM.keySet();
        if (set != null) {
            String[] stringArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = (String)iterator.next();
            }
            return stringArray;
        }
        return null;
    }

    public void clear() {
        this.mapTM.clear();
    }

    public TypeMapping getDefaultTypeMapping() {
        TypeMappingBase typeMappingBase;
        for (typeMappingBase = this.defaultDelTM; typeMappingBase != null && typeMappingBase instanceof TypeMappingDelegate; typeMappingBase = ((TypeMappingBase)typeMappingBase).getDelegate()) {
        }
        return typeMappingBase;
    }
}

