/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleValueSerializer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;

public class CalendarSerializer
implements SimpleValueSerializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    protected QName xmlType;
    protected Class javaType;

    public CalendarSerializer(Class clazz, QName qName) {
        this.xmlType = qName;
        this.javaType = clazz;
    }

    public void serialize(QName qName, Attributes attributes, Object object, SerializationContext serializationContext) throws IOException {
        serializationContext.getSerializationWriter().simpleElement(qName, attributes, this.getValueAsString(object, serializationContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueAsString(Object object, SerializationContext serializationContext) {
        Date date = object instanceof Date ? (Date)object : ((Calendar)object).getTime();
        SimpleDateFormat simpleDateFormat = zulu;
        synchronized (simpleDateFormat) {
            return zulu.format(date);
        }
    }

    public String getMechanismType() {
        return "WebServices SAX Mechanism";
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

