/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;

public class DateDeserializer
extends SimpleDeserializer {
    private static SimpleDateFormat zulu = new SimpleDateFormat("yyyy-MM-dd");
    private static Calendar calendar = Calendar.getInstance();

    public DateDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeValue(String string) {
        Date date;
        boolean bl = false;
        if (string != null) {
            if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '-') {
                string = string.substring(1);
                bl = true;
            }
            if (string.length() < 10) {
                throw new NumberFormatException(Messages.getMessage("badDate00", string));
            }
            if (string.charAt(4) != '-' || string.charAt(7) != '-') {
                throw new NumberFormatException(Messages.getMessage("badDate00", string));
            }
        }
        Calendar calendar = DateDeserializer.calendar;
        synchronized (calendar) {
            try {
                date = zulu.parse(string == null ? null : string.substring(0, 10));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.encoding.ser.DateDeserializer.makeValue", (String)"139", (Object)this);
                throw new NumberFormatException(exception.toString());
            }
            if (bl) {
                DateDeserializer.calendar.setTime(date);
                DateDeserializer.calendar.set(0, 0);
                date = DateDeserializer.calendar.getTime();
            }
        }
        return date;
    }
}

