/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PivotHandlerWrapper;
import com.ibm.ws.webservices.engine.SimpleChain;
import com.ibm.ws.webservices.engine.SimpleTargetedChain;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;

public class JAXRPCHandler
extends SimpleTargetedChain {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandler == null ? (class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandler = JAXRPCHandler.class$("com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler")) : class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandler).getName());
    public static final int MODE_CS_CLIENT = 1;
    public static final int MODE_CS_SERVER = 2;
    private int _modeClientServer = 0;
    private HandlerChain _handlerChain;
    private static final Set booleanOptions = new HashSet<String>(Arrays.asList("sendMultiRefs", "sendXsiTypes", "sendXMLDeclaration"));
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandler;

    public JAXRPCHandler() throws ConfigurationException {
        this(null, null, null);
    }

    public JAXRPCHandler(Handler handler2) {
        this(null, handler2, null);
    }

    public JAXRPCHandler(Handler handler2, Handler handler3, Handler handler4) {
        super(handler2, handler3, handler4);
    }

    public static Handler factory(Handler handler2, Handler handler3, Handler handler4, HandlerChain handlerChain, int n) {
        if (handler2 == null && handler4 == null && handlerChain == null) {
            return handler3;
        }
        JAXRPCHandler jAXRPCHandler = new JAXRPCHandler(handler2, handler3, handler4);
        jAXRPCHandler.setModeClientServer(n);
        if (handlerChain != null) {
            jAXRPCHandler.setHandlerChain(handlerChain);
        }
        return jAXRPCHandler;
    }

    protected final Handler adjustRequestHandler(Handler handler2) {
        Handler handler3 = super.adjustRequestHandler(handler2);
        if (this.getHandlerChain() == null) {
            return handler3;
        }
        if (this.getModeClientServer() == 2) {
            return SimpleChain.mergeHandlers(handler3, this.jaxrpcServerRequestHandler());
        }
        if (this.getModeClientServer() == 1) {
            return SimpleChain.mergeHandlers(this.jaxrpcClientRequestHandler(), handler3);
        }
        throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
    }

    protected final Handler adjustResponseHandler(Handler handler2) {
        Handler handler3 = super.adjustResponseHandler(handler2);
        if (this.getHandlerChain() == null) {
            return handler3;
        }
        if (this.getModeClientServer() == 2) {
            return SimpleChain.mergeHandlers(this.jaxrpcServerResponseHandler(), handler3);
        }
        if (this.getModeClientServer() == 1) {
            return SimpleChain.mergeHandlers(handler3, this.jaxrpcClientResponseHandler());
        }
        throw new InternalException(Messages.getMessage("soapport.csmode.undefined"));
    }

    public HandlerChain getHandlerChain() {
        return this._handlerChain;
    }

    public void setHandlerChain(HandlerChain handlerChain) {
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
        }
        this._handlerChain = handlerChain;
        this.resetAdjustedRequestHandler();
        this.resetAdjustedResponseHandler();
    }

    public Set getOptionsBooleanNames() {
        return booleanOptions;
    }

    private Handler jaxrpcServerRequestHandler() {
        return new PivotHandlerWrapper.BasicPreHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeServerRequestHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeServerFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcServerRequestHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeServerClosureHandler(messageContext);
            }

            public void preHandleIncoming(MessageContext messageContext) {
                JAXRPCHandler.this.invokeServerIncomingPreHandler(messageContext);
            }
        };
    }

    private Handler jaxrpcServerResponseHandler() {
        return new PivotHandlerWrapper.BasicPreHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeServerResponseHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeServerFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcServerResponseHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeServerClosureHandler(messageContext);
            }

            public void preHandleIncoming(MessageContext messageContext) {
            }
        };
    }

    private Handler jaxrpcClientRequestHandler() {
        return new PivotHandlerWrapper.BasicPreHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeClientRequestHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeClientFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcClientRequestHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeClientClosureHandler(messageContext);
            }

            public void preHandleIncoming(MessageContext messageContext) {
            }
        };
    }

    private Handler jaxrpcClientResponseHandler() {
        return new PivotHandlerWrapper.BasicPreHandler(){

            public void invoke(MessageContext messageContext) throws WebServicesFault {
                if (!JAXRPCHandler.this.invokeClientResponseHandler(messageContext)) {
                    messageContext.setMessagePath(3);
                }
            }

            public void onFault(MessageContext messageContext) {
                try {
                    if (!JAXRPCHandler.this.invokeClientFaultHandler(messageContext)) {
                        messageContext.setMessagePath(5);
                    }
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.JAXRPCHandler.jaxrpcClientResponseHandler", (String)"249", (Object)this);
                    messageContext.setMessagePath(5);
                    log.error((Object)Messages.getMessage("handlerRewindException01"));
                }
            }

            public void handleClosure(MessageContext messageContext) {
                JAXRPCHandler.this.invokeClientClosureHandler(messageContext);
            }

            public void preHandleIncoming(MessageContext messageContext) {
                JAXRPCHandler.this.invokeClientIncomingPreHandler(messageContext);
            }
        };
    }

    protected boolean invokeServerRequestHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleRequest(messageContext);
    }

    protected boolean invokeServerResponseHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleResponse(messageContext);
    }

    protected boolean invokeServerFaultHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleFault(messageContext);
    }

    protected void invokeServerClosureHandler(MessageContext messageContext) {
        this.getHandlerChain().handleClosure(messageContext);
    }

    protected void invokeServerIncomingPreHandler(MessageContext messageContext) {
        this.getHandlerChain().preHandleIncoming(messageContext);
    }

    protected boolean invokeClientRequestHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleRequest(messageContext);
    }

    protected boolean invokeClientResponseHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleResponse(messageContext);
    }

    protected boolean invokeClientFaultHandler(MessageContext messageContext) throws WebServicesFault {
        return this.getHandlerChain().handleFault(messageContext);
    }

    protected void invokeClientClosureHandler(MessageContext messageContext) {
        this.getHandlerChain().handleClosure(messageContext);
    }

    protected void invokeClientIncomingPreHandler(MessageContext messageContext) {
        this.getHandlerChain().preHandleIncoming(messageContext);
    }

    public void _destroy() {
        super._destroy();
        if (this._handlerChain != null) {
            this._handlerChain.destroy();
            this._handlerChain = null;
        }
    }

    public int getModeClientServer() {
        return this._modeClientServer;
    }

    public void setModeClientServer(int n) {
        this._modeClientServer = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

