/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.ExtendedHandlerInfo;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPool;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerPoolFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.wsspi.webservices.rpc.handler.Handler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class JAXRPCHandlerChain
extends AbstractList
implements HandlerChain {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandlerChain == null ? (class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandlerChain = JAXRPCHandlerChain.class$("com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain")) : class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandlerChain).getName());
    private List _handlerPools = new ArrayList();
    private static final Comparator qnameComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            String string = object == null ? "null" : object.toString();
            String string2 = object2 == null ? "null" : object2.toString();
            return string.compareTo(string2);
        }
    };
    private Collection _headerQNames = new TreeSet(qnameComparator);
    private Collection _roles;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCHandlerChain;
    static /* synthetic */ Class class$com$ibm$wsspi$webservices$rpc$handler$Handler;

    public JAXRPCHandlerChain(List list, Collection collection) {
        if (list != null) {
            this.addAll(list);
        }
        this._roles = collection;
    }

    public void destroy() {
        this.clear();
        this._handlerPools = null;
        this._headerQNames = null;
        this._roles = null;
    }

    public void preHandleIncoming(MessageContext messageContext) {
        boolean bl = false;
        String string = null;
        for (int i = 0; !bl && i < this._handlerPools.size(); ++i) {
            HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(i);
            string = handlerPool.getHandlerClassName();
            javax.xml.rpc.handler.Handler handler2 = handlerPool.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(string + ".preHandleIncoming()"));
                }
                if (handler2 instanceof SystemHandler) {
                    ((SystemHandler)handler2).preHandleIncoming(messageContext);
                }
                handlerPool.put(handler2);
                continue;
            }
            catch (SOAPFaultException sOAPFaultException) {
                FFDCFilter.processException((Throwable)sOAPFaultException, (String)"com.ibm.ws.webservices.engine.handlers.JAXRPCHandlerChain.preHandleIncoming", (String)"135", (Object)this);
                bl = true;
                handlerPool.put(handler2);
                throw sOAPFaultException;
            }
            catch (RuntimeException runtimeException) {
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.preHandleIncoming", (String)"228", (Object)this);
                bl = true;
                handlerPool.faulted(handler2);
                throw runtimeException;
            }
        }
    }

    public boolean handleRequest(MessageContext messageContext) throws WebServicesFault {
        Object object;
        boolean bl = true;
        boolean bl2 = false;
        Message message = null;
        String string = null;
        int n = 0;
        boolean bl3 = false;
        while (!bl2 && n < this._handlerPools.size()) {
            message = messageContext.getRequestMessage();
            object = (HandlerPool)this._handlerPools.get(n);
            string = ((HandlerPool)object).getHandlerClassName();
            boolean bl4 = ExtendedHandlerInfo.isFaultLocal(((HandlerPool)object).getOriginalInfo());
            bl3 = ExtendedHandlerInfo.isAutoResponse(((HandlerPool)object).getOriginalInfo());
            javax.xml.rpc.handler.Handler handler2 = ((HandlerPool)object).get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(string + ".handleRequest()"));
                }
                bl = handler2.handleRequest(messageContext);
                if (messageContext.isServer()) {
                    this.checkProtectedStateViolation(messageContext, string);
                }
                if (!bl) {
                    bl2 = true;
                } else {
                    ++n;
                }
                ((HandlerPool)object).put(handler2);
            }
            catch (SOAPFaultException sOAPFaultException) {
                FFDCFilter.processException((Throwable)sOAPFaultException, (String)"com.ibm.ws.webservices.engine.handlers.HandlerChain.handleRequest", (String)"135", (Object)this);
                bl2 = true;
                ((HandlerPool)object).put(handler2);
                this.handleSOAPException(messageContext, string, n, bl3, bl4, message, sOAPFaultException);
                throw sOAPFaultException;
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable;
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.handleRequest", (String)"228", (Object)this);
                bl2 = true;
                if (runtimeException instanceof JAXRPCException && (throwable = WebServicesFault.getRootCause(runtimeException)) instanceof WebServicesFault) {
                    ((HandlerPool)object).put(handler2);
                    this.handleSOAPException(messageContext, string, n, bl3, bl4, message, throwable);
                    throw (WebServicesFault)throwable;
                }
                ((HandlerPool)object).faulted(handler2);
                this.handleClosure(messageContext, n - 1);
                n = -1;
                if (messageContext.isServer()) {
                    this.handleRuntimeException(runtimeException, messageContext, string, "handleRequest");
                    continue;
                }
                throw WebServicesFault.makeFault(runtimeException);
            }
        }
        if (!bl) {
            if (bl3) {
                this.forceResponse(messageContext, message, string, false, null);
            }
            if (n >= 0) {
                if (messageContext.isOneWay()) {
                    this.handleClosure(messageContext, n);
                } else {
                    object = new LoopControls(n, -1);
                    this.oneHandleResponse(messageContext, (LoopControls)object);
                    if (!bl3) {
                        this.forceResponse(messageContext, message, string, true, null);
                    }
                    this.handleResponse(messageContext, (LoopControls)object);
                }
            }
        }
        return bl;
    }

    public void forceResponse(MessageContext messageContext, Message message, String string, boolean bl, Throwable throwable) throws MissingResourceException {
        messageContext.setPastPivot(true);
        if (!messageContext.isOneWay()) {
            Message message2 = messageContext.getRequestMessage();
            if (message2 == message) {
                if (messageContext.getResponseMessage() == null) {
                    if (bl) {
                        log.warn((Object)Messages.getMessage("jaxRpcHandlerMissingResponse00", string));
                    }
                    if (throwable == null) {
                        SOAPFactory sOAPFactory = new SOAPFactory(messageContext.getSOAPConstants());
                        try {
                            SOAPEnvelope sOAPEnvelope = sOAPFactory.createSOAPEnvelope(true);
                            Message message3 = new Message(sOAPEnvelope);
                            messageContext.setResponseMessage(message3);
                        }
                        catch (SOAPException sOAPException) {
                            log.warn((Object)Messages.getMessage("jaxRpcHandlerMissingResponse01"));
                        }
                    } else {
                        Message message4 = new Message(throwable);
                        messageContext.setResponseMessage(message4);
                    }
                }
            } else {
                messageContext.setResponseMessage(message2);
                messageContext.setRequestMessage(message);
            }
        }
    }

    protected void handleSOAPException(MessageContext messageContext, String string, int n, boolean bl, boolean bl2, Message message, Throwable throwable) throws WebServicesFault, MissingResourceException {
        if (messageContext.isServer()) {
            LoopControls loopControls = new LoopControls(n, -1);
            if (bl) {
                this.forceResponse(messageContext, message, string, false, throwable);
            }
            if (loopControls.idx() >= 0) {
                if (bl2) {
                    this.oneHandleFault(messageContext, loopControls);
                } else {
                    loopControls.next();
                }
            }
            if (!bl) {
                this.forceResponse(messageContext, message, string, true, throwable);
            }
            this.handleFault(messageContext, loopControls);
        } else {
            log.error((Object)Messages.getMessage("jaxRpcHandlerRequestClientFault00", string));
            this.handleClosure(messageContext, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRuntimeException(RuntimeException runtimeException, MessageContext messageContext, String string, String string2) throws WebServicesFault {
        log.error((Object)Messages.getMessage("jaxRpcHandlerServerRuntimeException00", string, string2), (Throwable)runtimeException);
        WebServicesFault webServicesFault = new WebServicesFault(QNameTable.createQName("http://schemas.xmlsoap.org/soap/envelope/", "Server.generalException"), Messages.getMessage("jaxRpcHandlerServerRuntimeException00", string, string2), string, null);
        if (!messageContext.isOneWay()) {
            Message message = messageContext.getResponseMessage();
            if (message != null) {
                String string3;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    message.writeTo(byteArrayOutputStream);
                    string3 = byteArrayOutputStream.toString();
                }
                catch (Exception exception) {
                    string3 = "!!responseMessage.writeTo() failed!!" + exception.toString();
                }
                finally {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                log.info((Object)Messages.getMessage("jaxRpcHandlerReplaceResponse00", string3));
            }
            message = new Message(webServicesFault);
            messageContext.setResponseMessage(message);
        }
        throw webServicesFault;
    }

    public boolean handleResponse(MessageContext messageContext) throws WebServicesFault {
        LoopControls loopControls = new LoopControls(this._handlerPools.size() - 1, -1);
        this.handleResponse(messageContext, loopControls);
        return loopControls.isResult();
    }

    private void handleResponse(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        while (!loopControls.isDone() && loopControls.idx() >= 0) {
            this.oneHandleResponse(messageContext, loopControls);
        }
    }

    private void oneHandleResponse(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        block10: {
            HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(loopControls.idx());
            String string = handlerPool.getHandlerClassName();
            javax.xml.rpc.handler.Handler handler2 = handlerPool.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(string + ".handleResponse()"));
                }
                loopControls.next();
                loopControls.setResult(handler2.handleResponse(messageContext));
                handlerPool.put(handler2);
                this.checkProtectedStateViolation(messageContext, string);
                if (!loopControls.isResult()) {
                    loopControls.setDone(true);
                    this.handleClosure(messageContext, loopControls);
                    break block10;
                }
                if (loopControls.isDone() || loopControls.idx() < 0) break block10;
                try {
                    if (messageContext.getResponseMessage().getFault() != null) {
                        this.handleFault(messageContext, loopControls);
                    }
                }
                catch (SOAPException sOAPException) {
                    FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.handler.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", (String)"722", null);
                    throw WebServicesFault.makeFault(sOAPException);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.handler.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", (String)"757", null);
                    throw WebServicesFault.makeFault(iOException);
                }
            }
            catch (RuntimeException runtimeException) {
                Throwable throwable;
                FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.oneHandleResponse", (String)"541", (Object)this);
                loopControls.setDone(true);
                if (runtimeException instanceof JAXRPCException && (throwable = WebServicesFault.getRootCause(runtimeException)) instanceof WebServicesFault) {
                    handlerPool.put(handler2);
                    this.handleClosure(messageContext, loopControls);
                    throw (WebServicesFault)throwable;
                }
                handlerPool.faulted(handler2);
                this.handleClosure(messageContext, loopControls);
                if (messageContext.isServer()) {
                    this.handleRuntimeException(runtimeException, messageContext, string, "handleResponse");
                }
                throw WebServicesFault.makeFault(runtimeException);
            }
        }
    }

    public void handleClosure(MessageContext messageContext) {
        this.handleClosure(messageContext, this._handlerPools.size() - 1);
    }

    public void handleClosure(MessageContext messageContext, LoopControls loopControls) {
        int n = loopControls.idx();
        loopControls.clear();
        this.handleClosure(messageContext, n);
    }

    private void handleClosure(MessageContext messageContext, int n) {
        for (int i = n; i >= 0; --i) {
            HandlerPool handlerPool;
            if (!(class$com$ibm$wsspi$webservices$rpc$handler$Handler == null ? JAXRPCHandlerChain.class$("com.ibm.wsspi.webservices.rpc.handler.Handler") : class$com$ibm$wsspi$webservices$rpc$handler$Handler).isAssignableFrom((handlerPool = (HandlerPool)this._handlerPools.get(i)).getHandlerClass())) continue;
            String string = handlerPool.getHandlerClassName();
            Handler handler2 = (Handler)handlerPool.get();
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(string + ".handleClosure()"));
                }
                handler2.handleClosure(messageContext);
                handlerPool.put(handler2);
                continue;
            }
            catch (RuntimeException runtimeException) {
                handlerPool.faulted(handler2);
            }
        }
    }

    public boolean handleFault(MessageContext messageContext) throws WebServicesFault {
        LoopControls loopControls = new LoopControls(this._handlerPools.size() - 1, -1);
        this.handleFault(messageContext, loopControls);
        return loopControls.isResult();
    }

    private void handleFault(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        while (!loopControls.isDone() && loopControls.idx() >= 0) {
            this.oneHandleFault(messageContext, loopControls);
        }
    }

    private void oneHandleFault(MessageContext messageContext, LoopControls loopControls) throws WebServicesFault {
        HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(loopControls.idx());
        String string = handlerPool.getHandlerClassName();
        javax.xml.rpc.handler.Handler handler2 = handlerPool.get();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(string + ".handleFault()"));
            }
            loopControls.next();
            loopControls.setResult(handler2.handleFault(messageContext));
            handlerPool.put(handler2);
            if (!loopControls.isResult()) {
                loopControls.setDone(true);
                this.handleClosure(messageContext, loopControls);
            }
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable;
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandlerChain.oneHandleFault", (String)"681", (Object)this);
            loopControls.setDone(true);
            if (runtimeException instanceof JAXRPCException && (throwable = WebServicesFault.getRootCause(runtimeException)) instanceof WebServicesFault) {
                handlerPool.put(handler2);
                this.handleClosure(messageContext, loopControls);
                throw (WebServicesFault)throwable;
            }
            handlerPool.faulted(handler2);
            this.handleClosure(messageContext, loopControls);
            if (messageContext.isServer()) {
                this.handleRuntimeException(runtimeException, messageContext, string, "handleFault");
            }
            throw WebServicesFault.makeFault(runtimeException);
        }
    }

    public Collection getRoles() {
        return this._roles;
    }

    public Collection getHeaderQNames() {
        return this._headerQNames;
    }

    protected void checkProtectedStateViolation(MessageContext messageContext, String string) throws SOAPFaultException {
    }

    private Object wrapObject(Object object) {
        if (object instanceof HandlerInfo) {
            HandlerInfo handlerInfo = (HandlerInfo)object;
            try {
                QName[] qNameArray = handlerInfo.getHeaders();
                if (qNameArray != null) {
                    for (int i = 0; i < qNameArray.length; ++i) {
                        this._headerQNames.add(qNameArray[i]);
                    }
                }
                return HandlerPoolFactory.createHandlerPool((HandlerInfo)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.handlers.HandlerChain.newHandlerPool", (String)"170");
                log.error((Object)Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString(), exception.getMessage()), (Throwable)exception);
                throw new JAXRPCException(Messages.getMessage("NoJAXRPCHandler00", handlerInfo.getHandlerClass().toString(), exception.getMessage()), exception);
            }
        }
        throw new JAXRPCException("Internal: improper element type '" + object.getClass().getName() + "' for JAXRPCHandlerChain");
    }

    public void add(int n, Object object) {
        this._handlerPools.add(n, this.wrapObject(object));
    }

    public Object get(int n) {
        return ((HandlerPool)this._handlerPools.get(n)).getOriginalInfo();
    }

    public Object remove(int n) {
        HandlerPool handlerPool = (HandlerPool)this._handlerPools.get(n);
        HandlerInfo handlerInfo = handlerPool.getOriginalInfo();
        handlerPool.destroy();
        this._handlerPools.remove(n);
        QName[] qNameArray = handlerInfo.getHeaders();
        if (qNameArray != null) {
            for (int i = 0; i < qNameArray.length; ++i) {
                this._headerQNames.remove(qNameArray[i]);
            }
        }
        return handlerInfo;
    }

    public Object set(int n, Object object) {
        return this._handlerPools.set(n, this.wrapObject(object));
    }

    public int size() {
        return this._handlerPools.size();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LoopControls {
        private boolean _done = false;
        private boolean _result = true;
        private int _idx;
        private int _dir;

        LoopControls(int n, int n2) {
            this._idx = n;
            this._dir = n2;
        }

        void clear() {
            this._idx = -1;
        }

        void setDone(boolean bl) {
            this._done = bl;
        }

        void setResult(boolean bl) {
            this._result = bl;
        }

        boolean isDone() {
            return this._done;
        }

        boolean isResult() {
            return this._result;
        }

        void next() {
            this._idx += this._dir;
        }

        int idx() {
            return this._idx;
        }
    }
}

