/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.handlers.jaxrpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.HandlerChain;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class JAXRPCSOAPHandler
extends JAXRPCHandler {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCSOAPHandler == null ? (class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCSOAPHandler = JAXRPCSOAPHandler.class$("com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler")) : class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCSOAPHandler).getName());
    private Set _actors = new TreeSet();
    private Collection _allActors;
    private Collection _allHeaderQNames;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$handlers$jaxrpc$JAXRPCSOAPHandler;

    public JAXRPCSOAPHandler() throws ConfigurationException {
        this(null, null, null);
    }

    public JAXRPCSOAPHandler(Handler handler2) {
        this(null, handler2, null);
    }

    public JAXRPCSOAPHandler(Handler handler2, Handler handler3, Handler handler4) {
        super(handler2, handler3, handler4);
    }

    public static Handler factory(Handler handler2, Handler handler3, Handler handler4, HandlerChain handlerChain) {
        if (handler2 == null && handler4 == null && handlerChain == null) {
            return handler3;
        }
        JAXRPCSOAPHandler jAXRPCSOAPHandler = new JAXRPCSOAPHandler(handler2, handler3, handler4);
        if (handlerChain != null) {
            jAXRPCSOAPHandler.setHandlerChain(handlerChain);
        }
        return jAXRPCSOAPHandler;
    }

    public Collection getActors() {
        return this._actors;
    }

    public void removeActor(String string) {
        this._actors.remove(string);
        this._allActors = null;
    }

    public void addActor(String string) {
        this._actors.add(string);
        this._allActors = null;
    }

    public Collection getAllActors() {
        if (this._allActors == null) {
            if (this.getHandlerChain() == null || this.getHandlerChain().getRoles() == null) {
                this._allActors = this.getActors();
            } else if (this.getActors() == null) {
                this._allActors = this.getHandlerChain().getRoles();
            } else {
                this._allActors = new TreeSet(this.getActors());
                this._allActors.addAll(this.getHandlerChain().getRoles());
            }
        }
        return this._allActors;
    }

    public Collection getAllHeaderQNames() {
        if (this._allHeaderQNames == null) {
            this._allHeaderQNames = this.getHandlerChain() != null && this.getHandlerChain().getHeaderQNames() != null ? this.getHandlerChain().getHeaderQNames() : new Vector();
        }
        return this._allHeaderQNames;
    }

    protected boolean invokeServerRequestHandler(MessageContext messageContext) throws WebServicesFault {
        this.checkSOAPSemantics(messageContext);
        return super.invokeServerRequestHandler(messageContext);
    }

    private void checkSOAPSemantics(MessageContext messageContext) throws WebServicesFault {
        Object object;
        Object object2;
        Serializable serializable;
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("semanticCheck00"));
        }
        Collection collection = this.getAllActors();
        Collection collection2 = this.getAllHeaderQNames();
        Vector<SOAPHeaderElement> vector = null;
        try {
            SOAPEnvelope sOAPEnvelope = messageContext.getRequestMessage().getSOAPEnvelope();
            serializable = ((SOAPHeader)sOAPEnvelope.getHeader()).getHeadersByActors(collection);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Actors: " + collection));
                log.debug((Object)("Headers: " + serializable));
            }
            object2 = ((Vector)serializable).elements();
            while (object2.hasMoreElements()) {
                object = (SOAPHeaderElement)object2.nextElement();
                if (!((SOAPHeaderElement)object).getMustUnderstand() || collection2.contains(((SOAPElement)object).getQName())) continue;
                if (vector == null) {
                    vector = new Vector<SOAPHeaderElement>();
                }
                vector.addElement((SOAPHeaderElement)object);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Misunderstood Header! " + object));
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", (String)"247", (Object)this);
            throw WebServicesFault.makeFault(sOAPException);
        }
        boolean bl = true;
        if (vector != null) {
            serializable = new WebServicesFault(Constants.FAULT_MUSTUNDERSTAND, null, null, null);
            object2 = new StringBuffer(256);
            if (bl) {
                object = vector.elements();
                while (object.hasMoreElements()) {
                    SOAPHeaderElement sOAPHeaderElement = (SOAPHeaderElement)object.nextElement();
                    if (((StringBuffer)object2).length() != 0) {
                        ((StringBuffer)object2).append(", ");
                    }
                    ((StringBuffer)object2).append(sOAPHeaderElement.getQName().toString());
                    SOAPHeaderElement sOAPHeaderElement2 = null;
                    try {
                        sOAPHeaderElement2 = sOAPHeaderElement.getSOAPFactory().createSOAPHeaderElement("http://www.w3.org/2002/06/soap-faults", "Misunderstood");
                    }
                    catch (SOAPException sOAPException) {
                        FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", (String)"278", (Object)this);
                        throw WebServicesFault.makeFault(sOAPException);
                    }
                    String string = null;
                    String string2 = sOAPHeaderElement.getLocalPart();
                    if (sOAPHeaderElement.getNamespaceURI().length() > 0) {
                        try {
                            string = sOAPHeaderElement.getPrefix();
                            sOAPHeaderElement2.addNamespaceDeclaration(string, sOAPHeaderElement.getNamespaceURI());
                        }
                        catch (SOAPException sOAPException) {
                            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCSOAPHandler.checkSOAPSemantics", (String)"292", (Object)this);
                            log.info((Object)Messages.getMessage("exception00", sOAPException.toString()));
                        }
                        string2 = string + ':' + string2;
                    }
                    sOAPHeaderElement2.addAttribute("", "qname", string2);
                    ((WebServicesFault)serializable).addHeader(sOAPHeaderElement2);
                }
            }
            ((WebServicesFault)serializable).setFaultString(Messages.getMessage("noUnderstand00", ((StringBuffer)object2).toString()));
            throw serializable;
        }
    }

    public void _destroy() {
        super._destroy();
        this._allActors = null;
        this._allHeaderQNames = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

