/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.server;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.PivotHandlerWrapper;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.configuration.EngineConfigurationFactoryFinder;
import com.ibm.ws.webservices.engine.handlers.WrappedHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.util.Map;
import org.apache.commons.logging.Log;

public class ServerEngine
extends WebServicesEngine {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$server$ServerEngine == null ? (class$com$ibm$ws$webservices$engine$server$ServerEngine = ServerEngine.class$("com.ibm.ws.webservices.engine.server.ServerEngine")) : class$com$ibm$ws$webservices$engine$server$ServerEngine).getName());
    private WebServicesEngine clientEngine;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$server$ServerEngine;

    public static ServerEngine getServer(Object object, Map map) throws WebServicesFault {
        log.debug((Object)"Enter: ServerEngine::getServer");
        ServerEngine serverEngine = null;
        try {
            EngineConfiguration engineConfiguration = ServerEngine.getEngineConfiguration(map);
            ServerEngine serverEngine2 = serverEngine = engineConfiguration == null ? new ServerEngine(object) : new ServerEngine(engineConfiguration);
            if (serverEngine != null && map != null) {
                serverEngine.setOptionDefault("attachments.Directory", (String)map.get("webservices.attachments.Directory"));
                serverEngine.setOptionDefault("attachments.Directory", (String)map.get("servlet.realpath"));
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.engine.server.ServerEngine.getServer", (String)"134");
            WebServicesFault.makeFault(throwable);
        }
        log.debug((Object)"Exit: ServerEngine::getServer");
        return serverEngine;
    }

    public ServerEngine() {
        this(EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig());
    }

    public ServerEngine(Object object) {
        this(EngineConfigurationFactoryFinder.newFactory(object).getServerEngineConfig());
    }

    public ServerEngine(EngineConfiguration engineConfiguration) {
        super(engineConfiguration == null ? EngineConfigurationFactoryFinder.newFactory().getServerEngineConfig() : engineConfiguration);
    }

    public synchronized WebServicesEngine getClientEngine() {
        if (this.clientEngine == null) {
            this.clientEngine = ClientEngineFactory.getEngine(true);
        }
        return this.clientEngine;
    }

    protected Handler createMessageFlow(MessageContext messageContext) throws WebServicesFault, ConfigurationException {
        Handler handler2 = new WrappedHandler(){

            public Handler getHandler(MessageContext messageContext) throws WebServicesFault {
                SOAPPort sOAPPort = messageContext.getPort();
                if (sOAPPort == null) {
                    Message message = messageContext.getRequestMessage();
                    message.getSOAPEnvelope();
                    sOAPPort = messageContext.getPort();
                    if (sOAPPort == null) {
                        throw new WebServicesFault("Server.NoService", Messages.getMessage("noService05", "" + messageContext.getTargetPortName()), null, null);
                    }
                }
                return sOAPPort;
            }
        };
        handler2 = PivotHandlerWrapper.factory(this.getGlobalHandler(), handler2);
        String string = messageContext.getTransportName();
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("transport01", "ServerEngine.invoke", string));
        }
        return PivotHandlerWrapper.factory(this.getTransport(string), handler2);
    }

    public boolean isServer() {
        return true;
    }

    private static EngineConfiguration getEngineConfiguration(Map map) {
        log.debug((Object)"Enter: DefaultServerEngineFactory::getEngineConfiguration");
        EngineConfiguration engineConfiguration = null;
        if (map != null) {
            try {
                engineConfiguration = (EngineConfiguration)map.get("engineConfig");
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webservices.engine.server.DefaultServerEngineFactory.getEngineConfiguration", (String)"173");
                log.warn((Object)Messages.getMessage("engineConfigWrongClass00"), (Throwable)classCastException);
            }
        }
        log.debug((Object)"Exit: DefaultServerEngineFactory::getEngineConfiguration");
        return engineConfiguration;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

