/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.WebServicesServiceHome;
import com.ibm.ws.webservices.component.WSClientImpl;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.BooleanHolder;
import com.ibm.ws.webservices.engine.components.net.DefaultSocketFactory;
import com.ibm.ws.webservices.engine.components.net.SocketFactory;
import com.ibm.ws.webservices.engine.components.net.SocketFactoryFactory;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientPropertiesFactory;
import com.ibm.ws.webservices.engine.encoding.Base64;
import com.ibm.ws.webservices.engine.enum.MessageType;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.transport.http.ChunkedInputStream;
import com.ibm.ws.webservices.engine.transport.http.ChunkedOutputStream;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.HTTPSessionContext;
import com.ibm.ws.webservices.engine.transport.http.SocketInputStream;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPrompt;
import com.ibm.ws.webservices.engine.transport.security.SecurityDataPromptFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public class HTTP11Sender
extends BasicHandler {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$transport$http$HTTP11Sender == null ? (class$com$ibm$ws$webservices$engine$transport$http$HTTP11Sender = HTTP11Sender.class$("com.ibm.ws.webservices.engine.transport.http.HTTP11Sender")) : class$com$ibm$ws$webservices$engine$transport$http$HTTP11Sender).getName());
    private static final boolean httpRedirectEnabledSysProp = Boolean.getBoolean(HTTPConstants.HTTP_302_ENABLED_PROP);
    private static final HashMap socketPoolFactoryMap = new HashMap();
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$http$HTTP11Sender;

    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("enter00", "HTTP11Sender::invoke"));
        }
        boolean bl = true;
        WrappedSocket wrappedSocket = null;
        try {
            URL uRL = new URL(messageContext.getStrProp(MessageContext.TRANS_URL));
            while (bl) {
                String string;
                int n;
                Hashtable hashtable;
                InputStream inputStream;
                block20: {
                    BooleanHolder booleanHolder = new BooleanHolder(false);
                    StringBuffer stringBuffer = new StringBuffer();
                    SocketPoolFactory socketPoolFactory = this.getSocketPoolFactory(uRL);
                    wrappedSocket = socketPoolFactory.obtainSocket(stringBuffer, booleanHolder);
                    if (messageContext.getTimeout() != 0) {
                        wrappedSocket.setSoTimeout(messageContext.getTimeout());
                    }
                    inputStream = null;
                    hashtable = new Hashtable();
                    n = -1;
                    try {
                        inputStream = this.writeToSocket(wrappedSocket, messageContext, uRL, stringBuffer, uRL.getHost(), uRL.getPort(), booleanHolder);
                        while (true) {
                            inputStream = this.readHeadersFromSocket(wrappedSocket, messageContext, inputStream, hashtable);
                            n = this.getStatusCode(messageContext);
                            if (n != 100 && n != 202) break;
                            hashtable.clear();
                            messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                            messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                        }
                        string = (String)hashtable.get("Connection");
                        if (string == null || !string.equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) break block20;
                        wrappedSocket.setAllowClose(true);
                    }
                    catch (SocketException socketException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage("socketException00", socketException.getMessage(), "HTTP11Sender::invoke"));
                        }
                        try {
                            wrappedSocket.destroy();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        wrappedSocket = null;
                        continue;
                    }
                }
                this.readFromSocket(wrappedSocket, messageContext, inputStream, n, hashtable);
                if (n == HTTPConstants.STATUS_CODE_302) {
                    string = messageContext.getStrProp(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                    if (JavaUtils.hasValue(string)) {
                        uRL = new URL(string);
                    } else {
                        bl = false;
                    }
                    messageContext.removeProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED);
                    continue;
                }
                if (n == HTTPConstants.STATUS_CODE_401) {
                    if (!((Boolean)messageContext.getProperty(HTTPConstants.HTTP_401_BASIC_AUTH_READY)).booleanValue()) {
                        bl = false;
                    }
                    messageContext.removeProperty(HTTPConstants.HTTP_401_BASIC_AUTH_READY);
                    continue;
                }
                bl = false;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.invoke", (String)"230", (Object)this);
            log.debug((Object)Messages.getMessage("exception01", exception.toString()));
            log.debug((Object)("URL = " + messageContext.getStrProp(MessageContext.TRANS_URL)));
            if (wrappedSocket != null) {
                try {
                    wrappedSocket.destroy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw WebServicesFault.makeFault(exception);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("exit00", "HTTP11Sender::invoke"));
        }
    }

    private Socket getSocket(URL uRL, StringBuffer stringBuffer, BooleanHolder booleanHolder) throws Exception {
        final SocketPoolFactory socketPoolFactory = this.getSocketPoolFactory(uRL);
        Socket socket = null;
        try {
            final StringBuffer stringBuffer2 = stringBuffer;
            final BooleanHolder booleanHolder2 = booleanHolder;
            socket = (Socket)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return socketPoolFactory.obtainSocket(stringBuffer2, booleanHolder2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.getSocket", (String)"191", (Object)this);
            throw privilegedActionException.getException();
        }
        return socket;
    }

    private InputStream writeToSocket(Socket socket, MessageContext messageContext, URL uRL, StringBuffer stringBuffer, String string, int n, BooleanHolder booleanHolder) throws IOException {
        Object object;
        Object object2;
        Map.Entry entry;
        Object object3;
        Serializable serializable;
        Object object4;
        String string2;
        Object object5 = messageContext.getUsername();
        String string3 = messageContext.getPassword();
        String string4 = string2 = messageContext.useSOAPAction() ? messageContext.getSOAPActionURI() : "";
        if (string2 == null) {
            string2 = "";
        }
        if (!JavaUtils.hasValue((String)object5) && uRL.getUserInfo() != null) {
            object4 = uRL.getUserInfo();
            int n2 = ((String)object4).indexOf(58);
            if (n2 >= 0 && n2 + 1 < ((String)object4).length()) {
                object5 = ((String)object4).substring(0, n2);
                string3 = ((String)object4).substring(n2 + 1);
            } else {
                object5 = object4;
            }
        }
        if (JavaUtils.hasValue((String)object5)) {
            object4 = new StringBuffer();
            ((StringBuffer)object4).append((String)object5).append(":").append(string3 == null ? "" : string3);
            stringBuffer.append("Authorization").append(": Basic ").append(Base64.encode(((StringBuffer)object4).toString().getBytes())).append("\r\n");
        }
        if (messageContext.getMaintainSession()) {
            object4 = messageContext.getProperty("com.ibm.ws.webservices.engine.session.context");
            String string5 = null;
            String string6 = null;
            if (object4 instanceof HTTPSessionContext) {
                serializable = (HTTPSessionContext)object4;
                string5 = ((HTTPSessionContext)serializable).getCookie();
                string6 = ((HTTPSessionContext)serializable).getCookie2();
            }
            if (string5 != null) {
                stringBuffer.append("Cookie").append(": ").append(string5).append("\r\n");
            }
            if (string6 != null) {
                stringBuffer.append("Cookie2").append(": ").append(string6).append("\r\n");
            }
        }
        object4 = new StringBuffer();
        String string7 = null;
        boolean bl = true;
        if (messageContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
            string7 = messageContext.getStrProp("soap12.webmethod");
        }
        if (string7 == null) {
            string7 = "POST";
        } else {
            bl = string7.equals("POST");
        }
        ((StringBuffer)object4).append(string7).append(" ");
        if (booleanHolder.value) {
            ((StringBuffer)object4).append(uRL.toExternalForm());
        } else {
            ((StringBuffer)object4).append(uRL.getFile() == null || uRL.getFile().equals("") ? "/" : uRL.getFile());
        }
        serializable = messageContext.getRequestMessage();
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        String string8 = null;
        String string9 = messageContext.getStrProp(MessageContext.HTTP_TRANSPORT_VERSION);
        if (null == string9) {
            string9 = HTTPConstants.HEADER_PROTOCOL_V10;
        }
        if ((string9 = string9.trim()).equals(HTTPConstants.HEADER_PROTOCOL_V11)) {
            bl2 = false;
        }
        bl2 = false;
        string9 = HTTPConstants.HEADER_PROTOCOL_V11;
        Hashtable hashtable = (Hashtable)messageContext.getProperty("HTTP-Request-Headers");
        if (hashtable != null) {
            if (null == stringBuffer) {
                stringBuffer = new StringBuffer(1024);
            }
            object3 = hashtable.entrySet().iterator();
            while (object3.hasNext()) {
                entry = object3.next();
                object2 = entry.getKey();
                if (null == object2) continue;
                String string10 = object2.toString().trim();
                if (string10.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING)) {
                    if (bl2 || null == (object = entry.getValue().toString()) || !((String)object).trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) continue;
                    bl3 = true;
                    continue;
                }
                if (string10.equalsIgnoreCase("Host") || string10.equalsIgnoreCase("Content-Type") || string10.equalsIgnoreCase("SOAPAction") || string10.equalsIgnoreCase("Content-Length") || string10.equalsIgnoreCase("Cookie") || string10.equalsIgnoreCase("Cookie2") || string10.equalsIgnoreCase("Authorization") || string10.equalsIgnoreCase("Proxy-Authorization")) continue;
                if (string10.equalsIgnoreCase("Connection")) {
                    if (bl2 || !((String)(object = entry.getValue().toString())).trim().equalsIgnoreCase(HTTPConstants.HEADER_CONNECTION_CLOSE)) continue;
                    string8 = HTTPConstants.HEADER_CONNECTION_CLOSE;
                    continue;
                }
                if (!bl2 && string10.equalsIgnoreCase("Expect") && null != (object = entry.getValue().toString()) && ((String)object).trim().equalsIgnoreCase("100-continue")) {
                    bl4 = true;
                }
                stringBuffer.append(string10).append(": ").append(entry.getValue()).append("\r\n");
            }
        }
        ((StringBuffer)object4).append(" ");
        ((StringBuffer)object4).append(bl2 ? "HTTP/1.0" : "HTTP/1.1").append("\r\n");
        if (bl) {
            ((StringBuffer)object4).append("Content-Type").append(": ").append(((Message)serializable).getContentType(messageContext.getSOAPConstants())).append("\r\n");
        }
        ((StringBuffer)object4).append("Accept").append(": ").append("application/soap+xml").append(", ").append("application/dime").append(", ").append("multipart/related").append(", ").append("text/*").append("\r\n").append("User-Agent").append(": ").append("IBM WebServices/1.0").append("\r\n").append("Host").append(": ").append(string).append(n == -1 ? "" : ":" + n).append("\r\n").append("Cache-Control").append(": ").append("no-cache").append("\r\n").append("Pragma").append(": ").append("no-cache").append("\r\n").append("SOAPAction").append(": \"").append(string2).append("\"\r\n");
        if (bl) {
            if (!bl3) {
                ((StringBuffer)object4).append("Content-Length").append(": ").append(((Message)serializable).getContentLength()).append("\r\n");
            } else {
                ((StringBuffer)object4).append(HTTPConstants.HEADER_TRANSFER_ENCODING).append(": ").append(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED).append("\r\n");
            }
        }
        if (null != string8) {
            ((StringBuffer)object4).append("Connection");
            ((StringBuffer)object4).append(": ");
            ((StringBuffer)object4).append(string8);
            ((StringBuffer)object4).append("\r\n");
        }
        if (null != stringBuffer) {
            ((StringBuffer)object4).append(stringBuffer.toString());
        }
        ((StringBuffer)object4).append("\r\n");
        object3 = null;
        try {
            entry = socket;
            object3 = (OutputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Socket)((Object)entry)){
                private final /* synthetic */ Socket val$finalsock;
                {
                    this.val$finalsock = socket;
                }

                public Object run() throws Exception {
                    return this.val$finalsock.getOutputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.writeToSocket", (String)"499", (Object)this);
            throw (IOException)privilegedActionException.getException();
        }
        if (!bl) {
            ((OutputStream)object3).write(((StringBuffer)object4).toString().getBytes("iso-8859-1"));
            ((OutputStream)object3).flush();
            return null;
        }
        entry = null;
        if (bl3) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"HTTP11Sender::writeToSocket chunked");
            }
            ((OutputStream)object3).write(((StringBuffer)object4).toString().getBytes("iso-8859-1"));
        }
        if (bl4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"HTTP11Sender::writeToSocket continueExpected");
            }
            ((OutputStream)object3).flush();
            object2 = new Hashtable();
            entry = this.readHeadersFromSocket(socket, messageContext, null, (Hashtable)object2);
            int n3 = -1;
            object = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
            if (null != object) {
                n3 = (Integer)object;
            }
            if (100 == n3) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"HTTP11Sender::writeToSocket: received 100 return code");
                }
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
                messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"HTTP11Sender::writeToSocket: did NOT receive 100 return code");
                }
                String string11 = (String)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                WebServicesFault webServicesFault = new WebServicesFault("HTTP", "(" + n3 + ")" + string11, null, null);
                webServicesFault.setFaultDetailString(Messages.getMessage("return01", "" + n3, ""));
                throw webServicesFault;
            }
        }
        if (bl3) {
            object2 = new ChunkedOutputStream((OutputStream)object3);
            try {
                ((Message)serializable).writeTo((OutputStream)object2);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.writeToSocket", (String)"455", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)sOAPException);
            }
            ((ChunkedOutputStream)object2).eos();
        } else {
            try {
                ((OutputStream)object3).write(((StringBuffer)object4).toString().getBytes("iso-8859-1"));
                ((Message)serializable).writeTo((OutputStream)object3);
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.writeToSocket", (String)"467", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)sOAPException);
            }
            ((OutputStream)object3).flush();
        }
        if (log.isDebugEnabled()) {
            String string12;
            object2 = new ByteArrayOutputStream();
            try {
                ((Message)serializable).writeTo((OutputStream)object2);
                string12 = ((ByteArrayOutputStream)object2).toString();
            }
            catch (SOAPException sOAPException) {
                string12 = "!!reqMessage.writeTo() failed!!" + sOAPException.toString();
            }
            log.debug((Object)Messages.getMessage("xmlSent00"));
            log.debug((Object)"---------------------------------------------------");
            log.debug((Object)(object4 + string12));
        }
        return entry;
    }

    private InputStream readHeadersFromSocket(Socket socket, MessageContext messageContext, InputStream inputStream, Hashtable hashtable) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
        }
        if (null == inputStream) {
            try {
                final Socket socket2 = socket;
                inputStream = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new BufferedInputStream(socket2.getInputStream());
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.readHeadersFromSocket", (String)"618", (Object)this);
                throw (IOException)privilegedActionException.getException();
            }
        }
        boolean bl = false;
        messageContext.removeProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
        while (true) {
            Object object;
            String string;
            String string2;
            if (!bl) {
                n = (byte)inputStream.read();
            }
            if (n == -1) break;
            bl = false;
            if (n != 13 && n != 10) {
                if (n == 58 && n3 == -1) {
                    n3 = n2;
                }
                ++n2;
                byteArrayOutputStream.write(n);
                continue;
            }
            if (n == 13) continue;
            if (n2 == 0) break;
            n = (byte)inputStream.read();
            bl = true;
            if (n == 32 || n == 9) continue;
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            if (n3 != -1) {
                string2 = new String(byArray, 0, n3, "iso-8859-1");
                string = new String(byArray, n3 + 1, n2 - 1 - n3, "iso-8859-1");
                n3 = -1;
            } else {
                string2 = new String(byArray, 0, n2, "iso-8859-1");
                string = "";
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(string2 + string));
            }
            if (messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE) == null) {
                int n5 = string2.indexOf(32) + 1;
                object = string2.substring(n5).trim();
                int n6 = ((String)object).indexOf(32);
                if (n6 != -1) {
                    object = ((String)object).substring(0, n6);
                }
                n4 = Integer.parseInt(object);
                messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_CODE, new Integer(n4));
                messageContext.setProperty(HTTPConstants.MC_HTTP_STATUS_MESSAGE, string2.substring(n5 + n6 + 1));
            } else {
                String string3 = string2.toLowerCase();
                if (string3.equalsIgnoreCase("Set-Cookie")) {
                    object = (Vector)hashtable.get(string3);
                    if (object == null) {
                        object = new Vector<String>();
                    }
                    ((Vector)object).add(string);
                    hashtable.put(string3, object);
                } else if (string3.equalsIgnoreCase("Set-Cookie2")) {
                    object = (Vector)hashtable.get(string3);
                    if (object == null) {
                        object = new Vector();
                    }
                    ((Vector)object).add(string);
                    hashtable.put(string3, object);
                } else {
                    hashtable.put(string2.toLowerCase(), string);
                }
            }
            if (string2.compareTo("Location") == 0 && string.compareTo(messageContext.getStrProp(MessageContext.TRANS_URL)) != 0 && this.isHttpRedirectEnabled(messageContext)) {
                messageContext.setProperty(MessageContext.TRANS_URL_HTTP_REDIRECTED, string);
            }
            if (string2.compareTo("WWW-Authenticate") == 0) {
                messageContext.setProperty("WWW-Authenticate", string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\"")));
            }
            n2 = 0;
        }
        return inputStream;
    }

    private int getStatusCode(MessageContext messageContext) throws SocketException {
        Integer n = (Integer)messageContext.getProperty(HTTPConstants.MC_HTTP_STATUS_CODE);
        if (n == null) {
            throw new SocketException("unable to read response code");
        }
        return n;
    }

    private void readFromSocket(Socket socket, MessageContext messageContext, InputStream inputStream, int n, Hashtable hashtable) throws IOException {
        String string;
        String string2;
        Message message = null;
        String string3 = (String)hashtable.get("Content-Type".toLowerCase());
        String string4 = string3 = null == string3 ? null : string3.trim();
        if (!(n > 199 && n < 300 || string3 != null && !string3.startsWith("text/html") && n > 499 && n < 600)) {
            if (n == HTTPConstants.STATUS_CODE_302 && this.isHttpRedirectEnabled(messageContext)) {
                log.debug((Object)"HTTP redirect enabled for status code 302.");
            } else if (n == HTTPConstants.STATUS_CODE_401 && WebServicesServiceHome.getWebServicesService() instanceof WSClientImpl) {
                if (!this.getHTTPBasicAuth(messageContext)) {
                    byte by;
                    log.debug((Object)Messages.getMessage("challengeStatus02"));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
                    while (-1 != (by = (byte)inputStream.read())) {
                        byteArrayOutputStream.write(by);
                    }
                    String string5 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                    WebServicesFault webServicesFault = new WebServicesFault("HTTP", "(" + n + ")" + string5, null, null);
                    webServicesFault.setFaultDetailString(Messages.getMessage("return01", "" + n, byteArrayOutputStream.toString()));
                    throw webServicesFault;
                }
                log.debug((Object)Messages.getMessage("challengeStatus01"));
            } else {
                byte by;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4097);
                while (-1 != (by = (byte)inputStream.read())) {
                    byteArrayOutputStream.write(by);
                }
                String string6 = messageContext.getStrProp(HTTPConstants.MC_HTTP_STATUS_MESSAGE);
                WebServicesFault webServicesFault = new WebServicesFault("HTTP", "(" + n + ")" + string6, null, null);
                webServicesFault.setFaultDetailString(Messages.getMessage("return01", "" + n, byteArrayOutputStream.toString()));
                throw webServicesFault;
            }
        }
        string2 = null == (string2 = (String)hashtable.get("Content-Location".toLowerCase())) ? null : string2.trim();
        String string7 = (String)hashtable.get("Content-Length".toLowerCase());
        string7 = null == string7 ? null : string7.trim();
        String string8 = (String)hashtable.get(HTTPConstants.HEADER_TRANSFER_ENCODING.toLowerCase());
        if (null != string8 && string8.trim().equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
            inputStream = new ChunkedInputStream(inputStream);
        }
        SocketInputStream socketInputStream = new SocketInputStream(inputStream, socket);
        if (string7 != null) {
            socketInputStream.setContentLength(Math.max(0, Integer.parseInt(string7)));
        }
        message = new Message(socketInputStream, false, string3, string2);
        message.setMessageType(MessageType.RESPONSE);
        messageContext.setResponseMessage(message);
        if (log.isDebugEnabled()) {
            string = message.getSOAPPartAsString();
            if (null == string7) {
                log.debug((Object)("\n" + Messages.getMessage("no00", "Content-Length")));
            }
            log.debug((Object)("\n" + Messages.getMessage("xmlRecd00")));
            log.debug((Object)"-----------------------------------------------");
            log.debug((Object)string);
        }
        if (messageContext.getMaintainSession()) {
            string = this.getCookieFromHeaders("Cookie", "Set-Cookie", hashtable);
            String string9 = this.getCookieFromHeaders("Cookie2", "Set-Cookie2", hashtable);
            if (string != null || string9 != null) {
                HTTPSessionContext hTTPSessionContext = new HTTPSessionContext(string, string9);
                messageContext.setProperty("com.ibm.ws.webservices.engine.session.context", hTTPSessionContext);
            }
        }
    }

    public String getCookieFromHeaders(String string, String string2, Hashtable hashtable) {
        String string3 = string2.toLowerCase();
        String string4 = null;
        if (hashtable.containsKey(string3)) {
            Object v = hashtable.get(string3);
            if (v instanceof String) {
                string4 = (String)v;
                int n = (string4 = string4.trim()).indexOf(59);
                if (n != -1) {
                    string4 = string4.substring(0, n);
                }
            } else if (v instanceof Vector) {
                Vector vector = (Vector)hashtable.get(string3);
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = vector.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    string4 = ((String)iterator.next()).trim();
                    n = string4.indexOf(59);
                    if (n != -1) {
                        string4 = string4.substring(0, n);
                    }
                    stringBuffer.append(string4).append(";");
                }
                string4 = stringBuffer != null && stringBuffer.length() != 0 ? stringBuffer.toString() : null;
            }
        }
        return string4;
    }

    private boolean isHttpRedirectEnabled(MessageContext messageContext) {
        Boolean bl = (Boolean)messageContext.getProperty("http.redirect.enabled");
        if (bl == null) {
            return httpRedirectEnabledSysProp;
        }
        return bl;
    }

    private boolean getHTTPBasicAuth(MessageContext messageContext) {
        boolean bl;
        block8: {
            bl = false;
            if (!JavaUtils.hasValue(messageContext.getUsername()) && !JavaUtils.hasValue(messageContext.getPassword())) {
                String string = System.getProperty(HTTPConstants.LOGIN_SOURCE);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(HTTPConstants.LOGIN_SOURCE + ": " + string));
                }
                try {
                    if (!JavaUtils.hasValue(string) || "prompt".compareToIgnoreCase(string) != 0 && "stdin".compareToIgnoreCase(string) != 0) break block8;
                    SecurityDataPrompt securityDataPrompt = SecurityDataPromptFactory.getPrompt(string);
                    String[] stringArray = null;
                    try {
                        final String string2 = messageContext.getStrProp("WWW-Authenticate");
                        final SecurityDataPrompt securityDataPrompt2 = securityDataPrompt;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)Messages.getMessage("challengeRealmInfo", string2));
                        }
                        stringArray = (String[])AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                return securityDataPrompt2.launch(string2 == null ? "" : string2);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.getHTTPBasicAuth", (String)"973", (Object)this);
                        log.debug((Object)privilegedActionException);
                        throw privilegedActionException.getException();
                    }
                    if (stringArray != null && JavaUtils.hasValue(stringArray[0]) && JavaUtils.hasValue(stringArray[1])) {
                        messageContext.setUsername(stringArray[0]);
                        messageContext.setPassword(stringArray[1]);
                        messageContext.setProperty(HTTPConstants.HTTP_401_BASIC_AUTH_READY, Boolean.TRUE);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.getHTTPBasicAuth", (String)"988", (Object)this);
                    log.debug((Object)Messages.getMessage("exception01", exception.toString()));
                }
            }
        }
        messageContext.removeProperty("WWW-Authenticate");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketPoolFactory getSocketPoolFactory(URL uRL) {
        String string;
        String string2;
        TransportClientProperties transportClientProperties = TransportClientPropertiesFactory.create(uRL.getProtocol());
        if (transportClientProperties.getProxyHost().length() == 0 || transportClientProperties.getProxyPort().length() == 0 || DefaultSocketFactory.isHostInNonProxyList(uRL.getHost(), transportClientProperties.getNonProxyHosts())) {
            string2 = uRL.getHost();
            string = String.valueOf(uRL.getPort());
        } else {
            string2 = transportClientProperties.getProxyHost();
            string = transportClientProperties.getProxyPort();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(uRL.getProtocol()).append(":").append(string2).append(":").append(string);
        String string3 = stringBuffer.toString();
        HashMap hashMap = socketPoolFactoryMap;
        synchronized (hashMap) {
            SocketPoolFactory socketPoolFactory = (SocketPoolFactory)socketPoolFactoryMap.get(string3);
            if (socketPoolFactory == null) {
                socketPoolFactory = new SocketPoolFactory(uRL);
                socketPoolFactoryMap.put(string3, socketPoolFactory);
            }
            return socketPoolFactory;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SocketPoolFactory {
        private SocketFactory factory;
        private String host;
        private int port;
        private final ArrayList pool = new ArrayList();

        public SocketPoolFactory(URL uRL) {
            this.factory = SocketFactoryFactory.getFactory(uRL.getProtocol(), HTTP11Sender.this.getOptions());
            this.host = uRL.getHost();
            this.port = uRL.getPort();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WrappedSocket obtainSocket(StringBuffer stringBuffer, BooleanHolder booleanHolder) throws Exception {
            WrappedSocket wrappedSocket = null;
            Serializable serializable = this.pool;
            synchronized (serializable) {
                while (this.pool.size() > 0) {
                    wrappedSocket = (WrappedSocket)this.pool.remove(this.pool.size() - 1);
                    if (wrappedSocket.isWrapperOpen()) {
                        throw new RuntimeException("socket is already open");
                    }
                    try {
                        wrappedSocket.setSoTimeout(0);
                        wrappedSocket.setWrapperOpen(true);
                        wrappedSocket.setFresh(false);
                        return wrappedSocket;
                    }
                    catch (IOException iOException) {
                        try {
                            wrappedSocket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        wrappedSocket = null;
                    }
                }
            }
            try {
                serializable = stringBuffer;
                BooleanHolder booleanHolder2 = booleanHolder;
                SocketPoolFactory socketPoolFactory = this;
                wrappedSocket = (WrappedSocket)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(this, (StringBuffer)serializable, booleanHolder2, socketPoolFactory){
                    private final /* synthetic */ StringBuffer val$finalotherHeaders;
                    private final /* synthetic */ BooleanHolder val$finaluseFullURL;
                    private final /* synthetic */ SocketPoolFactory val$spf;
                    private final /* synthetic */ SocketPoolFactory this$1;
                    {
                        this.this$1 = socketPoolFactory;
                        this.val$finalotherHeaders = stringBuffer;
                        this.val$finaluseFullURL = booleanHolder;
                        this.val$spf = socketPoolFactory2;
                    }

                    public Object run() throws Exception {
                        return SocketPoolFactory.access$300(this.this$1).new WrappedSocket(SocketPoolFactory.access$200(this.this$1).create(SocketPoolFactory.access$000(this.this$1), SocketPoolFactory.access$100(this.this$1), this.val$finalotherHeaders, this.val$finaluseFullURL), this.val$spf);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.webservices.engine.transport.http.HTTPSender.getSocket", (String)"191", (Object)this);
                throw privilegedActionException.getException();
            }
            return wrappedSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void releaseSocket(WrappedSocket wrappedSocket) {
            if (wrappedSocket.isWrapperOpen()) {
                throw new RuntimeException("socket is still open");
            }
            ArrayList arrayList = this.pool;
            synchronized (arrayList) {
                this.pool.add(wrappedSocket);
            }
        }

        static /* synthetic */ String access$000(SocketPoolFactory socketPoolFactory) {
            return socketPoolFactory.host;
        }

        static /* synthetic */ int access$100(SocketPoolFactory socketPoolFactory) {
            return socketPoolFactory.port;
        }

        static /* synthetic */ SocketFactory access$200(SocketPoolFactory socketPoolFactory) {
            return socketPoolFactory.factory;
        }

        static /* synthetic */ HTTP11Sender access$300(SocketPoolFactory socketPoolFactory) {
            return socketPoolFactory.HTTP11Sender.this;
        }
    }

    public class HTTP11OutputStream
    extends BufferedOutputStream {
        private WrappedSocket socket;

        public HTTP11OutputStream(WrappedSocket wrappedSocket, OutputStream outputStream) {
            super(outputStream, 8192);
            this.socket = wrappedSocket;
        }

        public void close() throws IOException {
            if (this.socket.getAllowClose()) {
                this.out.close();
            } else {
                this.flush();
            }
        }

        public boolean fromPooledSocket() {
            return !this.socket.isFresh();
        }
    }

    public class HTTP11InputStream
    extends FilterInputStream {
        private WrappedSocket socket;

        public HTTP11InputStream(WrappedSocket wrappedSocket, InputStream inputStream) {
            super(inputStream);
            this.socket = wrappedSocket;
        }

        public void close() throws IOException {
            if (this.socket.getAllowClose()) {
                this.in.close();
            }
        }
    }

    private class WrappedSocket
    extends Socket {
        private SocketPoolFactory spf;
        private Socket socket;
        private HTTP11InputStream inStream;
        private HTTP11OutputStream outStream;
        private boolean allowClose;
        private boolean wrapperOpen;
        private boolean fresh = true;

        public WrappedSocket(Socket socket, SocketPoolFactory socketPoolFactory) throws IOException {
            this.socket = socket;
            this.spf = socketPoolFactory;
            this.allowClose = false;
            this.inStream = new HTTP11InputStream(this, socket.getInputStream());
            this.outStream = new HTTP11OutputStream(this, socket.getOutputStream());
            this.wrapperOpen = true;
        }

        public boolean getAllowClose() {
            return this.allowClose;
        }

        public void setAllowClose(boolean bl) {
            this.allowClose = bl;
        }

        public boolean isWrapperOpen() {
            return this.wrapperOpen;
        }

        public void setWrapperOpen(boolean bl) {
            this.wrapperOpen = bl;
        }

        public InputStream getInputStream() throws IOException {
            return this.inStream;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.outStream;
        }

        public void close() throws IOException {
            if (this.allowClose) {
                try {
                    this.inStream.close();
                }
                catch (Throwable throwable) {
                    this.inStream = null;
                }
                try {
                    this.outStream.close();
                }
                catch (Throwable throwable) {
                    this.outStream = null;
                }
                this.socket.close();
            } else if (this.isWrapperOpen()) {
                this.setWrapperOpen(false);
                this.spf.releaseSocket(this);
            }
        }

        public void destroy() throws IOException {
            this.setAllowClose(true);
            this.close();
        }

        public void connect(SocketAddress socketAddress) throws IOException {
            this.socket.connect(socketAddress);
        }

        public void connect(SocketAddress socketAddress, int n) throws IOException {
            this.socket.connect(socketAddress, n);
        }

        public void bind(SocketAddress socketAddress) throws IOException {
            this.socket.bind(socketAddress);
        }

        public InetAddress getInetAddress() {
            return this.socket.getInetAddress();
        }

        public InetAddress getLocalAddress() {
            return this.socket.getLocalAddress();
        }

        public int getPort() {
            return this.socket.getPort();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public SocketAddress getRemoteSocketAddress() {
            return this.socket.getRemoteSocketAddress();
        }

        public SocketAddress getLocalSocketAddress() {
            return this.socket.getLocalSocketAddress();
        }

        public SocketChannel getChannel() {
            return this.socket.getChannel();
        }

        public void setTcpNoDelay(boolean bl) throws SocketException {
            this.socket.setTcpNoDelay(bl);
        }

        public boolean getTcpNoDelay() throws SocketException {
            return this.socket.getTcpNoDelay();
        }

        public void setSoLinger(boolean bl, int n) throws SocketException {
            this.socket.setSoLinger(bl, n);
        }

        public int getSoLinger() throws SocketException {
            return this.socket.getSoLinger();
        }

        public void setOOBInline(boolean bl) throws SocketException {
            this.socket.setOOBInline(bl);
        }

        public void setSoTimeout(int n) throws SocketException {
            this.socket.setSoTimeout(n);
        }

        public int getSoTimeout() throws SocketException {
            return this.socket.getSoTimeout();
        }

        public void setSendBufferSize(int n) throws SocketException {
            this.socket.setSendBufferSize(n);
        }

        public int getSendBufferSize() throws SocketException {
            return this.socket.getSendBufferSize();
        }

        public void setReceiveBufferSize(int n) throws SocketException {
            this.socket.setReceiveBufferSize(n);
        }

        public int getReceiveBufferSize() throws SocketException {
            return this.socket.getReceiveBufferSize();
        }

        public void setKeepAlive(boolean bl) throws SocketException {
            this.socket.setKeepAlive(bl);
        }

        public boolean getKeepAlive() throws SocketException {
            return this.socket.getKeepAlive();
        }

        public void setTrafficClass(int n) throws SocketException {
            this.socket.setTrafficClass(n);
        }

        public int getTrafficClass() throws SocketException {
            return this.socket.getTrafficClass();
        }

        public void setReuseAddress(boolean bl) throws SocketException {
            this.socket.setReuseAddress(bl);
        }

        public boolean getReuseAddress() throws SocketException {
            return this.socket.getReuseAddress();
        }

        public void shutdownInput() throws IOException {
            if (this.allowClose) {
                this.socket.shutdownInput();
            }
        }

        public void shutdownOutput() throws IOException {
            if (this.allowClose) {
                this.socket.shutdownOutput();
            }
        }

        public String toString() {
            return this.socket.toString();
        }

        public boolean isConnected() {
            return this.socket.isConnected();
        }

        public boolean isBound() {
            return this.socket.isBound();
        }

        public boolean isClosed() {
            return this.socket.isClosed();
        }

        public boolean isInputShutdown() {
            return this.socket.isInputShutdown();
        }

        public boolean isOutputShutdown() {
            return this.socket.isOutputShutdown();
        }

        public boolean isFresh() {
            return this.fresh;
        }

        public void setFresh(boolean bl) {
            this.fresh = bl;
        }
    }
}

