/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SocketInputStream
extends FilterInputStream {
    protected volatile boolean closed = false;
    Socket socket = null;
    public static final int NO_CONTENT_LENGTH = -1;
    protected int contentRemaining = -1;

    private SocketInputStream() {
        super(null);
    }

    public SocketInputStream(InputStream inputStream, Socket socket) {
        super(inputStream);
        this.socket = socket;
    }

    public void setContentLength(int n) {
        this.contentRemaining = n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.contentRemaining < 0) {
            return super.read(byArray, n, n2);
        }
        if (this.contentRemaining == 0) {
            return -1;
        }
        n2 = Math.min(n2, this.contentRemaining);
        if ((n2 = super.read(byArray, n, n2)) > 0) {
            this.contentRemaining -= n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        SocketInputStream socketInputStream = this;
        synchronized (socketInputStream) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.in.close();
        this.in = null;
        this.socket.close();
        this.socket = null;
    }
}

