/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.http;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.deploy.PublishWSDLInfo;
import com.ibm.ws.webservices.engine.ConfigurationException;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesEngine;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.PortDesc;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.security.servlet.ServletSecurityProvider;
import com.ibm.ws.webservices.engine.server.ServerEngine;
import com.ibm.ws.webservices.engine.transport.http.HTTPConstants;
import com.ibm.ws.webservices.engine.transport.http.ServletEndpointContextImpl;
import com.ibm.ws.webservices.engine.transport.http.WebServicesHttpSession;
import com.ibm.ws.webservices.engine.transport.http.WebServicesServletBase;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.wsdl.WSDLException;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;

public class WebServicesServlet
extends WebServicesServletBase
implements MessageContext.OneWayListener {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$transport$http$WebServicesServlet == null ? (class$com$ibm$ws$webservices$engine$transport$http$WebServicesServlet = WebServicesServlet.class$("com.ibm.ws.webservices.engine.transport.http.WebServicesServlet")) : class$com$ibm$ws$webservices$engine$transport$http$WebServicesServlet).getName());
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "webservices.enableListQuery";
    public static final String INIT_PROPERTY_JWS_CLASS_DIR = "webservices.jws.servletClassDir";
    private String transportName;
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug = false;
    private boolean enableList = false;
    private String jwsClassDir = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$http$WebServicesServlet;

    protected String getJWSClassDir() {
        return this.jwsClassDir;
    }

    public void init() {
        super.init();
        ServletContext servletContext = this.getServletConfig().getServletContext();
        isDebug = log.isDebugEnabled();
        if (isDebug) {
            log.debug((Object)"In servlet init");
        }
        this.transportName = this.getOption(servletContext, INIT_PROPERTY_TRANSPORT_NAME, "http");
        if (JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_USE_SECURITY, null))) {
            this.securityProvider = new ServletSecurityProvider();
        }
        this.enableList = JavaUtils.isTrueExplicitly(this.getOption(servletContext, INIT_PROPERTY_ENABLE_LIST, null));
        this.jwsClassDir = this.getOption(servletContext, INIT_PROPERTY_JWS_CLASS_DIR, null);
        if (this.jwsClassDir != null) {
            if (this.getHomeDir() != null) {
                this.jwsClassDir = this.getHomeDir() + this.jwsClassDir;
            }
        } else {
            this.jwsClassDir = this.getDefaultJWSClassDir();
        }
    }

    private void processWsdlRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter, boolean bl, boolean bl2) throws WebServicesFault {
        block26: {
            String string = httpServletRequest.getServletPath();
            String string2 = httpServletRequest.getPathInfo();
            String string3 = string.substring(1);
            boolean bl3 = false;
            if (!bl && !bl2) {
                if (string3.endsWith("/wsdl")) {
                    string3 = string3.substring(0, string3.lastIndexOf("/wsdl"));
                    bl3 = false;
                } else if (string3.endsWith("/extwsdl")) {
                    string3 = string3.substring(0, string3.lastIndexOf("/extwsdl"));
                    bl3 = true;
                }
            }
            try {
                SOAPPort sOAPPort = this.getEngine().getPort(string3);
                if (sOAPPort != null) {
                    String string4 = sOAPPort.getPortDesc().getWSDLFile();
                    String string5 = string4.substring(string4.lastIndexOf(File.separator) + 1);
                    try {
                        Object object;
                        if (string2 == null || string2.equals("") || string2.equals("/")) {
                            object = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                            if (!((String)object).endsWith("/")) {
                                object = (String)object + "/";
                            }
                            if (bl) {
                                object = (String)object + "wsdl/";
                            } else if (bl2) {
                                object = (String)object + "extwsdl/";
                            }
                            object = (String)object + string5;
                            httpServletResponse.sendRedirect((String)object);
                            string4 = null;
                        } else {
                            string4 = string4.substring(0, string4.lastIndexOf(File.separator) + 1);
                            if (string2.startsWith("/")) {
                                string2 = string2.substring(1);
                            }
                            string4 = string4 + string2;
                        }
                        if (string4 == null) break block26;
                        string4 = string4.replace('\\', '/');
                        string4 = string4.replace('/', File.separatorChar);
                        object = null;
                        PublishWSDLInfo publishWSDLInfo = null;
                        try {
                            String string6 = httpServletRequest.getContextPath();
                            publishWSDLInfo = DeployUtils.getUpdatedWSDLFile(string4, httpServletRequest.getScheme(), httpServletRequest.getServerName(), Integer.toString(httpServletRequest.getServerPort()), string6, string3, bl3);
                            object = publishWSDLInfo.getWSDLDoc();
                        }
                        catch (WSDLException wSDLException) {
                            FFDCFilter.processException((Throwable)wSDLException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"305", (Object)this);
                            log.debug((Object)"wsdl exception caught while getting wsdl", (Throwable)wSDLException);
                            try {
                                object = XMLUtils.newDocument(string4);
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"301", (Object)this);
                            }
                        }
                        if (object != null) {
                            if (!bl3 && publishWSDLInfo != null && publishWSDLInfo.hasService() && !publishWSDLInfo.hasSOAPPorts()) {
                                this.reportNoSOAPPorts(httpServletResponse, printWriter);
                                object = null;
                            } else {
                                httpServletResponse.setContentType("text/xml");
                                XMLUtils.DocumentToWriter((Document)object, printWriter);
                            }
                            break block26;
                        }
                        this.reportNoWSDL(httpServletResponse, printWriter);
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"328", (Object)this);
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)iOException);
                        try {
                            httpServletResponse.sendError(500);
                            break block26;
                        }
                        catch (IOException iOException2) {
                            FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"334", (Object)this);
                            log.error((Object)Messages.getMessage("exception00"), (Throwable)iOException2);
                        }
                    }
                    break block26;
                }
                this.reportNoWSDL(httpServletResponse, printWriter);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.processWsdlRequest", (String)"265", (Object)this);
                if (webServicesFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                    this.reportNoWSDL(httpServletResponse, printWriter);
                }
                throw webServicesFault;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (isDebug) {
            log.debug((Object)"Enter: doGet()");
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        try {
            block23: {
                boolean bl;
                String string;
                ServerEngine serverEngine = this.getEngine();
                ServletContext servletContext = this.getServletConfig().getServletContext();
                String string2 = httpServletRequest.getPathInfo();
                String string3 = httpServletRequest.getServletPath();
                String string4 = servletContext.getRealPath(httpServletRequest.getServletPath());
                if (string4 == null) {
                    string4 = string3;
                }
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = httpServletRequest.getParameterNames().hasMoreElements();
                boolean bl6 = httpServletRequest.getRequestURI().endsWith(".jws");
                if (bl6) {
                    string2 = httpServletRequest.getServletPath();
                }
                if ((string = httpServletRequest.getQueryString()) != null) {
                    if (string.equalsIgnoreCase("wsdl")) {
                        bl2 = true;
                    } else if (string.equalsIgnoreCase("extwsdl")) {
                        bl3 = true;
                    } else if (string.equalsIgnoreCase("list")) {
                        bl4 = true;
                    }
                }
                boolean bl7 = bl = string2 == null || string2.equals("");
                if (!(bl2 || bl3 || bl4 || !bl || string3.endsWith("/wsdl") || string3.endsWith("extwsdl"))) {
                    this.reportAvailableServices(httpServletResponse, printWriter, httpServletRequest);
                } else if (string4 != null) {
                    try {
                        if (string3.endsWith("/wsdl") || bl2 || string3.endsWith("/extwsdl") || bl3) {
                            this.processWsdlRequest(httpServletRequest, httpServletResponse, printWriter, bl2, bl3);
                            break block23;
                        }
                        if (bl4) {
                            this.processListRequest(httpServletResponse, printWriter);
                            break block23;
                        }
                        if (bl5) {
                            MessageContext messageContext = this.createMessageContext(serverEngine, httpServletRequest, httpServletResponse);
                            String string5 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString();
                            messageContext.setProperty(MessageContext.TRANS_URL, string5);
                            this.processMethodRequest(messageContext, httpServletRequest, httpServletResponse, printWriter);
                            break block23;
                        }
                        String string6 = string2.startsWith("/") ? string2.substring(1) : string2;
                        SOAPPort sOAPPort = serverEngine.getPort(string6);
                        if (sOAPPort == null) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.setContentType("text/html");
                            printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                            printWriter.println("<p>" + Messages.getMessage("noService06") + "</p>");
                            break block23;
                        }
                        this.reportServiceInfo(httpServletResponse, printWriter, sOAPPort, string6);
                    }
                    catch (WebServicesFault webServicesFault) {
                        FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doGet", (String)"320", (Object)this);
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.setStatus(500);
                        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                        printWriter.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
                        printWriter.println("<pre>Fault - " + webServicesFault.toString() + " </pre>");
                        printWriter.println("<pre>" + webServicesFault.dumpToString() + " </pre>");
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doGet", (String)"332", (Object)this);
                        log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.setStatus(500);
                        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                        printWriter.println("<p>" + Messages.getMessage("somethingWrong00") + "</p>");
                        printWriter.println("<pre>Exception - " + exception + "<br>");
                        if (this.isDevelopment()) {
                            printWriter.println(JavaUtils.stackToString(exception));
                        }
                        printWriter.println("</pre>");
                    }
                } else {
                    httpServletResponse.setContentType("text/html");
                    printWriter.println("<html><h1>WebServices HTTP Servlet</h1>");
                    printWriter.println(Messages.getMessage("reachedServlet00"));
                    printWriter.println("<p>" + Messages.getMessage("transportName00", "<b>" + this.transportName + "</b>"));
                    printWriter.println("</html>");
                }
            }
            Object var19_22 = null;
            printWriter.close();
            if (!isDebug) return;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            printWriter.close();
            if (!isDebug) throw throwable;
            log.debug((Object)"Exit: doGet()");
            throw throwable;
        }
        log.debug((Object)"Exit: doGet()");
    }

    protected void processMethodRequest(MessageContext messageContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws WebServicesFault {
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = null;
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (string3.equalsIgnoreCase("method")) {
                string = httpServletRequest.getParameter(string3);
                continue;
            }
            string2 = string2 + "<" + string3 + ">" + httpServletRequest.getParameter(string3) + "</" + string3 + ">";
        }
        if (string == null) {
            httpServletResponse.setContentType("text/html");
            printWriter.println("<h2>" + Messages.getMessage("error00") + ":  " + Messages.getMessage("invokeGet00") + "</h2>");
            printWriter.println("<p>" + Messages.getMessage("noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(messageContext, httpServletResponse, printWriter, string, string2);
        }
    }

    protected void invokeEndpointFromGet(MessageContext messageContext, HttpServletResponse httpServletResponse, PrintWriter printWriter, String string, String string2) throws WebServicesFault {
        ServerEngine serverEngine = this.getEngine();
        String string3 = "<" + string + ">" + string2 + "</" + string + ">";
        String string4 = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + string3 + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string4.getBytes());
        Message message = new Message((Object)byteArrayInputStream, false);
        messageContext.setRequestMessage(message);
        serverEngine.invoke(messageContext);
        Message message2 = messageContext.getResponseMessage();
        if (message2 != null) {
            httpServletResponse.setContentType("text/xml");
            printWriter.println(message2.getSOAPPartAsString());
        }
    }

    protected void reportServiceInfo(HttpServletResponse httpServletResponse, PrintWriter printWriter, SOAPPort sOAPPort, String string) {
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h1>" + sOAPPort.getName() + "</h1>");
        printWriter.println("<p>" + Messages.getMessage("webServicesService00") + "</p>");
        printWriter.println("<i>" + Messages.getMessage("perhaps00") + "</i>");
    }

    protected void processListRequest(HttpServletResponse httpServletResponse, PrintWriter printWriter) throws WebServicesFault {
        ServerEngine serverEngine = this.getEngine();
        if (this.enableList) {
            Document document = serverEngine.getConfigurationDocument();
            if (document != null) {
                httpServletResponse.setContentType("text/xml");
                XMLUtils.DocumentToWriter(document, printWriter);
            } else {
                httpServletResponse.setStatus(404);
                httpServletResponse.setContentType("text/html");
                printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
                printWriter.println("<p>" + Messages.getMessage("noDeploy00") + "</p>");
            }
        } else {
            httpServletResponse.setStatus(403);
            httpServletResponse.setContentType("text/html");
            printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
            printWriter.println("<p><i>?list</i>" + Messages.getMessage("disabled00") + "</p>");
        }
    }

    protected void reportNoWSDL(HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setStatus(404);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>" + Messages.getMessage("error00") + "</h2>");
        printWriter.println("<p>" + Messages.getMessage("noWSDL00") + "</p>");
    }

    protected void reportNoSOAPPorts(HttpServletResponse httpServletResponse, PrintWriter printWriter) {
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>" + Messages.getMessage("noSoapPorts00") + "</h2>");
    }

    protected void reportAvailableServices(HttpServletResponse httpServletResponse, PrintWriter printWriter, HttpServletRequest httpServletRequest) throws ConfigurationException, WebServicesFault {
        ServerEngine serverEngine = this.getEngine();
        httpServletResponse.setContentType("text/html");
        printWriter.println("<h2>And now... Some Services</h2>");
        Iterator iterator = serverEngine.getDeployedPorts();
        String string = this.getWebappBase(httpServletRequest) + "/services/";
        printWriter.println("<ul>");
        while (iterator.hasNext()) {
            PortDesc portDesc = (PortDesc)iterator.next();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<li>");
            String string2 = portDesc.getName();
            stringBuffer.append(string2);
            stringBuffer.append(" <a href=\"");
            stringBuffer.append(string);
            stringBuffer.append(string2);
            stringBuffer.append("?wsdl\"><i>(wsdl)</i></a></li>");
            printWriter.println(stringBuffer.toString());
            ArrayList arrayList = portDesc.getOperations();
            if (arrayList.isEmpty()) continue;
            printWriter.println("<ul>");
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)iterator2.next();
                printWriter.println("<li>" + operationDesc.getName());
            }
            printWriter.println("</ul>");
        }
        printWriter.println("</ul>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Message message;
        MessageContext messageContext;
        block27: {
            String string = null;
            messageContext = null;
            if (isDebug) {
                log.debug((Object)"Enter: doPost()");
            }
            message = null;
            ServerEngine serverEngine = null;
            try {
                serverEngine = this.getEngine();
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"768", (Object)this);
                ServletException servletException = new ServletException(Messages.getMessage("noEngine00"), (Throwable)webServicesFault);
                log.debug((Object)"No Engine Found..possibly startup errors occurred!", (Throwable)webServicesFault);
                throw servletException;
            }
            if (serverEngine == null) {
                ServletException servletException = new ServletException(Messages.getMessage("noEngine00"));
                log.debug((Object)"No Engine Found!", (Throwable)servletException);
                throw servletException;
            }
            try {
                String string2;
                httpServletResponse.setBufferSize(8192);
                messageContext = this.createMessageContext(serverEngine, httpServletRequest, httpServletResponse);
                if (this.securityProvider != null) {
                    if (isDebug) {
                        log.debug((Object)("securityProvider:" + this.securityProvider));
                    }
                    messageContext.setProperty("securityProvider", this.securityProvider);
                }
                if ((string2 = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString()) != null && string2.length() > 0) {
                    messageContext.setProperty("inbound.url", string2);
                    if (isDebug) {
                        log.debug((Object)("Set inbound.url property on MessageContext to: " + string2));
                    }
                }
                Message message2 = new Message(httpServletRequest.getInputStream(), false, httpServletRequest.getHeader("Content-Type"), httpServletRequest.getHeader("Content-Location"));
                message2.setCharacterEncoding(httpServletRequest.getCharacterEncoding());
                if (isDebug) {
                    log.debug((Object)("Request Message:" + message2));
                }
                messageContext.setRequestMessage(message2);
                try {
                    string = this.getSoapAction(httpServletRequest);
                    if (string != null) {
                        messageContext.setUseSOAPAction(true);
                        messageContext.setSOAPActionURI(string);
                    }
                    messageContext.setSession(new WebServicesHttpSession(httpServletRequest));
                    if (isDebug) {
                        log.debug((Object)"Invoking WebServices Engine.");
                    }
                    serverEngine.invoke(messageContext);
                    if (isDebug) {
                        log.debug((Object)"Return from WebServices Engine.");
                    }
                    message = messageContext.getResponseMessage();
                }
                catch (WebServicesFault webServicesFault) {
                    FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"713", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)webServicesFault);
                    int n = this.getHttpServletResponseStatus(webServicesFault);
                    if (n == 401) {
                        httpServletResponse.setHeader("WWW-Authenticate", "Basic realm=\"WebServices\"");
                    }
                    httpServletResponse.setStatus(n);
                    message = messageContext.getResponseMessage();
                    if (message == null) {
                        message = new Message(webServicesFault);
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"727", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                    httpServletResponse.setStatus(500);
                    message = messageContext.getResponseMessage();
                    if (message == null) {
                        message = new Message(WebServicesFault.makeFault(exception));
                    }
                }
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.doPost", (String)"736", (Object)this);
                log.error((Object)Messages.getMessage("webServicesFault00"), (Throwable)webServicesFault);
                message = messageContext.getResponseMessage();
                if (message != null) break block27;
                message = new Message(webServicesFault);
            }
        }
        if (message != null) {
            if (messageContext.isOneWay()) {
                log.error((Object)Messages.getMessage("servlet.unexpected.oneway.response00"));
                log.debug((Object)"No Response Sent");
            } else {
                this.sendResponse(this.getProtocolVersion(httpServletRequest), message.getContentType(messageContext.getSOAPConstants()), httpServletResponse, message);
                if (isDebug) {
                    log.debug((Object)"Response sent.");
                }
            }
        } else if (isDebug) {
            log.debug((Object)"No Response Sent");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: doPost()");
        }
    }

    public void oneWay(MessageContext messageContext) {
        Object object = messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
        if (object != null) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)object;
            try {
                httpServletResponse.getOutputStream().flush();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.oneWay", (String)"839", (Object)this);
            }
        }
    }

    protected int getHttpServletResponseStatus(WebServicesFault webServicesFault) {
        return webServicesFault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String string, String string2, HttpServletResponse httpServletResponse, Message message) throws WebServicesFault, IOException {
        if (message == null) {
            httpServletResponse.setStatus(204);
            if (isDebug) {
                log.debug((Object)"NO WEBSERVICES MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                log.debug((Object)("Returned Content-Type:" + string2));
            }
            try {
                httpServletResponse.setContentType(string2);
                message.writeTo((OutputStream)httpServletResponse.getOutputStream());
            }
            catch (SOAPException sOAPException) {
                FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.transport.http.WebServicesServlet.sendResponse", (String)"833", (Object)this);
                log.error((Object)Messages.getMessage("exception00"), (Throwable)sOAPException);
            }
        }
        if (!httpServletResponse.isCommitted()) {
            httpServletResponse.flushBuffer();
        }
    }

    private MessageContext createMessageContext(WebServicesEngine webServicesEngine, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        MessageContext messageContext = new MessageContext(webServicesEngine);
        if (isDebug) {
            log.debug((Object)("MessageContext:" + messageContext));
            log.debug((Object)("HEADER_CONTENT_TYPE:" + httpServletRequest.getHeader("Content-Type")));
            log.debug((Object)("HEADER_CONTENT_LOCATION:" + httpServletRequest.getHeader("Content-Location")));
            log.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            log.debug((Object)("Constants.MC_RELATIVE_PATH:" + httpServletRequest.getServletPath()));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETLOCATION:" + String.valueOf(this.getWebInfPath())));
            log.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + httpServletRequest.getPathInfo()));
            log.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + httpServletRequest.getHeader("Authorization")));
            log.debug((Object)("Constants.MC_REMOTE_ADDR:" + httpServletRequest.getRemoteAddr()));
            log.debug((Object)("configPath:" + String.valueOf(this.getWebInfPath())));
        }
        if (this.transportName != null) {
            messageContext.setTransportName(this.transportName);
        }
        if (this.jwsClassDir != null) {
            messageContext.setProperty("jws.classDir", this.jwsClassDir);
        }
        if ((string = this.getHomeDir()) != null) {
            messageContext.setProperty("home.dir", string);
        }
        if ((string = httpServletRequest.getServletPath()) != null) {
            messageContext.setProperty("path", string);
        }
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, this);
        messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        if (httpServletResponse != null) {
            messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        }
        if ((string = this.getWebInfPath()) != null) {
            messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, string);
            messageContext.setProperty("configPath", string);
        }
        if ((string = httpServletRequest.getPathInfo()) != null) {
            messageContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, string);
        }
        if ((string = httpServletRequest.getHeader("Authorization")) != null) {
            messageContext.setProperty("Authorization", string);
        }
        if ((string = httpServletRequest.getRemoteAddr()) != null) {
            messageContext.setProperty("remoteaddr", string);
        }
        ServletEndpointContextImpl servletEndpointContextImpl = ServletEndpointContextImpl.get();
        messageContext.setProperty("servletEndpointContext", servletEndpointContextImpl);
        String string2 = this.getServletConfig().getServletContext().getRealPath(httpServletRequest.getServletPath());
        if (string2 != null) {
            messageContext.setProperty("realpath", string2);
        }
        messageContext.addOneWayListener(this);
        return messageContext;
    }

    private String getSoapAction(HttpServletRequest httpServletRequest) throws WebServicesFault {
        String string = httpServletRequest.getHeader("SOAPAction");
        if (isDebug) {
            log.debug((Object)("HEADER_SOAP_ACTION:" + string));
        }
        if (string == null) {
            WebServicesFault webServicesFault = new WebServicesFault("Client.NoSOAPAction", Messages.getMessage("noHeader00", "SOAPAction"), null, null);
            log.error((Object)Messages.getMessage("genFault00"), (Throwable)webServicesFault);
            throw webServicesFault;
        }
        if (string.length() == 0) {
            string = httpServletRequest.getContextPath();
        }
        return string;
    }

    protected String getDefaultJWSClassDir() {
        return this.getWebInfPath() == null ? null : this.getWebInfPath() + File.separator + "jwsClasses";
    }

    protected String getProtocolVersion(HttpServletRequest httpServletRequest) {
        String string;
        int n;
        String string2 = HTTPConstants.HEADER_PROTOCOL_V10;
        String string3 = httpServletRequest.getProtocol();
        if (string3 != null && -1 != (n = string3.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((string = string3.substring(n + 1)).trim())) {
            string2 = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

