/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.BasicHandler;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSURLParser;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;

public class JMSSender
extends BasicHandler {
    private Hashtable icTable = null;
    private static final int CHUNK_SIZE = 4096;
    private static final TraceComponent _tc = Tr.register((Class)(class$com$ibm$ws$webservices$engine$transport$jms$JMSSender == null ? (class$com$ibm$ws$webservices$engine$transport$jms$JMSSender = JMSSender.class$("com.ibm.ws.webservices.engine.transport.jms.JMSSender")) : class$com$ibm$ws$webservices$engine$transport$jms$JMSSender), (String)"WebServices", (String)"com.ibm.ws.webservices.engine.resources.engineMessages");
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$transport$jms$JMSSender;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext messageContext) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"invoke");
        }
        JMSConnectionData jMSConnectionData = new JMSConnectionData();
        TransactionSuspender transactionSuspender = new TransactionSuspender();
        try {
            try {
                transactionSuspender.suspendTransaction();
                URL uRL = messageContext.getTargetEndpointAddressAsURL();
                if (uRL == null) {
                    throw new WebServicesFault(Messages.getMessage("JMS.noEndpoint"));
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Target URL string is [" + uRL.toString() + "]"));
                }
                this.parseURL(jMSConnectionData, uRL);
                this.getJMSObjects(jMSConnectionData);
                this.sendMessage(jMSConnectionData, messageContext, uRL);
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", (String)"178", (Object)this);
                throw webServicesFault;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.invoke", (String)"183", (Object)this);
                webServicesFault = WebServicesFault.makeFault(exception);
                throw webServicesFault;
            }
            Object var7_7 = null;
            transactionSuspender.resumeTransaction();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            transactionSuspender.resumeTransaction();
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"invoke");
            throw throwable;
        }
        if (!_tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)_tc, (String)"invoke");
    }

    private void parseURL(JMSConnectionData jMSConnectionData, URL uRL) throws WebServicesFault, Exception {
        Integer n;
        String string;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"parseURL");
        }
        JMSURLParser jMSURLParser = new JMSURLParser(uRL);
        jMSConnectionData.messageMode = jMSURLParser.getDestinationType();
        jMSConnectionData.connectionFactoryName = jMSURLParser.getConnectionFactory();
        jMSConnectionData.destinationName = jMSURLParser.getDestination();
        jMSConnectionData.targetService = jMSURLParser.getTargetService();
        if (jMSConnectionData.connectionFactoryName == null || jMSConnectionData.connectionFactoryName.length() == 0 || jMSConnectionData.destinationName == null || jMSConnectionData.destinationName.length() == 0 || jMSConnectionData.targetService == null || jMSConnectionData.targetService.length() == 0) {
            Tr.error((TraceComponent)_tc, (String)"JMS.MissingRequiredProperties");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.MissingRequiredProperties"), null, null);
        }
        try {
            string = jMSURLParser.getDeliveryMode();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.deliveryMode = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", (String)"256", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"JMS.BadPropValue", (Object)"deliveryMode");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "deliveryMode"), numberFormatException);
        }
        try {
            string = jMSURLParser.getPriority();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.priority = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", (String)"274", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"JMS.BadPropValue", (Object)"priority");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "priority"), numberFormatException);
        }
        try {
            string = jMSURLParser.getTimeToLive();
            if (string != null) {
                n = new Integer(string);
                jMSConnectionData.timeToLive = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.parseURL", (String)"292", (Object)this);
            Tr.error((TraceComponent)_tc, (String)"JMS.BadPropValue", (Object)"timeToLive");
            throw new WebServicesFault(Messages.getMessage("JMS.BadPropValue", "timeToLive"), numberFormatException);
        }
        jMSConnectionData.initialContextFactory = jMSURLParser.getInitialContextFactory();
        jMSConnectionData.jndiProviderURL = jMSURLParser.getJndiProviderURL();
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("message mode: [" + jMSConnectionData.messageMode + "], connectionFactoryName: [" + jMSConnectionData.connectionFactoryName + "], destinationName: [" + jMSConnectionData.destinationName + "], targetService: [" + jMSConnectionData.targetService + "]"));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"parseURL");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getJMSObjects");
        }
        try {
            try {
                if (jMSConnectionData.initialContextFactory == null) {
                    jMSConnectionData.initialContextFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
                }
                if (jMSConnectionData.jndiProviderURL == null) {
                    jMSConnectionData.jndiProviderURL = "corbaloc:iiop:localhost:2809/NameServiceServerRoot";
                }
                try {
                    jMSConnectionData.jndiContext = this.getInitialContext(jMSConnectionData.initialContextFactory, jMSConnectionData.jndiProviderURL);
                }
                catch (NamingException namingException) {
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"357", (Object)this);
                    Tr.error((TraceComponent)_tc, (String)"JMS.JNDIError01", (Object)namingException.toString());
                    throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError01", namingException.toString()), null, null);
                }
                switch (jMSConnectionData.messageMode) {
                    case 1: {
                        try {
                            jMSConnectionData.queueConnectionFactory = (QueueConnectionFactory)jMSConnectionData.jndiContext.lookup(jMSConnectionData.connectionFactoryName);
                            jMSConnectionData.queue = (Queue)jMSConnectionData.jndiContext.lookup(jMSConnectionData.destinationName);
                            break;
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"385", (Object)this);
                            Tr.error((TraceComponent)_tc, (String)"JMS.JNDIError02", (Object)namingException.toString());
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                        }
                    }
                    case 2: {
                        try {
                            jMSConnectionData.topicConnectionFactory = (TopicConnectionFactory)jMSConnectionData.jndiContext.lookup(jMSConnectionData.connectionFactoryName);
                            jMSConnectionData.topic = (Topic)jMSConnectionData.jndiContext.lookup(jMSConnectionData.destinationName);
                            break;
                        }
                        catch (NamingException namingException) {
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"410", (Object)this);
                            Tr.error((TraceComponent)_tc, (String)"JMS.JNDIError02", (Object)namingException.toString());
                            throw new WebServicesFault("JMS", Messages.getMessage("JMS.JNDIError02", namingException.toString()), null, null);
                        }
                    }
                }
            }
            catch (WebServicesFault webServicesFault) {
                FFDCFilter.processException((Throwable)webServicesFault, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.getJMSObjects", (String)"425", (Object)this);
                throw webServicesFault;
            }
            {
            }
            Object var4_6 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)_tc, (String)"getJMSObjects");
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"getJMSObjects");
            throw throwable;
        }
    }

    private synchronized InitialContext getInitialContext(String string, String string2) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"getInitialContext");
        }
        InitialContext initialContext = null;
        String string3 = (string != null ? string : "<null>") + "#" + (string2 != null ? string2 : "<null>");
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("InitialContext key=[" + string3 + "]."));
        }
        if (this.icTable == null) {
            this.icTable = new Hashtable();
        }
        if ((initialContext = (InitialContext)this.icTable.get(string3)) == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (string != null) {
                hashtable.put("java.naming.factory.initial", string);
            }
            if (string2 != null) {
                hashtable.put("java.naming.provider.url", string2);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("About to create an InitialContext with the following properties:" + hashtable.toString()));
            }
            initialContext = new InitialContext(hashtable);
            this.icTable.put(string3, initialContext);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Re-using existing InitialContext with key=[" + string3 + "]."));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)"getInitialContext");
        }
        return initialContext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData jMSConnectionData) throws WebServicesFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"closeConnection");
        }
        try {
            try {
                switch (jMSConnectionData.messageMode) {
                    case 1: {
                        if (jMSConnectionData.queueConnection != null) {
                            jMSConnectionData.queueConnection.close();
                        }
                        break;
                    }
                    case 2: {
                        if (jMSConnectionData.topicConnection != null) {
                            jMSConnectionData.topicConnection.close();
                        }
                        break;
                    }
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.closeConnection", (String)"562", (Object)this);
                Tr.error((TraceComponent)_tc, (String)"JMS.JMSError01", (Object)jMSException.toString());
                throw new WebServicesFault("JMS", Messages.getMessage("JMS.JMSError01", jMSException.toString()), null, null);
            }
            {
            }
            Object var4_2 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)_tc, (String)"closeConnection");
            return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"closeConnection");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendMessage(JMSConnectionData jMSConnectionData, MessageContext messageContext, URL uRL) throws WebServicesFault, IOException, SOAPException {
        int n;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"sendMessage");
        }
        boolean bl2 = bl = !messageContext.getOperation().isOneway();
        if (bl && jMSConnectionData.messageMode == 2) {
            Tr.error((TraceComponent)_tc, (String)"JMS.NoTwoWay");
            throw new WebServicesFault("JMS", Messages.getMessage("JMS.NoTwoWay"), null, null);
        }
        Message message = messageContext.getRequestMessage();
        String string = messageContext.getUsername();
        String string2 = messageContext.getPassword();
        if (_tc.isDebugEnabled()) {
            object3 = message.getSOAPPartAsString();
            Tr.debug((TraceComponent)_tc, (String)("SOAP Message:\n" + (String)object3));
            object2 = string == null || string.length() == 0 ? "<not-specified>" : string;
            if (string2 == null || string2.length() == 0) {
                object = "<not-specified>";
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length(); ++i) {
                    stringBuffer.append('*');
                }
                object = stringBuffer.toString();
            }
            Tr.debug((TraceComponent)_tc, (String)("Userid: " + (String)object2));
            Tr.debug((TraceComponent)_tc, (String)("Password: " + (String)object));
        }
        if ((object3 = (Integer)messageContext.getProperty("deliveryMode")) != null) {
            jMSConnectionData.deliveryMode = (Integer)object3;
        }
        if ((object2 = (Integer)messageContext.getProperty("priority")) != null) {
            jMSConnectionData.priority = (Integer)object2;
        }
        if ((object = (Integer)messageContext.getProperty("timeToLive")) != null) {
            jMSConnectionData.timeToLive = (Integer)object;
        }
        if ((n = messageContext.getTimeout()) > 0 && (jMSConnectionData.timeToLive <= 0 || jMSConnectionData.timeToLive > n)) {
            jMSConnectionData.timeToLive = n;
        }
        QueueSession queueSession = null;
        QueueSender queueSender = null;
        TopicSession topicSession = null;
        TopicPublisher topicPublisher = null;
        BytesMessage bytesMessage = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            try {
                switch (jMSConnectionData.messageMode) {
                    case 1: {
                        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                            jMSConnectionData.queueConnection = jMSConnectionData.queueConnectionFactory.createQueueConnection(string, string2);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Created queue connection with user [" + string + "] and password [" + string2 + "]."));
                            }
                        } else {
                            jMSConnectionData.queueConnection = jMSConnectionData.queueConnectionFactory.createQueueConnection();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created queue connection without user/password");
                            }
                        }
                        queueSession = jMSConnectionData.queueConnection.createQueueSession(false, 1);
                        queueSender = queueSession.createSender(jMSConnectionData.queue);
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        message.writeTo(byteArrayOutputStream);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to write the following request message to the JMS message:\n" + byteArrayOutputStream.toString()));
                        }
                        bytesMessage = queueSession.createBytesMessage();
                        bytesMessage.writeBytes(byteArrayOutputStream.toByteArray());
                        bytesMessage.setStringProperty("contentType", message.getContentType(messageContext.getSOAPConstants()));
                        bytesMessage.setStringProperty("targetService", jMSConnectionData.targetService);
                        bytesMessage.setStringProperty("endpointURL", uRL.toString());
                        bytesMessage.setStringProperty("transportVersion", "1");
                        TemporaryQueue temporaryQueue = null;
                        QueueReceiver queueReceiver = null;
                        if (bl) {
                            temporaryQueue = queueSession.createTemporaryQueue();
                            bytesMessage.setJMSReplyTo((Destination)temporaryQueue);
                            queueReceiver = queueSession.createReceiver((Queue)temporaryQueue);
                            jMSConnectionData.queueConnection.start();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created queue receiver and started the queue connection in preparation for the reply message.");
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to send message:\n" + bytesMessage.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + jMSConnectionData.deliveryMode + ", priority=" + jMSConnectionData.priority + ", timeToLive=" + jMSConnectionData.timeToLive));
                        }
                        queueSender.send((javax.jms.Message)bytesMessage, jMSConnectionData.deliveryMode, jMSConnectionData.priority, (long)jMSConnectionData.timeToLive);
                        String string3 = bytesMessage.getJMSMessageID();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("Sent the message, messageID=" + string3));
                        }
                        if (temporaryQueue != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("About to receive response message, requestTimeout=" + n + "ms."));
                            }
                            javax.jms.Message message2 = queueReceiver.receive((long)n);
                            if (_tc.isDebugEnabled()) {
                                if (message2 != null) {
                                    Tr.debug((TraceComponent)_tc, (String)("Received JMS response message:\n" + message2.toString()));
                                } else {
                                    Tr.debug((TraceComponent)_tc, (String)"Received null response message :-(");
                                }
                            }
                            if (message2 == null) {
                                Tr.error((TraceComponent)_tc, (String)"JMS.RequestTimeOut");
                                throw new WebServicesFault(Messages.getMessage("JMS.RequestTimeOut"));
                            }
                            if (!(message2 instanceof BytesMessage)) {
                                Tr.error((TraceComponent)_tc, (String)"JMS.InvalidReplyMsgType");
                                throw new WebServicesFault(Messages.getMessage("JMS.InvalidReplyMsgType"));
                            }
                            String string4 = message2.getJMSCorrelationID();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Reply message contains correlation id: " + string4));
                            }
                            if (!string4.equals(string3)) {
                                Tr.error((TraceComponent)_tc, (String)"JMS.MismatchedReply");
                                throw new WebServicesFault(Messages.getMessage("JMS.MismatchedReply"));
                            }
                            String string5 = message2.getStringProperty("contentType");
                            string5 = string5 == null ? null : string5.trim();
                            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                            byte[] byArray = new byte[4096];
                            int n2 = 1;
                            while (n2 > 0) {
                                n2 = ((BytesMessage)message2).readBytes(byArray);
                                if (n2 <= 0) continue;
                                byteArrayOutputStream2.write(byArray, 0, n2);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Extracted the following SOAP message from the JMS response message:\n" + byteArrayOutputStream2.toString()));
                            }
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
                            Message message3 = new Message(byteArrayInputStream, false, string5, null);
                            messageContext.setResponseMessage(message3);
                        }
                        break;
                    }
                    case 2: {
                        if (string != null && string.length() != 0 && string2 != null && string2.length() != 0) {
                            jMSConnectionData.topicConnection = jMSConnectionData.topicConnectionFactory.createTopicConnection(string, string2);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)("Created topic connection with user [" + string + "] and password [" + string2 + "]."));
                            }
                        } else {
                            jMSConnectionData.topicConnection = jMSConnectionData.topicConnectionFactory.createTopicConnection();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)_tc, (String)"Created topic connection without user/password");
                            }
                        }
                        topicSession = jMSConnectionData.topicConnection.createTopicSession(false, 1);
                        topicPublisher = topicSession.createPublisher(jMSConnectionData.topic);
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        message.writeTo(byteArrayOutputStream);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to write the following request message to the JMS message: " + byteArrayOutputStream.toString()));
                        }
                        bytesMessage = topicSession.createBytesMessage();
                        bytesMessage.writeBytes(byteArrayOutputStream.toByteArray());
                        bytesMessage.setStringProperty("contentType", message.getContentType(messageContext.getSOAPConstants()));
                        bytesMessage.setStringProperty("targetService", jMSConnectionData.targetService);
                        bytesMessage.setStringProperty("endpointURL", uRL.toString());
                        bytesMessage.setStringProperty("transportVersion", "1");
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)("About to publish message:\n" + bytesMessage.toString()));
                        }
                        topicPublisher.publish((javax.jms.Message)bytesMessage);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)_tc, (String)"Published the message.");
                        }
                        break;
                    }
                }
            }
            catch (JMSException jMSException) {
                FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.webservices.engine.transport.jms.JMSSender.sendMessage", (String)"968", (Object)this);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Messages.getMessage("JMS.JMSError01", jMSException.toString()));
                Exception exception = jMSException.getLinkedException();
                while (true) {
                    if (exception == null) {
                        Tr.error((TraceComponent)_tc, (String)stringBuffer.toString());
                        if (!_tc.isDebugEnabled()) throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
                        Tr.debug((TraceComponent)_tc, (String)stringBuffer.toString());
                        throw new WebServicesFault("JMS", stringBuffer.toString(), null, null);
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(Messages.getMessage("JMS.JMSError02", exception.toString()));
                    if (exception instanceof JMSException) {
                        exception = ((JMSException)((Object)exception)).getLinkedException();
                        continue;
                    }
                    exception = null;
                }
            }
            {
            }
            Object var29_34 = null;
            this.closeConnection(jMSConnectionData);
            if (!_tc.isEntryEnabled()) return;
            Tr.exit((TraceComponent)_tc, (String)"sendMessage");
            return;
        }
        catch (Throwable throwable) {
            Object var29_35 = null;
            this.closeConnection(jMSConnectionData);
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit((TraceComponent)_tc, (String)"sendMessage");
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

