/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Time
implements Serializable {
    private Calendar _value;
    private static SimpleDateFormat zulu = new SimpleDateFormat("HH:mm:ss.SSS'Z'");
    private static SimpleDateFormat zulu2 = new SimpleDateFormat("HH:mm:ss");

    public Time(Calendar calendar) {
        this._value = calendar;
        this._value.set(0, 0, 0);
    }

    public Time(String string) throws NumberFormatException {
        this._value = this.makeValue(string);
    }

    public Calendar getAsCalendar() {
        return this._value;
    }

    public void setTime(Calendar calendar) {
        this._value = calendar;
        this._value.set(0, 0, 0);
    }

    public void setTime(Date date) {
        this._value.setTime(date);
        this._value.set(0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Calendar makeValue(String string) throws NumberFormatException {
        Calendar calendar = Calendar.getInstance();
        Date date = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (string != null) {
            if (string.charAt(2) != ':' || string.charAt(5) != ':') {
                throw new NumberFormatException(Messages.getMessage("badTime00", string));
            }
            if (string.length() < 8) {
                throw new NumberFormatException(Messages.getMessage("badTime00", string));
            }
        }
        int n3 = 8;
        if (string != null) {
            block29: {
                int n4;
                if (n3 < string.length() && string.charAt(n3) == '.') {
                    n = 0;
                    n4 = ++n3;
                    while (n3 < string.length() && Character.isDigit(string.charAt(n3))) {
                        ++n3;
                    }
                    String string2 = string.substring(n4, n3);
                    if (string2.length() == 3) {
                        n = Integer.parseInt(string2);
                    } else if (string2.length() < 3) {
                        n = Integer.parseInt((string2 + "000").substring(0, 3));
                    } else {
                        n = Integer.parseInt(string2.substring(0, 3));
                        if (string2.charAt(3) >= '5') {
                            ++n;
                        }
                    }
                }
                if (n3 + 5 < string.length() && (string.charAt(n3) == '+' || string.charAt(n3) == '-')) {
                    if (!(Character.isDigit(string.charAt(n3 + 1)) && Character.isDigit(string.charAt(n3 + 2)) && string.charAt(n3 + 3) == ':' && Character.isDigit(string.charAt(n3 + 4)) && Character.isDigit(string.charAt(n3 + 5)))) {
                        throw new NumberFormatException(Messages.getMessage("badTimezone00", string));
                    }
                    n4 = (string.charAt(n3 + 1) - 48) * 10 + string.charAt(n3 + 2) - 48;
                    int n5 = (string.charAt(n3 + 4) - 48) * 10 + string.charAt(n3 + 5) - 48;
                    n2 = (n4 * 60 + n5) * 60 * 1000;
                    if (string.charAt(n3) == '+') {
                        n2 = -n2;
                    }
                    bl = true;
                    n3 += 6;
                }
                if (n3 < string.length() && string.charAt(n3) == 'Z') {
                    ++n3;
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    bl2 = true;
                }
                if (bl || bl2) {
                    try {
                        SimpleDateFormat simpleDateFormat = zulu;
                        synchronized (simpleDateFormat) {
                            date = zulu.parse(string == null ? null : string.substring(0, 8) + ".000Z");
                            break block29;
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.types.Time.makeValue", (String)"226", (Object)this);
                        throw new NumberFormatException(exception.toString());
                    }
                }
                if (!bl) {
                    try {
                        SimpleDateFormat simpleDateFormat = zulu2;
                        synchronized (simpleDateFormat) {
                            date = zulu2.parse(string == null ? null : string.substring(0, 8));
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.types.Time.makeValue", (String)"238", (Object)this);
                        throw new NumberFormatException(exception.toString());
                    }
                }
            }
            if (date != null) {
                date.setTime(date.getTime() + (long)n);
                date.setTime(date.getTime() + (long)n2);
            }
            if (n3 < string.length()) {
                throw new NumberFormatException(Messages.getMessage("badChars00", string));
            }
        }
        calendar.setTime(date);
        calendar.set(0, 0, 0);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SimpleDateFormat simpleDateFormat = zulu;
        synchronized (simpleDateFormat) {
            return zulu.format(this._value.getTime());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Time)) {
            return false;
        }
        Time time = (Time)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl = this._value == null && time._value == null || this._value != null && this._value.equals(time._value);
        return bl;
    }

    static {
        zulu.setTimeZone(TimeZone.getTimeZone("GMT"));
        zulu2.setTimeZone(TimeZone.getDefault());
    }
}

