/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.webservices.engine.utils.Messages;
import java.io.Serializable;
import java.text.NumberFormat;

public class YearMonth
implements Serializable {
    int year;
    int month;
    String timezone = null;

    public YearMonth(int n, int n2) throws NumberFormatException {
        this.setValue(n, n2);
    }

    public YearMonth(int n, int n2, String string) throws NumberFormatException {
        this.setValue(n, n2, string);
    }

    public YearMonth(String string) throws NumberFormatException {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        if (string.length() < 7 + n) {
            throw new NumberFormatException(Messages.getMessage("badYearMonth00", string));
        }
        int n2 = string.substring(n).indexOf(45);
        if (n2 < 0) {
            throw new NumberFormatException(Messages.getMessage("badYearMonth00", string));
        }
        if (n > 0) {
            ++n2;
        }
        this.setValue(Integer.parseInt(string.substring(0, n2)), Integer.parseInt(string.substring(n2 + 1, n2 + 3)), string.substring(n2 + 3));
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        if (n == 0) {
            throw new NumberFormatException(Messages.getMessage("badYearMonth00", String.valueOf(n)));
        }
        this.year = n;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        if (n < 1 || n > 12) {
            throw new NumberFormatException(Messages.getMessage("badYearMonth00", String.valueOf(n)));
        }
        this.month = n;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String string) {
        if (string != null && string.length() > 0) {
            if (string.charAt(0) == '+' || string.charAt(0) == '-' ? string.length() != 6 || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ':' || !Character.isDigit(string.charAt(4)) || !Character.isDigit(string.charAt(5)) : !string.equals("Z")) {
                throw new NumberFormatException(Messages.getMessage("badTimezone00", string));
            }
            this.timezone = string;
        }
    }

    public void setValue(int n, int n2, String string) throws NumberFormatException {
        this.setYear(n);
        this.setMonth(n2);
        this.setTimezone(string);
    }

    public void setValue(int n, int n2) throws NumberFormatException {
        this.setYear(n);
        this.setMonth(n2);
    }

    public String toString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        String string = numberFormat.format(this.year) + "-";
        numberFormat.setMinimumIntegerDigits(2);
        string = string + numberFormat.format(this.month);
        if (this.timezone != null) {
            string = string + this.timezone;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof YearMonth)) {
            return false;
        }
        YearMonth yearMonth = (YearMonth)object;
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        boolean bl2 = bl = this.year == yearMonth.year && this.month == yearMonth.month;
        if (this.timezone != null) {
            bl = bl && this.timezone.equals(yearMonth.timezone);
        }
        return bl;
    }
}

