/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final byte PAD = 61;
    private static byte[] base64Alphabet;
    private static byte[] lookUpBase64Alphabet;

    Base64() {
    }

    static boolean isBase64(String string) {
        return Base64.isArrayByteBase64(string.getBytes());
    }

    static boolean isBase64(byte by) {
        return by == 61 || base64Alphabet[by] != -1;
    }

    static boolean isArrayByteBase64(byte[] byArray) {
        int n = byArray.length;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (Base64.isBase64(byArray[i])) continue;
            return false;
        }
        return true;
    }

    static byte[] encode(byte[] byArray) {
        byte by;
        byte by2;
        int n = byArray.length * 8;
        int n2 = n % 24;
        int n3 = n / 24;
        byte[] byArray2 = null;
        byArray2 = n2 != 0 ? new byte[(n3 + 1) * 4] : new byte[n3 * 4];
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n6 = 0; n6 < n3; ++n6) {
            n5 = n6 * 3;
            by5 = byArray[n5];
            by6 = byArray[n5 + 1];
            by7 = byArray[n5 + 2];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            n4 = n6 * 4;
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byte by8 = (by7 & 0xFFFFFF80) == 0 ? (byte)(by7 >> 6) : (byte)(by7 >> 6 ^ 0xFC);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n4 + 2] = lookUpBase64Alphabet[by4 << 2 | by8];
            byArray2[n4 + 3] = lookUpBase64Alphabet[by7 & 0x3F];
        }
        n5 = n6 * 3;
        n4 = n6 * 4;
        if (n2 == 8) {
            by5 = byArray[n5];
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by3 << 4];
            byArray2[n4 + 2] = 61;
            byArray2[n4 + 3] = 61;
        } else if (n2 == 16) {
            by5 = byArray[n5];
            by6 = byArray[n5 + 1];
            by4 = (byte)(by6 & 0xF);
            by3 = (byte)(by5 & 3);
            by2 = (by5 & 0xFFFFFF80) == 0 ? (byte)(by5 >> 2) : (byte)(by5 >> 2 ^ 0xC0);
            by = (by6 & 0xFFFFFF80) == 0 ? (byte)(by6 >> 4) : (byte)(by6 >> 4 ^ 0xF0);
            byArray2[n4] = lookUpBase64Alphabet[by2];
            byArray2[n4 + 1] = lookUpBase64Alphabet[by | by3 << 4];
            byArray2[n4 + 2] = lookUpBase64Alphabet[by4 << 2];
            byArray2[n4 + 3] = 61;
        }
        return byArray2;
    }

    static byte[] decode(byte[] byArray) {
        if (byArray.length == 0) {
            return new byte[0];
        }
        int n = byArray.length / 4;
        byte[] byArray2 = null;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        while (byArray[n4 - 1] == 61) {
            if (--n4 != 0) continue;
            return new byte[0];
        }
        byArray2 = new byte[n4 - n];
        for (n4 = 0; n4 < n; ++n4) {
            n3 = n4 * 4;
            by5 = byArray[n3 + 2];
            by6 = byArray[n3 + 3];
            by = base64Alphabet[byArray[n3]];
            by2 = base64Alphabet[byArray[n3 + 1]];
            if (by5 != 61 && by6 != 61) {
                by3 = base64Alphabet[by5];
                by4 = base64Alphabet[by6];
                byArray2[n2] = (byte)(by << 2 | by2 >> 4);
                byArray2[n2 + 1] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
                byArray2[n2 + 2] = (byte)(by3 << 6 | by4);
            } else if (by5 == 61) {
                byArray2[n2] = (byte)(by << 2 | by2 >> 4);
            } else if (by6 == 61) {
                by3 = base64Alphabet[by5];
                byArray2[n2] = (byte)(by << 2 | by2 >> 4);
                byArray2[n2 + 1] = (byte)((by2 & 0xF) << 4 | by3 >> 2 & 0xF);
            }
            n2 += 3;
        }
        return byArray2;
    }

    static {
        int n;
        base64Alphabet = new byte[255];
        lookUpBase64Alphabet = new byte[64];
        for (n = 0; n < 255; ++n) {
            Base64.base64Alphabet[n] = -1;
        }
        for (n = 90; n >= 65; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 65);
        }
        for (n = 122; n >= 97; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 97 + 26);
        }
        for (n = 57; n >= 48; --n) {
            Base64.base64Alphabet[n] = (byte)(n - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (n = 0; n <= 25; ++n) {
            Base64.lookUpBase64Alphabet[n] = (byte)(65 + n);
        }
        n = 26;
        int n2 = 0;
        while (n <= 51) {
            Base64.lookUpBase64Alphabet[n] = (byte)(97 + n2);
            ++n;
            ++n2;
        }
        n = 52;
        n2 = 0;
        while (n <= 61) {
            Base64.lookUpBase64Alphabet[n] = (byte)(48 + n2);
            ++n;
            ++n2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

