/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOM2Writer {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";
    private static String NS_URI_XML = "http://www.w3.org/XML/1998/namespace";

    public static String nodeToString(Node node, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        DOM2Writer.serializeAsXML(node, bufferedWriter, bl);
        return stringWriter.getBuffer().toString();
    }

    public static void serializeAsXML(Node node, Writer writer, boolean bl) {
        DOM2Writer.serializeAsXML(node, writer, bl, false);
    }

    public static void serializeAsXML(Node node, Writer writer, boolean bl, boolean bl2) {
        PrintWriter printWriter = new PrintWriter(writer);
        if (!bl) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        MappingScope mappingScope = new MappingScope();
        DOM2Writer.print(node, mappingScope, printWriter, bl2, 0);
        printWriter.flush();
    }

    private static void print(Node node, MappingScope object, PrintWriter printWriter, boolean bl, int n) {
        if (node == null) {
            return;
        }
        boolean bl2 = false;
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Object object2 = node.getChildNodes();
                if (object2 == null) break;
                int n2 = object2.getLength();
                for (int i = 0; i < n2; ++i) {
                    DOM2Writer.print(object2.item(i), (MappingScope)object, printWriter, bl, n);
                }
                break;
            }
            case 1: {
                NamedNodeMap namedNodeMap;
                Object object2 = new MappingScope();
                ((MappingScope)object2).setParent((MappingScope)object);
                object = object2;
                if (bl) {
                    for (int i = 0; i < n; ++i) {
                        printWriter.print(' ');
                    }
                }
                printWriter.print('<' + node.getNodeName());
                String string = node.getPrefix();
                String string2 = node.getNamespaceURI();
                if (string != null && string2 != null) {
                    boolean bl3 = false;
                    try {
                        String string3;
                        Mapping mapping = ((MappingScope)object).getMappingForPrefix(string, false);
                        String string4 = string3 = mapping == null ? null : mapping.getNamespaceURI();
                        if (string2.equals(string3)) {
                            bl3 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (!bl3) {
                        DOM2Writer.printNamespaceDecl(node, (MappingScope)object, printWriter);
                    }
                }
                int n3 = (namedNodeMap = node.getAttributes()) != null ? namedNodeMap.getLength() : 0;
                boolean bl4 = false;
                for (int i = 0; i < n3; ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    if (!bl4 && i != 0 && ((Attr)namedNodeMap.item(i - 1)).getValue().compareTo("javax.xml.rpc.security.auth.password") == 0) {
                        printWriter.print(' ' + attr.getNodeName() + "=\"" + DOM2Writer.normalize("******") + '\"');
                        bl4 = true;
                    } else {
                        printWriter.print(' ' + attr.getNodeName() + "=\"" + DOM2Writer.normalize(attr.getValue()) + '\"');
                    }
                    String string5 = attr.getPrefix();
                    String string6 = attr.getNamespaceURI();
                    if (string5 == null || string6 == null) continue;
                    boolean bl5 = false;
                    try {
                        String string7;
                        Mapping mapping = ((MappingScope)object).getMappingForPrefix(string5, false);
                        String string8 = string7 = mapping == null ? null : mapping.getNamespaceURI();
                        if (string6.equals(string7)) {
                            bl5 = true;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (bl5) continue;
                    DOM2Writer.printNamespaceDecl(attr, (MappingScope)object, printWriter);
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null) {
                    int n4 = nodeList.getLength();
                    boolean bl6 = bl2 = n4 > 0;
                    if (bl2) {
                        printWriter.print('>');
                        if (bl) {
                            printWriter.print(JavaUtils.LS);
                        }
                    }
                    for (int i = 0; i < n4; ++i) {
                        DOM2Writer.print(nodeList.item(i), (MappingScope)object, printWriter, bl, n + 1);
                    }
                } else {
                    bl2 = false;
                }
                if (!bl2) {
                    printWriter.print("/>");
                    if (bl) {
                        printWriter.print(JavaUtils.LS);
                    }
                }
                object = ((MappingScope)object).getParent();
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOM2Writer.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                if (!bl) break;
                printWriter.print(JavaUtils.LS);
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                Object object2 = node.getNodeValue();
                if (object2 != null && ((String)object2).length() > 0) {
                    printWriter.print(' ');
                    printWriter.print((String)object2);
                }
                printWriter.println("?>");
                if (!bl) break;
                printWriter.print(JavaUtils.LS);
            }
        }
        if (s == 1 && bl2) {
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    printWriter.print(' ');
                }
            }
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            if (bl) {
                printWriter.print(JavaUtils.LS);
            }
            bl2 = false;
        }
    }

    private static void printNamespaceDecl(Node node, MappingScope mappingScope, PrintWriter printWriter) {
        switch (node.getNodeType()) {
            case 2: {
                DOM2Writer.printNamespaceDecl(((Attr)node).getOwnerElement(), node, mappingScope, printWriter);
                break;
            }
            case 1: {
                DOM2Writer.printNamespaceDecl((Element)node, node, mappingScope, printWriter);
            }
        }
    }

    private static void printNamespaceDecl(Element element, Node node, MappingScope mappingScope, PrintWriter printWriter) {
        String string = node.getNamespaceURI();
        String string2 = node.getPrefix();
        if (!(string.equals(NS_URI_XMLNS) && string2.equals("xmlns") || string.equals(NS_URI_XML) && string2.equals("xml"))) {
            if (XMLUtils.getNamespace(string2, element) == null) {
                printWriter.print(" xmlns:" + string2 + "=\"" + string + '\"');
            }
        } else {
            string2 = node.getLocalName();
            string = node.getNodeValue();
        }
        mappingScope.addMapping(string, string2);
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    if (i > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(JavaUtils.LS);
                            continue block7;
                        }
                        stringBuffer.append('\n');
                        continue block7;
                    }
                    stringBuffer.append(JavaUtils.LS);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

