/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class LockableHashtable
extends Hashtable {
    Set lockedEntries = new HashSet();
    private Map parent = null;

    public LockableHashtable() {
    }

    public LockableHashtable(int n, float f) {
        super(n, f);
    }

    public LockableHashtable(Map map) {
        this.putAll(map);
    }

    public LockableHashtable(int n) {
        super(n);
    }

    public synchronized void setParent(Map map) {
        this.parent = map;
    }

    public synchronized Object get(Object object) {
        Object v = super.get(object);
        if (v == null && this.parent != null) {
            v = this.parent.get(object);
        }
        return v;
    }

    public synchronized Object put(Object object, Object object2, boolean bl) {
        if (this.lockedEntries.contains(object)) {
            return null;
        }
        if (bl) {
            this.lockedEntries.add(object);
        }
        return super.put(object, object2);
    }

    public synchronized Object put(Object object, Object object2) {
        return this.put(object, object2, false);
    }

    public synchronized Object remove(Object object) {
        if (this.lockedEntries.contains(object)) {
            return null;
        }
        return super.remove(object);
    }

    public synchronized void clear() {
        super.clear();
        this.lockedEntries.clear();
    }

    public boolean isKeyLocked(Object object) {
        return this.lockedEntries.contains(object);
    }
}

