/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.Messages;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.apache.commons.logging.Log;

public class SessionUtils {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$utils$SessionUtils == null ? (class$com$ibm$ws$webservices$engine$utils$SessionUtils = SessionUtils.class$("com.ibm.ws.webservices.engine.utils.SessionUtils")) : class$com$ibm$ws$webservices$engine$utils$SessionUtils).getName());
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected static String algorithm = "MD5";
    protected static MessageDigest digest = null;
    protected static Random random = null;
    protected static String randomClass = "java.security.SecureRandom";
    private static String thisHost = null;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$utils$SessionUtils;

    public static synchronized String generateSessionId() {
        byte[] byArray = new byte[16];
        SessionUtils.getRandom().nextBytes(byArray);
        byArray = SessionUtils.getDigest().digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)((byArray[i] & 0xF0) >> 4);
            byte by2 = (byte)(byArray[i] & 0xF);
            if (by < 10) {
                stringBuffer.append((char)(48 + by));
            } else {
                stringBuffer.append((char)(65 + (by - 10)));
            }
            if (by2 < 10) {
                stringBuffer.append((char)(48 + by2));
                continue;
            }
            stringBuffer.append((char)(65 + (by2 - 10)));
        }
        return stringBuffer.toString();
    }

    public static synchronized Long generateSession() {
        return new Long(SessionUtils.getRandom().nextLong());
    }

    private static synchronized MessageDigest getDigest() {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.webservices.engine.utils.SessionUtils.getDigest", (String)"167");
                try {
                    digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    FFDCFilter.processException((Throwable)noSuchAlgorithmException2, (String)"com.ibm.ws.webservices.engine.utils.SessionUtils.getDigest", (String)"171");
                    digest = null;
                }
            }
        }
        return digest;
    }

    private static synchronized Random getRandom() {
        if (random == null) {
            try {
                Class<?> clazz = Class.forName(randomClass);
                random = (Random)clazz.newInstance();
                long l = System.currentTimeMillis();
                char[] cArray = SessionUtils.getEntropy().toCharArray();
                for (int i = 0; i < cArray.length; ++i) {
                    long l2 = (byte)cArray[i] << i % 8 * 8;
                    l ^= l2;
                }
                random.setSeed(l);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.utils.SessionUtils.getRandom", (String)"202");
                random = new Random();
            }
        }
        return random;
    }

    private static String getEntropy() {
        if (null == thisHost) {
            try {
                thisHost = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.webservices.engine.utils.SessionUtils.getEntropy", (String)"219");
                log.error((Object)Messages.getMessage("javaNetUnknownHostException00"), (Throwable)unknownHostException);
                thisHost = "localhost";
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringBuffer.hashCode()).append('.').append(System.currentTimeMillis()).append(".IBM.WEBSERVICES@").append(thisHost);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

