/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContextImpl;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.PEventProcessor;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.MappingTable;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContent;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.Node;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeaderElement;
import com.ibm.ws.webservices.engine.xmlsoap.Text;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import com.ibm.ws.webservices.engine.xmlsoap.ext.RequestResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPElement
extends Node
implements javax.xml.soap.SOAPElement,
Serializable {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$xmlsoap$SOAPElement == null ? (class$com$ibm$ws$webservices$engine$xmlsoap$SOAPElement = SOAPElement.class$("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement")) : class$com$ibm$ws$webservices$engine$xmlsoap$SOAPElement).getName());
    private String localPart;
    private String namespaceURI;
    private QName qName;
    private String prefix = "";
    protected transient Attributes attributes = NullAttributes.singleton;
    private ArrayList children = null;
    protected MappingScope mappingScope = null;
    Text textNode = null;
    private boolean isProtect = false;
    protected static ArrayList noChildren = new ArrayList();
    protected Object altContent = null;
    protected boolean altContentAffectsTagQName = false;
    protected boolean altContentAffectsTagAttributes = false;
    protected boolean inAsSOAPElement = false;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$xmlsoap$SOAPElement;

    SOAPElement(String string, String string2, SOAPFactory sOAPFactory) {
        super(sOAPFactory);
        if (string == null) {
            string = "";
        }
        this.namespaceURI = string;
        this.localPart = string2;
    }

    public void setParentElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement == null) {
            throw new SOAPException(Messages.getMessage("nullParent00"));
        }
        ((SOAPElement)sOAPElement).protectionCheck();
        this.protectionCheck();
        if (((SOAPElement)sOAPElement).getSOAPFactory() != this.soapFactory) {
            this.changeSOAPFactory(((SOAPElement)sOAPElement).getSOAPFactory());
        }
        if (sOAPElement != this.parent) {
            this.parent = (SOAPElement)sOAPElement;
            if (this.parent != null) {
                this.parent.addChildElement(this);
                if (this.mappingScope != null) {
                    this.mappingScope.setParent(this.parent.mappingScope);
                }
            }
        }
    }

    public javax.xml.soap.SOAPElement getParentElement() {
        return this.parent;
    }

    private void changeSOAPFactory(SOAPFactory sOAPFactory) {
        if (this.soapFactory != sOAPFactory) {
            this.soapFactory = sOAPFactory;
            if (this.children != null) {
                for (int i = 0; i < this.children.size(); ++i) {
                    SOAPElement sOAPElement = (SOAPElement)this.children.get(i);
                    sOAPElement.changeSOAPFactory(sOAPFactory);
                }
            }
        }
    }

    public String getValue() {
        this.asSOAPElement(false);
        if (this.textNode != null) {
            return this.textNode.getValue();
        }
        return null;
    }

    public javax.xml.soap.SOAPElement addAttribute(javax.xml.soap.Name name2, String string) throws SOAPException {
        try {
            this.addAttribute(name2.getURI(), name2.getLocalName(), string);
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addAttribute", (String)"276", (Object)this);
            throw new SOAPException(runtimeException);
        }
        return this;
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.Name name2) throws SOAPException {
        return this.addChildElement(name2.getLocalName(), name2.getPrefix(), name2.getURI());
    }

    public javax.xml.soap.SOAPElement addChildElement(String string) throws SOAPException {
        SOAPElement sOAPElement = this.createChildElement("", string, this.soapFactory);
        return this.addChildElement(sOAPElement);
    }

    public javax.xml.soap.SOAPElement addChildElement(String string, String string2) throws SOAPException {
        SOAPElement sOAPElement = this.createChildElement(this.getNamespaceURI(string2), string, this.soapFactory);
        sOAPElement.setPrefix(string2);
        return this.addChildElement(sOAPElement);
    }

    public javax.xml.soap.SOAPElement addChildElement(String string, String string2, String string3) throws SOAPException {
        SOAPElement sOAPElement = this.createChildElement(string3, string, this.soapFactory);
        sOAPElement.setPrefix(string2);
        sOAPElement.addNamespaceDeclaration(string2, string3);
        return this.addChildElement(sOAPElement);
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        this.asSOAPElement(false);
        try {
            if (this.children == null || !this.children.contains(sOAPElement)) {
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(sOAPElement);
                ((SOAPElement)sOAPElement).setParentElement(this);
            }
            return sOAPElement;
        }
        catch (ClassCastException classCastException) {
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addChildElement", (String)"377", (Object)this);
            throw new SOAPException(classCastException);
        }
    }

    public javax.xml.soap.SOAPElement addNamespaceDeclaration(String string, String string2) throws SOAPException {
        this.asSOAPElement(true);
        try {
            if (this.mappingScope == null) {
                this.createMappingScope();
            } else {
                Mapping mapping = this.mappingScope.getMappingForPrefix(string, false);
                if (mapping != null && mapping.getNamespaceURI() == string2) {
                    return this;
                }
            }
            this.protectionCheck();
            this.mappingScope.addMapping(string2, string);
            if (string != null && string.equals(this.prefix)) {
                this.namespaceURI = string2;
            }
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.addNamespaceDeclaration", (String)"416", (Object)this);
            throw new SOAPException(runtimeException);
        }
        return this;
    }

    public javax.xml.soap.SOAPElement addTextNode(String string) throws SOAPException {
        this.asSOAPElement(false);
        this.textNode = new Text(string, this.soapFactory);
        this.textNode.setParentElement(this);
        return this;
    }

    public Iterator getAllAttributes() {
        this.asSOAPElement(true);
        int n = this.attributes.getLength();
        Vector<Name> vector = new Vector<Name>(n);
        for (int i = 0; i < n; ++i) {
            int n2;
            String string = this.attributes.getQName(i);
            String string2 = "";
            if (string != null && (n2 = string.indexOf(":")) > 0) {
                string2 = string.substring(0, n2);
            }
            vector.add(new Name(this.attributes.getURI(i), this.attributes.getLocalName(i), string2));
        }
        return vector.iterator();
    }

    public String getAttributeValue(javax.xml.soap.Name name2) {
        this.asSOAPElement(true);
        return this.attributes.getValue(name2.getURI(), name2.getLocalName());
    }

    public Iterator getChildElements() {
        this.asSOAPElement(false);
        if (this.children == null && this.textNode == null) {
            return noChildren.iterator();
        }
        if (this.textNode == null) {
            return this.children.iterator();
        }
        ArrayList arrayList = null;
        arrayList = this.children == null ? new ArrayList() : (ArrayList)this.children.clone();
        arrayList.add(this.textNode);
        return arrayList.iterator();
    }

    public Iterator getChildElements(javax.xml.soap.Name name2) {
        return this.getChildElements(name2.getURI(), name2.getLocalName());
    }

    public javax.xml.soap.Name getElementName() {
        try {
            return new Name(this.getNamespaceURI(), this.getLocalPart(), this.getPrefix());
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.getElementName", (String)"537", (Object)this);
            throw new InternalException(sOAPException);
        }
    }

    public String getEncodingStyle() {
        this.asSOAPElement(true);
        String string = this.attributes.getValue(this.soapFactory.getSOAPConstants().getEnvelopeURI(), "encodingStyle");
        if (string == null) {
            string = this.parent == null ? "" : this.parent.getEncodingStyle();
        }
        return string;
    }

    public void setEncodingStyle(String string) throws SOAPException {
        this.asSOAPElement(true);
        if (string == null) {
            string = "";
        }
        if (string.equals(this.getEncodingStyle())) {
            return;
        }
        if (!string.equals("") && !Constants.isSOAP_ENC(string)) {
            throw new IllegalArgumentException(Messages.getMessage("illegalArgumentException01", string));
        }
        int n = this.attributes.getIndex(this.soapFactory.getSOAPConstants().getEnvelopeURI(), "encodingStyle");
        this.setAttribute(this.soapFactory.getSOAPConstants().getEnvelopeURI(), "encodingStyle", string);
        if (string.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            Mapping mapping = MappingTable.createMapping("http://schemas.xmlsoap.org/soap/encoding/");
            this.addNamespaceDeclaration(mapping.getPrefix(), mapping.getNamespaceURI());
        } else if (string.equals("http://www.w3.org/2002/06/soap-encoding")) {
            Mapping mapping = MappingTable.createMapping("http://www.w3.org/2002/06/soap-encoding");
            this.addNamespaceDeclaration(mapping.getPrefix(), mapping.getNamespaceURI());
        }
    }

    public Iterator getNamespacePrefixes() {
        this.asSOAPElement(true);
        Vector<String> vector = new Vector<String>();
        if (this.mappingScope != null) {
            for (int i = 0; i < this.mappingScope.size(); ++i) {
                Mapping mapping = this.mappingScope.get(i);
                vector.add(mapping.getPrefix());
            }
        }
        return vector.iterator();
    }

    public String getNamespaceURI(String string) {
        Mapping mapping;
        if (string == null) {
            string = "";
        }
        if (this.mappingScope != null && (mapping = this.mappingScope.getMappingForPrefix(string, false)) != null) {
            return mapping.getNamespaceURI();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage("noPrefix00", "" + this, string));
        }
        return null;
    }

    public boolean removeAttribute(javax.xml.soap.Name name2) {
        this.asSOAPElement(true);
        this.protectionCheck();
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        boolean bl = false;
        for (int i = 0; i < attributesImpl.getLength() && !bl; ++i) {
            if (!attributesImpl.getURI(i).equals(name2.getURI()) || !attributesImpl.getLocalName(i).equals(name2.getLocalName())) continue;
            attributesImpl.removeAttribute(i);
            bl = true;
        }
        return bl;
    }

    public boolean removeNamespaceDeclaration(String string) {
        this.asSOAPElement(true);
        this.protectionCheck();
        if (this.mappingScope != null) {
            return this.mappingScope.removeMappingForPrefix(string);
        }
        return false;
    }

    public void detachNode() {
        if (this.parent != null) {
            this.parent.removeChildElement(this);
            this.parent = null;
        }
    }

    public final String getNamespaceURI() {
        this.getLocalPart();
        return this.namespaceURI;
    }

    public final String getLocalPart() {
        if (this.localPart == null && this.altContent != null && this.altContentAffectsTagQName) {
            this.asSOAPElement(true);
        }
        return this.localPart;
    }

    public final QName getQName() {
        if (this.qName == null) {
            this.qName = QNameTable.createQName(this.getNamespaceURI(), this.getLocalPart());
        }
        return this.qName;
    }

    public final void setQName(QName qName) {
        this.qName = qName;
        this.localPart = qName.getLocalPart();
        this.namespaceURI = qName.getNamespaceURI();
    }

    public String getPrefix() throws SOAPException {
        if (this.prefix == null || this.prefix.length() == 0 && this.namespaceURI.length() > 0) {
            this.setPrefix(this.prefix);
        }
        return this.prefix;
    }

    public String setPrefix(String string) throws SOAPException {
        this.asSOAPElement(true);
        if ((string == null || string.length() == 0) && this.namespaceURI.length() > 0) {
            if (this.mappingScope == null) {
                this.createMappingScope();
            }
            string = this.mappingScope.getOrCreatePrefix(this.namespaceURI, string, false);
        }
        this.prefix = string;
        this.addNamespaceDeclaration(string, this.namespaceURI);
        return string;
    }

    public void setAttributes(Attributes attributes) {
        this.asSOAPElement(true);
        this.protectionCheck();
        if (!this.inAsSOAPElement && this.attributes != null && this.attributes.getLength() > 0) {
            throw new IllegalArgumentException(Messages.getMessage("setAttrsErr00"));
        }
        this.attributes = attributes == null || attributes.getLength() == 0 ? NullAttributes.singleton : new AttributesImpl(attributes);
    }

    protected AttributesImpl makeAttributesEditable() {
        this.asSOAPElement(true);
        if (this.attributes == null || this.attributes instanceof NullAttributes) {
            this.attributes = new AttributesImpl();
        } else if (!(this.attributes instanceof AttributesImpl)) {
            this.attributes = new AttributesImpl(this.attributes);
        }
        return (AttributesImpl)this.attributes;
    }

    public void addAttribute(String string, String string2, String string3) {
        String string4;
        this.asSOAPElement(true);
        this.protectionCheck();
        if (this.mappingScope == null) {
            this.createMappingScope();
        }
        String string5 = (string4 = this.mappingScope.getOrCreatePrefix(string, null, true)).length() > 0 ? string4 + ":" + string2 : string2;
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        attributesImpl.addAttribute(string, string2, string5, "CDATA", string3);
    }

    public void setAttribute(String string, String string2, String string3) {
        this.protectionCheck();
        AttributesImpl attributesImpl = this.makeAttributesEditable();
        int n = attributesImpl.getIndex(string, string2);
        if (n > -1) {
            if (string3 != null) {
                attributesImpl.setValue(n, string3);
            } else {
                attributesImpl.removeAttribute(n);
            }
            return;
        }
        this.addAttribute(string, string2, string3);
    }

    public String getAttributeValue(String string, String string2) {
        this.asSOAPElement(true);
        if (this.attributes == null) {
            return null;
        }
        if (string == null || string.length() == 0) {
            return this.attributes.getValue(string2);
        }
        return this.attributes.getValue(string, string2);
    }

    public void setMappingScope(MappingScope mappingScope) {
        this.asSOAPElement(true);
        this.protectionCheck();
        if (!this.inAsSOAPElement && this.mappingScope != null) {
            throw new IllegalArgumentException(Messages.getMessage("setMappingScopeErr00"));
        }
        this.mappingScope = (MappingScope)mappingScope.clone();
        if (this.parent != null) {
            this.mappingScope.setParent(this.parent.mappingScope);
        }
    }

    protected void removeChildElement(SOAPElement sOAPElement) {
        int n;
        this.asSOAPElement(false);
        this.protectionCheck();
        sOAPElement.protectionCheck();
        while ((n = this.children.indexOf(sOAPElement)) != -1) {
            this.children.remove(n);
        }
    }

    public int getNumChildren() {
        this.asSOAPElement(false);
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public SOAPElement getChildElement(int n) {
        this.asSOAPElement(false);
        return (SOAPElement)this.children.get(n);
    }

    public Iterator getChildElements(String string, String string2) {
        this.asSOAPElement(false);
        if (this.children == null) {
            return new Vector().iterator();
        }
        int n = this.children.size();
        Vector<SOAPElement> vector = new Vector<SOAPElement>(n);
        for (int i = 0; i < n; ++i) {
            SOAPElement sOAPElement = (SOAPElement)this.children.get(i);
            if (!sOAPElement.getNamespaceURI().equals(string) || !sOAPElement.getLocalPart().equals(string2)) continue;
            vector.add(sOAPElement);
        }
        return vector.iterator();
    }

    public SOAPElement getChildElement(String string, String string2) throws SOAPException {
        Iterator iterator = this.getChildElements(string, string2);
        if (iterator == null || !iterator.hasNext()) {
            return null;
        }
        SOAPElement sOAPElement = (SOAPElement)iterator.next();
        if (iterator.hasNext()) {
            throw new SOAPException(Messages.getMessage("getChildElementErr00", string, string2));
        }
        return sOAPElement;
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        return new SOAPElement(string, string2, sOAPFactory);
    }

    public final void output(SerializationContext serializationContext) throws Exception {
        if (this.mappingScope == null) {
            this.createMappingScope();
        }
        if (this.mappingScope.getParent() == null) {
            this.outputImpl(serializationContext, this.mappingScope);
        } else {
            this.outputImpl(serializationContext, this.mappingScope.flatten());
        }
    }

    protected void outputImpl(SerializationContext serializationContext, MappingScope mappingScope) throws Exception {
        Object object;
        Object object2;
        if (mappingScope == null) {
            mappingScope = this.mappingScope;
        }
        if ((object2 = this.getAlternateContent()) instanceof AlternateContent && (object = (AlternateContent)object2).isAffectingTagQName()) {
            String string = object.getAsString();
            serializationContext.getSerializationWriter().writeSnippet(object.getAsString(), mappingScope);
            return;
        }
        if (object2 instanceof Element) {
            boolean bl = serializationContext.getSerializationWriter().getPretty();
            serializationContext.getSerializationWriter().setPretty(false);
            serializationContext.getSerializationWriter().writeDOMElement((Element)object2);
            serializationContext.getSerializationWriter().setPretty(bl);
            return;
        }
        if (object2 instanceof ParamValue) {
            object = this.soapFactory.getMessageContext();
            ((ParamValue)object2).serialize(serializationContext);
            return;
        }
        if (this.isObjectContent()) {
            serializationContext.serialize(this.getQName(), null, object2, null, false, null);
            return;
        }
        if (this.prefix.length() == 0) {
            this.prefix = this.setPrefix("");
        }
        if (this.prefix != null && this.prefix.length() > 0 && this.namespaceURI != null && this.namespaceURI.length() > 0) {
            serializationContext.getSerializationWriter().addMapping(this.prefix, this.namespaceURI);
        }
        if ((object = this.getValue()) != null && this.altContent == null) {
            serializationContext.getSerializationWriter().simpleElement(this.getQName(), this.attributes, mappingScope, (String)object);
        } else {
            serializationContext.getSerializationWriter().startElement(this.getQName(), this.attributes, mappingScope);
            this.outputContentsImpl(serializationContext);
            serializationContext.getSerializationWriter().endElement();
        }
    }

    protected void outputContentsImpl(SerializationContext serializationContext) throws Exception {
        Object object = this.getAlternateContent();
        if (object != null) {
            if (object instanceof InputStream) {
                InputStream inputStream = (InputStream)object;
                try {
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    String string = new String(byArray);
                    serializationContext.getSerializationWriter().writeString(string);
                    this.altContent = new ByteArrayInputStream(string.getBytes("utf-8"));
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.outputContentsImpl", (String)"1254", (Object)this);
                    throw iOException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.outputContentsImpl", (String)"1258", (Object)this);
                    log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
                }
                return;
            }
            throw new SAXException(Messages.getMessage("altContentErr00", object.getClass().getName()));
        }
        String string = this.getValue();
        if (string != null) {
            serializationContext.getSerializationWriter().writeSafeString(string);
        } else if (this.children != null) {
            for (int i = 0; i < this.getNumChildren(); ++i) {
                this.getChildElement(i).outputImpl(serializationContext, null);
            }
        }
    }

    private String getAsString() throws Exception {
        SerializationContextImpl serializationContextImpl = null;
        StringWriter stringWriter = new StringWriter(1024);
        MessageContext messageContext = this.soapFactory.getMessageContext();
        serializationContextImpl = new SerializationContextImpl(stringWriter, messageContext, false);
        this.output(serializationContextImpl);
        stringWriter.close();
        return stringWriter.getBuffer().toString();
    }

    public String toXMLString() {
        return this.toString();
    }

    public String toString() {
        try {
            return this.getAsString();
        }
        catch (Exception exception) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)exception);
            return null;
        }
    }

    protected void createMappingScope() {
        this.mappingScope = new MappingScope();
        SOAPElement sOAPElement = (SOAPElement)this.getParentElement();
        if (sOAPElement != null) {
            if (sOAPElement.mappingScope == null) {
                sOAPElement.createMappingScope();
            }
            this.mappingScope.setParent(sOAPElement.mappingScope);
        }
    }

    public void toEvents(PEventProcessor pEventProcessor) throws SAXException {
        this.asSOAPElement(true);
        String string = this.getLocalPart();
        try {
            String string2 = this.getPrefix();
            if (string2.length() != 0) {
                string = string2 + ":" + this.prefix;
            }
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.toEvents", (String)"1348", (Object)this);
            throw new SAXException(sOAPException);
        }
        pEventProcessor.startElement(this.getNamespaceURI(), this.getLocalPart(), string, this.attributes, this.mappingScope, this);
        this.toContainedEvents(pEventProcessor);
        pEventProcessor.endElement(this.getNamespaceURI(), this.getLocalPart(), string);
    }

    protected void toContainedEvents(PEventProcessor pEventProcessor) throws SAXException {
        String string = this.getValue();
        if (string != null) {
            pEventProcessor.characters(string);
            return;
        }
        for (int i = 0; i < this.getNumChildren(); ++i) {
            SOAPElement sOAPElement = this.getChildElement(i);
            if (sOAPElement == null) continue;
            sOAPElement.toEvents(pEventProcessor);
        }
    }

    public Element getAsDOM() throws Exception {
        return this.getAsDocument().getDocumentElement();
    }

    public Document getAsDocument() throws Exception {
        String string = this.getAsString();
        StringReader stringReader = new StringReader(string);
        Document document = XMLUtils.newDocument(new InputSource(stringReader));
        if (document == null) {
            throw new Exception(Messages.getMessage("noDoc00", string));
        }
        return document;
    }

    public void setAlternateContent(Object object) throws SOAPException {
        this.protectionCheck();
        if (object == null) {
            this.altContent = null;
            return;
        }
        if (this.children != null && !this.children.isEmpty()) {
            SOAPException sOAPException = new SOAPException(Messages.getMessage("childPresent"));
            log.error((Object)Messages.getMessage("childPresent"), (Throwable)sOAPException);
            throw sOAPException;
        }
        if (this.altContent != null) {
            SOAPException sOAPException = new SOAPException(Messages.getMessage("altContentAlreadySet00"));
            throw sOAPException;
        }
        if (object instanceof InputStream || object instanceof RequestResponse) {
            this.altContentAffectsTagQName = false;
            this.altContentAffectsTagAttributes = false;
        } else if (object instanceof ParamValue || object instanceof Element) {
            this.altContentAffectsTagQName = true;
            this.altContentAffectsTagAttributes = true;
        } else if (object instanceof AlternateContent) {
            this.altContentAffectsTagQName = ((AlternateContent)object).isAffectingTagQName();
            this.altContentAffectsTagAttributes = ((AlternateContent)object).isAffectingTagAttribute();
        } else {
            this.altContentAffectsTagQName = false;
            this.altContentAffectsTagAttributes = true;
        }
        this.altContent = object;
    }

    public Object getAlternateContent() {
        return this.altContent;
    }

    protected void asSOAPElement(boolean bl) {
        if (this.altContent == null || bl && !this.altContentAffectsTagAttributes || this.inAsSOAPElement || this.getAlternateContent() == null) {
            return;
        }
        this.inAsSOAPElement = true;
        Object object = null;
        P2DConverter p2DConverter = this.soapFactory.getDeserializationContext().getEventConverter();
        try {
            try {
                Serializable serializable;
                Object object2;
                Object object3 = this.getAlternateContent();
                if (object3 instanceof ParamValue && this instanceof SOAPHeaderElement) {
                    object2 = (SOAPEnvelope)this.parent.getParentElement();
                    serializable = (SOAPBody)((SOAPEnvelope)object2).getBody();
                    this.inAsSOAPElement = false;
                    serializable.asSOAPElement(false);
                    this.inAsSOAPElement = true;
                }
                while (this.getNumChildren() > 0) {
                    this.removeChildElement(this.getChildElement(0));
                }
                if (this.textNode != null) {
                    this.textNode.detachNode();
                }
                object2 = this.getAsString();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("asSOAPElement xmlText=" + (String)object2));
                }
                serializable = new RuntimeException(Messages.getMessage("saajtransform00", (String)object2));
                MessageContext messageContext = this.soapFactory.getMessageContext();
                if (messageContext != null) {
                    if (messageContext.isPropertyTrue(MessageContext.FAULT_ON_SAAJ_TRANSFORMATION)) {
                        throw serializable;
                    }
                    if (messageContext.getProperty(MessageContext.SAAJ_TRANSFORMATION) == null) {
                        messageContext.setProperty(MessageContext.SAAJ_TRANSFORMATION, serializable);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)serializable);
                    }
                }
                InputSource inputSource = new InputSource(new StringReader((String)object2));
                this.altContent = null;
                SOAPBuilder sOAPBuilder = this.createBuilder();
                sOAPBuilder.setMyElement(this);
                object = p2DConverter.saveState();
                p2DConverter.pushDEventProcessor(new WrapperProcessor(sOAPBuilder));
                SAXParser sAXParser = XMLUtils.getSAXParser();
                p2DConverter.startDocument();
                sAXParser.parse(inputSource, (DefaultHandler)p2DConverter);
                p2DConverter.endDocument();
                p2DConverter.popDEventProcessor();
                object = null;
                XMLUtils.releaseSAXParser(sAXParser);
                this.setProtect(this.isProtect);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.SOAPElement.asSOAPElement", (String)"1675", (Object)this);
                throw new InternalException(exception);
            }
            Object var12_12 = null;
            this.inAsSOAPElement = false;
            if (object != null) {
                p2DConverter.restoreState(object);
                object = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.inAsSOAPElement = false;
            if (object != null) {
                p2DConverter.restoreState(object);
                object = null;
            }
            throw throwable;
        }
    }

    public boolean isInAsSOAPElement() {
        return this.inAsSOAPElement;
    }

    public boolean rebuildTagQName() {
        return this.altContentAffectsTagQName && this.inAsSOAPElement;
    }

    public boolean rebuildAttributesAndMapping() {
        return this.altContentAffectsTagAttributes && this.inAsSOAPElement;
    }

    public Object asObject() throws Exception {
        QName qName = this.getType();
        if (qName == null) {
            qName = QNameTable.createQName(this.namespaceURI, ">" + this.localPart);
        }
        try {
            return this.asObject(qName);
        }
        catch (Exception exception) {
            return this;
        }
    }

    public Object asObject(QName qName) throws Exception {
        if (this.isObjectContent()) {
            return this.getAlternateContent();
        }
        Object object = this.convertToObject(qName);
        while (this.getNumChildren() > 0) {
            this.removeChildElement(this.getChildElement(0));
        }
        if (this.textNode != null) {
            this.textNode.detachNode();
        }
        this.altContent = null;
        this.setAlternateContent(object);
        return this.altContent;
    }

    protected QName getType() {
        SOAPElement sOAPElement;
        String string;
        this.asSOAPElement(true);
        QName qName = AttributeUtils.getTypeFromAttributes(this.namespaceURI, this.localPart, this.attributes, this.mappingScope);
        if (this.attributes.getValue(Constants.URI_DEFAULT_SOAP_ENC, "arrayType") != null) {
            qName = Constants.SOAP_ARRAY;
        }
        if (qName == null && this.soapFactory.getDeserializationContext() != null && (string = AttributeUtils.getHref(this.attributes)) != null && (sOAPElement = this.soapFactory.getDeserializationContext().getHrefTable().getElementByHref(string)) != null) {
            qName = sOAPElement.getType();
        }
        return qName;
    }

    private Object convertToObject(QName qName) throws Exception {
        if (this.soapFactory.getDeserializationContext() == null) {
            throw new Exception(Messages.getMessage("noContext00"));
        }
        Deserializer deserializer = this.soapFactory.getDeserializationContext().getDeserializer(null, qName);
        if (deserializer == null) {
            throw new Exception(Messages.getMessage("noDeser00", "" + qName));
        }
        P2DConverter p2DConverter = this.soapFactory.getDeserializationContext().getEventConverter();
        p2DConverter.pushDEventProcessor(new WrapperProcessor(deserializer));
        this.toEvents(p2DConverter);
        return deserializer.getValue();
    }

    protected boolean isObjectContent() throws Exception {
        Object object = this.getAlternateContent();
        return object != null && !(object instanceof Element) && !(object instanceof InputStream) && !(object instanceof ParamValue);
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPBuilder();
    }

    public void setProtect(boolean bl) {
        this.isProtect = bl;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                SOAPElement sOAPElement = (SOAPElement)this.children.get(i);
                if (sOAPElement.isProtect == bl) continue;
                sOAPElement.setProtect(bl);
            }
        }
    }

    protected final void protectionCheck() {
        if (this.isProtect && !this.inAsSOAPElement && this.soapFactory.getProtectState()) {
            try {
                SOAPElement sOAPElement = this;
                while (!(sOAPElement instanceof SOAPEnvelope)) {
                    sOAPElement = sOAPElement.parent;
                }
                sOAPElement = (SOAPBody)((SOAPEnvelope)sOAPElement).getBody();
                sOAPElement.isProtect = false;
            }
            catch (SOAPException sOAPException) {
                // empty catch block
            }
            this.getSOAPFactory().setProtectionViolation(true);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        try {
            this.setAlternateContent(new SOAPFactory.StringAlternateContent(string));
        }
        catch (SOAPException sOAPException) {
            throw new IOException(sOAPException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

