/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.xmlsoap.Name;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFactory;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPHeader;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPEnvelopeBuilder;
import java.util.Iterator;
import javax.xml.soap.SOAPException;
import org.apache.commons.logging.Log;

public final class SOAPEnvelope
extends SOAPElement
implements javax.xml.soap.SOAPEnvelope {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$engine$xmlsoap$SOAPEnvelope == null ? (class$com$ibm$ws$webservices$engine$xmlsoap$SOAPEnvelope = SOAPEnvelope.class$("com.ibm.ws.webservices.engine.xmlsoap.SOAPEnvelope")) : class$com$ibm$ws$webservices$engine$xmlsoap$SOAPEnvelope).getName());
    private SOAPHeader header;
    private SOAPBody body;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$xmlsoap$SOAPEnvelope;

    SOAPEnvelope(SOAPFactory sOAPFactory) throws SOAPException {
        this(false, sOAPFactory);
    }

    SOAPEnvelope(boolean bl, SOAPFactory sOAPFactory) throws SOAPException {
        super(sOAPFactory.getSOAPConstants().getEnvelopeURI(), "Envelope", sOAPFactory);
        if (bl) {
            this.bootstrap();
        }
        this.addHeader();
        this.addBody();
    }

    private void bootstrap() throws SOAPException {
        this.addNamespaceDeclaration("soapenv", this.soapFactory.getSOAPConstants().getEnvelopeURI());
        this.addNamespaceDeclaration("soapenc", this.soapFactory.getSOAPConstants().getEncodingURI());
        this.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public javax.xml.soap.SOAPBody addBody() throws SOAPException {
        if (this.body == null) {
            this.addChildElement(new SOAPBody(this.soapFactory));
            return this.body;
        }
        throw new SOAPException(Messages.getMessage("bodyPresent"));
    }

    public javax.xml.soap.SOAPHeader addHeader() throws SOAPException {
        if (this.header == null) {
            this.addChildElement(new SOAPHeader(this.soapFactory));
            return this.header;
        }
        throw new SOAPException(Messages.getMessage("headerPresent"));
    }

    public javax.xml.soap.Name createName(String string) throws SOAPException {
        return new Name("", string, "");
    }

    public javax.xml.soap.Name createName(String string, String string2, String string3) throws SOAPException {
        return new Name(string3, string, string2);
    }

    public javax.xml.soap.SOAPBody getBody() throws SOAPException {
        return this.body;
    }

    public javax.xml.soap.SOAPHeader getHeader() throws SOAPException {
        return this.header;
    }

    public javax.xml.soap.SOAPElement addChildElement(javax.xml.soap.SOAPElement sOAPElement) throws SOAPException {
        if (sOAPElement instanceof SOAPHeader) {
            if (this.header != null && this.header != sOAPElement) {
                this.header.detachNode();
            }
            this.header = (SOAPHeader)sOAPElement;
            super.addChildElement(sOAPElement);
            return sOAPElement;
        }
        if (sOAPElement instanceof SOAPBody) {
            if (this.body != null && this.body != sOAPElement) {
                this.body.detachNode();
            }
            this.body = (SOAPBody)sOAPElement;
            super.addChildElement(sOAPElement);
            return sOAPElement;
        }
        throw new SOAPException(Messages.getMessage("addChildElement2Err00", sOAPElement.getClass().getName(), this.getClass().getName()));
    }

    public void outputImpl(SerializationContext serializationContext, MappingScope mappingScope) throws Exception {
        if (mappingScope == null) {
            mappingScope = this.mappingScope;
        }
        serializationContext.getSerializationWriter().startElement(this.getQName(), this.attributes, mappingScope);
        Iterator iterator = this.getChildElements();
        while (iterator.hasNext()) {
            SOAPElement sOAPElement = (SOAPElement)iterator.next();
            if (sOAPElement instanceof SOAPHeader || sOAPElement instanceof SOAPBody) continue;
            sOAPElement.output(serializationContext);
        }
        if (this.header != null) {
            this.header.outputImpl(serializationContext, null);
        }
        if (this.body != null) {
            this.body.outputImpl(serializationContext, null);
        }
        serializationContext.getSerializationWriter().endElement();
    }

    protected void removeChildElement(SOAPElement sOAPElement) {
        super.removeChildElement(sOAPElement);
        if (sOAPElement == this.body) {
            this.body = null;
        }
        if (sOAPElement == this.header) {
            this.header = null;
        }
    }

    protected SOAPBuilder createBuilder() {
        return new SOAPEnvelopeBuilder(this);
    }

    protected SOAPElement createChildElement(String string, String string2, SOAPFactory sOAPFactory) throws SOAPException {
        throw new SOAPException(Messages.getMessage("addChildElementErr00", this.getClass().getName()));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

