/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.builders;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.Callback;
import com.ibm.ws.webservices.engine.encoding.utils.CallbackTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPFault;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPBuilder;
import com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultDetailsBuilder;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SOAPFaultBuilder
extends SOAPBuilder
implements Callback {
    boolean waiting = false;
    boolean passedEnd = false;
    protected DeserializationContext context;
    static HashMap fields = new HashMap();
    protected QName faultCode = null;
    protected String faultString = null;
    protected String faultActor = null;
    protected Element[] faultDetails;
    protected Class faultClass = null;
    protected Object faultData = null;
    private static HashMap TYPES;
    static /* synthetic */ Class class$com$ibm$ws$webservices$engine$WebServicesFault;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;

    public SOAPFaultBuilder(DeserializationContext deserializationContext) {
        this.context = deserializationContext;
    }

    void setFaultData(Object object) {
        this.faultData = object;
        if (this.waiting && this.passedEnd) {
            this.createFault();
        }
        this.waiting = false;
    }

    public void setFaultClass(Class clazz) {
        this.faultClass = clazz;
    }

    public void endElement(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        super.endElement(string, string2, deserializationContext);
        if (!this.waiting) {
            this.createFault();
        } else {
            this.passedEnd = true;
        }
    }

    void setWaiting(boolean bl) {
        this.waiting = bl;
    }

    private void createFault() {
        WebServicesFault webServicesFault = null;
        if (this.faultClass != null) {
            try {
                Serializable serializable;
                Serializable serializable2;
                if (this.faultData != null) {
                    serializable2 = null;
                    if (this.faultData instanceof Exception) {
                        serializable2 = (Exception)this.faultData;
                    } else {
                        serializable = this.ConvertWrapper(this.faultData.getClass());
                        Constructor constructor = this.faultClass.getConstructor(new Class[]{serializable});
                        serializable2 = (Exception)constructor.newInstance(this.faultData);
                    }
                    if (serializable2 != null) {
                        webServicesFault = WebServicesFault.makeUserFault(serializable2, this.faultCode);
                    }
                }
                if ((class$com$ibm$ws$webservices$engine$WebServicesFault == null ? (class$com$ibm$ws$webservices$engine$WebServicesFault = SOAPFaultBuilder.class$("com.ibm.ws.webservices.engine.WebServicesFault")) : class$com$ibm$ws$webservices$engine$WebServicesFault).isAssignableFrom(this.faultClass)) {
                    if (webServicesFault == null) {
                        webServicesFault = (WebServicesFault)this.faultClass.newInstance();
                    }
                    webServicesFault.setFaultCode(this.faultCode);
                    webServicesFault.setFaultString(this.faultString);
                    webServicesFault.setFaultActor(this.faultActor);
                    webServicesFault.setFaultDetail(this.faultDetails);
                }
                if (webServicesFault == null && (serializable2 = this.getFaultDesc()) != null) {
                    serializable = (Exception)this.faultClass.newInstance();
                    webServicesFault = WebServicesFault.makeUserFault((Exception)serializable, this.faultCode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (webServicesFault == null) {
            webServicesFault = new WebServicesFault(this.faultCode, this.faultString, this.faultActor, this.faultDetails);
        }
        ((SOAPFault)this.myElement).setFault(webServicesFault);
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        try {
            DEventProcessor dEventProcessor = null;
            QName qName = (QName)fields.get(string2);
            if (qName != null) {
                Deserializer deserializer = deserializationContext.getDeserializer(null, qName);
                if (deserializer != null) {
                    deserializer.registerValueTarget(new CallbackTarget(this, string2));
                }
                dEventProcessor = deserializer;
            } else if (string2.equals("detail")) {
                dEventProcessor = new SOAPFaultDetailsBuilder(this);
                this.myChildElement = this.myElement.getSOAPFactory().createDetail(attributes, mappingScope, deserializationContext, (SOAPFault)this.myElement);
                ((SOAPBuilder)dEventProcessor).setMyElement(this.myChildElement);
            }
            return dEventProcessor;
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder.onStartChild", (String)"260", (Object)this);
            throw new SAXException(sOAPException);
        }
    }

    public void onEndChild(String string, String string2, DeserializationContext deserializationContext) throws SAXException {
        if ("detail".equals(string2) && this.myChildElement.getNumChildren() > 0) {
            Element[] elementArray = new Element[this.myChildElement.getNumChildren()];
            for (int i = 0; i < this.myChildElement.getNumChildren(); ++i) {
                try {
                    elementArray[i] = this.myChildElement.getChildElement(i).getAsDOM();
                    continue;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.builders.SOAPFaultBuilder.onEndChild", (String)"275", (Object)this);
                    throw new SAXException(exception);
                }
            }
            this.faultDetails = elementArray;
        }
        super.onEndChild(string, string2, deserializationContext);
    }

    public void setValue(Object object, Object object2) {
        String string = (String)object2;
        if (string.equals("faultcode")) {
            int n;
            this.faultCode = (QName)object;
            String string2 = this.faultCode.getLocalPart();
            if (string2 != null && string2.startsWith("{") && (n = string2.indexOf("}")) > 0) {
                String string3 = string2.substring(1, n);
                string2 = string2.substring(n + 1);
                this.faultCode = QNameTable.createQName(string3, string2);
            }
            this.setFaultClassFromFaultCode();
        } else if (string.equals("faultstring")) {
            this.faultString = (String)object;
        } else if (string.equals("faultactor")) {
            this.faultActor = (String)object;
        }
    }

    QName getFaultCode() {
        return this.faultCode;
    }

    private void setFaultClassFromFaultCode() {
        FaultDesc faultDesc = this.getFaultDesc();
        if (faultDesc != null) {
            try {
                Class clazz = ClassUtils.forName(faultDesc.getClassName());
                this.setFaultClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    FaultDesc getFaultDesc() {
        MessageContext messageContext = this.context.getMessageContext();
        OperationDesc operationDesc = messageContext.getOperation();
        if (operationDesc != null) {
            return operationDesc.getFaultByFaultCode(this.faultCode);
        }
        return null;
    }

    private Class ConvertWrapper(Class clazz) {
        Class clazz2 = (Class)TYPES.get(clazz);
        if (clazz2 != null) {
            return clazz2;
        }
        return clazz;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fields.put("faultcode", Constants.XSD_QNAME);
        fields.put("faultstring", Constants.XSD_STRING);
        fields.put("faultactor", Constants.XSD_STRING);
        fields.put("detail", null);
        TYPES = new HashMap(7);
        TYPES.put(class$java$lang$Integer == null ? (class$java$lang$Integer = SOAPFaultBuilder.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE);
        TYPES.put(class$java$lang$Float == null ? (class$java$lang$Float = SOAPFaultBuilder.class$("java.lang.Float")) : class$java$lang$Float, Float.TYPE);
        TYPES.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SOAPFaultBuilder.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.TYPE);
        TYPES.put(class$java$lang$Double == null ? (class$java$lang$Double = SOAPFaultBuilder.class$("java.lang.Double")) : class$java$lang$Double, Double.TYPE);
        TYPES.put(class$java$lang$Byte == null ? (class$java$lang$Byte = SOAPFaultBuilder.class$("java.lang.Byte")) : class$java$lang$Byte, Byte.TYPE);
        TYPES.put(class$java$lang$Short == null ? (class$java$lang$Short = SOAPFaultBuilder.class$("java.lang.Short")) : class$java$lang$Short, Short.TYPE);
        TYPES.put(class$java$lang$Long == null ? (class$java$lang$Long = SOAPFaultBuilder.class$("java.lang.Long")) : class$java$lang$Long, Long.TYPE);
    }
}

