/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.engine.events.P2DConverter;
import com.ibm.ws.webservices.engine.events.WrapperProcessor;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.NullAttributes;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPBody;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import com.ibm.ws.webservices.engine.xmlsoap.builders.RequestResponseProcessor;
import com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.xml.sax.SAXException;

public final class RequestResponse {
    protected Vector params = new Vector();
    protected boolean needDeser = false;
    OperationDesc[] tryOperations = null;
    OperationDesc operation = null;
    DeserializationContext context = null;
    SOAPBody body;
    boolean isResponse;
    QName qName = null;
    boolean inDeserialize = false;

    public RequestResponse(String string, String string2, SOAPBody sOAPBody, boolean bl, OperationDesc[] operationDescArray, DeserializationContext deserializationContext) throws SOAPException {
        this.body = sOAPBody;
        this.isResponse = bl;
        this.tryOperations = operationDescArray;
        if (operationDescArray != null && operationDescArray.length == 1) {
            this.operation = operationDescArray[0];
        }
        this.context = deserializationContext;
        this.qName = QNameTable.createQName(string, string2);
        if (sOAPBody != null) {
            sOAPBody.setAlternateContent(this);
        }
    }

    public RequestResponse(String string, String string2, SOAPBody sOAPBody, boolean bl) throws SOAPException {
        this.body = sOAPBody;
        this.isResponse = bl;
        this.qName = QNameTable.createQName(string, string2);
        if (sOAPBody != null) {
            sOAPBody.setAlternateContent(this);
        }
    }

    public SOAPBody getBody() {
        return this.body;
    }

    public void attachToBody(SOAPBody sOAPBody) throws SOAPException {
        this.body = sOAPBody;
        if (sOAPBody != null) {
            sOAPBody.setAlternateContent(this);
        }
    }

    public QName getQName() {
        return this.qName;
    }

    public OperationDesc getOperation() throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        return this.operation;
    }

    public void addParams(Object[] objectArray) {
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (objectArray[i] instanceof ParamValue) {
                this.addParam((ParamValue)objectArray[i]);
                continue;
            }
            String string = null;
            if (string == null) {
                string = "arg" + i;
            }
            this.addParam(new ParamValue("", string, objectArray[i]));
        }
    }

    public void setNeedDeser(boolean bl) {
        this.needDeser = bl;
    }

    public boolean hasDeserializedParams() {
        return !this.needDeser;
    }

    private void deserialize(DeserializationContext deserializationContext) throws SAXException {
        Serializable serializable;
        this.inDeserialize = true;
        this.operation = null;
        this.params.clear();
        MessageContext messageContext = deserializationContext.getMessageContext();
        Message message = messageContext.getCurrentMessage();
        RequestResponseProcessor requestResponseProcessor = new RequestResponseProcessor(this, this.isResponse);
        P2DConverter p2DConverter = deserializationContext.getEventConverter();
        Object object = null;
        if (this.tryOperations != null) {
            serializable = null;
            this.pruneDocLitOperations();
            for (int i = 0; i < this.tryOperations.length; ++i) {
                this.operation = this.tryOperations[i];
                requestResponseProcessor.setOperation(this.operation);
                try {
                    SOAPElement sOAPElement = this.operation.getStyle() == Style.DOCUMENT ? this.body : this.body.getChildElement(0);
                    object = p2DConverter.saveState();
                    p2DConverter.pushDEventProcessor(new WrapperProcessor(requestResponseProcessor));
                    sOAPElement.toEvents(p2DConverter);
                    messageContext.setOperation(this.operation);
                    if (object != null) {
                        p2DConverter.restoreState(object);
                        object = null;
                    }
                    this.updateQName();
                    this.needDeser = false;
                    return;
                }
                catch (SAXException sAXException) {
                    if (serializable == null) {
                        serializable = sAXException;
                    }
                    if (object != null) {
                        p2DConverter.restoreState(object);
                        object = null;
                    }
                    this.params.clear();
                    continue;
                }
            }
            if (serializable != null) {
                throw serializable;
            }
            if (!messageContext.isClient()) {
                throw new SAXException(Messages.getMessage("noSuchOperation", this.body.getChildElement(0).getLocalPart()));
            }
            requestResponseProcessor.setOperation(this.tryOperations[0]);
            this.operation = this.tryOperations[0];
            this.updateQName();
        }
        serializable = this.tryOperations != null && this.tryOperations.length > 0 && this.operation.getStyle() == Style.DOCUMENT ? this.body : this.body.getChildElement(0);
        p2DConverter.pushDEventProcessor(new WrapperProcessor(requestResponseProcessor));
        serializable.toEvents(p2DConverter);
        this.needDeser = false;
        this.inDeserialize = false;
    }

    private void updateQName() {
        if (this.operation != null && !this.isResponse && this.operation.getStyle() == Style.DOCUMENT) {
            this.qName = this.operation.getElementQName();
        }
    }

    public ParamValue getParam(String string) throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            ParamValue paramValue = (ParamValue)this.params.elementAt(i);
            if (!paramValue.getName().equals(string)) continue;
            return paramValue;
        }
        return null;
    }

    public Vector getParams() throws SAXException {
        if (this.needDeser && !this.inDeserialize) {
            this.deserialize(this.context);
        }
        return this.params;
    }

    public void addParam(ParamValue paramValue) {
        this.params.addElement(paramValue);
    }

    public void outputImpl(SerializationContext serializationContext) throws Exception {
        boolean bl;
        String string = this.body.getEncodingStyle();
        MessageContext messageContext = serializationContext.getMessageContext();
        boolean bl2 = bl = messageContext == null || messageContext.getOperationStyle() == Style.RPC || messageContext.getOperationStyle() == Style.WRAPPED;
        if (bl) {
            serializationContext.getSerializationWriter().startElement(this.qName, NullAttributes.singleton);
        }
        for (int i = 0; i < this.params.size(); ++i) {
            ParamValue paramValue = (ParamValue)this.params.elementAt(i);
            ParameterDesc parameterDesc = paramValue.getParamDesc();
            if (parameterDesc != null && (!this.isResponse || parameterDesc.isOutHeader()) && (this.isResponse || parameterDesc.isInHeader())) continue;
            paramValue.serialize(serializationContext);
        }
        if (bl) {
            serializationContext.getSerializationWriter().endElement();
        }
    }

    private void pruneDocLitOperations() throws SAXException {
        if (this.isResponse || this.tryOperations.length <= 1 || this.tryOperations[0].getStyle() != Style.DOCUMENT || this.tryOperations[0].getUse() != Use.LITERAL) {
            return;
        }
        ArrayList<QName> arrayList = new ArrayList<QName>();
        for (int i = 0; i < this.body.getNumChildren(); ++i) {
            QName qName = this.body.getChildElement(i).getQName();
            if (arrayList.contains(qName)) continue;
            arrayList.add(qName);
        }
        ArrayList<OperationDesc> arrayList2 = new ArrayList<OperationDesc>();
        for (int i = 0; i < this.tryOperations.length; ++i) {
            int n;
            OperationDesc operationDesc = this.tryOperations[i];
            boolean bl = true;
            ParameterDesc parameterDesc = null;
            for (n = 0; n < arrayList.size() && bl; ++n) {
                QName qName = (QName)arrayList.get(n);
                ParameterDesc parameterDesc2 = operationDesc.getInputParamByQName(qName);
                if (parameterDesc2 == null || parameterDesc2.isInHeader()) {
                    bl = false;
                    continue;
                }
                if (parameterDesc != null && parameterDesc.getOrder() > parameterDesc2.getOrder()) {
                    bl = false;
                    continue;
                }
                parameterDesc = parameterDesc2;
            }
            if (!bl) continue;
            for (n = 0; n < arrayList2.size() && ((OperationDesc)arrayList2.get(n)).getNumInParams(true) < operationDesc.getNumInParams(true); ++n) {
            }
            arrayList2.add(n, operationDesc);
        }
        if (arrayList2.size() == 0) {
            throw new SAXException(Messages.getMessage("noSuchOperation", this.body.getChildElement(0).getLocalPart()));
        }
        if (arrayList2.size() > 1 && ((OperationDesc)arrayList2.get(0)).getNumInParams(true) == ((OperationDesc)arrayList2.get(1)).getNumInParams(true)) {
            throw new SAXException(Messages.getMessage("noSuchOperation", this.body.getChildElement(0).getLocalPart()));
        }
        this.tryOperations = new OperationDesc[1];
        this.tryOperations[0] = (OperationDesc)arrayList2.get(0);
    }
}

