/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.handlers;

import com.ibm.websphere.pmi.WebServicesPerf;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import org.apache.commons.logging.Log;

class MessagePMIContext {
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$handlers$MessagePMIContext == null ? (class$com$ibm$ws$webservices$handlers$MessagePMIContext = MessagePMIContext.class$("com.ibm.ws.webservices.handlers.MessagePMIContext")) : class$com$ibm$ws$webservices$handlers$MessagePMIContext).getName());
    public static final String propertyName = (class$com$ibm$ws$webservices$handlers$MessagePMIContext == null ? (class$com$ibm$ws$webservices$handlers$MessagePMIContext = MessagePMIContext.class$("com.ibm.ws.webservices.handlers.MessagePMIContext")) : class$com$ibm$ws$webservices$handlers$MessagePMIContext).getName();
    private final WebServicesPerf.ServicePerf pmiServiceModule;
    private long receivedRequestTime = 0L;
    private long sentRequestTime = 0L;
    private long receivedReplyTime = 0L;
    private long sentReplyTime = 0L;
    private final long STATE_RECEIVE_REQUEST = 0L;
    private final long STATE_SEND_REQUEST = 1L;
    private final long STATE_RECEIVE_REPLY = 2L;
    private final long STATE_SEND_REPLY = 3L;
    private final long STATE_DONE = 4L;
    private long next_state = 0L;
    static /* synthetic */ Class class$com$ibm$ws$webservices$handlers$MessagePMIContext;

    MessagePMIContext(MessageContext messageContext, WebServicesPerf webServicesPerf, String string) {
        this.pmiServiceModule = webServicesPerf.getService(string);
    }

    void onServiceReceiveRequest(long l) {
        this.receivedRequestTime = this.pmiServiceModule.getPMILevel() >= 3 ? System.currentTimeMillis() : 0L;
        this.pmiServiceModule.onServiceReceiveRequest(l);
        this.next_state = 1L;
    }

    void onServiceSendRequest() {
        if (this.pmiServiceModule.getPMILevel() >= 3) {
            this.sentRequestTime = System.currentTimeMillis();
            this.pmiServiceModule.onServiceSendRequest(this.sentRequestTime - this.receivedRequestTime);
        } else {
            this.sentRequestTime = 0L;
            this.pmiServiceModule.onServiceSendRequest(0L);
        }
        this.next_state = 2L;
    }

    void onServiceReceiveReply(long l) {
        if (this.pmiServiceModule.getPMILevel() >= 3) {
            this.receivedReplyTime = System.currentTimeMillis();
            this.pmiServiceModule.onServiceReceiveReply(l, this.receivedReplyTime - this.sentRequestTime);
        } else {
            this.receivedReplyTime = 0L;
            this.pmiServiceModule.onServiceReceiveReply(l, 0L);
        }
        this.next_state = 3L;
    }

    void onServiceSendReply() {
        if (this.pmiServiceModule.getPMILevel() >= 3) {
            this.sentReplyTime = System.currentTimeMillis();
            this.pmiServiceModule.onServiceSendReply(this.sentReplyTime - this.receivedReplyTime, this.sentReplyTime - this.receivedRequestTime);
        } else {
            this.sentReplyTime = 0L;
            this.pmiServiceModule.onServiceSendReply(0L, 0L);
        }
        this.next_state = 4L;
    }

    void close(MessageContext messageContext) {
        if (this.next_state == 1L) {
            this.onServiceSendRequest();
        }
        if (this.next_state == 2L) {
            long l = messageContext == null ? 0L : this.getLength(messageContext.getResponseMessage(), null);
            this.onServiceReceiveReply(l);
        }
        if (this.next_state == 3L) {
            this.onServiceSendReply();
        }
    }

    long getLength(Message message, String string) {
        long l;
        if (this.pmiServiceModule.getPMILevel() >= 7) {
            if (message == null) {
                l = 0L;
                if (string != null) {
                    log.error((Object)Messages.getMessage("requestMessageMissing00"));
                }
            } else {
                try {
                    l = message.getContentLength();
                }
                catch (WebServicesFault webServicesFault) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unable to determine message length, will log 0", (Throwable)webServicesFault);
                    }
                    l = 0L;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("PMI message length = " + l));
            }
        } else {
            l = 0L;
        }
        return l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

