/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.description.ParameterDesc;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Port;
import javax.xml.namespace.QName;

public class InvocationContext {
    private ServiceContext serviceContext = null;
    private Class generatedStubClass;
    private String endpoint;
    private Class seiClass;
    private Class[] argClasses;
    private String portName;
    private String inputMessageName;
    private HashMap properties = new HashMap();
    private ArrayList propertyNames = new ArrayList();

    public InvocationContext(ServiceContext serviceContext) {
        this.serviceContext = serviceContext != null ? serviceContext : new ServiceContext(null, null, null);
    }

    public String toString() {
        String string = "InvocationContext: [seiClass=" + this.seiClass.getName() + ", generatedStubClass=" + this.generatedStubClass.getName() + ", endpoint=" + this.endpoint + ", portName=" + (this.portName != null ? this.portName.toString() : "<null>") + "]";
        return string;
    }

    public void setServiceContext(ServiceContext serviceContext) {
        if (serviceContext != null) {
            this.serviceContext = serviceContext;
        }
    }

    public ServiceContext getServiceContext() {
        return this.serviceContext;
    }

    public Class getGeneratedStubClass() {
        return this.generatedStubClass;
    }

    public void setGeneratedStubClass(Class clazz) {
        this.generatedStubClass = clazz;
    }

    public boolean isUsingGeneratedStub() {
        return this.generatedStubClass != null;
    }

    public void setArgClasses(Class[] classArray) {
        this.argClasses = classArray;
    }

    public String getInputMessageName() {
        return this.inputMessageName;
    }

    public String getPortName() {
        return this.portName;
    }

    public Port getPort() {
        String string = this.getPortName();
        return this.serviceContext.getPortForQName(this.serviceContext.getPortQName(string));
    }

    public Class getSeiClass() {
        return this.seiClass;
    }

    public void setInputMessageName(String string) {
        this.inputMessageName = string;
    }

    public void setPortName(String string) {
        this.portName = string;
    }

    public void setSeiClass(Class clazz) {
        this.seiClass = clazz;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public Class[] getInParameterTypes(QName qName, int n) {
        OperationDesc[] operationDescArray = this.getOperationDescs(qName);
        if (operationDescArray == null) {
            return this.argClasses;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        boolean bl = false;
        for (int i = 0; i < operationDescArray.length; ++i) {
            OperationDesc operationDesc = operationDescArray[i];
            if (operationDesc.getNumInParams() != n) continue;
            ArrayList arrayList2 = operationDesc.getParameters();
            if (bl) {
                return null;
            }
            bl = true;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
                if (parameterDesc.getMode() == 2) continue;
                Class clazz = parameterDesc.getJavaType();
                arrayList.add(clazz);
            }
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public QName[] getInParameterNames(QName qName, int n) {
        OperationDesc[] operationDescArray = this.getOperationDescs(qName);
        if (operationDescArray == null) {
            return null;
        }
        ArrayList<QName> arrayList = new ArrayList<QName>();
        boolean bl = false;
        for (int i = 0; i < operationDescArray.length; ++i) {
            OperationDesc operationDesc = operationDescArray[i];
            if (operationDesc.getNumInParams() != n) continue;
            ArrayList arrayList2 = operationDesc.getParameters();
            if (bl) {
                return null;
            }
            bl = true;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
                if (parameterDesc.getMode() == 2) continue;
                QName qName2 = parameterDesc.getQName();
                arrayList.add(qName2);
            }
        }
        return arrayList.toArray(new QName[arrayList.size()]);
    }

    public Class getReturnType(QName qName, int n) {
        OperationDesc[] operationDescArray = this.getOperationDescs(qName);
        if (operationDescArray == null) {
            return null;
        }
        Class clazz = null;
        boolean bl = false;
        for (int i = 0; i < operationDescArray.length; ++i) {
            OperationDesc operationDesc = operationDescArray[i];
            if (operationDesc.getNumInParams() != n) continue;
            if (bl) {
                return null;
            }
            bl = true;
            clazz = operationDesc.getReturnClass();
        }
        return clazz;
    }

    protected OperationDesc[] getOperationDescs(QName qName) {
        if (qName == null || this.portName == null) {
            return null;
        }
        String string = qName.getLocalPart();
        if (string == null) {
            return null;
        }
        List list = this.serviceContext.getOperationDescriptions(this.portName, string);
        if (list == null) {
            return null;
        }
        return list.toArray(new OperationDesc[list.size()]);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void removeProperty(String string) {
        this.properties.remove(string);
    }

    public void setPropertyNames(ArrayList arrayList) {
        this.propertyNames = arrayList;
    }

    public boolean isPropertiesSet(String string) {
        return this.properties.keySet().contains(string);
    }
}

