/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol;

import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.ServiceInformation;
import com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Reference;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;

public class ServiceContext {
    private URL wsdlDocumentLocation;
    private Definition wsdlDefinition;
    private QName serviceName;
    private Map seiToPortTypeMapping;
    private Map portTypeToPortMapping;
    private Hashtable namespace2PackageMapping;
    private ServiceInformation serviceInfo;
    private String defaultNamespace;
    private String serviceNamespace;
    private String locatorClassName;
    private boolean attempted = false;
    private String serviceRefName = null;
    private boolean managedEnv = false;
    private Reference clientReference = null;

    public String toString() {
        String string = this.serviceName != null ? this.serviceName.toString() : "null";
        String string2 = this.clientReference != null ? this.clientReference.toString() : "null";
        String string3 = this.serviceInfo != null ? this.serviceInfo.getClass().getName() : "null";
        String string4 = this.seiToPortTypeMapping != null ? this.seiToPortTypeMapping.toString() : "null";
        String string5 = this.portTypeToPortMapping != null ? this.portTypeToPortMapping.toString() : "null";
        String string6 = this.namespace2PackageMapping != null ? this.namespace2PackageMapping.toString() : "null";
        String string7 = this.wsdlDocumentLocation != null ? this.wsdlDocumentLocation.toString() : "null";
        String string8 = this.wsdlDefinition != null ? this.wsdlDefinition.toString() : "null";
        String string9 = "ServiceContext: \n\twsdlDocumentLocation=[" + string7.toString() + "]\n" + "\tserviceName=" + string.toString() + "\n" + "\tserviceRefName=" + this.serviceRefName + "\n" + "\tdefaultNamespace=" + this.defaultNamespace + "\n" + "\tserviceNamespace=" + this.serviceNamespace + "\n" + "\tlocatorClassName=" + this.locatorClassName + "\n" + "\tserviceInfo=" + string3 + "\n" + "\tmanagedEnv=" + (this.managedEnv ? "true" : "false") + "\n" + "\tattempted=" + (this.attempted ? "true" : "false") + "\n" + "\tclientReference=[" + string2 + "]\n" + "\tseiToPortTypeMapping=[" + string4 + "]\n" + "\tportTypeToPortMapping=[" + string5 + "]\n" + "\tnamespace2PackageMapping=[" + string6 + "]\n" + "\twsdlDefinition=[" + string8.toString() + "]";
        return string9;
    }

    public ServiceContext(URL uRL, Definition definition, QName qName) {
        this.wsdlDocumentLocation = uRL;
        this.wsdlDefinition = definition;
        this.serviceName = qName;
    }

    public URL getWSDLDocumentLocation() {
        return this.wsdlDocumentLocation;
    }

    public Definition getDefinition() {
        return this.wsdlDefinition;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public Map getSEIToPortTypeMapping() {
        return this.seiToPortTypeMapping;
    }

    public void setSEIToPortTypeMapping(Map map) {
        this.seiToPortTypeMapping = map;
    }

    public Map getPortTypeToPortMapping() {
        return this.portTypeToPortMapping;
    }

    public void setPortTypeToPortMapping(Map map) {
        this.portTypeToPortMapping = map;
    }

    public Hashtable getNamespace2PackageMapping() {
        return this.namespace2PackageMapping;
    }

    public void setNamespace2PackageMapping(Hashtable hashtable) {
        this.namespace2PackageMapping = hashtable;
    }

    public String getDefaultNamespace() {
        if (this.defaultNamespace == null) {
            this.defaultNamespace = "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        return this.defaultNamespace;
    }

    public QName getPortQName(Port port2) {
        QName qName = this.getServiceName();
        QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), port2.getName());
        return qName2;
    }

    public QName getPortQName(String string) {
        QName qName = this.getServiceName();
        QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), string);
        return qName2;
    }

    public Port getNamedPort(String string) {
        QName qName = QNameTable.createQName(this.getServiceName().getNamespaceURI(), string == null ? "" : string);
        Port port2 = this.getPortForQName(qName);
        return port2;
    }

    public void setDefaultNamespace(String string) {
        this.defaultNamespace = string;
    }

    public void setServiceRefName(String string) {
        this.serviceRefName = string;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public void setReference(Reference reference) {
        this.clientReference = reference;
    }

    public Reference getReference() {
        return this.clientReference;
    }

    public Port getPortForQName(QName qName) {
        Service service = this.getWSDLService();
        Port port2 = null;
        if (service != null && qName != null) {
            port2 = service.getPort(qName.getLocalPart());
        }
        return port2;
    }

    public Collection getServicePorts() {
        Service service = this.getWSDLService();
        Collection collection = service != null ? service.getPorts().values() : new ArrayList(0);
        return collection;
    }

    public Service getWSDLService() {
        Service service = null;
        Definition definition = this.getDefinition();
        if (definition != null) {
            QName qName = this.getServiceName();
            service = definition.getService(qName);
        }
        return service;
    }

    public String getServiceNamespace() {
        if (this.serviceNamespace == null) {
            QName qName = this.getServiceName();
            this.serviceNamespace = qName == null ? "" : qName.getNamespaceURI();
        }
        return this.serviceNamespace;
    }

    public List getPortsForPortType(QName qName) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collection collection = this.getServicePorts();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Port port2 = (Port)iterator.next();
            if (!port2.getBinding().getPortType().getQName().equals(qName)) continue;
            arrayList.add(port2.getName());
        }
        return arrayList;
    }

    public String getPortBindingNamespace(Port port2) {
        String string = null;
        List list = port2.getBinding().getExtensibilityElements();
        if (list != null && list.size() > 0) {
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
            string = extensibilityElement.getElementType().getNamespaceURI();
        }
        return string;
    }

    public boolean hasWSDL() {
        boolean bl = this.wsdlDefinition != null;
        return bl;
    }

    public void setLocatorName(String string) {
        this.locatorClassName = string;
    }

    public String getLocatorName() {
        return this.locatorClassName;
    }

    public ServiceInformation getServiceInformation() {
        String string;
        String string2;
        if (this.serviceInfo != null || this.wsdlDocumentLocation == null && this.wsdlDefinition == null) {
            return this.serviceInfo;
        }
        ServiceInformation serviceInformation = null;
        if (this.locatorClassName != null) {
            string2 = this.locatorClassName.substring(0, this.locatorClassName.lastIndexOf("Locator"));
            string = string2 + "Information";
            try {
                serviceInformation = (ServiceInformation)ClassUtils.forName(string).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serviceInformation != null) {
            this.serviceInfo = serviceInformation;
            return serviceInformation;
        }
        String string3 = string2 = this.namespace2PackageMapping == null ? null : (String)this.namespace2PackageMapping.get(this.serviceNamespace);
        if (string2 == null) {
            String string4 = this.serviceNamespace != null ? this.serviceNamespace : (string = this.serviceName != null ? this.serviceName.getNamespaceURI() : null);
            if (string != null) {
                string2 = JavaUtils.makePackageName(string);
            }
        }
        if (string2 != null && this.serviceName != null) {
            string = JavaUtils.xmlNameToJavaClass(this.serviceName.getLocalPart());
            String string5 = string2 + "." + string + "Information";
            try {
                serviceInformation = (ServiceInformation)ClassUtils.forName(string5).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serviceInformation == null && this.serviceName != null) {
            serviceInformation = new DynamicServiceInformation(this.wsdlDefinition, this.wsdlDocumentLocation.toString(), this.serviceName);
        }
        this.serviceInfo = serviceInformation;
        return serviceInformation;
    }

    public Map getOperationDescriptions(String string) {
        ServiceInformation serviceInformation = this.getServiceInformation();
        if (serviceInformation == null) {
            return null;
        }
        return serviceInformation.getOperationDescriptions(string);
    }

    public List getOperationDescriptions(String string, String string2) {
        ServiceInformation serviceInformation = this.getServiceInformation();
        if (serviceInformation == null) {
            return null;
        }
        return serviceInformation.getOperationDescriptions(string, string2);
    }

    public Map getTypeMappings() {
        ServiceInformation serviceInformation = this.getServiceInformation();
        if (serviceInformation == null) {
            return null;
        }
        return serviceInformation.getTypeMappings();
    }

    public boolean isManagedEnvironment() {
        return this.managedEnv;
    }

    public void setManagedEnvironment(boolean bl) {
        this.managedEnv = bl;
    }
}

