/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.models;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.Transport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.wsdl.WSDLException;
import javax.xml.rpc.JAXRPCException;

public abstract class ModelTransport
implements Transport {
    protected ServiceContext context;
    protected Hashtable endpoint2TargetCache;

    public ModelTransport(ServiceContext serviceContext) {
        this.context = serviceContext;
        this.endpoint2TargetCache = new Hashtable();
    }

    public Object getTargetObject(InvocationContext invocationContext) throws RemoteException {
        Object object = null;
        boolean bl = false;
        Object object2 = null;
        if (invocationContext != null) {
            Object object3 = invocationContext.getProperty("javax.xml.rpc.session.maintain");
            if (object3 != null && object3 instanceof Boolean) {
                bl = (Boolean)object3;
            }
            object2 = this.getTargetKey(invocationContext);
            if (bl) {
                object = this.getTargetFromCache(object2);
            }
        }
        if (object == null) {
            this.validateEndpoint(object2);
            object = this.makeTargetObject(invocationContext);
            this.addTarget2Cache(object2, object);
        }
        return object;
    }

    protected void validateEndpoint(Object object) {
        if (object == null) {
            throw new JAXRPCException(Messages.getMessage("null_argument", "endpoint"));
        }
        AgnosticAddress agnosticAddress = null;
        if (object instanceof String) {
            agnosticAddress = new AgnosticAddress();
            agnosticAddress.setLocationURI((String)object);
        }
        if (object instanceof AgnosticAddress) {
            agnosticAddress = (AgnosticAddress)object;
        }
        if (agnosticAddress != null) {
            String string;
            try {
                string = agnosticAddress.getURLProtocol();
            }
            catch (WSDLException wSDLException) {
                FFDCFilter.processException((Throwable)wSDLException, (String)"com.ibm.ws.webservices.multiprotocol.models.ModelTransport.validateEndpoint", (String)"99", (Object)this);
                throw new JAXRPCException(Messages.getMessage("errorGetURLProtocol", wSDLException.toString()));
            }
            String string2 = this.getProtocol();
            if (string2 != null && !string2.equals(string)) {
                throw new JAXRPCException(Messages.getMessage("invalidURLProtocol2", string2, string));
            }
        }
    }

    public void close(Object object) throws RemoteException {
        if (object == null) {
            return;
        }
        Object v = this.endpoint2TargetCache.get(object);
        if (v != null) {
            this.endpoint2TargetCache.remove(object);
            InvocationContext invocationContext = new InvocationContext(this.context);
            this.close(invocationContext, v);
        }
    }

    protected Object getTargetFromCache(Object object) {
        return this.endpoint2TargetCache.get(object);
    }

    protected void addTarget2Cache(Object object, Object object2) {
        this.endpoint2TargetCache.put(object, object2);
    }

    public Object getTargetKey(InvocationContext invocationContext) {
        return invocationContext.getEndpoint();
    }
}

