/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.soap;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.enum.MIMEStyle;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.models.ModelBindingGenerator;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.wsdl.BindingFaultImpl;
import com.ibm.wsdl.extensions.mime.MIMEContentImpl;
import com.ibm.wsdl.extensions.mime.MIMEMultipartRelatedImpl;
import com.ibm.wsdl.extensions.mime.MIMEPartImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.xml.namespace.QName;

public class SOAPBindingGenerator
extends ModelBindingGenerator {
    protected OptionDescriptor[] specificOptionDescriptors = new OptionDescriptor[]{new OptionDescriptor(this.bindingTypeName + ".soapAction", false, Messages.getMessage("desc.soapAction", this.bindingTypeName)), new OptionDescriptor(this.bindingTypeName + ".MIMEStyle", false, Messages.getMessage("desc.MIMEStyle", this.bindingTypeName))};
    private static Map axisTypeToMIMEString = new HashMap();

    public SOAPBindingGenerator(String string) {
        super(string);
    }

    public String getBindingTypeName() {
        return this.bindingTypeName;
    }

    public String getBindingName(Properties properties) {
        String string;
        String string2 = properties.getProperty(this.bindingTypeName + ".bindingName");
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = properties.getProperty("bindingName");
            string = this.bindingTypeName.equalsIgnoreCase("HTTP") ? string3 + "SoapBinding" : (this.bindingTypeName.equalsIgnoreCase("JMS") ? string3 + "JMSSoapBinding" : string3 + JavaUtils.capitalizeFirstChar(this.bindingTypeName) + "Binding");
        }
        return string;
    }

    public String getPortName(Properties properties) {
        String string;
        String string2 = properties.getProperty(this.bindingTypeName + ".servicePortName");
        if (string2 != null) {
            string = string2;
        } else {
            String string3 = properties.getProperty("servicePortName");
            string = this.bindingTypeName.equalsIgnoreCase("HTTP") ? string3 : (this.bindingTypeName.equalsIgnoreCase("JMS") ? string3 + "JMS" : string3 + JavaUtils.capitalizeFirstChar(this.bindingTypeName));
        }
        return string;
    }

    public Binding makeBinding(Definition definition, PortType portType, QName qName, Properties properties) {
        Binding binding = definition.createBinding();
        binding.setUndefined(false);
        binding.setQName(qName);
        binding.setPortType(portType);
        String string = properties.getProperty("style", "rpc");
        SOAPBindingImpl sOAPBindingImpl = new SOAPBindingImpl();
        sOAPBindingImpl.setStyle(string);
        sOAPBindingImpl.setTransportURI(this.getTransportURI());
        binding.addExtensibilityElement((ExtensibilityElement)sOAPBindingImpl);
        if (portType.getOperations() != null) {
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement;
                Message message;
                Object object;
                Operation operation = (Operation)iterator.next();
                BindingOperation bindingOperation = definition.createBindingOperation();
                bindingOperation.setName(operation.getName());
                bindingOperation.setOperation(operation);
                binding.addBindingOperation(bindingOperation);
                SOAPOperationImpl sOAPOperationImpl = new SOAPOperationImpl();
                String string2 = properties.getProperty(this.bindingTypeName + ".soapAction");
                if (string2 == null) {
                    string2 = properties.getProperty("soapAction", "DEFAULT");
                }
                String string3 = "";
                if (string2.equalsIgnoreCase("OPERATION")) {
                    string3 = operation.getName();
                }
                sOAPOperationImpl.setSoapActionURI(string3);
                bindingOperation.addExtensibilityElement((ExtensibilityElement)sOAPOperationImpl);
                boolean bl = false;
                if (operation.getInput() != null) {
                    object = definition.createBindingInput();
                    object.setName(operation.getInput().getName());
                    message = operation.getInput().getMessage();
                    extensibilityElement = this.getIfMIME(message, properties);
                    if (extensibilityElement == null) {
                        extensibilityElement = this.getSOAPBody(message, properties);
                    } else {
                        bl = true;
                    }
                    object.addExtensibilityElement(extensibilityElement);
                    bindingOperation.setBindingInput((BindingInput)object);
                }
                if (operation.getOutput() != null) {
                    object = definition.createBindingOutput();
                    object.setName(operation.getOutput().getName());
                    message = operation.getOutput().getMessage();
                    extensibilityElement = this.getIfMIME(message, properties);
                    if (extensibilityElement == null) {
                        extensibilityElement = this.getSOAPBody(message, properties);
                    } else {
                        bl = true;
                    }
                    object.addExtensibilityElement(extensibilityElement);
                    bindingOperation.setBindingOutput((BindingOutput)object);
                }
                if (bl) {
                    definition.addNamespace("mime", "http://schemas.xmlsoap.org/wsdl/mime/");
                }
                if (operation.getFaults() == null) continue;
                object = operation.getFaults().values().iterator();
                while (object.hasNext()) {
                    message = (Fault)object.next();
                    extensibilityElement = new BindingFaultImpl();
                    SOAPFault sOAPFault = this.getSOAPFault(message.getMessage(), properties);
                    sOAPFault.setName(message.getName());
                    extensibilityElement.setName(message.getName());
                    extensibilityElement.addExtensibilityElement((ExtensibilityElement)sOAPFault);
                    bindingOperation.addBindingFault((BindingFault)extensibilityElement);
                }
            }
        }
        return binding;
    }

    private ExtensibilityElement getIfMIME(Message message, Properties properties) {
        MIMEMultipartRelatedImpl mIMEMultipartRelatedImpl = null;
        String string = properties.getProperty(this.bindingTypeName + ".MIMEStyle");
        if (string == null) {
            string = properties.getProperty("MIMEStyle", MIMEStyle.WSDL11.toString());
        }
        if (string.equals(MIMEStyle.WSDL11.toString())) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.sortTypes(message, arrayList, arrayList2);
            if (arrayList.size() > 0) {
                Object object;
                MIMEPartImpl mIMEPartImpl;
                mIMEMultipartRelatedImpl = new MIMEMultipartRelatedImpl();
                if (arrayList2.size() > 0) {
                    MIMEPartImpl mIMEPartImpl2 = new MIMEPartImpl();
                    mIMEMultipartRelatedImpl.addMIMEPart((MIMEPart)mIMEPartImpl2);
                    mIMEPartImpl = (SOAPBody)this.getSOAPBody(message, properties);
                    mIMEPartImpl2.addExtensibilityElement((ExtensibilityElement)mIMEPartImpl);
                    object = new ArrayList();
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        Part part = (Part)arrayList2.get(i);
                        ((ArrayList)object).add(part.getName());
                    }
                    mIMEPartImpl.setParts((List)object);
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    mIMEPartImpl = new MIMEPartImpl();
                    mIMEMultipartRelatedImpl.addMIMEPart((MIMEPart)mIMEPartImpl);
                    object = new MIMEContentImpl();
                    mIMEPartImpl.addExtensibilityElement((ExtensibilityElement)object);
                    Part part = (Part)arrayList.get(i);
                    object.setPart(part.getName());
                    object.setType(this.mimeType(part.getTypeName()));
                    part.setTypeName(Constants.XSD_HEXBIN);
                }
            }
        }
        return mIMEMultipartRelatedImpl;
    }

    private void sortTypes(Message message, List list, List list2) {
        Iterator iterator = message.getParts().values().iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            QName qName = part.getTypeName();
            if (Constants.MIME_IMAGE.equals(qName) || Constants.MIME_PLAINTEXT.equals(qName) || Constants.MIME_MULTIPART.equals(qName) || Constants.MIME_SOURCE.equals(qName) || Constants.MIME_OCTETSTREAM.equals(qName) || Constants.MIME_DATA_HANDLER.equals(qName)) {
                list.add(part);
                continue;
            }
            list2.add(part);
        }
    }

    private String mimeType(QName qName) {
        return (String)axisTypeToMIMEString.get(qName);
    }

    private ExtensibilityElement getSOAPBody(Message message, Properties properties) {
        Object object;
        SOAPBodyImpl sOAPBodyImpl = new SOAPBodyImpl();
        String string = properties.getProperty("use", "encoded");
        if (string.equalsIgnoreCase("encoded")) {
            sOAPBodyImpl.setUse("encoded");
            object = new ArrayList<String>();
            ((ArrayList)object).add(properties.getProperty("encodingStyle", Constants.URI_DEFAULT_SOAP_ENC));
            sOAPBodyImpl.setEncodingStyles((List)object);
        } else {
            sOAPBodyImpl.setUse("literal");
        }
        object = properties.getProperty("style", "rpc");
        if (((String)object).equalsIgnoreCase("rpc")) {
            sOAPBodyImpl.setNamespaceURI(properties.getProperty("intfNS", "unknownInterfaceNamespace"));
        }
        return sOAPBodyImpl;
    }

    private SOAPFault getSOAPFault(Message message, Properties properties) {
        SOAPFaultImpl sOAPFaultImpl = new SOAPFaultImpl();
        String string = properties.getProperty("use", "encoded");
        if (!string.equalsIgnoreCase("encoded")) {
            sOAPFaultImpl.setUse("literal");
        } else {
            sOAPFaultImpl.setUse("encoded");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(properties.getProperty("encodingStyle", Constants.URI_DEFAULT_SOAP_ENC));
            sOAPFaultImpl.setEncodingStyles(arrayList);
        }
        return sOAPFaultImpl;
    }

    public ExtensibilityElement makePortAddress(Definition definition, Port port2, Properties properties) {
        String string = properties.getProperty(this.bindingTypeName + ".location");
        if (string == null) {
            string = properties.getProperty("location");
        }
        if (this.bindingTypeName.equalsIgnoreCase("JMS")) {
            string = string.replace('|', '&');
        }
        SOAPAddressImpl sOAPAddressImpl = new SOAPAddressImpl();
        sOAPAddressImpl.setLocationURI(string);
        return sOAPAddressImpl;
    }

    public String getTransportURI() {
        if (this.bindingTypeName.equalsIgnoreCase("http")) {
            return "http://schemas.xmlsoap.org/soap/http";
        }
        return "http://schemas.xmlsoap.org/soap/jms";
    }

    public OptionDescriptor[] getOptionDescriptors() {
        int n;
        OptionDescriptor[] optionDescriptorArray = this.getDefaultOptionDescriptors();
        int n2 = optionDescriptorArray.length;
        int n3 = this.specificOptionDescriptors.length;
        OptionDescriptor[] optionDescriptorArray2 = new OptionDescriptor[n2 + n3];
        for (n = 0; n < n2; ++n) {
            optionDescriptorArray2[n] = optionDescriptorArray[n];
        }
        for (n = 0; n < n3; ++n) {
            optionDescriptorArray2[n + n2] = this.specificOptionDescriptors[n];
        }
        return optionDescriptorArray2;
    }

    protected ExtensibilityElement getBindingExtension(PortType portType) {
        return null;
    }

    protected ExtensibilityElement getBindingOperation(Operation operation) {
        return null;
    }

    protected Map getRequiredNamespaces() {
        return null;
    }

    static {
        axisTypeToMIMEString.put(Constants.MIME_IMAGE, "image/jpeg");
        axisTypeToMIMEString.put(Constants.MIME_PLAINTEXT, "text/plain");
        axisTypeToMIMEString.put(Constants.MIME_MULTIPART, "multipart/*");
        axisTypeToMIMEString.put(Constants.MIME_SOURCE, "text/xml");
        axisTypeToMIMEString.put(Constants.MIME_OCTETSTREAM, "application/octetstream");
        axisTypeToMIMEString.put(Constants.MIME_DATA_HANDLER, "application/octetstream");
    }
}

