/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.ServiceInformation;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.RuntimeJavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DynamicServiceInformation
implements ServiceInformation {
    protected static MetaInfo metaInfo = new MetaInfo();
    protected static ToolEnv env = DefaultToolEnv.create();
    private Map typeMappings = new HashMap();
    private Map operationDescriptions = new HashMap();

    public DynamicServiceInformation(Definition definition, String string, QName qName) {
        Iterator iterator;
        Types types;
        Document document = null;
        if (definition != null && (types = definition.getTypes()) != null && (iterator = types.getExtensibilityElements().iterator()).hasNext()) {
            UnknownExtensibilityElement unknownExtensibilityElement = (UnknownExtensibilityElement)iterator.next();
            Element element = unknownExtensibilityElement.getElement();
            document = element.getOwnerDocument();
        }
        this.init(definition, document, string, qName);
    }

    public DynamicServiceInformation(Definition definition, Document document, String string, QName qName) throws Exception {
        this.init(definition, document, string, qName);
    }

    public void init(Definition definition, Document document, String string, QName qName) {
        try {
            Emitter emitter = new Emitter(true);
            emitter.setFactory(new RuntimeJavaGeneratorFactory(emitter));
            if (definition != null && document != null) {
                emitter.run(string, document, definition);
            } else if (document != null) {
                emitter.run(string, document);
            } else {
                emitter.run(string);
            }
            SymbolTable symbolTable = emitter.getSymbolTable();
            ServiceEntry serviceEntry = symbolTable.getServiceEntry(qName);
            this.parseService(serviceEntry, symbolTable);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", (String)"191", (Object)this);
        }
        catch (SAXException sAXException) {
            FFDCFilter.processException((Throwable)sAXException, (String)"com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", (String)"193", (Object)this);
        }
        catch (WSDLException wSDLException) {
            FFDCFilter.processException((Throwable)wSDLException, (String)"com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", (String)"195", (Object)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            FFDCFilter.processException((Throwable)parserConfigurationException, (String)"com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", (String)"197", (Object)this);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.init", (String)"199", (Object)this);
        }
    }

    public Map getTypeMappings() {
        return this.typeMappings;
    }

    public Class getJavaType(QName qName) {
        return (Class)this.typeMappings.get(qName);
    }

    public Map getOperationDescriptions(String string) {
        return (Map)this.operationDescriptions.get(string);
    }

    public List getOperationDescriptions(String string, String string2) {
        Map map = (Map)this.operationDescriptions.get(string);
        if (map != null) {
            return (List)map.get(string2);
        }
        return null;
    }

    protected void parseService(ServiceEntry serviceEntry, SymbolTable symbolTable) throws Exception {
        HashSet hashSet = new HashSet();
        ArrayList<PortType> arrayList = new ArrayList<PortType>();
        HashMap hashMap = new HashMap();
        for (int i = 0; i < serviceEntry.numPorts(); ++i) {
            ArrayList<BindingOperationEntry> arrayList2 = new ArrayList<BindingOperationEntry>();
            PortEntry portEntry = serviceEntry.getPort(i);
            Port port2 = portEntry.getPort();
            Binding binding = port2.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", port2.getName()));
            }
            BindingEntry bindingEntry = symbolTable.getBindingEntry(binding.getQName());
            if (bindingEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", binding.getQName().toString()));
            }
            this.populateTypesFromPortType(binding.getPortType(), bindingEntry, hashSet, symbolTable);
            if (bindingEntry.isReferenced() && !arrayList.contains(binding.getPortType())) {
                arrayList.add(binding.getPortType());
                List list = binding.getBindingOperations();
                for (int j = 0; j < list.size(); ++j) {
                    BindingOperation bindingOperation = (BindingOperation)list.get(j);
                    BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(bindingOperation.getOperation());
                    Operation operation = bindingOperation.getOperation();
                    OperationType operationType = operation.getStyle();
                    if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) continue;
                    arrayList2.add(bindingOperationEntry);
                }
            }
            if (arrayList2.size() > 1) {
                Collections.sort(arrayList2, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n = 0;
                        try {
                            n = ((BindingOperationEntry)object).getName().compareTo(((BindingOperationEntry)object2).getName());
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.multiprotocol.utils.DynamicServiceInformation.compare", (String)"289", (Object)this);
                        }
                        return n;
                    }
                });
            }
            hashMap.put(port2, arrayList2);
        }
        this.typeMappings.putAll(this.getTypeMappings(hashSet));
        this.operationDescriptions.putAll(this.getOperationDescriptions(hashMap, symbolTable));
    }

    private void populateTypesFromPortType(PortType portType, BindingEntry bindingEntry, HashSet hashSet, SymbolTable symbolTable) {
        Object object;
        HashSet hashSet2 = new HashSet();
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            object = (Operation)list.get(i);
            hashSet2.addAll(JavaStubWriter.getTypesInOperation(object, bindingEntry));
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object = (TypeEntry)iterator.next();
            if (hashSet.contains(object)) continue;
            hashSet.add(object);
            hashSet.addAll(Utils.getNestedTypes((TypeEntry)object, symbolTable, true));
        }
    }

    private Map getTypeMappings(HashSet hashSet) throws Exception {
        HashMap<QName, Class> hashMap = new HashMap<QName, Class>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            TypeEntry typeEntry = (TypeEntry)iterator.next();
            if (typeEntry.isBaseType() && typeEntry.getRefType() == null || typeEntry.isCollectionTypeEntry() || typeEntry instanceof com.ibm.ws.webservices.wsdl.symbolTable.Element || !typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced()) continue;
            QName qName = typeEntry.getQName();
            hashMap.put(QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart()), ClassUtils.forName(typeEntry.getName()));
        }
        return hashMap;
    }

    protected Map getOperationDescriptions(HashMap hashMap, SymbolTable symbolTable) throws Exception {
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Port port2 = (Port)iterator.next();
            List list = (List)hashMap.get(port2);
            QName qName = port2.getBinding().getPortType().getQName();
            BindingEntry bindingEntry = symbolTable.getBindingEntry(port2.getBinding().getQName());
            HashMap hashMap4 = null;
            HashMap hashMap5 = (HashMap)hashMap3.get(qName);
            if (hashMap5 != null) {
                hashMap4 = hashMap5;
            } else {
                hashMap4 = new HashMap();
                hashMap3.put(qName, hashMap4);
            }
            String string = null;
            ArrayList<OperationDesc> arrayList = null;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator2.next();
                if (!bindingOperationEntry.getName().equals(string)) {
                    arrayList = new ArrayList<OperationDesc>();
                    hashMap4.put(bindingOperationEntry.getName(), arrayList);
                }
                arrayList.add(this.getOperationDesc(bindingOperationEntry, bindingEntry, symbolTable));
                string = bindingOperationEntry.getName();
            }
            if (hashMap4 == null) continue;
            hashMap2.put(port2.getName(), hashMap4);
        }
        return hashMap2;
    }

    protected OperationDesc getOperationDesc(BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, SymbolTable symbolTable) throws Exception {
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, bindingEntry, symbolTable);
        OperationDesc operationDesc = operationDescBuilder.getOperationDesc(true);
        return operationDesc;
    }
}

