/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools.resource;

import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.ResourceManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class WSADToolEnv
implements ToolEnv {
    private Environment env;
    private ResourceSet javaContext;

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }

    public boolean fileExists(String string) {
        this.checkEnv();
        boolean bl = false;
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            bl = resourceManager.exists(uRL);
        }
        catch (Exception exception) {
            bl = new File(string).exists();
        }
        return bl;
    }

    public PrintWriter getPrintWriter(String string) throws IOException {
        this.checkEnv();
        return new PrintWriter(this.getOutputStream(string));
    }

    public OutputStream getOutputStream(String string) throws IOException {
        OutputStream outputStream;
        this.checkEnv();
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            outputStream = resourceManager.getOutputStream(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            File file2 = new File(file.getParent());
            file2.mkdirs();
            outputStream = new FileOutputStream(file);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.webservices.tools.resource.WSADToolEnv.getOutputStream", (String)"125", (Object)this);
            throw new IOException(resourceException.getStatus().getMessage());
        }
        return outputStream;
    }

    public InputStream getInputStream(String string) throws IOException {
        InputStream inputStream;
        this.checkEnv();
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            inputStream = resourceManager.getInputStream(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            File file2 = new File(file.getParent());
            file2.mkdirs();
            inputStream = new FileInputStream(file);
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.webservices.tools.resource.WSADToolEnv.getInputStream", (String)"154", (Object)this);
            throw new IOException(resourceException.getStatus().getMessage());
        }
        return inputStream;
    }

    public void mkdir(String string) throws IOException {
        this.checkEnv();
        try {
            URL uRL = new URL(string);
            ResourceManager resourceManager = this.env.getResourceManager();
            resourceManager.createFolders(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            file.mkdirs();
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.webservices.tools.resource.WSADToolEnv.mkdir", (String)"179", (Object)this);
            throw new IOException(resourceException.getStatus().getMessage());
        }
    }

    private void checkEnv() {
        if (this.env == null) {
            this.setEnvironment((Environment)new ConsoleEnvironment());
        }
    }

    public char getSeparatorChar() {
        this.checkEnv();
        ResourceManager resourceManager = this.env.getResourceManager();
        return resourceManager.getSeparatorChar();
    }

    public void report(String string) {
        this.checkEnv();
        ProgressMonitor progressMonitor = this.env.getProgressMonitor();
        progressMonitor.report(string);
    }

    public void reporterr(String string) {
        this.report(string);
    }

    public boolean isJavaIntrospectionAllowed() {
        return false;
    }

    public void setJavaContext(ResourceSet resourceSet) {
        this.javaContext = resourceSet;
    }

    public ResourceSet getJavaContext() {
        return this.javaContext;
    }
}

