/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.utils.PortInfo;
import com.ibm.ws.webservices.utils.SaveInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;

public class WSDLParser {
    private String contextURI;
    private String wsdlURI;
    private Definition def;
    private Vector portInfos;
    private Vector imports;

    public WSDLParser(String string, String string2) throws IOException {
        this.contextURI = string;
        this.wsdlURI = string2;
        try {
            this.parse();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.utils.WSDLParser.WSDLParser", (String)"69", (Object)this);
            throw new IOException(exception.toString() + JavaUtils.LS + JavaUtils.stackToString(exception));
        }
    }

    private void parse() throws WSDLException {
        WSDLFactory wSDLFactory = WSDLFactory.newInstance();
        WSDLReader wSDLReader = wSDLFactory.newWSDLReader();
        this.def = wSDLReader.readWSDL(null, this.contextURI + this.wsdlURI);
        this.portInfos = new Vector();
        this.imports = new Vector();
        this.gatherPortInfos(this.def, this.portInfos, this.imports);
    }

    public boolean portExists(String string, String string2) {
        PortInfo portInfo = this.findPort(string, string2);
        return portInfo != null;
    }

    public PortInfo[] findUndeployedPorts() {
        Vector<PortInfo> vector = new Vector<PortInfo>();
        PortInfo[] portInfoArray = this.portInfos.elements();
        while (portInfoArray.hasMoreElements()) {
            PortInfo portInfo = (PortInfo)portInfoArray.nextElement();
            if (portInfo.soapAddressChanged) continue;
            vector.add(portInfo);
        }
        portInfoArray = new PortInfo[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            portInfoArray[n] = (PortInfo)enumeration.nextElement();
            ++n;
        }
        return portInfoArray;
    }

    public boolean setSOAPAddress(String string, String string2, String string3) {
        PortInfo portInfo = this.findPort(string, string2);
        if (portInfo == null) {
            return false;
        }
        return this.setSOAPAddress(portInfo, string3);
    }

    private boolean setSOAPAddress(PortInfo portInfo, String string) {
        Object[] objectArray = portInfo.port.getExtensibilityElements().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof SOAPAddress)) continue;
            SOAPAddress sOAPAddress = (SOAPAddress)objectArray[i];
            sOAPAddress.setLocationURI(string);
            portInfo.soapAddressChanged = true;
            return true;
        }
        return false;
    }

    public SaveInfo[] save(String string, String string2) throws WSDLException, IOException {
        Object object;
        Vector<SaveInfo> vector = new Vector<SaveInfo>();
        WSDLFactory wSDLFactory = WSDLFactory.newInstance();
        WSDLWriter wSDLWriter = wSDLFactory.newWSDLWriter();
        File file = new File(string);
        File file2 = new File(file, string2);
        String string3 = file2.getParent();
        File file3 = null;
        if (string3 != null) {
            file3 = new File(string3);
            file3.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        vector.add(new SaveInfo(string2, file2.getCanonicalPath()));
        wSDLWriter.writeWSDL(this.def, (OutputStream)fileOutputStream);
        ((OutputStream)fileOutputStream).close();
        SaveInfo[] saveInfoArray = this.imports.elements();
        while (saveInfoArray.hasMoreElements()) {
            Import import_ = (Import)saveInfoArray.nextElement();
            object = import_.getDefinition();
            String string4 = import_.getLocationURI();
            if (string4.startsWith("http://") || string4.startsWith("https://") || string4.startsWith("file:")) continue;
            File file4 = new File(file3, string4);
            String string5 = file4.getParent();
            if (string5 != null) {
                new File(string5).mkdirs();
            }
            FileOutputStream fileOutputStream2 = new FileOutputStream(file4);
            vector.add(new SaveInfo(string4, file4.getCanonicalPath()));
            if (object != null) {
                wSDLWriter.writeWSDL((Definition)object, (OutputStream)fileOutputStream2);
            } else {
                int n;
                URL uRL = this.contextURI != null ? new URL(this.contextURI) : new URL(this.wsdlURI);
                URL uRL2 = new URL(uRL, string4);
                InputStream inputStream = uRL2.openStream();
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream2).write(byArray, 0, n);
                }
            }
            ((OutputStream)fileOutputStream2).close();
        }
        saveInfoArray = new SaveInfo[vector.size()];
        int n = 0;
        object = vector.elements();
        while (object.hasMoreElements()) {
            saveInfoArray[n] = (SaveInfo)object.nextElement();
            ++n;
        }
        return saveInfoArray;
    }

    private PortInfo findPort(String string, String string2) {
        Enumeration enumeration = this.portInfos.elements();
        while (enumeration.hasMoreElements()) {
            PortInfo portInfo = (PortInfo)enumeration.nextElement();
            if (!portInfo.def.getTargetNamespace().equals(string) || !portInfo.port.getName().equals(string2)) continue;
            return portInfo;
        }
        return null;
    }

    private Import findImport(String string, Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Import import_ = (Import)enumeration.nextElement();
            if (!string.equals(import_.getLocationURI())) continue;
            return import_;
        }
        return null;
    }

    private void gatherPortInfos(Import import_, Vector vector, Vector vector2) {
        if (this.findImport(import_.getLocationURI(), vector2) != null) {
            return;
        }
        vector2.add(import_);
        Definition definition = import_.getDefinition();
        if (definition != null) {
            this.gatherPortInfos(definition, vector, vector2);
        }
    }

    private void gatherPortInfos(Definition definition, Vector vector, Vector vector2) {
        Object object;
        Object object2;
        Object object3;
        Object object4 = definition.getServices().values().iterator();
        while (object4.hasNext()) {
            object3 = (Service)object4.next();
            object2 = object3.getPorts().values().iterator();
            while (object2.hasNext()) {
                object = (Port)object2.next();
                vector.add(new PortInfo(definition, (Port)object));
            }
        }
        object4 = definition.getImports();
        object3 = object4.values().iterator();
        while (object3.hasNext()) {
            object2 = (List)object3.next();
            object = object2.iterator();
            while (object.hasNext()) {
                Import import_ = (Import)object.next();
                this.gatherPortInfos(import_, vector, vector2);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 3) {
                WSDLParser.usage();
            }
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = stringArray[2];
            WSDLParser wSDLParser = new WSDLParser(string, string2);
            SaveInfo[] saveInfoArray = wSDLParser.portInfos.elements();
            while (saveInfoArray.hasMoreElements()) {
                PortInfo portInfo = (PortInfo)saveInfoArray.nextElement();
                wSDLParser.setSOAPAddress(portInfo, "http://com.ibm.webservices.ri.deploy.WSDLParser/test");
            }
            saveInfoArray = wSDLParser.save(string3, string2);
            System.out.println(saveInfoArray.length + " files saved");
            for (int i = 0; i < saveInfoArray.length; ++i) {
                System.out.println(saveInfoArray[i].fileURI + " saved at " + saveInfoArray[i].fileName);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.utils.WSDLParser.main", (String)"331");
            exception.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("usage: java com.ibm.webservices.ri.deploy.WSDLParser contextURI wsdlURI outDirectory");
        System.exit(1);
    }

    public Vector getPortInfos() {
        return this.portInfos;
    }
}

