/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.ImportResolver;
import com.ibm.ws.webservices.wsdl.NoopFactory;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Parser {
    protected ToolEnv env = null;
    protected boolean debug = false;
    protected boolean verbose = false;
    protected String username = null;
    protected String password = null;
    private long timeoutms = 45000L;
    private GeneratorFactory genFactory = null;
    private SymbolTable symbolTable = null;
    protected MetaInfo metaInfo = new MetaInfo();

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public long getTimeout() {
        return this.timeoutms;
    }

    public void setTimeout(long l) {
        this.timeoutms = l;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public GeneratorFactory getFactory() {
        return this.genFactory;
    }

    public void setFactory(GeneratorFactory generatorFactory) {
        this.genFactory = generatorFactory;
    }

    public void setResolver(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.metaInfo.setImportResolver((ImportResolver)ClassUtils.forName(string).newInstance());
    }

    public void setResolver(ImportResolver importResolver) {
        this.metaInfo.setImportResolver(importResolver);
    }

    public ImportResolver getResolver() {
        return this.metaInfo.getImportResolver();
    }

    public void setToolEnv(ToolEnv toolEnv) {
        this.env = toolEnv;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public Definition getCurrentDefinition() {
        return this.symbolTable == null ? null : this.symbolTable.getDefinition();
    }

    public String getWSDLURI() {
        return this.symbolTable == null ? null : this.symbolTable.getWSDLURI();
    }

    public void run(String string) throws Exception {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        this.metaInfo.setBaseTypeMapping(this.genFactory.getBaseTypeMapping());
        this.symbolTable = new SymbolTable(this.env, this.metaInfo, true, this.verbose);
        WSDLRunnable wSDLRunnable = new WSDLRunnable(this.symbolTable, string);
        Thread thread = new Thread(wSDLRunnable);
        thread.start();
        try {
            if (this.timeoutms > 0L) {
                thread.join(this.timeoutms);
            } else {
                thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.webservices.wsdl.gen.Parser.run", (String)"222", (Object)this);
        }
        if (thread.isAlive()) {
            thread.interrupt();
            throw new IOException(Messages.getMessage("timedOut"));
        }
        if (wSDLRunnable.getFailure() != null) {
            throw wSDLRunnable.getFailure();
        }
        this.generate(this.symbolTable);
    }

    public void run(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        this.metaInfo.setBaseTypeMapping(this.genFactory.getBaseTypeMapping());
        this.symbolTable = new SymbolTable(this.env, this.metaInfo, true, this.verbose);
        this.symbolTable.populate(string, document);
        this.generate(this.symbolTable);
    }

    public void run(String string, Document document, Definition definition) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        if (this.getFactory() == null) {
            this.setFactory(new NoopFactory());
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        this.metaInfo.setBaseTypeMapping(this.genFactory.getBaseTypeMapping());
        this.symbolTable = new SymbolTable(this.env, this.metaInfo, true, this.verbose);
        this.symbolTable.populateUsingDefinition(string, document, definition);
        this.generate(this.symbolTable);
    }

    private void generate(SymbolTable symbolTable) throws IOException {
        Object object;
        Definition definition = symbolTable.getDefinition();
        this.genFactory.generatorPass(definition, symbolTable);
        if (this.isDebug()) {
            symbolTable.dump(System.out);
        }
        this.generateTypes(symbolTable);
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            object = (Vector)iterator.next();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                SymTabEntry symTabEntry;
                SymTabEntry symTabEntry2 = (SymTabEntry)((Vector)object).elementAt(i);
                Generator generator = null;
                if (symTabEntry2 instanceof MessageEntry) {
                    generator = this.genFactory.getGenerator(((MessageEntry)symTabEntry2).getMessage(), symbolTable);
                } else if (symTabEntry2 instanceof PortTypeEntry) {
                    symTabEntry = (PortTypeEntry)symTabEntry2;
                    if (((PortTypeEntry)symTabEntry).getPortType().isUndefined()) continue;
                    generator = this.genFactory.getGenerator(((PortTypeEntry)symTabEntry).getPortType(), symbolTable);
                } else if (symTabEntry2 instanceof BindingEntry) {
                    symTabEntry = (BindingEntry)symTabEntry2;
                    Binding binding = ((BindingEntry)symTabEntry).getBinding();
                    if (binding.isUndefined() || !symTabEntry.isReferenced()) continue;
                    generator = this.genFactory.getGenerator(binding, symbolTable);
                } else if (symTabEntry2 instanceof ServiceEntry) {
                    generator = this.genFactory.getGenerator(((ServiceEntry)symTabEntry2).getService(), symbolTable);
                }
                if (generator == null) continue;
                generator.generate();
            }
        }
        object = this.genFactory.getGenerator(definition, symbolTable);
        object.generate();
    }

    private void generateTypes(SymbolTable symbolTable) throws IOException {
        Vector vector = symbolTable.getTypes();
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl;
            TypeEntry typeEntry = (TypeEntry)vector.elementAt(i);
            boolean bl2 = bl = typeEntry instanceof Type || typeEntry.isCollectionTypeEntry();
            if (typeEntry.getNode() == null || !typeEntry.isReferenced() || !bl || typeEntry.isBaseType()) continue;
            Generator generator = this.genFactory.getGenerator(typeEntry, symbolTable);
            generator.generate();
        }
    }

    private class WSDLRunnable
    implements Runnable {
        private SymbolTable symbolTable;
        private String wsdlURI;
        private Exception failure = null;

        public WSDLRunnable(SymbolTable symbolTable, String string) {
            this.symbolTable = symbolTable;
            this.wsdlURI = string;
        }

        public void run() {
            try {
                this.symbolTable.populate(this.wsdlURI, Parser.this.username, Parser.this.password);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.wsdl.gen.Parser.run", (String)"250", (Object)this);
                this.failure = exception;
            }
        }

        public Exception getFailure() {
            return this.failure;
        }
    }
}

