/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.CLArgsParser;
import com.ibm.ws.webservices.engine.utils.CLOption;
import com.ibm.ws.webservices.engine.utils.CLOptionDescriptor;
import com.ibm.ws.webservices.engine.utils.CLUtil;
import com.ibm.ws.webservices.engine.utils.DefaultAuthenticator;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.Parser;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class WSDL2 {
    protected static final int DEBUG_OPT = 68;
    protected static final int HELP_OPT = 104;
    protected static final int NETWORK_TIMEOUT_OPT = 79;
    protected static final int VERBOSE_OPT = 118;
    protected static final int USE_RESOLVER_OPT = 117;
    protected CLOptionDescriptor[] options = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, Messages.getMessage("optionHelp00")), new CLOptionDescriptor("verbose", 8, 118, Messages.getMessage("optionVerbose00")), new CLOptionDescriptor("timeout", 2, 79, Messages.getMessage("optionTimeout00")), new CLOptionDescriptor("Debug", 8, 68, Messages.getMessage("optionDebug00")), new CLOptionDescriptor("useResolver", 2, 117, Messages.getMessage("optionUseResolver00"))};
    protected String wsdlURI = null;
    protected Parser parser = this.createParser();

    protected WSDL2() {
    }

    protected Parser createParser() {
        return new Parser();
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void addOptions(CLOptionDescriptor[] cLOptionDescriptorArray) {
        if (cLOptionDescriptorArray != null && cLOptionDescriptorArray.length > 0) {
            CLOptionDescriptor[] cLOptionDescriptorArray2 = new CLOptionDescriptor[this.options.length + cLOptionDescriptorArray.length];
            System.arraycopy(this.options, 0, cLOptionDescriptorArray2, 0, this.options.length);
            System.arraycopy(cLOptionDescriptorArray, 0, cLOptionDescriptorArray2, this.options.length, cLOptionDescriptorArray.length);
            this.options = cLOptionDescriptorArray2;
        }
    }

    protected void parseOption(CLOption cLOption) {
        switch (cLOption.getId()) {
            case 0: {
                if (this.wsdlURI != null) {
                    System.out.println(Messages.getMessage("w2jDuplicateWSDLURI00", this.wsdlURI, cLOption.getArgument()));
                    this.printUsage();
                }
                this.wsdlURI = cLOption.getArgument();
                break;
            }
            case 104: {
                this.printUsage();
                break;
            }
            case 79: {
                String string = cLOption.getArgument();
                long l = Long.parseLong(string);
                if (l > 0L) {
                    l *= 1000L;
                }
                this.parser.setTimeout(l);
                break;
            }
            case 118: {
                this.parser.setVerbose(true);
                break;
            }
            case 68: {
                this.parser.setDebug(true);
                break;
            }
            case 117: {
                try {
                    this.parser.setResolver(cLOption.getArgument());
                    break;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.wsdl.WSDL2.parseOption", (String)"205", (Object)this);
                    System.out.println(exception.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    protected void validateOptions() {
        if (this.wsdlURI == null) {
            System.out.println(Messages.getMessage("w2jMissingWSDLURI00"));
            this.printUsage();
        }
        this.checkForAuthInfo(this.wsdlURI);
        Authenticator.setDefault(new DefaultAuthenticator(this.parser.getUsername(), this.parser.getPassword()));
    }

    private void checkForAuthInfo(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.webservices.wsdl.gen.WSDL2.checkForAuthInfo", (String)"223", (Object)this);
            return;
        }
        String string2 = uRL.getUserInfo();
        if (string2 != null) {
            int n = string2.indexOf(58);
            if (n >= 0) {
                this.parser.setUsername(string2.substring(0, n));
                this.parser.setPassword(string2.substring(n + 1));
            } else {
                this.parser.setUsername(string2);
            }
        }
    }

    protected void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Messages.getMessage("usage00", "java " + this.getClass().getName() + " [options] WSDL-URI")).append(string);
        stringBuffer.append(Messages.getMessage("options00")).append(string);
        stringBuffer.append(CLUtil.describeOptions(this.options).toString());
        System.out.println(stringBuffer.toString());
        System.exit(1);
    }

    protected void run(String[] stringArray) {
        CLArgsParser cLArgsParser = new CLArgsParser(stringArray, this.options);
        if (null != cLArgsParser.getErrorString()) {
            System.err.println(Messages.getMessage("error01", cLArgsParser.getErrorString()));
            this.printUsage();
        }
        Vector vector = cLArgsParser.getArguments();
        int n = vector.size();
        try {
            for (int i = 0; i < n; ++i) {
                this.parseOption((CLOption)vector.get(i));
            }
            this.validateOptions();
            this.parser.setToolEnv(DefaultToolEnv.create());
            this.parser.run(this.wsdlURI);
            System.exit(0);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.webservices.wsdl.gen.WSDL2.run", (String)"291", (Object)this);
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        WSDL2 wSDL2 = new WSDL2();
        wSDL2.run(stringArray);
    }
}

