/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava;

import com.ibm.etools.java.ArrayType;
import com.ibm.etools.java.JavaClass;
import com.ibm.etools.java.JavaHelpers;
import com.ibm.etools.java.JavaPackage;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.enum.MIMEStyle;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.multiprotocol.provider.BindingGenerator;
import com.ibm.ws.webservices.multiprotocol.provider.ServiceProvider;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.utils.OptionDescriptor;
import com.ibm.ws.webservices.wsdl.fromJava.ClassFactory;
import com.ibm.ws.webservices.wsdl.fromJava.Namespaces;
import com.ibm.ws.webservices.wsdl.fromJava.Style;
import com.ibm.ws.webservices.wsdl.fromJava.Types;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.OperationDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.PortDesc;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Emitter {
    private static String binaryCopyright = Version.getBinaryCopyright();
    private static final String FUL = "file:undefined_location";
    protected static Log log = LogFactory.getLog((class$com$ibm$ws$webservices$wsdl$fromJava$Emitter == null ? (class$com$ibm$ws$webservices$wsdl$fromJava$Emitter = Emitter.class$("com.ibm.ws.webservices.wsdl.fromJava.Emitter")) : class$com$ibm$ws$webservices$wsdl$fromJava$Emitter).getName());
    private static OptionDescriptor[] commonOptions = new OptionDescriptor[]{new OptionDescriptor("servicePortName", false, null), new OptionDescriptor("portTypeName", false, null), new OptionDescriptor("bindingName", false, null), new OptionDescriptor("location", false, null), new OptionDescriptor("soapAction", false, null), new OptionDescriptor("style", false, null), new OptionDescriptor("use", false, null), new OptionDescriptor("wrapped", false, null), new OptionDescriptor("verbose", false, null), new OptionDescriptor("debug", false, null), new OptionDescriptor("encodingStyle", false, null), new OptionDescriptor("MIMEStyle", false, null), new OptionDescriptor("intfNS", false, null)};
    public static final int MODE_ALL = 0;
    public static final int MODE_INTERFACE = 1;
    public static final int MODE_IMPLEMENTATION = 2;
    private static final int REQUEST = 0;
    private static final int RESPONSE = 1;
    private static final int FAULT = 2;
    private static final String BINDING_TYPE_HTTP = "http";
    private static final String BINDING_TYPE_DELIMITERS = " ,;";
    private JavaClass cls;
    private JavaClass[] extraClasses;
    private JavaClass implCls;
    private ArrayList stopClasses = new ArrayList();
    private String intfNS;
    private String implNS;
    private String inputWSDL;
    private String locationUrl;
    private String importUrl;
    private String servicePortName;
    private String serviceElementName;
    private MIMEStyle mimeStyle = MIMEStyle.WSDL11;
    private Style style = Style.RPC;
    private Use use = null;
    private boolean wrapped = true;
    private TypeMapping defaultTM = null;
    private String voidReturn = null;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean removeBinding = false;
    private Namespaces namespaces;
    private Map exceptionMsg = null;
    private String encodingList = null;
    private Types types;
    private String clsName;
    private String portTypeName;
    private String bindingName;
    private ArrayList bindingTypes = null;
    private PortDesc portDesc;
    private PortDesc portDesc2;
    private String soapAction = "DEFAULT";
    private Map commonNSMap = new Hashtable();
    protected ToolEnv env = null;
    protected HashMap availableBindingGenerators = new HashMap();
    private ArrayList useBindingGenerators = new ArrayList();
    private Properties XProperties = new Properties();
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$fromJava$Emitter;

    public Emitter() {
        this.namespaces = new Namespaces();
        this.exceptionMsg = new HashMap();
        this.stopClasses.add("javax.ejb.EJBObject");
        this.stopClasses.add("javax.ejb.SessionBean");
        this.stopClasses.add("javax.ejb.EntityBean");
        this.stopClasses.add("javax.ejb.EnterpriseBean");
        this.stopClasses.add("javax.rmi.RemoteException");
        this.initPluggableBindings();
    }

    public void emit(String string, String string2) throws MissingResourceException, Exception {
        Definition definition = this.getIntfWSDL();
        Definition definition2 = this.getImplWSDL();
        if (string == null) {
            string = this.getServicePortName() + "_interface.wsdl";
        }
        if (string2 == null) {
            string2 = this.getServicePortName() + "_implementation.wsdl";
        }
        for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
            this.types.writeTypeForPart((JavaHelpers)this.extraClasses[i], null);
        }
        Document document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
        this.types.insertTypesFragment(document);
        this.prettyDocumentToFile(document, string);
        document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition2);
        this.prettyDocumentToFile(document, string2);
    }

    public void emit(String string) throws MissingResourceException, Exception {
        this.emit(string, 0);
    }

    private Document emit(int n) throws MissingResourceException, Exception {
        Document document = null;
        Definition definition = null;
        switch (n) {
            case 0: {
                definition = this.getWSDL();
                for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
                    this.types.writeTypeForPart((JavaHelpers)this.extraClasses[i], null);
                }
                document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 1: {
                definition = this.getIntfWSDL();
                for (int i = 0; this.extraClasses != null && i < this.extraClasses.length; ++i) {
                    this.types.writeTypeForPart((JavaHelpers)this.extraClasses[i], null);
                }
                document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
                this.types.insertTypesFragment(document);
                break;
            }
            case 2: {
                definition = this.getImplWSDL();
                document = new ServiceProviderManager(null).getWSDLFactory().newWSDLWriter().getDocument(definition);
            }
        }
        return document;
    }

    private String emitToString(int n) throws MissingResourceException, Exception {
        Document document = this.emit(n);
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        XMLUtils.PrettyDocumentToWriter(document, bufferedWriter);
        bufferedWriter.close();
        return stringWriter.getBuffer().toString();
    }

    private void emit(String string, int n) throws MissingResourceException, Exception {
        Document document = this.emit(n);
        if (string == null) {
            string = this.getServicePortName();
            switch (n) {
                case 0: {
                    string = string + ".wsdl";
                    break;
                }
                case 1: {
                    string = string + "_interface.wsdl";
                    break;
                }
                case 2: {
                    string = string + "_implementation.wsdl";
                }
            }
        }
        this.prettyDocumentToFile(document, string);
    }

    public Definition getWSDL() throws MissingResourceException, Exception {
        this.init(0);
        Definition definition = this.createDefinition();
        this.addDefinitionHeader(definition, this.intfNS);
        this.types = this.createTypes(definition);
        PortType portType = this.addPortType(definition);
        this.checkPortType(definition, portType);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            Binding binding = this.addBinding(definition, portType, bindingGenerator);
            this.addService(definition, binding, bindingGenerator);
        }
        return definition;
    }

    public Definition getIntfWSDL() throws MissingResourceException, Exception {
        this.init(1);
        Definition definition = this.createDefinition();
        this.addDefinitionHeader(definition, this.intfNS);
        this.types = this.createTypes(definition);
        PortType portType = this.addPortType(definition);
        this.checkPortType(definition, portType);
        for (int i = 0; i < this.useBindingGenerators.size(); ++i) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.useBindingGenerators.get(i);
            this.addBinding(definition, portType, bindingGenerator);
        }
        return definition;
    }

    public Definition getImplWSDL() throws MissingResourceException, Exception {
        this.init(2);
        Definition definition = this.createDefinition();
        this.addDefinitionHeader(definition, this.implNS);
        this.addImport(definition, this.intfNS, this.importUrl);
        QName qName = QNameTable.createQName(this.intfNS, this.getBindingName());
        Binding binding = definition.createBinding();
        binding.setUndefined(false);
        binding.setQName(qName);
        this.addService(definition, binding, null);
        return definition;
    }

    private void init(int n) throws MissingResourceException, Exception {
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        if (this.voidReturn == null) {
            this.voidReturn = "TWOWAY";
        }
        if (this.use == null) {
            this.use = this.style == Style.RPC ? Use.ENCODED : Use.LITERAL;
        }
        if (this.use == Use.ENCODED || this.style == Style.RPC) {
            this.wrapped = false;
        }
        this.defaultTM = this.use == Use.ENCODED ? DefaultSOAP12TypeMappingImpl.getSingleton() : DefaultTypeMappingImpl.getSingleton();
        if (this.bindingTypes == null) {
            this.initBindingTypes();
        }
        if (this.portDesc == null) {
            this.portDesc = new PortDesc(this);
            this.portDesc.setImplClass(this.cls);
            this.portDesc.setTypeMapping(this.defaultTM);
            this.portDesc.setStopClasses(this.stopClasses);
            if (this.implCls != null && this.implCls != this.cls && this.portDesc2 == null) {
                this.portDesc2 = new PortDesc(this);
                this.portDesc2.setImplClass(this.implCls);
                this.portDesc2.setTypeMapping(this.defaultTM);
                this.portDesc2.setStopClasses(this.stopClasses);
            }
        }
        if (this.encodingList == null) {
            this.clsName = this.cls.getJavaName();
            this.clsName = this.clsName.substring(this.clsName.lastIndexOf(46) + 1);
            if (this.getPortTypeName() == null) {
                this.setPortTypeName(this.clsName);
            }
            if (this.getServiceElementName() == null) {
                this.setServiceElementName(this.getPortTypeName() + "Service");
            }
            if (this.getServicePortName() == null) {
                this.initServicePortName();
            }
            this.encodingList = Constants.URI_DEFAULT_SOAP_ENC;
            if (this.intfNS == null) {
                JavaPackage javaPackage = this.cls.getJavaPackage();
                this.intfNS = this.namespaces.getCreate(javaPackage == null ? null : javaPackage.getPackageName());
            }
            if (this.getBindingName() == null) {
                this.setBindingName(this.getServicePortName());
            }
            if (this.implNS == null) {
                int n2;
                this.implNS = n == 0 ? this.intfNS : ((n2 = this.intfNS.indexOf("://")) > 0 ? this.intfNS.substring(0, n2 += 3) + "impl." + this.intfNS.substring(n2) : this.intfNS + "-impl");
            }
            this.namespaces.put(this.cls.getJavaName(), this.intfNS, "intf");
            this.namespaces.putPrefix(this.implNS, "impl");
        }
        this.initLocation();
        this.seedProperties();
        this.validatePluginOptions();
    }

    private Definition createDefinition() throws WSDLException, SAXException, IOException, ParserConfigurationException {
        Definition definition;
        if (this.inputWSDL == null) {
            definition = new ServiceProviderManager(null).getWSDLFactory().newDefinition();
        } else {
            WSDLReader wSDLReader = new ServiceProviderManager(null).getWSDLFactory().newWSDLReader();
            Document document = XMLUtils.newDocument(this.inputWSDL);
            definition = wSDLReader.readWSDL(this.inputWSDL, document);
            definition.setTypes(null);
        }
        return definition;
    }

    private Types createTypes(Definition definition) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.types = new Types(this, definition, this.defaultTM, this.namespaces, this.intfNS, this.stopClasses, this.style, this.use, this.verbose);
        if (this.inputWSDL != null) {
            this.types.loadInputTypes(this.inputWSDL);
        }
        return this.types;
    }

    private void addDefinitionHeader(Definition definition, String string) {
        definition.setTargetNamespace(string);
        definition.addNamespace("intf", this.intfNS);
        this.commonNSMap.put("intf", this.intfNS);
        definition.addNamespace("impl", this.implNS);
        this.commonNSMap.put("impl", this.implNS);
        definition.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/soap/", "wsdlsoap");
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.namespaces.putPrefix("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        this.commonNSMap.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        if (this.use != Use.LITERAL) {
            definition.addNamespace("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
            this.namespaces.putPrefix(Constants.URI_DEFAULT_SOAP_ENC, "soapenc");
            this.commonNSMap.put("soapenc", Constants.URI_DEFAULT_SOAP_ENC);
        }
        definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.namespaces.putPrefix("http://www.w3.org/2001/XMLSchema", "xsd");
        this.commonNSMap.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }

    Map getCommonNSMap() {
        return this.commonNSMap;
    }

    private void addImport(Definition definition, String string, String string2) {
        Import import_ = definition.createImport();
        import_.setNamespaceURI(string);
        if (string2 != null && !string2.equals("")) {
            import_.setLocationURI(string2);
        }
        definition.addImport(import_);
    }

    private PortType addPortType(Definition definition) throws WSDLException, WebServicesFault {
        PortType portType;
        QName qName = QNameTable.createQName(this.intfNS, this.getPortTypeName());
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "portType", qName.toString()));
        }
        if ((portType = definition.getPortType(qName)) != null) {
            return portType;
        }
        portType = definition.createPortType();
        portType.setUndefined(false);
        portType.setQName(qName);
        definition.addPortType(portType);
        ArrayList arrayList = this.portDesc.getOperations();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            OperationDesc[] operationDescArray;
            OperationDesc operationDesc;
            OperationDesc operationDesc2 = operationDesc = (OperationDesc)iterator.next();
            if (this.style == Style.DOCUMENT && this.use == Use.LITERAL && this.wrapped && (operationDescArray = this.portDesc.getOperationsByName(operationDesc.getName())) != null && operationDescArray.length > 1) {
                throw new WebServicesFault(Messages.getMessage("DocLitWrappedOverloaded", operationDesc.getName()));
            }
            if (this.portDesc2 != null) {
                operationDescArray = this.portDesc2.getOperationsByName(operationDesc.getName());
                boolean bl = false;
                if (operationDescArray != null) {
                    for (int i = 0; i < operationDescArray.length && !bl; ++i) {
                        OperationDesc operationDesc3 = operationDescArray[i];
                        if (operationDesc3.getParameters().size() != operationDesc.getParameters().size()) continue;
                        boolean bl2 = true;
                        for (int j = 0; j < operationDesc.getParameters().size() && bl2; ++j) {
                            if (operationDesc3.getParameter(j).getMode() == operationDesc.getParameter(j).getMode() && operationDesc3.getParameter(j).getJavaType().equals(operationDesc.getParameter(j).getJavaType())) continue;
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        operationDesc2 = operationDesc3;
                        bl = true;
                    }
                }
            }
            this.addOperation(definition, portType, operationDesc2);
        }
        return portType;
    }

    private Operation addOperation(Definition definition, PortType portType, OperationDesc operationDesc) throws WSDLException, WebServicesFault {
        Object object;
        Operation operation = definition.createOperation();
        operation.setName(operationDesc.getName());
        operation.setUndefined(false);
        portType.addOperation(operation);
        Message message = this.addRequestMessage(definition, operationDesc);
        Input input = definition.createInput();
        input.setMessage(message);
        String string = message.getQName().getLocalPart();
        input.setName(string);
        operation.setInput(input);
        message = this.addResponseMessage(definition, operationDesc);
        Output output = definition.createOutput();
        output.setMessage(message);
        string = message.getQName().getLocalPart();
        output.setName(string);
        operation.setOutput(output);
        ArrayList arrayList = operationDesc.getFaults();
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            object = (FaultDesc)arrayList.get(i);
            message = this.addFaultMessage(definition, (FaultDesc)object);
            Fault fault2 = definition.createFault();
            fault2.setMessage(message);
            fault2.setName(((FaultDesc)object).getJavaClass().getName());
            operation.addFault(fault2);
        }
        ArrayList arrayList2 = operationDesc.getParameters();
        object = new Vector();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ParameterDesc parameterDesc = (ParameterDesc)arrayList2.get(i);
            ((Vector)object).add(parameterDesc.getName());
        }
        if (((Vector)object).size() > 0 && !this.isWrapped()) {
            operation.setParameterOrdering((List)object);
        }
        return operation;
    }

    private Message addRequestMessage(Definition definition, OperationDesc operationDesc) throws WSDLException, WebServicesFault {
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, operationDesc.getName(), "Request");
        message.setQName(qName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
        }
        message.setUndefined(false);
        ArrayList arrayList = operationDesc.getParameters();
        if (this.isWrapped() && arrayList.size() == 0) {
            QName qName2 = QNameTable.createQName(message.getQName().getNamespaceURI(), message.getQName().getLocalPart().substring(0, message.getQName().getLocalPart().indexOf("Request")));
            if (this.types.writeWrapperForPart(qName2, null, null, false, false)) {
                Part part = definition.createPart();
                part.setName("parameters");
                part.setElementName(qName2);
                message.addPart(part);
            }
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                ParameterDesc parameterDesc = (ParameterDesc)arrayList.get(i);
                this.addPartToMessage(definition, message, 0, parameterDesc);
            }
        }
        definition.addMessage(message);
        return message;
    }

    private Message addResponseMessage(Definition definition, OperationDesc operationDesc) throws WSDLException, WebServicesFault {
        Serializable serializable;
        Message message = definition.createMessage();
        QName qName = this.createMessageName(definition, operationDesc.getName(), "Response");
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
        }
        message.setQName(qName);
        message.setUndefined(false);
        JavaHelpers javaHelpers = operationDesc.getReturnClass();
        if (this.isWrapped() && (javaHelpers == null || javaHelpers.getJavaName().equals("void"))) {
            this.types.writeWrapperForPart(qName, null, null, false, false);
            serializable = definition.createPart();
            serializable.setName("parameters");
            serializable.setElementName(qName);
            message.addPart((Part)serializable);
        } else {
            serializable = new ParameterDesc();
            ((ParameterDesc)serializable).setName(operationDesc.getName() + "Return");
            ((ParameterDesc)serializable).setMode((byte)2);
            ((ParameterDesc)serializable).setIsReturn(true);
            ((ParameterDesc)serializable).setJavaType(operationDesc.getReturnClass(), this);
            this.addPartToMessage(definition, message, 1, (ParameterDesc)serializable);
        }
        serializable = operationDesc.getParameters();
        Iterator iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            ParameterDesc parameterDesc = (ParameterDesc)iterator.next();
            this.addPartToMessage(definition, message, 1, parameterDesc);
        }
        definition.addMessage(message);
        return message;
    }

    private Message addFaultMessage(Definition definition, FaultDesc faultDesc) throws WSDLException, WebServicesFault {
        String string = faultDesc.getJavaClass().getJavaName();
        String string2 = string.substring(string.lastIndexOf(46) + 1, string.length());
        Message message = (Message)this.exceptionMsg.get(string);
        if (message == null) {
            message = definition.createMessage();
            QName qName = this.createMessageName(definition, string2, "");
            if (this.verbose) {
                this.env.report(Messages.getMessage("j2wGen00", "message", qName.toString()));
            }
            message.setQName(qName);
            message.setUndefined(false);
            ParameterDesc parameterDesc = new ParameterDesc(QNameTable.createQName("", "fault"), 1, this.types.getTypeQName((JavaHelpers)faultDesc.getJavaClass()), (JavaHelpers)faultDesc.getJavaClass(), false, false);
            this.addPartToMessage(definition, message, 2, parameterDesc);
            this.exceptionMsg.put(string, message);
            definition.addMessage(message);
        }
        return message;
    }

    public Part addPartToMessage(Definition definition, Message message, int n, ParameterDesc parameterDesc) throws WSDLException, WebServicesFault {
        if (parameterDesc == null || parameterDesc.getJavaType().getJavaName().equals("void")) {
            return null;
        }
        if (n == 2 && parameterDesc.getMode() != 1) {
            return null;
        }
        if (n == 0 && parameterDesc.getMode() == 2) {
            return null;
        }
        if (n == 1 && parameterDesc.getMode() == 1) {
            return null;
        }
        Part part = definition.createPart();
        JavaHelpers javaHelpers = parameterDesc.getHeldJavaType(this);
        if (this.isWrapped() && n != 2) {
            boolean bl = false;
            JavaHelpers javaHelpers2 = javaHelpers;
            if (javaHelpers.isArray() && !javaHelpers.getJavaName().equals("byte[]")) {
                javaHelpers2 = ((ArrayType)javaHelpers).getComponentTypeAsHelper();
                bl = true;
            }
            QName qName = this.types.writeTypeForPart(javaHelpers2, parameterDesc.getTypeQName());
            QName qName2 = null;
            qName2 = n == 0 ? QNameTable.createQName(message.getQName().getNamespaceURI(), message.getQName().getLocalPart().substring(0, message.getQName().getLocalPart().indexOf("Request"))) : message.getQName();
            if (qName != null && this.types.writeWrapperForPart(qName2, parameterDesc.getName(), qName, bl, this.types.isNullable(javaHelpers2))) {
                part.setName("parameters");
                part.setElementName(qName2);
                message.addPart(part);
            }
        } else if (this.use == Use.ENCODED || this.style == Style.RPC) {
            QName qName = this.types.writeTypeForPart(javaHelpers, parameterDesc.getTypeQName());
            this.types.writeElementForPart(javaHelpers, parameterDesc.getTypeQName(), parameterDesc.getName());
            if (qName != null) {
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
            }
        } else if (this.use == Use.LITERAL) {
            QName qName = this.types.writeTypeForPart(javaHelpers, parameterDesc.getTypeQName());
            QName qName3 = this.types.writeElementForPart(javaHelpers, parameterDesc.getTypeQName(), parameterDesc.getName());
            if (qName3 != null) {
                part.setName(parameterDesc.getName());
                part.setElementName(qName3);
                message.addPart(part);
            } else if (qName != null) {
                part.setName(parameterDesc.getName());
                part.setTypeName(qName);
                message.addPart(part);
            }
        }
        return part;
    }

    private Binding addBinding(Definition definition, PortType portType, BindingGenerator bindingGenerator) {
        if (bindingGenerator == null) {
            return null;
        }
        QName qName = QNameTable.createQName(this.intfNS, bindingGenerator.getBindingName(this.XProperties));
        Binding binding = definition.getBinding(qName);
        if (binding != null) {
            this.env.report(Messages.getMessage("duplicateBinding", qName.toString()));
            return binding;
        }
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "binding", qName.toString()));
        }
        if (bindingGenerator != null) {
            binding = bindingGenerator.makeBinding(definition, portType, qName, this.XProperties);
            definition.addBinding(binding);
        }
        return binding;
    }

    private void addService(Definition definition, Binding binding, BindingGenerator bindingGenerator) {
        QName qName = QNameTable.createQName(this.implNS, this.getServiceElementName());
        Service service = definition.getService(qName);
        if (this.verbose) {
            this.env.report(Messages.getMessage("j2wGen00", "service", qName.toString()));
        }
        if (service == null) {
            service = definition.createService();
            service.setQName(qName);
            definition.addService(service);
        }
        Port port2 = definition.createPort();
        port2.setBinding(binding);
        if (bindingGenerator != null) {
            port2.setName(bindingGenerator.getPortName(this.XProperties));
            if (this.verbose) {
                this.env.report(Messages.getMessage("j2wGen00", "port", port2.getName()));
            }
            ExtensibilityElement extensibilityElement = bindingGenerator.makePortAddress(definition, port2, this.XProperties);
            port2.addExtensibilityElement(extensibilityElement);
        }
        service.addPort(port2);
    }

    private void checkPortType(Definition definition, PortType portType) {
        Object object;
        Operation operation;
        Iterator<Object> iterator;
        if (this.voidReturn.equals("TWOWAY")) {
            return;
        }
        if (portType.getOperations() != null) {
            iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                operation = (Operation)iterator.next();
                if (operation.getOutput() != null && operation.getOutput().getMessage() != null && operation.getOutput().getMessage().getParts() != null && operation.getOutput().getMessage().getParts().size() > 0) continue;
                object = operation.getFaults();
                if (object != null && object.size() > 0) {
                    this.env.report(Messages.getMessage("onewayHasFault", operation.getName()));
                    continue;
                }
                operation.setOutput(null);
            }
        }
        if (definition.getBindings() != null) {
            iterator = definition.getBindings().values().iterator();
            while (iterator.hasNext()) {
                operation = (Binding)iterator.next();
                if (operation.getPortType() != portType || operation.getBindingOperations() == null) continue;
                object = operation.getBindingOperations().iterator();
                while (object.hasNext()) {
                    BindingOperation bindingOperation = (BindingOperation)object.next();
                    Map map = bindingOperation.getBindingFaults();
                    if (bindingOperation.getBindingOutput() != null || map != null && map.size() > 0) continue;
                    bindingOperation.setBindingOutput(null);
                    if (map == null) continue;
                    map.clear();
                }
            }
        }
    }

    private QName createMessageName(Definition definition, String string, String string2) {
        QName qName = QNameTable.createQName(this.intfNS, string.concat(string2));
        int n = 1;
        while (definition.getMessage(qName) != null) {
            StringBuffer stringBuffer = new StringBuffer(string.concat(string2));
            stringBuffer.append(n);
            qName = QNameTable.createQName(this.intfNS, stringBuffer.toString());
            ++n;
        }
        return qName;
    }

    private void prettyDocumentToFile(Document document, String string) throws IOException {
        OutputStream outputStream = this.env.getOutputStream(string);
        XMLUtils.PrettyDocumentToStream(document, outputStream);
        outputStream.close();
    }

    public void setMIMEStyle(String string) {
        this.mimeStyle = MIMEStyle.getMIMEStyle(string);
    }

    public void setMIMEStyle(MIMEStyle mIMEStyle) {
        this.mimeStyle = mIMEStyle;
    }

    public MIMEStyle getMIMEStyle() {
        return this.mimeStyle;
    }

    public void setCls(String string) throws ClassNotFoundException {
        this.cls = (JavaClass)ClassFactory.getClassFactory(this).forName(string);
    }

    public void setImplCls(String string) throws ClassNotFoundException {
        this.implCls = (JavaClass)ClassFactory.getClassFactory(this).forName(string);
    }

    public String getIntfNamespace() {
        return this.intfNS;
    }

    public void setIntfNamespace(String string) {
        this.intfNS = string;
    }

    public String getImplNamespace() {
        return this.implNS;
    }

    public void setImplNamespace(String string) {
        this.implNS = string;
    }

    public void setStopClasses(ArrayList arrayList) {
        if (this.stopClasses == null) {
            this.stopClasses = new ArrayList();
        }
        this.stopClasses.addAll(arrayList);
    }

    public void setStopClasses(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,+");
            if (this.stopClasses == null) {
                this.stopClasses = new ArrayList();
            }
            while (stringTokenizer.hasMoreTokens()) {
                this.stopClasses.add(stringTokenizer.nextToken());
            }
        }
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public Map getNamespaceMap() {
        return this.namespaces;
    }

    public void setNamespaceMap(Map map) {
        if (map != null) {
            this.namespaces.putAll(map);
        }
    }

    public String getInputWSDL() {
        return this.inputWSDL;
    }

    public void setInputWSDL(String string) {
        this.inputWSDL = string;
    }

    public String getLocationUrl() {
        return this.locationUrl;
    }

    public void setLocationUrl(String string) {
        this.locationUrl = string;
    }

    public String getImportUrl() {
        return this.importUrl;
    }

    public void setImportUrl(String string) {
        this.importUrl = string;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public void setServicePortName(String string) {
        this.servicePortName = string;
    }

    public String getServiceElementName() {
        return this.serviceElementName;
    }

    public void setServiceElementName(String string) {
        this.serviceElementName = string;
    }

    public String getPortTypeName() {
        return this.portTypeName;
    }

    public void setPortTypeName(String string) {
        this.portTypeName = string;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String string) {
        this.bindingName = string;
    }

    public void setBindingTypes(String string) {
        this.bindingTypes = new ArrayList();
        this.useBindingGenerators.clear();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, BINDING_TYPE_DELIMITERS);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(string2);
                if (bindingGenerator == null) {
                    this.env.reporterr(Messages.getMessage("noGenerator", string2));
                    continue;
                }
                this.addBindingGenerator(bindingGenerator);
                this.bindingTypes.add(string2);
                if (!this.verbose) continue;
                this.env.report(Messages.getMessage("foundGenerator", string2));
            }
        }
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String string) {
        this.soapAction = string;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = Style.getStyle(string);
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Use getUse() {
        return this.use;
    }

    public void setUse(String string) {
        this.use = Use.getUse(string);
    }

    public void setUse(Use use) {
        this.use = use;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public void setTransport(String string) {
        if (string == null || string.length() == 0) {
            string = BINDING_TYPE_HTTP;
        }
        this.setBindingTypes(string);
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setToolEnv(ToolEnv toolEnv) {
        this.env = toolEnv;
    }

    public ToolEnv getToolEnv() {
        return this.env;
    }

    public void setVoidReturn(String string) {
        if (string.equalsIgnoreCase("ONEWAY")) {
            this.voidReturn = "ONEWAY";
        } else if (string.equalsIgnoreCase("TWOWAY")) {
            this.voidReturn = "TWOWAY";
        } else {
            log.error((Object)Messages.getMessage("j2voidreturnerr00"));
            this.env.reporterr(Messages.getMessage("j2wvoidreturnerr00"));
        }
    }

    public void setExtraClasses(String string) throws ClassNotFoundException {
        JavaClass javaClass;
        JavaClass[] javaClassArray;
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        if (string != null) {
            javaClassArray = new StringTokenizer(string, " ,");
            while (javaClassArray.hasMoreTokens()) {
                String string2 = javaClassArray.nextToken();
                javaClass = (JavaClass)ClassFactory.getClassFactory(this).forName(string2);
                arrayList.add(javaClass);
            }
        }
        if (this.extraClasses != null) {
            javaClassArray = new JavaClass[arrayList.size() + this.extraClasses.length];
            for (int i = 0; i < this.extraClasses.length; ++i) {
                javaClassArray[i] = javaClass = this.extraClasses[i];
            }
        } else {
            javaClassArray = new JavaClass[arrayList.size()];
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            javaClassArray[i] = javaClass = (JavaClass)arrayList.get(i);
        }
        this.extraClasses = javaClassArray;
    }

    private void initLocation() {
        if (this.locationUrl == null) {
            this.locationUrl = FUL;
            if (this.bindingTypes.size() == 1) {
                if (this.XProperties.getProperty(this.bindingTypes.get(0) + ".location") == null) {
                    this.env.report(Messages.getMessage("java2wsdl.UndefinedLocation", FUL));
                }
            } else {
                for (int i = 0; i < this.bindingTypes.size(); ++i) {
                    if (this.XProperties.getProperty(this.bindingTypes.get(i) + ".location") != null) continue;
                    this.env.report(Messages.getMessage("missingLocation", (String)this.bindingTypes.get(i), FUL));
                }
            }
        } else if (this.bindingTypes.size() > 1) {
            this.locationUrl = FUL;
            this.env.report(Messages.getMessage("genericLocation"));
        }
    }

    private void initServicePortName() {
        if (this.getServicePortName() == null) {
            String string = this.getLocationUrl();
            if (string != null) {
                if ((string = string.lastIndexOf(47) > 0 ? string.substring(string.lastIndexOf(47) + 1) : (string.lastIndexOf(92) > 0 ? string.substring(string.lastIndexOf(92) + 1) : null)) != null && string.endsWith(".jws")) {
                    string = string.substring(0, string.length() - ".jws".length());
                }
                if (string != null && string.length() > 0) {
                    string = Character.isUpperCase(string.charAt(0)) ? JavaUtils.xmlNameToJavaClass(string) : JavaUtils.xmlNameToJava(string);
                }
            }
            if (string == null || string.equals("")) {
                string = this.clsName;
            }
            this.setServicePortName(string);
        }
    }

    private void initBindingTypes() throws MissingResourceException, Exception {
        if (this.bindingTypes == null) {
            this.bindingTypes = new ArrayList();
            this.bindingTypes.add(BINDING_TYPE_HTTP);
            BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(BINDING_TYPE_HTTP);
            if (bindingGenerator != null) {
                this.addBindingGenerator(bindingGenerator);
            } else {
                throw new Exception(Messages.getMessage("noGenerator", BINDING_TYPE_HTTP));
            }
        }
    }

    protected void initPluggableBindings() {
        ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
        Iterator iterator = serviceProviderManager.getAllServiceProviders();
        while (iterator.hasNext()) {
            ServiceProvider serviceProvider = (ServiceProvider)iterator.next();
            BindingGenerator[] bindingGeneratorArray = serviceProvider.getBindingGenerators();
            if (bindingGeneratorArray == null) continue;
            for (int i = 0; i < bindingGeneratorArray.length; ++i) {
                if (this.verbose) {
                    this.env.report(Messages.getMessage("foundGenerator", bindingGeneratorArray[i].getBindingTypeName()));
                }
                this.availableBindingGenerators.put(bindingGeneratorArray[i].getBindingTypeName(), bindingGeneratorArray[i]);
            }
        }
    }

    public void addBindingGenerator(BindingGenerator bindingGenerator) {
        this.useBindingGenerators.add(bindingGenerator);
    }

    public ArrayList getAvailableBindingGeneratorsTypeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.availableBindingGenerators.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public void setXProperties(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, BINDING_TYPE_DELIMITERS);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf(61);
                this.XProperties.setProperty(string2.substring(0, n), string2.substring(n + 1));
            }
        }
    }

    public Properties getXProperties() {
        return this.XProperties;
    }

    private void seedProperties() {
        this.XProperties.setProperty("servicePortName", this.getServicePortName());
        this.XProperties.setProperty("portTypeName", this.getPortTypeName());
        this.XProperties.setProperty("bindingName", this.getBindingName());
        this.XProperties.setProperty("location", this.getLocationUrl());
        this.XProperties.setProperty("soapAction", this.getSoapAction());
        this.XProperties.setProperty("style", this.getStyle().toString().toLowerCase());
        this.XProperties.setProperty("use", this.getUse().toString());
        this.XProperties.setProperty("wrapped", this.isWrapped() ? "true" : "false");
        this.XProperties.setProperty("verbose", this.verbose ? "true" : "false");
        this.XProperties.setProperty("debug", this.debug ? "true" : "false");
        this.XProperties.setProperty("encodingStyle", this.encodingList);
        this.XProperties.setProperty("MIMEStyle", this.getMIMEStyle().toString());
        this.XProperties.setProperty("intfNS", this.intfNS);
        if (this.verbose) {
            this.env.report(Messages.getMessage("bsProps1", this.XProperties.toString()));
        }
    }

    public String getPluggableHelpInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.availableBindingGenerators.keySet().iterator();
        while (iterator.hasNext()) {
            BindingGenerator bindingGenerator = (BindingGenerator)this.availableBindingGenerators.get(iterator.next());
            OptionDescriptor[] optionDescriptorArray = bindingGenerator.getOptionDescriptors();
            if (optionDescriptorArray == null) continue;
            stringBuffer.append("\n    ");
            stringBuffer.append(Messages.getMessage("bsProps2", bindingGenerator.getBindingTypeName()));
            stringBuffer.append("\n");
            for (int i = 0; i < optionDescriptorArray.length; ++i) {
                String string = optionDescriptorArray[i].getName();
                String string2 = optionDescriptorArray[i].getDescription();
                stringBuffer.append("        ");
                stringBuffer.append(string);
                stringBuffer.append("\n");
                stringBuffer.append("            ");
                stringBuffer.append(string2 == null ? "" : string2);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private void validatePluginOptions() throws IOException {
        Object object;
        Object object2;
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (n = 0; n < commonOptions.length; ++n) {
            hashMap.put(commonOptions[n].getName(), commonOptions[n]);
        }
        for (n = 0; n < this.useBindingGenerators.size(); ++n) {
            object2 = (BindingGenerator)this.useBindingGenerators.get(n);
            object = object2.getOptionDescriptors();
            if (object == null) continue;
            for (int i = 0; i < ((Object)object).length; ++i) {
                hashMap.put(((OptionDescriptor)object[i]).getName(), object[i]);
            }
        }
        n = 0;
        object2 = this.XProperties.propertyNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            OptionDescriptor optionDescriptor = (OptionDescriptor)hashMap.get(object);
            if (optionDescriptor != null) continue;
            ++n;
            this.env.reporterr(Messages.getMessage("unsupportedProperty", (String)object));
        }
        object = hashMap.values().iterator();
        while (object.hasNext()) {
            OptionDescriptor optionDescriptor = (OptionDescriptor)object.next();
            if (!optionDescriptor.isRequired() || this.XProperties.containsKey(optionDescriptor.getName())) continue;
            this.env.reporterr(Messages.getMessage("missingRequiredProperty", optionDescriptor.getName()));
            ++n;
        }
        if (n > 0) {
            throw new IOException(Messages.getMessage("propValidationError"));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

