/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava.description;

import com.ibm.etools.java.JavaHelpers;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import java.io.Serializable;
import javax.xml.namespace.QName;

public class ParameterDesc
implements Serializable {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    private transient QName name;
    private byte mode = 1;
    private QName typeQName;
    private JavaHelpers javaType = null;
    private int order = -1;
    private boolean isReturn = false;
    private String mimeType = null;
    private boolean inHeader = false;
    private boolean outHeader = false;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc parameterDesc) {
        this.name = parameterDesc.name;
        this.mode = parameterDesc.mode;
        this.typeQName = parameterDesc.typeQName;
        this.javaType = parameterDesc.javaType;
        this.order = parameterDesc.order;
        this.isReturn = parameterDesc.isReturn;
        this.mimeType = parameterDesc.mimeType;
    }

    public ParameterDesc(QName qName, byte by, QName qName2) {
        this.name = qName;
        this.mode = by;
        this.typeQName = qName2;
    }

    public ParameterDesc(QName qName, byte by, QName qName2, JavaHelpers javaHelpers, boolean bl, boolean bl2) {
        this(qName, by, qName2);
        this.javaType = javaHelpers;
        this.inHeader = bl;
        this.outHeader = bl2;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "name:       " + this.name + "\n";
        string2 = string2 + string + "mode:       " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\n";
        string2 = string2 + string + "isReturn:   " + this.isReturn + "\n";
        string2 = string2 + string + "typeQName:  " + this.typeQName + "\n";
        string2 = string2 + string + "javaType:   " + this.javaType + "\n";
        string2 = string2 + string + "inHeader:   " + this.inHeader + "\n";
        string2 = string2 + string + "outHeader:  " + this.outHeader + "\n";
        return string2;
    }

    public static byte modeFromString(String string) {
        int n = 1;
        if (string == null) {
            return 1;
        }
        if (string.equalsIgnoreCase("out")) {
            n = 2;
        } else if (string.equalsIgnoreCase("inout")) {
            n = 3;
        }
        return (byte)n;
    }

    public static String getModeAsString(byte by) {
        if (by == 3) {
            return "inout";
        }
        if (by == 2) {
            return "out";
        }
        if (by == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(by)));
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String string) {
        this.name = new QName("", string);
    }

    public void setQName(QName qName) {
        this.name = qName;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName qName) {
        this.typeQName = qName;
    }

    public JavaHelpers getJavaType() {
        return this.javaType;
    }

    public JavaHelpers getHeldJavaType(Emitter emitter) {
        JavaHelpers javaHelpers = Utils.getHolderValueType(this.javaType, emitter);
        if (javaHelpers == null) {
            javaHelpers = this.javaType;
        }
        return javaHelpers;
    }

    public void setJavaType(JavaHelpers javaHelpers, Emitter emitter) {
        if (javaHelpers != null) {
            JavaHelpers javaHelpers2 = Utils.getHolderValueType(javaHelpers, emitter);
            if ((this.mode == 1 || this.isReturn) && javaHelpers2 != null || this.mode != 1 && !this.isReturn && javaHelpers2 == null) {
                throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", javaHelpers.getJavaName(), ParameterDesc.getModeAsString(this.mode)));
            }
        }
        this.javaType = javaHelpers;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte by) {
        this.mode = by;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int n) {
        this.order = n;
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean bl) {
        this.outHeader = bl;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean bl) {
        this.isReturn = bl;
    }
}

