/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.mapping;

import com.ibm.etools.archive.LoadStrategy;
import com.ibm.etools.webservice.jaxrpcmap.ExceptionMapping;
import com.ibm.etools.webservice.jaxrpcmap.JavaXMLTypeMapping;
import com.ibm.etools.webservice.jaxrpcmap.MethodParamPartsMapping;
import com.ibm.etools.webservice.jaxrpcmap.PackageMapping;
import com.ibm.etools.webservice.jaxrpcmap.PortMapping;
import com.ibm.etools.webservice.jaxrpcmap.ServiceEndpointInterfaceMapping;
import com.ibm.etools.webservice.jaxrpcmap.ServiceEndpointMethodMapping;
import com.ibm.etools.webservice.jaxrpcmap.ServiceInterfaceMapping;
import com.ibm.etools.webservice.jaxrpcmap.VariableMapping;
import com.ibm.etools.webservice.jaxrpcmap.WSDLPortType;
import com.ibm.etools.webservice.jaxrpcmap.WSDLReturnValueMapping;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaDOM;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationKey;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationValue;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.xml.namespace.QName;

public class MappingMetaData {
    MappingMetaDOM dom = null;
    HashMap exceptionMappings = new HashMap();

    public MappingMetaData() {
        this.dom = new MappingMetaDOM();
    }

    public static MappingMetaData loadFromFile(String string, ToolEnv toolEnv) throws IOException {
        MappingMetaData mappingMetaData = new MappingMetaData();
        mappingMetaData.dom = MappingMetaDOM.loadFromFile(string, toolEnv);
        return mappingMetaData;
    }

    public static MappingMetaData loadFromFile(String string, LoadStrategy loadStrategy) throws IOException {
        MappingMetaData mappingMetaData = new MappingMetaData();
        mappingMetaData.dom = MappingMetaDOM.loadFromFile(string, loadStrategy);
        return mappingMetaData;
    }

    public void write(String string, ToolEnv toolEnv) throws IOException {
        this.dom.write(string, toolEnv);
    }

    public void addPackageMappings(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)hashMap.get(string);
            this.dom.createPackageMapping(string2, string);
        }
    }

    public HashMap getPackageMappings() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Iterator iterator = this.dom.getPackageMappings();
        while (iterator.hasNext()) {
            PackageMapping packageMapping = (PackageMapping)iterator.next();
            hashMap.put(this.dom.getNamespaceURI(packageMapping), this.dom.getPackageType(packageMapping));
        }
        return hashMap;
    }

    public HashMap getSEIMappings() {
        HashMap<String, QName> hashMap = new HashMap<String, QName>();
        Iterator iterator = this.dom.getServiceEndpointInterfaceMappings();
        while (iterator.hasNext()) {
            ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping = (ServiceEndpointInterfaceMapping)iterator.next();
            WSDLPortType wSDLPortType = serviceEndpointInterfaceMapping.getWsdlPortType();
            QName qName = new QName(wSDLPortType.getNamespaceURI(), wSDLPortType.getLocalPart());
            hashMap.put(serviceEndpointInterfaceMapping.getServiceEndpointInterface(), qName);
        }
        return hashMap;
    }

    public void preSymbolTable(MetaInfo metaInfo) {
        Iterator iterator = this.dom.getServiceEndpointInterfaceMappings();
        while (iterator.hasNext()) {
            ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping = (ServiceEndpointInterfaceMapping)iterator.next();
            QName qName = this.dom.getWsdlBinding(serviceEndpointInterfaceMapping);
            Iterator iterator2 = this.dom.getServiceEndpointMethodMappings(serviceEndpointInterfaceMapping);
            while (iterator2.hasNext()) {
                MethodParamPartsMapping methodParamPartsMapping;
                int n;
                Object object;
                Object object2;
                ServiceEndpointMethodMapping serviceEndpointMethodMapping = (ServiceEndpointMethodMapping)iterator2.next();
                String string = this.dom.getWsdlOperation(serviceEndpointMethodMapping);
                QName qName2 = null;
                QName qName3 = null;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator3 = this.dom.getMethodParamPartsMappings(serviceEndpointMethodMapping);
                while (iterator3.hasNext()) {
                    object2 = (MethodParamPartsMapping)iterator3.next();
                    object = this.dom.getParamMode((MethodParamPartsMapping)object2);
                    if (("IN".equalsIgnoreCase((String)object) || "INOUT".equalsIgnoreCase((String)object)) && qName2 == null) {
                        qName2 = this.dom.getWsdlMessage((MethodParamPartsMapping)object2);
                    }
                    if ("OUT".equalsIgnoreCase((String)object) && qName3 == null) {
                        qName3 = this.dom.getWsdlMessage((MethodParamPartsMapping)object2);
                    }
                    arrayList.add(object2);
                }
                object2 = new ArrayList();
                object = new ArrayList();
                for (n = 0; n < arrayList.size(); ++n) {
                    ((ArrayList)object2).add(null);
                    ((ArrayList)object).add(null);
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    methodParamPartsMapping = (MethodParamPartsMapping)arrayList.get(n);
                    int n2 = this.dom.getParamPosition(methodParamPartsMapping);
                    if (n2 < 0) continue;
                    ((ArrayList)object2).set(n2, this.dom.getWsdlParam(methodParamPartsMapping));
                    ((ArrayList)object).set(n2, this.dom.getParamMode(methodParamPartsMapping));
                }
                String string2 = null;
                methodParamPartsMapping = this.dom.getWSDLReturnValueMapping(serviceEndpointMethodMapping);
                if (methodParamPartsMapping != null) {
                    string2 = this.dom.getWsdlParam((WSDLReturnValueMapping)methodParamPartsMapping);
                    if (qName3 == null) {
                        qName3 = this.dom.getWsdlMessage((WSDLReturnValueMapping)methodParamPartsMapping);
                    }
                }
                MetaOperationKey metaOperationKey = new MetaOperationKey(qName, string, qName2, qName3);
                MetaOperationValue metaOperationValue = new MetaOperationValue((ArrayList)object2, (ArrayList)object, string2, this.dom.getWrappedElement(serviceEndpointMethodMapping));
                metaInfo.getOperationMap().put(metaOperationKey, metaOperationValue);
            }
        }
    }

    public void postSymbolTable(SymbolTable symbolTable) {
        Iterator iterator = this.dom.getJavaXmlTypeMappings();
        while (iterator.hasNext()) {
            this.processJavaXmlTypeMapping((JavaXMLTypeMapping)iterator.next(), symbolTable);
        }
        iterator = this.dom.getExceptionMappings();
        while (iterator.hasNext()) {
            this.processExceptionMapping((ExceptionMapping)iterator.next(), symbolTable);
        }
        iterator = this.dom.getServiceEndpointInterfaceMappings();
        while (iterator.hasNext()) {
            this.processServiceEndpointInterfaceMapping((ServiceEndpointInterfaceMapping)iterator.next(), symbolTable);
        }
        iterator = this.dom.getServiceInterfaceMappings();
        while (iterator.hasNext()) {
            this.processServiceInterfaceMapping((ServiceInterfaceMapping)iterator.next(), symbolTable);
        }
    }

    public void fromSymbolTable(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        int n = 0;
        int n2 = 0;
        BindingEntry bindingEntry = null;
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (!symTabEntry.isReferenced()) continue;
                if (symTabEntry instanceof TypeEntry) {
                    this.fromTypeEntry((TypeEntry)symTabEntry, symbolTable);
                    continue;
                }
                if (symTabEntry instanceof MessageEntry) {
                    this.fromMessageEntry((MessageEntry)symTabEntry, symbolTable);
                    continue;
                }
                if (symTabEntry instanceof BindingEntry) {
                    this.fromBindingEntry((BindingEntry)symTabEntry, symbolTable);
                    bindingEntry = (BindingEntry)symTabEntry;
                    ++n;
                    continue;
                }
                if (!(symTabEntry instanceof ServiceEntry)) continue;
                this.fromServiceEntry((ServiceEntry)symTabEntry, symbolTable);
                ++n2;
            }
        }
        if (bindingEntry != null) {
            while (n < n2) {
                ++n;
                this.fromBindingEntry(bindingEntry, symbolTable);
            }
        }
    }

    private void setJavaName(SymbolTable symbolTable, Entry entry, String string) {
        if (entry.getDynamicVar("oldName") == null) {
            TypeEntry typeEntry;
            entry.setDynamicVar("oldName", entry.getName());
            if (entry instanceof TypeEntry && (typeEntry = (TypeEntry)entry).getRefType() == null && typeEntry.isBaseType()) {
                Type type = null;
                if (string.equals("javax.xml.soap.SOAPElement") || string.equals("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement")) {
                    type = symbolTable.getType(Constants.WEBSERVICES_SOAPELEMENT);
                    if (type == null) {
                        type = new DefinedType(Constants.WEBSERVICES_SOAPELEMENT, null);
                        type.setName("java.xml.soap.SOAPElement");
                        symbolTable.addTypeEntry(type);
                    }
                } else if (string.equals("org.w3c.dom.Element") && (type = symbolTable.getType(Constants.SOAP_ELEMENT)) == null) {
                    type = new DefinedType(Constants.SOAP_ELEMENT, null);
                    type.setName("org.w3c.dom.Element");
                    symbolTable.addTypeEntry(type);
                }
                if (type != null && type != typeEntry) {
                    typeEntry.setRefType(type, null);
                }
            }
        }
        entry.setName(string);
    }

    private void processJavaXmlTypeMapping(JavaXMLTypeMapping javaXMLTypeMapping, SymbolTable symbolTable) {
        Object object;
        Object object2;
        TypeEntry typeEntry = "element".equalsIgnoreCase(this.dom.getQNameScope(javaXMLTypeMapping)) ? symbolTable.getElement(this.dom.getRootTypeQName(javaXMLTypeMapping)) : symbolTable.getType(this.dom.getRootTypeQName(javaXMLTypeMapping));
        if (typeEntry == null) {
            return;
        }
        this.setJavaName(symbolTable, typeEntry, this.dom.getClassType(javaXMLTypeMapping));
        TypeEntry typeEntry2 = typeEntry.getRefType();
        while (typeEntry2 != null) {
            if (typeEntry2.isCollectionTypeEntry() || typeEntry2 instanceof Type && ((Type)typeEntry2).isAnonType()) {
                object2 = typeEntry.getName();
                object = typeEntry2.getName();
                int n = ((String)object2).indexOf(91);
                int n2 = ((String)object).indexOf(91);
                object = n < 0 ? object2 : (n2 >= 0 ? ((String)object2).substring(0, n) + ((String)object).substring(n2) : ((String)object2).substring(0, n));
                this.setJavaName(symbolTable, typeEntry2, (String)object);
                typeEntry2 = typeEntry2.getRefType();
                continue;
            }
            typeEntry2 = null;
        }
        object2 = this.dom.getVariableMappings(javaXMLTypeMapping);
        if (object2.hasNext()) {
            object = null;
            typeEntry2 = typeEntry;
            while (typeEntry2 != null && object == null) {
                if (typeEntry2 instanceof Type && ((Type)typeEntry2).getChildren() != null) {
                    object = ((Type)typeEntry2).getChildren();
                    continue;
                }
                typeEntry2 = typeEntry2.getRefType();
            }
            if (object != null) {
                while (object2.hasNext()) {
                    VariableMapping variableMapping = (VariableMapping)object2.next();
                    Entry entry = null;
                    for (int i = 0; i < ((Vector)object).size() && entry == null; ++i) {
                        ChildEntry childEntry = (ChildEntry)((Vector)object).elementAt(i);
                        if (childEntry instanceof ChildEnumValueEntry && ((ChildEnumValueEntry)childEntry).getEnumValue().equals(this.dom.getXmlElementName(variableMapping))) {
                            entry = childEntry;
                            continue;
                        }
                        if (childEntry.getQName() == null || !childEntry.getQName().getLocalPart().equals(this.dom.getXmlElementName(variableMapping))) continue;
                        entry = childEntry;
                    }
                    if (entry == null) continue;
                    this.setJavaName(symbolTable, entry, this.dom.getJavaVariableName(variableMapping));
                    if (!this.dom.getDataMember(variableMapping)) continue;
                    entry.setDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER, Boolean.TRUE);
                }
            }
        }
    }

    private void processExceptionMapping(ExceptionMapping exceptionMapping, SymbolTable symbolTable) {
        QName qName = this.dom.getWsdlMessage(exceptionMapping);
        SymTabEntry symTabEntry = symbolTable.getElement(qName);
        if (symTabEntry == null && (symTabEntry = symbolTable.getType(qName)) == null) {
            symTabEntry = symbolTable.getMessageEntry(qName);
        }
        this.setJavaName(symbolTable, symTabEntry, this.dom.getExceptionType(exceptionMapping));
        if (symTabEntry instanceof Element) {
            symTabEntry = ((TypeEntry)symTabEntry).getRefType();
            this.setJavaName(symbolTable, symTabEntry, this.dom.getExceptionType(exceptionMapping));
        }
        symTabEntry.setDynamicVar("constructorOrder", this.dom.getConstructorParameterOrder(exceptionMapping));
    }

    private void processServiceEndpointInterfaceMapping(ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping, SymbolTable symbolTable) {
        QName qName = this.dom.getWsdlBinding(serviceEndpointInterfaceMapping);
        BindingEntry bindingEntry = symbolTable.getBindingEntry(qName);
        if (bindingEntry == null) {
            return;
        }
        bindingEntry.setDynamicVar(JavaGeneratorFactory.INTERFACE_NAME, this.dom.getServiceEndpointInterface(serviceEndpointInterfaceMapping));
        Iterator iterator = this.dom.getServiceEndpointMethodMappings(serviceEndpointInterfaceMapping);
        while (iterator.hasNext()) {
            ServiceEndpointMethodMapping serviceEndpointMethodMapping = (ServiceEndpointMethodMapping)iterator.next();
            String string = this.dom.getJavaMethodName(serviceEndpointMethodMapping);
            BindingOperationEntry bindingOperationEntry = this.getBindingOperationEntry(serviceEndpointMethodMapping, bindingEntry);
            if (bindingOperationEntry == null) continue;
            this.setJavaName(symbolTable, bindingOperationEntry, string);
            WSDLReturnValueMapping wSDLReturnValueMapping = this.dom.getWSDLReturnValueMapping(serviceEndpointMethodMapping);
            if (wSDLReturnValueMapping != null && bindingOperationEntry.getReturn() != null) {
                bindingOperationEntry.getReturn().setDynamicVar("parameterType", this.dom.getMethodReturnValue(wSDLReturnValueMapping));
            }
            Iterator iterator2 = this.dom.getMethodParamPartsMappings(serviceEndpointMethodMapping);
            while (iterator2.hasNext()) {
                MethodParamPartsMapping methodParamPartsMapping = (MethodParamPartsMapping)iterator2.next();
                int n = this.dom.getParamPosition(methodParamPartsMapping);
                bindingOperationEntry.getParameter(n).setDynamicVar("parameterType", this.dom.getParamType(methodParamPartsMapping));
            }
        }
    }

    private BindingOperationEntry getBindingOperationEntry(ServiceEndpointMethodMapping serviceEndpointMethodMapping, BindingEntry bindingEntry) {
        QName qName;
        Operation operation;
        BindingOperationEntry bindingOperationEntry;
        Object object;
        MethodParamPartsMapping methodParamPartsMapping;
        String string = this.dom.getWsdlOperation(serviceEndpointMethodMapping);
        QName qName2 = null;
        QName qName3 = null;
        Iterator iterator = this.dom.getMethodParamPartsMappings(serviceEndpointMethodMapping);
        while (iterator.hasNext()) {
            methodParamPartsMapping = (MethodParamPartsMapping)iterator.next();
            object = this.dom.getParamMode(methodParamPartsMapping);
            if (("IN".equalsIgnoreCase((String)object) || "INOUT".equalsIgnoreCase((String)object)) && qName3 == null) {
                qName3 = this.dom.getWsdlMessage(methodParamPartsMapping);
            }
            if (!"OUT".equalsIgnoreCase((String)object) || qName2 != null) continue;
            qName2 = this.dom.getWsdlMessage(methodParamPartsMapping);
        }
        methodParamPartsMapping = this.dom.getWSDLReturnValueMapping(serviceEndpointMethodMapping);
        if (methodParamPartsMapping != null && qName2 == null) {
            qName2 = this.dom.getWsdlMessage((WSDLReturnValueMapping)methodParamPartsMapping);
        }
        object = bindingEntry.getOperations();
        while (object.hasNext()) {
            bindingOperationEntry = (BindingOperationEntry)object.next();
            operation = bindingOperationEntry.getBindingOperation().getOperation();
            qName = null;
            if (operation.getInput() != null && operation.getInput().getMessage() != null && operation.getInput().getMessage().getParts() != null && operation.getInput().getMessage().getParts().values().size() != 0) {
                qName = operation.getInput().getMessage().getQName();
            }
            QName qName4 = null;
            if (operation.getOutput() != null && operation.getOutput().getMessage() != null) {
                qName4 = operation.getOutput().getMessage().getQName();
            }
            if (!string.equals(bindingOperationEntry.getQName().getLocalPart()) || qName3 != qName && (qName3 == null || !qName3.equals(qName)) || qName2 != qName4 && (qName2 == null || !qName2.equals(qName4))) continue;
            return bindingOperationEntry;
        }
        if (qName2 == null) {
            object = bindingEntry.getOperations();
            while (object.hasNext()) {
                bindingOperationEntry = (BindingOperationEntry)object.next();
                operation = bindingOperationEntry.getBindingOperation().getOperation();
                qName = null;
                if (operation.getInput() != null && operation.getInput().getMessage() != null) {
                    qName = operation.getInput().getMessage().getQName();
                }
                if (!string.equals(bindingOperationEntry.getQName().getLocalPart()) || qName3 != qName && (qName3 == null || !qName3.equals(qName))) continue;
                return bindingOperationEntry;
            }
        }
        return null;
    }

    private void processServiceInterfaceMapping(ServiceInterfaceMapping serviceInterfaceMapping, SymbolTable symbolTable) {
        QName qName = this.dom.getWsdlServiceName(serviceInterfaceMapping);
        ServiceEntry serviceEntry = symbolTable.getServiceEntry(qName);
        if (serviceEntry == null) {
            return;
        }
        this.setJavaName(symbolTable, serviceEntry, this.dom.getServiceInterface(serviceInterfaceMapping));
        Iterator iterator = this.dom.getPortMappings(serviceInterfaceMapping);
        while (iterator.hasNext()) {
            PortMapping portMapping = (PortMapping)iterator.next();
            String string = this.dom.getPortName(portMapping);
            QName qName2 = QNameTable.createQName(serviceEntry.getQName().getNamespaceURI(), string);
            PortEntry portEntry = serviceEntry.getPort(qName2);
            if (portEntry == null) continue;
            this.setJavaName(symbolTable, portEntry, this.dom.getJavaPortName(portMapping));
        }
    }

    private void fromTypeEntry(TypeEntry typeEntry, SymbolTable symbolTable) {
        Type type;
        Vector vector;
        if (typeEntry.isOnlyWrappedLiteralReferenced()) {
            return;
        }
        Boolean bl = (Boolean)typeEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (bl != null && bl.booleanValue() && typeEntry instanceof Type) {
            this.fromFaultType((Type)typeEntry, symbolTable);
            return;
        }
        String string = "complexType";
        if (typeEntry instanceof Element) {
            string = "element";
        } else if (typeEntry instanceof Type && ((Type)typeEntry).isSimpleType()) {
            string = "simpleType";
        }
        JavaXMLTypeMapping javaXMLTypeMapping = this.dom.createJavaXmlTypeMapping(typeEntry.getName(), typeEntry.getQName(), string);
        if (typeEntry instanceof Type && (vector = (type = (Type)typeEntry).getChildren()) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ChildEntry childEntry = (ChildEntry)vector.elementAt(i);
                if (childEntry instanceof ChildEnumValueEntry) {
                    this.dom.createVariableMapping(javaXMLTypeMapping, childEntry.getName(), false, ((ChildEnumValueEntry)childEntry).getEnumValue());
                    continue;
                }
                Boolean bl2 = (Boolean)childEntry.getDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER);
                this.dom.createVariableMapping(javaXMLTypeMapping, childEntry.getName(), bl2 != null && bl2 != false, childEntry.getQName().getLocalPart());
            }
        }
    }

    private void fromMessageEntry(MessageEntry messageEntry, SymbolTable symbolTable) {
        if (!messageEntry.isFault()) {
            return;
        }
        Boolean bl = (Boolean)messageEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (bl == null || !bl.booleanValue()) {
            ArrayList arrayList = (ArrayList)messageEntry.getDynamicVar("constructorOrder");
            this.dom.createExceptionMapping(messageEntry.getName(), messageEntry.getQName(), arrayList);
        }
    }

    private void fromFaultType(Type type, SymbolTable symbolTable) {
        if (this.exceptionMappings.get(type) != null) {
            return;
        }
        this.exceptionMappings.put(type, Boolean.TRUE);
        Boolean bl = (Boolean)type.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
        if (bl != null && bl.booleanValue()) {
            ArrayList arrayList = (ArrayList)type.getDynamicVar("constructorOrder");
            this.dom.createExceptionMapping(type.getName(), type.getQName(), arrayList);
        }
    }

    private void fromBindingEntry(BindingEntry bindingEntry, SymbolTable symbolTable) {
        String string = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(bindingEntry.getBinding().getPortType().getQName());
        ServiceEndpointInterfaceMapping serviceEndpointInterfaceMapping = this.dom.createServiceEndpointInterfaceMapping(string, portTypeEntry.getQName(), bindingEntry.getQName());
        Iterator iterator = bindingEntry.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            ServiceEndpointMethodMapping serviceEndpointMethodMapping = this.dom.createServiceEndpointMethodMapping(serviceEndpointInterfaceMapping, bindingOperationEntry.getName(), bindingOperationEntry.getQName().getLocalPart(), bindingOperationEntry.isWrapped());
            BindingParamEntry bindingParamEntry = bindingOperationEntry.getReturn();
            Operation operation = bindingOperationEntry.getBindingOperation().getOperation();
            if (operation.getStyle() == OperationType.REQUEST_RESPONSE) {
                if (bindingParamEntry == null) {
                    this.dom.createWSDLReturnValueMapping(serviceEndpointMethodMapping, "void", operation.getOutput().getMessage().getQName(), null);
                } else {
                    this.dom.createWSDLReturnValueMapping(serviceEndpointMethodMapping, (String)bindingParamEntry.getDynamicVar("parameterType"), bindingParamEntry.getOutMessageEntry().getQName(), bindingParamEntry.getQName().getLocalPart());
                }
            }
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                BindingParamEntry bindingParamEntry2 = bindingOperationEntry.getParameter(i);
                MessageEntry messageEntry = bindingParamEntry2.getInMessageEntry();
                if (messageEntry == null) {
                    messageEntry = bindingParamEntry2.getOutMessageEntry();
                }
                this.dom.createMethodParamPartsMapping(serviceEndpointMethodMapping, (String)bindingParamEntry2.getDynamicVar("parameterType"), i, bindingParamEntry2.getModeString(), messageEntry.getQName(), bindingParamEntry2.getQName().getLocalPart(), false);
            }
        }
    }

    private void fromServiceEntry(ServiceEntry serviceEntry, SymbolTable symbolTable) {
        ServiceInterfaceMapping serviceInterfaceMapping = this.dom.createServiceInterfaceMapping(serviceEntry.getName(), serviceEntry.getQName());
        for (int i = 0; i < serviceEntry.numPorts(); ++i) {
            PortEntry portEntry = serviceEntry.getPort(i);
            this.dom.createPortMapping(serviceInterfaceMapping, portEntry.getQName().getLocalPart(), portEntry.getName());
        }
    }
}

