/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Operation;

public class BindingEntry
extends SymTabEntry {
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_NONSOAP = 4;
    private Binding binding;
    private int bindingType = 3;
    private Style bindingStyle = Style.DOCUMENT;
    private HashMap operations = new HashMap();

    public BindingEntry(Binding binding) {
        super(binding.getQName());
        this.binding = binding;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getBindingType() {
        return this.bindingType;
    }

    void setBindingType(int n) {
        this.bindingType = n;
    }

    public Style getBindingStyle() {
        return this.bindingStyle;
    }

    void setBindingStyle(Style style) {
        this.bindingStyle = style;
    }

    public BindingOperationEntry getOperation(Operation operation) {
        return (BindingOperationEntry)this.operations.get(operation);
    }

    void addOperation(Operation operation, BindingOperationEntry bindingOperationEntry) {
        this.operations.put(operation, bindingOperationEntry);
    }

    public Iterator getOperations() {
        return this.operations.values().iterator();
    }

    public boolean hasLiteral() {
        Iterator iterator = this.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            if (bindingOperationEntry.getInputBodyUse() != Use.LITERAL && bindingOperationEntry.getOutputBodyUse() != Use.LITERAL) continue;
            return true;
        }
        return false;
    }

    public boolean hasMIMETypes() {
        Iterator iterator = this.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            if (!bindingOperationEntry.hasMIMETypes()) continue;
            return true;
        }
        return false;
    }
}

