/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SchemaUtils {
    private static String[] schemaTypes = new String[]{"string", "normalizedString", "token", "byte", "unsignedByte", "base64Binary", "hexBinary", "integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "int", "unsignedInt", "long", "unsignedLong", "short", "unsignedShort", "decimal", "float", "double", "boolean", "time", "dateTime", "duration", "date", "gMonth", "gYear", "gYearMonth", "gDay", "gMonthDay", "Name", "QName", "NCName", "anyURI", "language", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION", "NMTOKEN", "NMTOKENS"};

    SchemaUtils() {
    }

    static Vector getContainedElementDeclarations(Node object, SymbolTable symbolTable, List list) {
        Object object2;
        Object object3;
        Object object4;
        if (object == null) {
            return null;
        }
        QName qName = Utils.getNodeQName((Node)object);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            object4 = object.getChildNodes();
            object3 = null;
            for (int i = 0; i < object4.getLength() && object3 == null; ++i) {
                object2 = Utils.getNodeQName(object4.item(i));
                if (object2 == null || !((QName)object2).getLocalPart().equals("complexType") || !Constants.isSchemaXSD(((QName)object2).getNamespaceURI())) continue;
                object = object3 = object4.item(i);
            }
        }
        if ((qName = Utils.getNodeQName((Node)object)) != null && qName.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            QName qName2;
            QName qName3;
            int n;
            object4 = object.getChildNodes();
            object3 = null;
            Node node = null;
            object2 = null;
            for (n = 0; n < object4.getLength() && object3 == null; ++n) {
                qName3 = Utils.getNodeQName(object4.item(n));
                if (qName3 == null || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                if (qName3.getLocalPart().equals("complexContent")) {
                    object3 = object4.item(n);
                    continue;
                }
                if (!qName3.getLocalPart().equals("simpleContent")) continue;
                node = object4.item(n);
            }
            if (object3 != null) {
                object4 = object3.getChildNodes();
                for (n = 0; n < object4.getLength() && object2 == null; ++n) {
                    qName3 = Utils.getNodeQName(object4.item(n));
                    if (qName3 == null || !qName3.getLocalPart().equals("extension") || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                    object2 = object4.item(n);
                }
            }
            if (node != null) {
                object4 = node.getChildNodes();
                for (n = 0; n < object4.getLength() && object2 == null; ++n) {
                    Type type;
                    qName3 = Utils.getNodeQName(object4.item(n));
                    if (qName3 == null || !qName3.getLocalPart().equals("extension") || !Constants.isSchemaXSD(qName3.getNamespaceURI()) || (type = symbolTable.getType(qName2 = Utils.getTypeQName(object4.item(n), new BooleanHolder(), false, list))) == null) continue;
                    Vector<ChildElement> vector = new Vector<ChildElement>();
                    ChildElement childElement = new ChildElement(QNameTable.createQName("", "value"), type);
                    vector.add(childElement);
                    return vector;
                }
            }
            if (object2 != null) {
                object = object2;
            }
            object4 = object.getChildNodes();
            Vector vector = new Vector();
            for (int i = 0; i < object4.getLength(); ++i) {
                qName2 = Utils.getNodeQName(object4.item(i));
                if (qName2 == null || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                if (qName2.getLocalPart().equals("sequence")) {
                    vector.addAll(SchemaUtils.processSequenceNode(object4.item(i), symbolTable, list));
                    continue;
                }
                if (qName2.getLocalPart().equals("all")) {
                    vector.addAll(SchemaUtils.processAllNode(object4.item(i), symbolTable, list));
                    continue;
                }
                if (qName2.getLocalPart().equals("choice")) {
                    vector.addAll(SchemaUtils.processChoiceNode(object4.item(i), symbolTable, list));
                    continue;
                }
                if (!qName2.getLocalPart().equals("group")) continue;
                vector.addAll(SchemaUtils.processGroupNode(object4.item(i), symbolTable, list));
            }
            return vector;
        }
        object4 = SchemaUtils.getSimpleTypeBase((Node)object, symbolTable, list);
        if (object4 != null && (object3 = symbolTable.getType((QName)object4)) != null && ((Type)object3).getExtensionBase() == null && ((Type)object3).getRestrictionBase() == null) {
            Vector<Object> vector = new Vector<Object>();
            object2 = new ChildElement(QNameTable.createQName("", "value"), (TypeEntry)object3);
            vector.add(object2);
            return vector;
        }
        return null;
    }

    private static Vector processChoiceNode(Node node, SymbolTable symbolTable, List list) {
        Vector<ChildElement> vector = new Vector<ChildElement>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ChildElement childElement;
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if (qName.getLocalPart().equals("choice")) {
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (qName.getLocalPart().equals("sequence")) {
                vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (qName.getLocalPart().equals("group")) {
                vector.addAll(SchemaUtils.processGroupNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (!qName.getLocalPart().equals("element") || (childElement = SchemaUtils.processChildElementNode(nodeList.item(i), symbolTable, list)) == null) continue;
            vector.add(childElement);
        }
        return vector;
    }

    private static Vector processSequenceNode(Node node, SymbolTable symbolTable, List list) {
        Vector<Entry> vector = new Vector<Entry>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Entry entry;
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if (qName.getLocalPart().equals("choice")) {
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (qName.getLocalPart().equals("sequence")) {
                vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (qName.getLocalPart().equals("group")) {
                vector.addAll(SchemaUtils.processGroupNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (qName.getLocalPart().equals("any")) {
                entry = symbolTable.getTypeForAnyElement();
                ChildElement childElement = new ChildElement(QNameTable.createQName("", "any"), (TypeEntry)entry);
                childElement.setAnyElement(true);
                vector.add(childElement);
                continue;
            }
            if (!qName.getLocalPart().equals("element") || (entry = SchemaUtils.processChildElementNode(nodeList.item(i), symbolTable, list)) == null) continue;
            vector.add(entry);
        }
        return vector;
    }

    private static Vector processGroupNode(Node node, SymbolTable symbolTable, List list) {
        Vector vector = new Vector();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if (qName.getLocalPart().equals("choice")) {
                vector.addAll(SchemaUtils.processChoiceNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (qName.getLocalPart().equals("sequence")) {
                vector.addAll(SchemaUtils.processSequenceNode(nodeList.item(i), symbolTable, list));
                continue;
            }
            if (!qName.getLocalPart().equals("all")) continue;
            vector.addAll(SchemaUtils.processAllNode(nodeList.item(i), symbolTable, list));
        }
        return vector;
    }

    private static Vector processAllNode(Node node, SymbolTable symbolTable, List list) {
        Vector<ChildElement> vector = new Vector<ChildElement>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ChildElement childElement;
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI()) || !qName.getLocalPart().equals("element") || (childElement = SchemaUtils.processChildElementNode(nodeList.item(i), symbolTable, list)) == null) continue;
            vector.add(childElement);
        }
        return vector;
    }

    private static ChildElement processChildElementNode(Node node, SymbolTable symbolTable, List list) {
        String string;
        Object object;
        QName qName = Utils.getNodeNameQName(node, list);
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName2 = Utils.getTypeQName(node, booleanHolder, false, list);
        TypeEntry typeEntry = symbolTable.getTypeEntry(qName2, booleanHolder.value);
        if (!booleanHolder.value) {
            object = Utils.getAttribute(node, "form");
            if (object != null && ((String)object).equals("unqualified")) {
                qName = QNameTable.createQName("", qName.getLocalPart());
            } else if (object == null && ((string = Utils.getScopedAttribute(node, "elementFormDefault", list)) == null || string.equals("unqualified"))) {
                qName = QNameTable.createQName("", qName.getLocalPart());
            }
        }
        if (typeEntry != null) {
            object = new ChildElement(qName, typeEntry);
            string = Utils.getAttribute(node, "minOccurs");
            if (string != null && string.equals("0")) {
                ((ChildElement)object).setMinOccursIs0(true);
            }
            return object;
        }
        return null;
    }

    static QName getElementAnonQName(Node node, List list) {
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !qName2.getLocalPart().equals("complexType") && !qName2.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                return Utils.getNodeNameQName(nodeList.item(i), list);
            }
        }
        return null;
    }

    static QName getAttributeAnonQName(Node node, List list) {
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("attribute") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !qName2.getLocalPart().equals("complexType") && !qName2.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                return Utils.getNodeNameQName(nodeList.item(i), list);
            }
        }
        return null;
    }

    static boolean isSimpleTypeOrSimpleContent(Node node, List list) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return false;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 != null && qName2.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
                    node = node2 = nodeList.item(i);
                }
                if (qName2 == null || !qName2.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                return true;
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && qName.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return true;
        }
        if (qName != null && qName.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            Node node3 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName3 = Utils.getNodeQName(nodeList.item(i));
                if (qName3 == null || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                if (qName3.getLocalPart().equals("complexContent")) {
                    node2 = nodeList.item(i);
                    continue;
                }
                if (!qName3.getLocalPart().equals("simpleContent")) continue;
                node3 = nodeList.item(i);
            }
            if (node2 != null) {
                return false;
            }
            if (node3 != null) {
                return true;
            }
        }
        return false;
    }

    static Type getComplexElementExtensionBase(Node node, SymbolTable symbolTable, List list) {
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !qName2.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                node = node2 = nodeList.item(i);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && qName.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            QName qName3;
            int n;
            nodeList = node.getChildNodes();
            node2 = null;
            Node node3 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName3 = Utils.getNodeQName(nodeList.item(n));
                if (qName3 != null && qName3.getLocalPart().equals("complexContent") && Constants.isSchemaXSD(qName3.getNamespaceURI())) {
                    node2 = nodeList.item(n);
                }
                if (qName3 == null || !qName3.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node3 == null; ++n) {
                    qName3 = Utils.getNodeQName(nodeList.item(n));
                    if (qName3 == null || !qName3.getLocalPart().equals("extension") || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                    node3 = nodeList.item(n);
                }
            }
            if (node3 == null) {
                return null;
            }
            QName qName4 = Utils.getTypeQName(node3, new BooleanHolder(), false, list);
            if (qName4 == null) {
                return null;
            }
            return symbolTable.getType(qName4);
        }
        return null;
    }

    static QName getSimpleTypeBase(Node node, SymbolTable symbolTable, List list) {
        QName qName;
        int n;
        Node node2;
        NodeList nodeList;
        QName qName2 = null;
        if (node == null || SchemaUtils.getEnumerationBaseAndValues(node, symbolTable, list) != null) {
            return null;
        }
        QName qName3 = Utils.getNodeQName(node);
        if (qName3 != null && qName3.getLocalPart().equals("element") && Constants.isSchemaXSD(qName3.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !qName.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName3 = Utils.getNodeQName(node)) != null && qName3.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(qName3.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !qName.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            if (node2 != null) {
                qName2 = Utils.getTypeQName(node2, new BooleanHolder(), false, list);
            }
        }
        return qName2;
    }

    static Node getRestrictionOrExtensionNode(Node node) {
        QName qName;
        int n;
        Node node2;
        NodeList nodeList;
        Node node3 = null;
        if (node == null) {
            return node3;
        }
        QName qName2 = Utils.getNodeQName(node);
        if (qName2 != null && qName2.getLocalPart().equals("element") && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !qName.getLocalPart().equals("simpleType") && !qName.getLocalPart().equals("complexType") && !qName.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName2 = Utils.getNodeQName(node)) != null && (qName2.getLocalPart().equals("simpleType") || qName2.getLocalPart().equals("complexType")) && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            if (qName2.getLocalPart().equals("complexType")) {
                for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                    qName = Utils.getNodeQName(nodeList.item(n));
                    if (qName == null || !qName.getLocalPart().equals("complexContent") && !qName.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                    node2 = nodeList.item(n);
                }
                node = node2;
            }
            if (node != null) {
                nodeList = node.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node3 == null; ++n) {
                    qName = Utils.getNodeQName(nodeList.item(n));
                    if (qName == null || !qName.getLocalPart().equals("extension") && !qName.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                    node3 = nodeList.item(n);
                }
            }
        }
        return node3;
    }

    static QName getArrayComponentQName(Node node, IntHolder intHolder, List list) {
        intHolder.value = 1;
        QName qName = SchemaUtils.getCollectionComponentQName(node, list);
        if (qName == null) {
            qName = SchemaUtils.getArrayComponentQName_JAXRPC(node, intHolder, list);
        }
        return qName;
    }

    private static QName getCollectionComponentQName(Node node, List list) {
        QName qName;
        BooleanHolder booleanHolder;
        QName qName2;
        if (node == null) {
            return null;
        }
        QName qName3 = Utils.getNodeQName(node);
        if (qName3 != null && qName3.getLocalPart().equals("element") && Constants.isSchemaXSD(qName3.getNamespaceURI()) && (qName2 = Utils.getTypeQName(node, booleanHolder = new BooleanHolder(), true, list)) != null && !qName2.equals(qName = Utils.getTypeQName(node, booleanHolder, false, list))) {
            return qName2;
        }
        return null;
    }

    private static QName getArrayComponentQName_JAXRPC(Node node, IntHolder intHolder, List list) {
        QName qName;
        int n;
        Node node2;
        NodeList nodeList;
        intHolder.value = 0;
        if (node == null) {
            return null;
        }
        QName qName2 = Utils.getNodeQName(node);
        if (qName2 != null && qName2.getLocalPart().equals("element") && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !qName.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName2 = Utils.getNodeQName(node)) != null && qName2.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            Object object;
            Object object2;
            Object object3;
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                qName = Utils.getNodeQName(nodeList.item(n));
                if (qName == null || !qName.getLocalPart().equals("complexContent") && !qName.getLocalPart().equals("simpleContent") || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            Node node3 = null;
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (int i = 0; i < nodeList.getLength() && node3 == null; ++i) {
                    object3 = Utils.getNodeQName(nodeList.item(i));
                    if (object3 == null || !((QName)object3).getLocalPart().equals("restriction") || !Constants.isSchemaXSD(((QName)object3).getNamespaceURI())) continue;
                    node3 = nodeList.item(i);
                }
            }
            QName qName3 = null;
            if (!(node3 == null || (qName3 = Utils.getTypeQName(node3, new BooleanHolder(), false, list)) != null && qName3.getLocalPart().equals("Array") && Constants.isSOAP_ENC(qName3.getNamespaceURI()))) {
                qName3 = null;
            }
            object3 = null;
            Node node4 = null;
            if (qName3 != null) {
                nodeList = node3.getChildNodes();
                for (int i = 0; i < nodeList.getLength() && object3 == null && node4 == null; ++i) {
                    object2 = Utils.getNodeQName(nodeList.item(i));
                    if (object2 != null && (((QName)object2).getLocalPart().equals("sequence") || ((QName)object2).getLocalPart().equals("all")) && Constants.isSchemaXSD(((QName)object2).getNamespaceURI()) && (object3 = nodeList.item(i)).getChildNodes().getLength() == 0) {
                        object3 = null;
                    }
                    if (object2 == null || !((QName)object2).getLocalPart().equals("attribute") || !Constants.isSchemaXSD(((QName)object2).getNamespaceURI())) continue;
                    BooleanHolder booleanHolder = new BooleanHolder();
                    object = Utils.getTypeQName(nodeList.item(i), booleanHolder, false, list);
                    if (object == null || !booleanHolder.value || !((QName)object).getLocalPart().equals("arrayType") || !Constants.isSOAP_ENC(((QName)object).getNamespaceURI())) continue;
                    node4 = nodeList.item(i);
                }
            }
            if (node4 != null) {
                String string;
                int n2;
                String string2 = null;
                object2 = Utils.getAttributesWithLocalName(node4, "arrayType");
                for (n2 = 0; n2 < ((Vector)object2).size() && string2 == null; ++n2) {
                    object = (Node)((Vector)object2).elementAt(n2);
                    string = object.getNodeName();
                    QName qName4 = Utils.getQNameFromPrefixedName(node4, string, list);
                    if (!Constants.isWSDL(qName4.getNamespaceURI())) continue;
                    string2 = object.getNodeValue();
                }
                if (string2 != null && (n2 = string2.indexOf(91)) > 0) {
                    object = string2.substring(0, n2);
                    string = string2.replace(',', '[');
                    intHolder.value = 0;
                    int n3 = string.indexOf(91);
                    while (n3 > 0) {
                        ++intHolder.value;
                        n3 = string.indexOf(91, n3 + 1);
                    }
                    return Utils.getQNameFromPrefixedName(node3, (String)object, list);
                }
            } else if (object3 != null) {
                String string;
                NodeList nodeList2 = object3.getChildNodes();
                object2 = null;
                for (int i = 0; i < nodeList2.getLength() && object2 == null; ++i) {
                    object = Utils.getNodeQName(nodeList2.item(i));
                    if (object == null || !((QName)object).getLocalPart().equals("element") || !Constants.isSchemaXSD(((QName)object).getNamespaceURI())) continue;
                    object2 = nodeList2.item(i);
                }
                if (object2 != null && (string = Utils.getAttribute((Node)object2, "maxOccurs")) != null && string.equalsIgnoreCase("unbounded")) {
                    intHolder.value = 1;
                    return Utils.getTypeQName((Node)object2, new BooleanHolder(), true, list);
                }
            }
        }
        return null;
    }

    static Vector getContainedAttributeTypes(Node node, SymbolTable symbolTable, List list) {
        Node node2;
        NodeList nodeList;
        Vector<ChildAttribute> vector = null;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (int i = 0; i < nodeList.getLength() && node2 == null; ++i) {
                QName qName2 = Utils.getNodeQName(nodeList.item(i));
                if (qName2 == null || !qName2.getLocalPart().equals("complexType") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                node = node2 = nodeList.item(i);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && qName.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            Object object;
            int n;
            nodeList = node.getChildNodes();
            node2 = null;
            Node node3 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                object = Utils.getNodeQName(nodeList.item(n));
                if (object == null || !Constants.isSchemaXSD(((QName)object).getNamespaceURI()) || !((QName)object).getLocalPart().equals("complexContent") && !((QName)object).getLocalPart().equals("simpleContent")) continue;
                node2 = nodeList.item(n);
            }
            if (node2 != null) {
                nodeList = node2.getChildNodes();
                for (n = 0; n < nodeList.getLength(); ++n) {
                    object = Utils.getNodeQName(nodeList.item(n));
                    if (object == null || !((QName)object).getLocalPart().equals("extension") || !Constants.isSchemaXSD(((QName)object).getNamespaceURI())) continue;
                    node3 = nodeList.item(n);
                    break;
                }
            }
            if (node3 != null) {
                node = node3;
            }
            nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = nodeList.item(n);
                qName = Utils.getNodeQName((Node)object);
                if (qName == null) continue;
                if (qName.getLocalPart().equals("attribute")) {
                    if (vector == null) {
                        vector = new Vector<ChildAttribute>();
                    }
                    SchemaUtils.addChildAttribute(vector, (Node)object, list, symbolTable);
                    continue;
                }
                if (!qName.getLocalPart().equals("anyAttribute")) continue;
                if (vector == null) {
                    vector = new Vector();
                }
                try {
                    vector.add(new ChildAttribute(QNameTable.createQName("", "anyAttribute"), symbolTable.getSOAPElementType()));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return vector;
    }

    private static void addChildAttribute(Vector vector, Node node, List list, SymbolTable symbolTable) {
        Object object;
        QName qName = Utils.getNodeNameQName(node, list);
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName2 = Utils.getTypeQName(node, booleanHolder, false, list);
        if (!booleanHolder.value) {
            String string;
            object = Utils.getAttribute(node, "form");
            if (object != null && ((String)object).equals("unqualified")) {
                qName = QNameTable.createQName("", qName.getLocalPart());
            } else if (object == null && ((string = Utils.getScopedAttribute(node, "attributeFormDefault", list)) == null || string.equals("unqualified"))) {
                qName = QNameTable.createQName("", qName.getLocalPart());
            }
        } else {
            qName = qName2;
        }
        object = symbolTable.getTypeEntry(qName2, booleanHolder.value);
        if (object != null && qName != null) {
            vector.add(new ChildAttribute(qName, (TypeEntry)object));
        }
    }

    static Vector getEnumerationBaseAndValues(Node node, SymbolTable symbolTable, List list) {
        Serializable serializable;
        int n;
        Node node2;
        NodeList nodeList;
        if (node == null) {
            return null;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                serializable = Utils.getNodeQName(nodeList.item(n));
                if (serializable == null || !serializable.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(serializable.getNamespaceURI())) continue;
                node = node2 = nodeList.item(n);
            }
        }
        if ((qName = Utils.getNodeQName(node)) != null && qName.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            nodeList = node.getChildNodes();
            node2 = null;
            for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                serializable = Utils.getNodeQName(nodeList.item(n));
                if (serializable == null || !serializable.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(serializable.getNamespaceURI())) continue;
                node2 = nodeList.item(n);
            }
            Type type = null;
            if (node2 != null && (type = symbolTable.getType((QName)(serializable = Utils.getTypeQName(node2, new BooleanHolder(), false, list)))) != null && (Constants.equals(serializable, Constants.XSD_BOOLEAN) || Constants.equals(serializable, Constants.SOAP_BOOLEAN) || Constants.equals(serializable, Constants.XSD_QNAME) || Constants.equals(serializable, Constants.XSD_DATETIME) || Constants.equals(serializable, Constants.XSD_BASE64) || Constants.equals(serializable, Constants.XSD_HEXBIN) || !SchemaUtils.isSimpleSchemaType(type.getQName()))) {
                type = null;
            }
            if (type != null && node2 != null) {
                serializable = null;
                NodeList nodeList2 = node2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    Node node3;
                    String string;
                    QName qName2 = Utils.getNodeQName(nodeList2.item(i));
                    if (qName2 == null || !qName2.getLocalPart().equals("enumeration") || !Constants.isSchemaXSD(qName2.getNamespaceURI()) || (string = Utils.getAttribute(node3 = nodeList2.item(i), "value")) == null) continue;
                    if (serializable == null) {
                        serializable = new Vector();
                    }
                    ((Vector)serializable).add(new ChildEnumValueEntry(type, string));
                }
                return serializable;
            }
        }
        return null;
    }

    static boolean isNotMappable(Node object, SymbolTable symbolTable, List list) {
        Object object2;
        Object object3;
        Object object4;
        if (SchemaUtils.getArrayComponentQName_JAXRPC((Node)object, new IntHolder(), list) != null) {
            return false;
        }
        if (SchemaUtils.getEnumerationBaseAndValues((Node)object, symbolTable, list) != null) {
            return false;
        }
        QName qName = Utils.getNodeQName((Node)object);
        if (qName != null && qName.getLocalPart().equals("element") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            object4 = object.getChildNodes();
            object3 = null;
            for (int i = 0; i < object4.getLength() && object3 == null; ++i) {
                object2 = Utils.getNodeQName(object4.item(i));
                if (object2 == null || !((QName)object2).getLocalPart().equals("complexType") || !Constants.isSchemaXSD(((QName)object2).getNamespaceURI())) continue;
                object = object3 = object4.item(i);
            }
        }
        if ((qName = Utils.getNodeQName((Node)object)) != null && qName.getLocalPart().equals("complexType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            QName qName2;
            int n;
            object4 = Utils.getAttribute((Node)object, "maxOccurs");
            if (object4 != null && !((String)object4).equals("1")) {
                return true;
            }
            object3 = Utils.getAttribute((Node)object, "mixed");
            if (object3 != null && !((String)object3).equals("false")) {
                return true;
            }
            NodeList nodeList = object.getChildNodes();
            object2 = null;
            Node node = null;
            Node node2 = null;
            for (n = 0; n < nodeList.getLength() && object2 == null; ++n) {
                qName2 = Utils.getNodeQName(nodeList.item(n));
                if (qName2 == null || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                if (qName2.getLocalPart().equals("complexContent")) {
                    object2 = nodeList.item(n);
                    continue;
                }
                if (!qName2.getLocalPart().equals("simpleContent")) continue;
                node = nodeList.item(n);
            }
            if (object2 != null) {
                nodeList = object2.getChildNodes();
                for (n = 0; n < nodeList.getLength() && node2 == null; ++n) {
                    qName2 = Utils.getNodeQName(nodeList.item(n));
                    if (qName2 != null && qName2.getLocalPart().equals("extension") && Constants.isSchemaXSD(qName2.getNamespaceURI())) {
                        node2 = nodeList.item(n);
                    }
                    if (qName2 == null || !qName2.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(qName2.getNamespaceURI())) continue;
                    return true;
                }
            }
            if (node != null) {
                return false;
            }
            if (node2 != null) {
                object = node2;
            }
            nodeList = object.getChildNodes();
            return SchemaUtils.childrenNotMappable(nodeList);
        }
        if (qName != null && qName.getLocalPart().equals("simpleType") && Constants.isSchemaXSD(qName.getNamespaceURI())) {
            QName qName3;
            int n;
            object4 = Utils.getAttribute((Node)object, "maxOccurs");
            if (object4 != null && !((String)object4).equals("1")) {
                return true;
            }
            object3 = object.getChildNodes();
            Node node = null;
            for (n = 0; n < object3.getLength() && node == null; ++n) {
                qName3 = Utils.getNodeQName(object3.item(n));
                if (qName3 == null || !qName3.getLocalPart().equals("restriction") || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                node = object3.item(n);
            }
            if (node == null) {
                return true;
            }
            object3 = node.getChildNodes();
            for (n = 0; n < object3.getLength(); ++n) {
                qName3 = Utils.getNodeQName(object3.item(n));
                if (qName3 == null || !qName3.getLocalPart().equals("simpleType") || !Constants.isSchemaXSD(qName3.getNamespaceURI())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean childrenNotMappable(NodeList nodeList) {
        boolean bl = false;
        String string = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            QName qName = Utils.getNodeQName(nodeList.item(i));
            if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) continue;
            if (qName.getLocalPart().equals("sequence")) {
                if (bl) {
                    return true;
                }
                bl = true;
                string = Utils.getAttribute(nodeList.item(i), "maxOccurs");
                if (string != null && !string.equals("1")) {
                    return true;
                }
                if (!SchemaUtils.childrenNotMappable(nodeList.item(i).getChildNodes())) continue;
                return true;
            }
            if (qName.getLocalPart().equals("all")) {
                if (bl) {
                    return true;
                }
                bl = true;
                string = Utils.getAttribute(nodeList.item(i), "maxOccurs");
                if (string != null && !string.equals("1")) {
                    return true;
                }
                if (!SchemaUtils.childrenNotMappable(nodeList.item(i).getChildNodes())) continue;
                return true;
            }
            if (qName.getLocalPart().equals("choice")) {
                return true;
            }
            if (qName.getLocalPart().equals("group")) {
                return true;
            }
            if (!qName.getLocalPart().equals("anyAttribute")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSimpleSchemaType(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < schemaTypes.length; ++i) {
            if (!schemaTypes[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    static boolean isSimpleSchemaType(QName qName) {
        if (qName == null || !Constants.isSchemaXSD(qName.getNamespaceURI())) {
            return false;
        }
        return SchemaUtils.isSimpleSchemaType(qName.getLocalPart());
    }
}

