/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.URLHashSet;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.multiprotocol.discovery.ServiceProviderManager;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedElement;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaInfo;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationKey;
import com.ibm.ws.webservices.wsdl.symbolTable.MetaOperationValue;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SchemaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Undefined;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedElement;
import com.ibm.ws.webservices.wsdl.symbolTable.UndefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.http.HTTPBinding;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.holders.BooleanHolder;
import javax.xml.rpc.holders.IntHolder;
import javax.xml.rpc.holders.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SymbolTable {
    private boolean addImports;
    private HashMap symbolTable = new HashMap();
    private Vector types = new Vector();
    private boolean verbose;
    private BaseTypeMapping btm = null;
    public static final String ANON_TOKEN = ">";
    private Definition def = null;
    private String wsdlURI = null;
    private WSDLReader reader;
    private MetaInfo metaInfo;
    private ToolEnv env;
    private URLHashSet importedFiles = new URLHashSet();
    private static final int ABOVE_SCHEMA_LEVEL = -1;
    private static final int SCHEMA_LEVEL = 0;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$MessageEntry;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$PortTypeEntry;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$BindingEntry;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$ServiceEntry;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedElement;

    public SymbolTable(ToolEnv toolEnv, MetaInfo metaInfo, boolean bl, boolean bl2) {
        this.env = toolEnv;
        this.btm = metaInfo.getBaseTypeMapping();
        this.addImports = bl;
        this.verbose = bl2;
        this.metaInfo = metaInfo;
    }

    public HashMap getHashMap() {
        return this.symbolTable;
    }

    public Vector getSymbols(QName qName) {
        return (Vector)this.symbolTable.get(qName);
    }

    public SymTabEntry get(QName qName, Class clazz) {
        Vector vector = (Vector)this.symbolTable.get(qName);
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
            if (!clazz.isInstance(symTabEntry)) continue;
            return symTabEntry;
        }
        return null;
    }

    public TypeEntry getTypeEntry(QName qName, boolean bl) {
        if (bl) {
            return this.getElement(qName);
        }
        return this.getType(qName);
    }

    public Type getType(QName qName) {
        Vector vector = this.getSymbols(qName);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (!symTabEntry.getQName().equals(qName) || !(symTabEntry instanceof Type)) continue;
                return (Type)symTabEntry;
            }
        }
        return null;
    }

    Type getSOAPElementType() throws IOException {
        Type type = this.getType(Constants.WEBSERVICES_SOAPELEMENT);
        if (type == null) {
            type = new DefinedType(Constants.WEBSERVICES_SOAPELEMENT);
            this.symbolTablePut(type);
        }
        return type;
    }

    public Type getTypeForAnyElement() {
        Type type = this.getType(Constants.XSD_ANY);
        try {
            if (type == null) {
                Type type2 = this.getSOAPElementType();
                type = new DefinedType(Constants.XSD_ANY);
                type.setRefType(type2, "[]");
                this.symbolTablePut(type);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable.getTypeForAnyElement", (String)"316", (Object)this);
            throw new InternalException(iOException);
        }
        return type;
    }

    public Element getElement(QName qName) {
        Vector vector = this.getSymbols(qName);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.get(i);
                if (!symTabEntry.getQName().equals(qName) || !(symTabEntry instanceof Element)) continue;
                return (Element)symTabEntry;
            }
        }
        return null;
    }

    public MessageEntry getMessageEntry(QName qName) {
        return (MessageEntry)this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$MessageEntry == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$MessageEntry = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry")) : class$com$ibm$ws$webservices$wsdl$symbolTable$MessageEntry);
    }

    public PortTypeEntry getPortTypeEntry(QName qName) {
        return (PortTypeEntry)this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$PortTypeEntry == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$PortTypeEntry = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry")) : class$com$ibm$ws$webservices$wsdl$symbolTable$PortTypeEntry);
    }

    public BindingEntry getBindingEntry(QName qName) {
        return (BindingEntry)this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$BindingEntry == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$BindingEntry = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry")) : class$com$ibm$ws$webservices$wsdl$symbolTable$BindingEntry);
    }

    public ServiceEntry getServiceEntry(QName qName) {
        return (ServiceEntry)this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$ServiceEntry == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$ServiceEntry = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry")) : class$com$ibm$ws$webservices$wsdl$symbolTable$ServiceEntry);
    }

    public Vector getTypes() {
        return this.types;
    }

    public Definition getDefinition() {
        return this.def;
    }

    public String getWSDLURI() {
        return this.wsdlURI;
    }

    public void dump(PrintStream printStream) {
        printStream.println();
        printStream.println(Messages.getMessage("symbolTable00"));
        printStream.println("-----------------------");
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                printStream.println(vector.elementAt(i).getClass().getName());
                printStream.println(vector.elementAt(i));
            }
        }
        printStream.println("-----------------------");
    }

    public void populate(String string) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        this.populate(string, null, null);
    }

    public void populate(String string, String string2, String string3) throws IOException, WSDLException, SAXException, ParserConfigurationException {
        if (this.verbose) {
            this.env.report(Messages.getMessage("parsing00", string));
        }
        Document document = XMLUtils.newDocument(string, string2, string3);
        this.wsdlURI = string;
        try {
            string = new URL(string).toString();
        }
        catch (MalformedURLException malformedURLException) {
            FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.webservices.engine.wsdl.symbolTable.SymbolTable.populate", (String)"366", (Object)this);
        }
        this.populate(string, document);
    }

    public void populate(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        ServiceProviderManager serviceProviderManager = new ServiceProviderManager(null);
        this.reader = serviceProviderManager.getWSDLFactory().newWSDLReader();
        this.reader.setFeature("javax.wsdl.verbose", this.verbose);
        this.def = this.reader.readWSDL(string, document);
        this.add(string, this.def, document);
    }

    public void populateUsingDefinition(String string, Document document, Definition definition) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.def = definition;
        this.add(string, this.def, document);
    }

    private void add(String string, Definition definition, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        URL uRL = string == null ? null : Utils.getURL(null, string);
        this.populate(uRL, definition, document, null, new ArrayList());
        this.checkForUndefined();
        this.setReferences(definition, document);
    }

    private void checkForUndefined(Definition definition, String string) throws IOException {
        if (definition != null) {
            Object object;
            Iterator iterator = definition.getBindings().values().iterator();
            while (iterator.hasNext()) {
                object = (Binding)iterator.next();
                if (!object.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedBinding01", object.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedBinding02", object.getQName().getLocalPart(), string));
            }
            object = definition.getPortTypes().values().iterator();
            while (object.hasNext()) {
                PortType portType = (PortType)object.next();
                if (!portType.isUndefined()) continue;
                if (string == null) {
                    throw new IOException(Messages.getMessage("emitFailtUndefinedPort01", portType.getQName().getLocalPart()));
                }
                throw new IOException(Messages.getMessage("emitFailtUndefinedPort02", portType.getQName().getLocalPart(), string));
            }
        }
    }

    private void checkForUndefined() throws IOException {
        Vector<Type> vector = null;
        Iterator iterator = this.symbolTable.values().iterator();
        while (iterator.hasNext()) {
            Vector vector2 = (Vector)iterator.next();
            for (int i = 0; i < vector2.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector2.get(i);
                if (symTabEntry instanceof UndefinedType) {
                    QName qName = symTabEntry.getQName();
                    if (qName.getLocalPart().equals("dateTime") && !qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") || qName.getLocalPart().equals("timeInstant") && qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                        throw new IOException(Messages.getMessage("wrongNamespace00", qName.getLocalPart(), qName.getNamespaceURI()));
                    }
                    if (SchemaUtils.isSimpleSchemaType(symTabEntry.getQName())) {
                        Type type;
                        this.env.report(Messages.getMessage("unsupportedSchemaType00", qName.getLocalPart()));
                        this.env.report(Messages.getMessage("w2junmap00", qName.toString()));
                        if (vector == null) {
                            vector = new Vector<Type>();
                        }
                        if ((type = this.getType(Constants.WEBSERVICES_SOAPELEMENT)) == null) {
                            type = new DefinedType(Constants.WEBSERVICES_SOAPELEMENT);
                            vector.add(type);
                        }
                        DefinedType definedType = new DefinedType(qName);
                        definedType.setSimpleType(((Type)symTabEntry).isSimpleType());
                        definedType.setRefType(type, null);
                        vector.add(definedType);
                        continue;
                    }
                    throw new IOException(Messages.getMessage("undefined00", symTabEntry.getQName().toString()));
                }
                if (!(symTabEntry instanceof UndefinedElement)) continue;
                throw new IOException(Messages.getMessage("undefinedElem00", symTabEntry.getQName().toString()));
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.symbolTablePut((Type)vector.get(i));
            }
        }
    }

    private void populate(URL uRL, Definition definition, Document document, String string, List list) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        if (document != null) {
            this.populateTypes(uRL, document, list);
            if (this.addImports) {
                this.lookForImports(uRL, document);
            }
        }
        if (definition != null) {
            this.checkForUndefined(definition, string);
            if (this.addImports) {
                Map map = definition.getImports();
                Object[] objectArray = map.keySet().toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    Vector vector = (Vector)map.get(objectArray[i]);
                    for (int j = 0; j < vector.size(); ++j) {
                        Import import_ = (Import)vector.get(j);
                        String string2 = import_.getLocationURI();
                        if (this.importedFiles.contains(string2)) continue;
                        this.importedFiles.add(string2);
                        URL uRL2 = Utils.getURL(uRL, string2);
                        String string3 = uRL2.toString();
                        InputStream inputStream = null;
                        Document document2 = null;
                        Definition definition2 = null;
                        if (this.metaInfo.getImportResolver() != null) {
                            inputStream = this.metaInfo.getImportResolver().resolve(string2);
                        }
                        if (inputStream != null) {
                            document2 = XMLUtils.newDocument(inputStream);
                            definition2 = this.reader.readWSDL(string3, document2);
                        } else {
                            document2 = XMLUtils.newDocument(string3);
                            definition2 = import_.getDefinition();
                        }
                        this.populate(uRL2, definition2, document2, string3, new ArrayList());
                    }
                }
            }
            this.populateMessages(definition);
            this.populatePortTypes(definition);
            this.populateBindings(definition);
            this.populateServices(definition);
        }
    }

    private void lookForImports(URL uRL, Node node) throws IOException, ParserConfigurationException, SAXException, WSDLException {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if ("import".equals(node2.getLocalName())) {
                URL uRL2;
                NamedNodeMap namedNodeMap = node2.getAttributes();
                Node node3 = namedNodeMap.getNamedItem("namespace");
                if (node3 != null && Constants.isSOAP_ENC(node3.getNodeValue())) continue;
                Node node4 = namedNodeMap.getNamedItem("schemaLocation");
                if (node4 != null && !this.importedFiles.contains(uRL2 = Utils.getURL(uRL, node4.getNodeValue()))) {
                    this.importedFiles.add(uRL2);
                    String string = uRL2.toString();
                    InputStream inputStream = null;
                    Document document = null;
                    if (this.metaInfo.getImportResolver() != null) {
                        inputStream = this.metaInfo.getImportResolver().resolve(string);
                    }
                    document = inputStream != null ? XMLUtils.newDocument(inputStream) : XMLUtils.newDocument(string);
                    this.populate(uRL2, null, document, string, new ArrayList());
                }
            }
            this.lookForImports(uRL, node2);
        }
    }

    private void populateTypes(URL uRL, Document document, List list) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.addTypes(uRL, document, -1, list);
        this.enhanceTypes();
    }

    private void addTypes(URL uRL, Node node, int n, List list) throws IOException, ParserConfigurationException, WSDLException, SAXException {
        int n2;
        Object object;
        if (node == null) {
            return;
        }
        QName qName = Utils.getNodeQName(node);
        if (qName != null) {
            Object object2;
            Serializable serializable;
            Object object3;
            object = qName.getLocalPart();
            n2 = Constants.isSchemaXSD(qName.getNamespaceURI());
            if (n2 != 0 && ((String)object).equals("complexType") || ((String)object).equals("simpleType")) {
                object3 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object3 != null && Utils.getAttribute((Node)object3, "base") != null) {
                    this.createTypeFromRef((Node)object3, list);
                }
                this.createTypeFromDef(node, false, false, list);
            } else if (n2 != 0 && ((String)object).equals("element")) {
                this.createTypeFromRef(node, list);
                object3 = SchemaUtils.getRestrictionOrExtensionNode(node);
                if (object3 != null && Utils.getAttribute((Node)object3, "base") != null) {
                    this.createTypeFromRef((Node)object3, list);
                }
                this.createTypeFromDef(node, true, n > 0, list);
            } else if (n2 != 0 && ((String)object).equals("attribute")) {
                object3 = new BooleanHolder();
                serializable = Utils.getTypeQName(node, (BooleanHolder)object3, false, list);
                if (serializable != null && !((BooleanHolder)object3).value) {
                    this.createTypeFromRef(node, list);
                    if (serializable != null) {
                        object2 = this.getType((QName)serializable);
                        if (object2 != null && object2 instanceof Undefined) {
                            ((Type)object2).setSimpleType(true);
                        } else if (object2 == null || !((Type)object2).isSimpleType()) {
                            throw new IOException(Messages.getMessage("AttrNotSimpleType01", ((QName)serializable).toString()));
                        }
                    }
                    this.createTypeFromDef(node, true, n > 0, list);
                }
            } else if (n2 != 0 && ((String)object).equals("any")) {
                this.getTypeForAnyElement();
            } else if (((String)object).equals("part") && Constants.isWSDL(qName.getNamespaceURI())) {
                this.createTypeFromRef(node, list);
            } else if (n2 != 0 && ((String)object).equals("include") && (object3 = Utils.getAttribute(node, "schemaLocation")) != null) {
                serializable = Utils.getURL(uRL, (String)object3);
                object2 = XMLUtils.newDocument(((URL)serializable).toString());
                ArrayList<Node> arrayList = new ArrayList<Node>(list);
                arrayList.add(node);
                this.populate((URL)serializable, null, (Document)object2, ((URL)serializable).toString(), arrayList);
            }
        }
        if (n == -1) {
            if (qName != null && qName.getLocalPart().equals("schema")) {
                n = 0;
            }
        } else {
            ++n;
        }
        object = node.getChildNodes();
        for (n2 = 0; n2 < object.getLength(); ++n2) {
            this.addTypes(uRL, object.item(n2), n, list);
        }
    }

    private void createTypeFromDef(Node node, boolean bl, boolean bl2, List list) throws IOException {
        QName qName = Utils.getNodeNameQName(node, list);
        if (qName != null) {
            if (!bl && this.btm.getBaseName(qName) != null) {
                return;
            }
            boolean bl3 = JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "abstract"));
            BooleanHolder booleanHolder = new BooleanHolder();
            QName qName2 = Utils.getTypeQName(node, booleanHolder, false, list);
            if (qName2 != null) {
                if (qName.getLocalPart().length() == 0) {
                    String string = Utils.getAttribute(node, "name");
                    if (string == null) {
                        string = "unknown";
                    }
                    throw new IOException(Messages.getMessage("emptyref00", string));
                }
                TypeEntry typeEntry = this.getTypeEntry(qName2, booleanHolder.value);
                if (!bl2) {
                    DefinedElement definedElement = new DefinedElement(qName, node, list);
                    definedElement.setRefType(typeEntry, null);
                    definedElement.setAbstract(bl3);
                    if (bl3 && typeEntry != null && typeEntry instanceof Type && ((Type)typeEntry).isAnonType()) {
                        typeEntry.setAbstract(bl3);
                    }
                    this.symbolTablePut(definedElement);
                }
            } else {
                IntHolder intHolder = new IntHolder();
                intHolder.value = 0;
                QName qName3 = SchemaUtils.getArrayComponentQName(node, intHolder, list);
                if (qName3 != null) {
                    String string;
                    qName2 = qName3;
                    TypeEntry typeEntry = this.getTypeEntry(qName2, false);
                    if (typeEntry == null) {
                        string = this.btm.getBaseName(qName2);
                        if (string != null) {
                            typeEntry = new DefinedType(qName2);
                            ((Type)typeEntry).setSimpleType(true);
                        } else {
                            typeEntry = new UndefinedType(qName2);
                        }
                        this.symbolTablePut(typeEntry);
                    }
                    string = "";
                    while (intHolder.value > 0) {
                        string = string + "[]";
                        --intHolder.value;
                    }
                    TypeEntry typeEntry2 = null;
                    if (!bl || !bl2) {
                        typeEntry2 = bl ? new DefinedElement(qName, node, list) : new DefinedType(qName, node, list);
                        typeEntry2.setAbstract(bl3);
                        typeEntry2.setRefType(typeEntry, string);
                    }
                    if (typeEntry2 != null) {
                        this.symbolTablePut(typeEntry2);
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        DefinedType definedType = new DefinedType(qName);
                        definedType.setSimpleType(true);
                        this.symbolTablePut(definedType);
                    } else {
                        TypeEntry typeEntry = null;
                        if (SchemaUtils.isNotMappable(node, this, list)) {
                            Type type = this.getSOAPElementType();
                            if (!bl) {
                                typeEntry = new DefinedType(qName, node, list);
                            } else if (!bl2) {
                                typeEntry = new DefinedElement(qName, node, list);
                            }
                            typeEntry.setRefType(type, null);
                            if (SchemaUtils.isSimpleTypeOrSimpleContent(node, list)) {
                                ((Type)typeEntry).setSimpleType(true);
                            }
                            this.env.report(Messages.getMessage("w2junmap00", qName.toString()));
                        } else if (!bl) {
                            typeEntry = new DefinedType(qName, node, list);
                            if (SchemaUtils.isSimpleTypeOrSimpleContent(node, list)) {
                                ((Type)typeEntry).setSimpleType(true);
                            }
                        } else if (!bl2) {
                            typeEntry = new DefinedElement(qName, node, list);
                        }
                        if (typeEntry != null) {
                            typeEntry.setAbstract(bl3);
                            this.symbolTablePut(typeEntry);
                        }
                    }
                }
            }
        }
    }

    private void createTypeFromRef(Node node, List list) throws IOException {
        BooleanHolder booleanHolder = new BooleanHolder();
        QName qName = Utils.getTypeQName(node, booleanHolder, false, list);
        if (qName != null) {
            if (qName.getLocalPart().length() == 0) {
                String string = Utils.getAttribute(node, "name");
                if (string == null) {
                    string = "unknown";
                }
                throw new IOException(Messages.getMessage("emptyref00", string));
            }
            TypeEntry typeEntry = this.getTypeEntry(qName, booleanHolder.value);
            if (typeEntry == null) {
                if (qName.getLocalPart().indexOf("[") > 0) {
                    QName qName2 = Utils.getTypeQName(node, booleanHolder, true, list);
                    TypeEntry typeEntry2 = this.getTypeEntry(qName2, booleanHolder.value);
                    if (!booleanHolder.value) {
                        Object object;
                        if (typeEntry2 == null) {
                            object = this.btm.getBaseName(qName2);
                            if (object != null) {
                                typeEntry2 = new DefinedType(qName2);
                                ((Type)typeEntry2).setSimpleType(true);
                            } else {
                                typeEntry2 = new UndefinedType(qName2);
                            }
                            this.symbolTablePut(typeEntry2);
                        }
                        object = new DefinedType(qName, node, list);
                        ((TypeEntry)object).setRefType(typeEntry2, "[]");
                        this.symbolTablePut((SymTabEntry)object);
                    } else {
                        if (typeEntry2 == null) {
                            typeEntry2 = new UndefinedElement(qName2);
                            this.symbolTablePut(typeEntry2);
                        }
                        DefinedElement definedElement = new DefinedElement(qName, node, list);
                        definedElement.setRefType(typeEntry2, "[]");
                        this.symbolTablePut(definedElement);
                    }
                } else {
                    String string = this.btm.getBaseName(qName);
                    if (string != null) {
                        DefinedType definedType = new DefinedType(qName);
                        definedType.setSimpleType(true);
                        this.symbolTablePut(definedType);
                    } else if (!booleanHolder.value) {
                        this.symbolTablePut(new UndefinedType(qName));
                    } else {
                        this.symbolTablePut(new UndefinedElement(qName));
                    }
                }
            }
        }
    }

    private void enhanceTypes() throws IOException {
        for (int i = 0; i < this.types.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
            if (!(typeEntry instanceof DefinedType) || typeEntry.getNode() == null) continue;
            Type type = (Type)typeEntry;
            this.enhanceType(type);
        }
    }

    private void enhanceType(Type type) throws IOException {
        Vector vector = SchemaUtils.getEnumerationBaseAndValues(type.getNode(), this, type.getNodeStack());
        if (vector != null) {
            type.setEnumeration(true);
            type.setChildren(vector);
            type.setRestrictionBase((Type)((ChildEnumValueEntry)vector.get(0)).getType());
        } else {
            Serializable serializable;
            Type type2 = SchemaUtils.getComplexElementExtensionBase(type.getNode(), this, type.getNodeStack());
            if (type2 != null) {
                this.enhanceType(type2);
                type.setExtensionBase(type2);
            } else {
                serializable = SchemaUtils.getSimpleTypeBase(type.getNode(), this, type.getNodeStack());
                if (serializable != null) {
                    type2 = this.getType((QName)serializable);
                    this.enhanceType(type2);
                    type.setRestrictionBase(type2);
                }
            }
            if (type2 != null && type2.getRefType() != null && type2.getRefType() == this.getSOAPElementType()) {
                type.setRefType(this.getSOAPElementType(), null);
                this.env.report(Messages.getMessage("w2junmap00", type2.getQName().toString()));
            } else {
                Vector vector2;
                serializable = new Vector();
                Vector vector3 = SchemaUtils.getContainedAttributeTypes(type.getNode(), this, type.getNodeStack());
                if (vector3 != null) {
                    while (vector3.size() > 0) {
                        if (this.containsQName((List)((Object)serializable), ((Entry)vector3.elementAt(0)).getQName())) {
                            type.setRefType(this.getSOAPElementType(), null);
                            this.env.report(Messages.getMessage("w2junmap00", type.getQName().toString()));
                            return;
                        }
                        ((Vector)serializable).add(vector3.remove(0));
                    }
                }
                if ((vector2 = SchemaUtils.getContainedElementDeclarations(type.getNode(), this, type.getNodeStack())) != null) {
                    while (vector2.size() > 0) {
                        if (this.containsQName((List)((Object)serializable), ((Entry)vector2.elementAt(0)).getQName())) {
                            type.setRefType(this.getSOAPElementType(), null);
                            this.env.report(Messages.getMessage("w2junmap00", type.getQName().toString()));
                            return;
                        }
                        ((Vector)serializable).add(vector2.remove(0));
                    }
                }
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    ChildEntry childEntry = (ChildEntry)((Vector)serializable).get(i);
                    TypeEntry typeEntry = childEntry.getType();
                    while (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry() && typeEntry.getRefType() != null) {
                        typeEntry = typeEntry.getRefType();
                    }
                    childEntry.setType(typeEntry);
                }
                type.setChildren((Vector)serializable);
            }
        }
    }

    private boolean containsQName(List list, QName qName) {
        for (int i = 0; i < list.size(); ++i) {
            if (!((Entry)list.get(i)).getQName().equals(qName)) continue;
            return true;
        }
        return false;
    }

    private void populateMessages(Definition definition) throws IOException {
        Iterator iterator = definition.getMessages().values().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            MessageEntry messageEntry = new MessageEntry(message);
            this.symbolTablePut(messageEntry);
        }
    }

    private void populatePortTypes(Definition definition) throws IOException {
        Iterator iterator = definition.getPortTypes().values().iterator();
        while (iterator.hasNext()) {
            PortType portType = (PortType)iterator.next();
            if (portType.isUndefined()) continue;
            PortTypeEntry portTypeEntry = new PortTypeEntry(portType);
            this.symbolTablePut(portTypeEntry);
        }
    }

    private void populateBindings(Definition definition) throws IOException {
        Iterator iterator = definition.getBindings().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            SOAPBinding sOAPBinding;
            Object object2;
            Binding binding = (Binding)iterator.next();
            BindingEntry bindingEntry = new BindingEntry(binding);
            this.symbolTablePut(bindingEntry);
            Iterator iterator2 = binding.getExtensibilityElements().iterator();
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                if (object2 instanceof SOAPBinding) {
                    bindingEntry.setBindingType(0);
                    sOAPBinding = (SOAPBinding)object2;
                    object = sOAPBinding.getStyle();
                    if (!"rpc".equalsIgnoreCase((String)object)) continue;
                    bindingEntry.setBindingStyle(Style.RPC);
                    continue;
                }
                if (object2 instanceof HTTPBinding) {
                    sOAPBinding = (HTTPBinding)object2;
                    if (sOAPBinding.getVerb().equalsIgnoreCase("post")) {
                        bindingEntry.setBindingType(2);
                        continue;
                    }
                    bindingEntry.setBindingType(1);
                    continue;
                }
                bindingEntry.setBindingType(4);
            }
            object2 = binding.getBindingOperations();
            sOAPBinding = object2.iterator();
            while (sOAPBinding.hasNext()) {
                object = (BindingOperation)sOAPBinding.next();
                this.addBindingOperation(bindingEntry, (BindingOperation)object);
            }
        }
    }

    private void addBindingOperation(BindingEntry bindingEntry, BindingOperation bindingOperation) throws IOException {
        String string;
        Operation operation = bindingOperation.getOperation();
        BindingInput bindingInput = bindingOperation.getBindingInput();
        BindingOutput bindingOutput = bindingOperation.getBindingOutput();
        String string2 = bindingOperation.getName();
        String string3 = bindingInput == null ? null : bindingInput.getName();
        String string4 = string = bindingOutput == null ? null : bindingOutput.getName();
        if (bindingEntry.getBinding().getPortType().getOperation(string2, string3, string) == null) {
            throw new IOException(Messages.getMessage("unmatchedOp", new String[]{string2, string3, string}));
        }
        BindingOperationEntry bindingOperationEntry = new BindingOperationEntry(bindingOperation);
        bindingEntry.addOperation(operation, bindingOperationEntry);
        List list = bindingOperationEntry.getBindingOperation().getExtensibilityElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string5;
            Object e = iterator.next();
            if (!(e instanceof SOAPOperation) || (string5 = ((SOAPOperation)e).getStyle()) == null || bindingEntry.getBindingStyle() == Style.WRAPPED || string5.equals(bindingEntry.getBindingStyle().toString())) continue;
            throw new IOException(Messages.getMessage("useMismatch", new String[]{string2, "binding style", bindingEntry.getBindingStyle().toString(), "operation style", string5}));
        }
        if (bindingInput != null) {
            this.setBodyUseAndNamespace(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setBodyUseAndNamespace(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
        if (bindingOperationEntry.getInputBodyUse() != null && bindingOperationEntry.getOutputBodyUse() != null && bindingOperationEntry.getInputBodyUse() != bindingOperationEntry.getOutputBodyUse()) {
            throw new IOException(Messages.getMessage("useMismatch", new String[]{string2, "input use", bindingOperationEntry.getInputBodyUse().toString(), "output use", bindingOperationEntry.getOutputBodyUse().toString()}));
        }
        this.addOperationParameters(bindingEntry, bindingOperationEntry);
        if (bindingInput != null) {
            this.setHeaderInfo(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setHeaderInfo(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
        if (bindingInput != null) {
            this.setMIMEInfo(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setMIMEInfo(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
        this.addOperationFaults(bindingEntry, bindingOperationEntry);
        if (bindingInput != null) {
            this.setHeaderFaultInfo(bindingOperationEntry, bindingInput.getExtensibilityElements(), true);
        }
        if (bindingOutput != null) {
            this.setHeaderFaultInfo(bindingOperationEntry, bindingOutput.getExtensibilityElements(), false);
        }
    }

    public void addOperationParameters(BindingEntry bindingEntry, BindingOperationEntry bindingOperationEntry) throws IOException {
        int n;
        int n2;
        Object object;
        int n3;
        List list;
        Vector vector;
        Object object2;
        Operation operation = bindingOperationEntry.getBindingOperation().getOperation();
        Input input = operation.getInput();
        Output output = operation.getOutput();
        QName qName = null;
        QName qName2 = null;
        if (input != null && input.getMessage() != null && input.getMessage().getParts() != null && input.getMessage().getParts().values().size() != 0) {
            qName = input.getMessage().getQName();
        }
        if (output != null && output.getMessage() != null && output.getMessage().getParts() != null && output.getMessage().getParts().values().size() != 0) {
            qName2 = output.getMessage().getQName();
        }
        MetaOperationKey metaOperationKey = new MetaOperationKey(bindingEntry.getQName(), operation.getName(), qName, qName2);
        MetaOperationValue metaOperationValue = (MetaOperationValue)this.metaInfo.getOperationMap().get(metaOperationKey);
        if (metaOperationValue == null) {
            metaOperationKey = new MetaOperationKey(bindingEntry.getQName(), operation.getName(), qName, null);
            metaOperationValue = (MetaOperationValue)this.metaInfo.getOperationMap().get(metaOperationKey);
        }
        boolean bl = false;
        if (metaOperationValue != null) {
            bl = !metaOperationValue.isWrapped();
        } else if (this.metaInfo != null) {
            bl = this.metaInfo.getProperty("noWrappedOperations") == Boolean.TRUE || this.metaInfo.getProperty("noDataBinding") == Boolean.TRUE;
        }
        List list2 = null;
        ArrayList arrayList = null;
        if (metaOperationValue != null) {
            list2 = metaOperationValue.getParameterOrder();
            arrayList = metaOperationValue.getModeOrder();
        } else {
            list2 = operation.getParameterOrdering();
        }
        if (list2 != null && list2.isEmpty()) {
            list2 = null;
        }
        if (!(list2 == null || metaOperationValue != null && metaOperationValue.isWrapped() || input == null)) {
            object2 = input.getMessage();
            vector = object2.getParts();
            list = list2;
            if (arrayList != null) {
                list = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!arrayList.get(i).equals("IN") && !arrayList.get(i).equals("INOUT")) continue;
                    list.add(list2.get(i));
                }
            }
            List list3 = object2.getOrderedParts(list);
            if (vector.size() != list3.size()) {
                throw new IOException(Messages.getMessage("emitFail00", operation.getName()));
            }
        }
        object2 = null;
        if (metaOperationValue != null) {
            object2 = metaOperationValue.getReturnPart();
        }
        vector = new Vector();
        list = new Vector();
        boolean bl2 = false;
        boolean bl3 = false;
        StringHolder stringHolder = new StringHolder();
        Style style = bindingEntry.getBindingStyle();
        if (input != null && input.getMessage() != null && (bl2 = this.createBindingParams(vector, this.getMessageEntry(input.getMessage().getQName()), true, bindingOperationEntry, bindingEntry, stringHolder, bl))) {
            bindingEntry.setBindingStyle(Style.WRAPPED);
        }
        if (output != null && output.getMessage() != null) {
            bl3 = this.createBindingParams((Vector)list, this.getMessageEntry(output.getMessage().getQName()), false, bindingOperationEntry, bindingEntry, null, bl);
        }
        if (bl2) {
            if (output == null || bl3) {
                bindingOperationEntry.setWrapped(true);
                bindingOperationEntry.setNamespace(stringHolder.value);
            } else {
                bindingEntry.setBindingStyle(style);
                vector = new Vector();
                list = new Vector();
                if (input != null && input.getMessage() != null) {
                    this.createBindingParams(vector, this.getMessageEntry(input.getMessage().getQName()), true, bindingOperationEntry, bindingEntry, stringHolder, true);
                }
                if (output != null && output.getMessage() != null) {
                    this.createBindingParams((Vector)list, this.getMessageEntry(output.getMessage().getQName()), false, bindingOperationEntry, bindingEntry, null, true);
                }
            }
        }
        if (list2 != null) {
            for (n3 = 0; n3 < list2.size(); ++n3) {
                object = (String)list2.get(n3);
                n2 = -1;
                if (arrayList == null || arrayList.get(n3).equals("IN") || arrayList.get(n3).equals("INOUT")) {
                    n2 = this.getParamIndex((String)object, vector);
                }
                n = -1;
                if (arrayList == null || arrayList.get(n3).equals("OUT") || arrayList.get(n3).equals("INOUT")) {
                    n = this.getParamIndex((String)object, (Vector)list);
                }
                if (n2 >= 0) {
                    if (((String)object).equals(object2) && n >= 0) {
                        BindingParamEntry bindingParamEntry = (BindingParamEntry)((Vector)list).get(n);
                        bindingParamEntry.setMode((byte)2);
                        bindingOperationEntry.setReturn(bindingParamEntry);
                        ((Vector)list).remove(n);
                        n = -1;
                    }
                    this.addInishParm(vector, (Vector)list, n2, n, bindingOperationEntry);
                    vector.remove(n2);
                    continue;
                }
                if (n >= 0) {
                    this.addOutParm((Vector)list, n, bindingOperationEntry);
                    ((Vector)list).remove(n);
                    continue;
                }
                if (bl2) continue;
                System.err.println(Messages.getMessage("noPart00", (String)object));
            }
        }
        if (bl2 && bl3 && vector.size() == 1 && ((Vector)list).size() == 1 && ((BindingParamEntry)vector.get(0)).getQName().equals(((BindingParamEntry)((Vector)list).get(0)).getQName()) && (metaOperationValue == null || metaOperationValue.getReturnPart() != null)) {
            this.addInishParm(vector, null, 0, -1, bindingOperationEntry);
        } else {
            for (n3 = 0; n3 < vector.size(); ++n3) {
                object = (BindingParamEntry)vector.get(n3);
                n2 = -1;
                for (n = 0; n < ((Vector)list).size() && n2 == -1; ++n) {
                    if (!((Entry)object).getQName().equals(((BindingParamEntry)((Vector)list).get(n)).getQName())) continue;
                    n2 = n;
                }
                this.addInishParm(vector, (Vector)list, n3, n2, bindingOperationEntry);
            }
        }
        if (((Vector)list).size() == 1 && (metaOperationValue == null || metaOperationValue.getReturnPart() != null)) {
            BindingParamEntry bindingParamEntry = (BindingParamEntry)((Vector)list).get(0);
            bindingParamEntry.setMode((byte)2);
            bindingOperationEntry.setReturn(bindingParamEntry);
        } else {
            for (n3 = 0; n3 < ((Vector)list).size(); ++n3) {
                this.addOutParm((Vector)list, n3, bindingOperationEntry);
            }
        }
    }

    private int getParamIndex(String string, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(i);
            if (!bindingParamEntry.getQName().getLocalPart().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void addInishParm(Vector vector, Vector vector2, int n, int n2, BindingOperationEntry bindingOperationEntry) {
        BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(n);
        bindingParamEntry.setMode((byte)1);
        if (n2 >= 0) {
            BindingParamEntry bindingParamEntry2 = (BindingParamEntry)vector2.get(n2);
            if (bindingParamEntry.getType().equals(bindingParamEntry2.getType())) {
                vector2.remove(n2);
                bindingParamEntry.setMode((byte)3);
                bindingParamEntry.setOutMessageEntry(bindingParamEntry2.getOutMessageEntry());
            }
        }
        bindingOperationEntry.addParameter(bindingParamEntry);
    }

    private void addOutParm(Vector vector, int n, BindingOperationEntry bindingOperationEntry) {
        BindingParamEntry bindingParamEntry = (BindingParamEntry)vector.get(n);
        bindingParamEntry.setMode((byte)2);
        bindingOperationEntry.addParameter(bindingParamEntry);
    }

    private boolean createBindingParams(Vector vector, MessageEntry messageEntry, boolean bl, BindingOperationEntry bindingOperationEntry, BindingEntry bindingEntry, StringHolder stringHolder, boolean bl2) throws IOException {
        Object object;
        Object object2;
        Object object3;
        int n;
        Use use = bl ? bindingOperationEntry.getInputBodyUse() : bindingOperationEntry.getOutputBodyUse();
        String string = bindingOperationEntry.getQName().getLocalPart();
        boolean bl3 = false;
        if (bl) {
            n = 0;
            boolean bl4 = false;
            object3 = messageEntry.getMessage().getOrderedParts(null);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Part)object2.next();
                if (object.getElementName() == null) continue;
                ++n;
                if (!bl || !object.getElementName().getLocalPart().equals(string)) continue;
                bl4 = true;
            }
            if (!bl2 && (bindingEntry.getBindingStyle() == Style.WRAPPED || bindingEntry.getBindingStyle() == Style.DOCUMENT) && use == Use.LITERAL && n == 1 && bl4) {
                bl3 = true;
            }
        } else {
            n = 0;
            List list = messageEntry.getMessage().getOrderedParts(null);
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (Part)object3.next();
                if (object2.getElementName() == null) continue;
                ++n;
            }
            if (!bl2 && bindingEntry.getBindingStyle() == Style.WRAPPED && use == Use.LITERAL && n <= 1) {
                bl3 = true;
            }
        }
        Iterator iterator = messageEntry.getMessage().getOrderedParts(null).iterator();
        while (iterator.hasNext()) {
            Object object4;
            Part part = (Part)iterator.next();
            object3 = part.getElementName();
            object2 = part.getTypeName();
            object = part.getName();
            if (bl3) {
                int n2;
                Serializable serializable;
                if (bl) {
                    stringHolder.value = ((QName)object3).getNamespaceURI();
                }
                if (object2 != null && bindingEntry.hasMIMETypes()) {
                    object4 = bindingEntry == null ? "unknown" : bindingEntry.getBinding().getQName().toString();
                    throw new IOException(Messages.getMessage("literalTypePart00", new String[]{object, string, object4}));
                }
                object4 = this.getType((QName)object2);
                if (object4 == null) {
                    serializable = this.getElement((QName)object3);
                    while (serializable instanceof Element) {
                        serializable = ((TypeEntry)serializable).getRefType();
                    }
                    object4 = (Type)serializable;
                }
                if (object4 == null) {
                    throw new IOException(Messages.getMessage("badTypeNode", new String[]{object, string, ((QName)object3).toString()}));
                }
                serializable = ((Type)object4).getChildren();
                if (serializable == null) {
                    bl3 = false;
                } else {
                    for (n2 = 0; n2 < ((Vector)serializable).size() && bl3; ++n2) {
                        if (((Vector)serializable).get(n2) instanceof ChildElement) continue;
                        bl3 = false;
                    }
                }
                if (bl3) {
                    if (serializable != null) {
                        for (n2 = 0; n2 < ((Vector)serializable).size(); ++n2) {
                            ChildElement childElement = (ChildElement)((Vector)serializable).elementAt(n2);
                            BindingParamEntry bindingParamEntry = new BindingParamEntry(childElement.getQName());
                            if (bl) {
                                bindingParamEntry.setInMessageEntry(messageEntry);
                            } else {
                                bindingParamEntry.setOutMessageEntry(messageEntry);
                            }
                            bindingParamEntry.setType(childElement.getType());
                            bindingParamEntry.setMinOccursIs0(childElement.getMinOccursIs0());
                            bindingParamEntry.setMaxOccursIs1(!childElement.getType().isCollectionTypeEntry());
                            bindingParamEntry.setParentNamespace(((Entry)object4).getQName().getNamespaceURI());
                            vector.add(bindingParamEntry);
                        }
                    }
                    return true;
                }
            }
            object4 = new BindingParamEntry(QNameTable.createQName("", (String)object));
            if (bl) {
                ((BindingParamEntry)object4).setInMessageEntry(messageEntry);
            } else {
                ((BindingParamEntry)object4).setOutMessageEntry(messageEntry);
            }
            ((Entry)object4).setName((String)object);
            if (object2 != null) {
                ((BindingParamEntry)object4).setType(this.getType((QName)object2));
            } else if (object3 != null) {
                ((BindingParamEntry)object4).setType(this.getElement((QName)object3));
            } else {
                throw new IOException(Messages.getMessage("noTypeOrElement00", new String[]{object, string}));
            }
            vector.add(object4);
        }
        return bl3;
    }

    private void setMIMEInfo(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MIMEMultipartRelated)) continue;
            MIMEMultipartRelated mIMEMultipartRelated = (MIMEMultipartRelated)e;
            List list2 = mIMEMultipartRelated.getMIMEParts();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                MIMEPart mIMEPart = (MIMEPart)iterator2.next();
                List list3 = mIMEPart.getExtensibilityElements();
                Iterator iterator3 = list3.iterator();
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    if (!(e2 instanceof MIMEContent)) continue;
                    MIMEContent mIMEContent = (MIMEContent)e2;
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(mIMEContent.getPart());
                    if (bindingParamEntry == null) {
                        bindingParamEntry = bindingOperationEntry.getReturn();
                    }
                    if (bindingParamEntry == null) continue;
                    bindingParamEntry.setMIMEType(mIMEContent.getType());
                }
            }
        }
    }

    private void setMIMEType(BindingParamEntry bindingParamEntry, String string) {
        QName qName;
        if (string == null && (qName = bindingParamEntry.getType().getQName()).getNamespaceURI().equals("http://xml.apache.org/xml-soap")) {
            if (Constants.MIME_IMAGE.equals(qName)) {
                string = "image/jpeg";
            } else if (Constants.MIME_PLAINTEXT.equals(qName)) {
                string = "text/plain";
            } else if (Constants.MIME_MULTIPART.equals(qName)) {
                string = "multipart/related";
            } else if (Constants.MIME_SOURCE.equals(qName)) {
                string = "text/xml";
            }
        }
        bindingParamEntry.setMIMEType(string);
    }

    private void setHeaderInfo(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SOAPHeader sOAPHeader;
            BindingParamEntry bindingParamEntry;
            Object e = iterator.next();
            if (!(e instanceof SOAPHeader) || (bindingParamEntry = bindingOperationEntry.getParameter((sOAPHeader = (SOAPHeader)e).getPart())) == null) continue;
            if (bl) {
                bindingParamEntry.setInHeader(true);
                continue;
            }
            bindingParamEntry.setOutHeader(true);
        }
    }

    private void setHeaderFaultInfo(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SOAPHeader)) continue;
            SOAPHeader sOAPHeader = (SOAPHeader)e;
            Iterator iterator2 = sOAPHeader.getSOAPHeaderFaults().iterator();
            while (iterator2.hasNext()) {
                SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)iterator2.next();
                BindingFaultRefEntry bindingFaultRefEntry = bindingOperationEntry.getFault(sOAPHeaderFault.getMessage().getLocalPart());
                if (bindingFaultRefEntry == null) {
                    bindingFaultRefEntry = this.createBindingFaultRef(this.getMessageEntry(sOAPHeaderFault.getMessage()), bindingOperationEntry);
                }
                if (bl) {
                    bindingFaultRefEntry.setInHeader(true);
                } else {
                    bindingFaultRefEntry.setOutHeader(true);
                }
                bindingFaultRefEntry.setUse(Use.getUse(sOAPHeaderFault.getUse()));
            }
        }
    }

    private void addOperationFaults(BindingEntry bindingEntry, BindingOperationEntry bindingOperationEntry) throws IOException {
        BindingOperation bindingOperation = bindingOperationEntry.getBindingOperation();
        Binding binding = bindingEntry.getBinding();
        Iterator iterator = bindingOperation.getBindingFaults().values().iterator();
        while (iterator.hasNext()) {
            Object object;
            BindingFault bindingFault = (BindingFault)iterator.next();
            String string = bindingFault.getName();
            if (string == null || string.length() == 0) {
                throw new IOException(Messages.getMessage("unNamedFault00", bindingOperation.getName(), binding.getQName().toString()));
            }
            SOAPFault sOAPFault = null;
            Iterator iterator2 = bindingFault.getExtensibilityElements().iterator();
            while (iterator2.hasNext()) {
                object = iterator2.next();
                if (!(object instanceof SOAPFault)) continue;
                sOAPFault = (SOAPFault)object;
                break;
            }
            if (sOAPFault == null && bindingEntry.getBindingType() != 4) {
                throw new IOException(Messages.getMessage("missingSoapFault00", string, bindingOperation.getName(), binding.getQName().toString()));
            }
            object = bindingOperation.getOperation().getFault(bindingFault.getName());
            if (object == null) {
                throw new IOException(Messages.getMessage("noPortTypeFault", new String[]{bindingFault.getName(), bindingOperation.getName(), binding.getQName().toString()}));
            }
            if (bindingEntry.getBindingType() == 4) continue;
            MessageEntry messageEntry = this.getMessageEntry(object.getMessage().getQName());
            BindingFaultRefEntry bindingFaultRefEntry = this.createBindingFaultRef(messageEntry, bindingOperationEntry);
            bindingFaultRefEntry.setUse(Use.getUse(sOAPFault.getUse()));
            if (bindingOperationEntry.getInputBodyUse() == null || bindingFaultRefEntry.getUse() == null || bindingOperationEntry.getInputBodyUse() == bindingFaultRefEntry.getUse()) continue;
            throw new IOException(Messages.getMessage("useMismatch", new String[]{bindingOperation.getName(), "input use", bindingOperationEntry.getInputBodyUse().toString(), "fault use", bindingFaultRefEntry.getUse().toString()}));
        }
    }

    private BindingFaultRefEntry createBindingFaultRef(MessageEntry messageEntry, BindingOperationEntry bindingOperationEntry) {
        this.setMessageEntryAsFault(messageEntry);
        BindingFaultRefEntry bindingFaultRefEntry = new BindingFaultRefEntry(messageEntry);
        bindingOperationEntry.addFault(bindingFaultRefEntry);
        return bindingFaultRefEntry;
    }

    public void setMessageEntryAsFault(MessageEntry messageEntry) {
        if (messageEntry.isFault()) {
            return;
        }
        messageEntry.setFault(true);
        Vector<ChildFaultPartEntry> vector = new Vector<ChildFaultPartEntry>();
        List list = messageEntry.getMessage().getOrderedParts(null);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Part part = (Part)iterator.next();
            QName qName = QNameTable.createQName("", part.getName());
            TypeEntry typeEntry = null;
            typeEntry = part.getTypeName() != null ? this.getType(part.getTypeName()) : this.getElement(part.getElementName());
            vector.add(new ChildFaultPartEntry(qName, typeEntry));
        }
        messageEntry.setFaultParts(vector);
    }

    private void setBodyUseAndNamespace(BindingOperationEntry bindingOperationEntry, List list, boolean bl) throws IOException {
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SOAPBody sOAPBody;
            Object e = iterator.next();
            if (e instanceof SOAPBody) {
                sOAPBody = (SOAPBody)e;
                this.setBodyUse(bindingOperationEntry, sOAPBody.getUse(), bl);
                if (!bl || sOAPBody.getNamespaceURI() == null) continue;
                bindingOperationEntry.setNamespace(sOAPBody.getNamespaceURI());
                continue;
            }
            if (e instanceof SOAPHeader) {
                sOAPBody = (SOAPHeader)e;
                this.setBodyUse(bindingOperationEntry, sOAPBody.getUse(), bl);
                continue;
            }
            if (!(e instanceof MIMEMultipartRelated)) continue;
            sOAPBody = (MIMEMultipartRelated)e;
            this.setBodyUse(bindingOperationEntry, "encoded", bl);
            List list2 = sOAPBody.getMIMEParts();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                MIMEPart mIMEPart = (MIMEPart)iterator2.next();
                List list3 = mIMEPart.getExtensibilityElements();
                Iterator iterator3 = list3.iterator();
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    if (e2 instanceof SOAPBody) {
                        this.setBodyUse(bindingOperationEntry, ((SOAPBody)e2).getUse(), bl);
                        continue;
                    }
                    if (!(e2 instanceof SOAPHeader)) continue;
                    SOAPHeader sOAPHeader = (SOAPHeader)e2;
                    this.setBodyUse(bindingOperationEntry, sOAPHeader.getUse(), bl);
                }
            }
        }
    }

    private void setBodyUse(BindingOperationEntry bindingOperationEntry, String string, boolean bl) throws IOException {
        if (string == null) {
            throw new IOException(Messages.getMessage("noUse", bindingOperationEntry.getName()));
        }
        if (bl) {
            bindingOperationEntry.setInputBodyUse(Use.getUse(string));
        } else {
            bindingOperationEntry.setOutputBodyUse(Use.getUse(string));
        }
    }

    private void populateServices(Definition definition) throws IOException {
        Iterator iterator = definition.getServices().values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            if (service.getQName() == null || service.getQName().getLocalPart() == null || service.getQName().getLocalPart().equals("")) {
                throw new IOException(Messages.getMessage("BadServiceName00"));
            }
            ServiceEntry serviceEntry = new ServiceEntry(service);
            this.symbolTablePut(serviceEntry);
            Map map = service.getPorts();
            Iterator iterator2 = map.values().iterator();
            while (iterator2.hasNext()) {
                Port port2 = (Port)iterator2.next();
                QName qName = QNameTable.createQName(service.getQName().getNamespaceURI(), port2.getName());
                serviceEntry.addPort(new PortEntry(qName, port2));
            }
        }
    }

    private void setReferences(Definition definition, Document document) {
        Map map = definition.getServices();
        if (map.isEmpty()) {
            map = definition.getBindings();
            if (map.isEmpty()) {
                map = definition.getPortTypes();
                if (map.isEmpty()) {
                    map = definition.getMessages();
                    if (map.isEmpty()) {
                        for (int i = 0; i < this.types.size(); ++i) {
                            TypeEntry typeEntry = (TypeEntry)this.types.get(i);
                            this.setTypeReferences(typeEntry, document, false);
                        }
                    } else {
                        Iterator iterator = map.values().iterator();
                        while (iterator.hasNext()) {
                            Message message = (Message)iterator.next();
                            MessageEntry messageEntry = this.getMessageEntry(message.getQName());
                            this.setMessageReferences(messageEntry, definition, document, false);
                        }
                    }
                } else {
                    Iterator iterator = map.values().iterator();
                    while (iterator.hasNext()) {
                        PortType portType = (PortType)iterator.next();
                        PortTypeEntry portTypeEntry = this.getPortTypeEntry(portType.getQName());
                        this.setPortTypeReferences(portTypeEntry, null, definition, document);
                    }
                }
            } else {
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    Binding binding = (Binding)iterator.next();
                    BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
                    this.setBindingReferences(bindingEntry, definition, document);
                }
            }
        } else {
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Service service = (Service)iterator.next();
                ServiceEntry serviceEntry = this.getServiceEntry(service.getQName());
                this.setServiceReferences(serviceEntry, definition, document);
            }
        }
    }

    private void setTypeReferences(TypeEntry typeEntry, Document document, boolean bl) {
        this.setTypeReferences(typeEntry, document, bl, false);
    }

    private void setTypeReferences(TypeEntry typeEntry, Document document, boolean bl, boolean bl2) {
        TypeEntry typeEntry2;
        Object object;
        Object object2;
        if (typeEntry.isReferenced() && !bl || typeEntry.isOnlyWrappedLiteralReferenced() && bl) {
            return;
        }
        if (!typeEntry.isReferenced() && bl) {
            typeEntry.setOnlyWrappedLiteralReference(true);
        } else if (typeEntry.isOnlyWrappedLiteralReferenced() && !bl) {
            typeEntry.setOnlyWrappedLiteralReference(false);
        }
        Node node = typeEntry.getNode();
        if (this.addImports || node == null || node.getOwnerDocument() == document) {
            typeEntry.setIsReferenced(true);
            if (typeEntry instanceof DefinedElement) {
                object2 = new BooleanHolder();
                object = Utils.getTypeQName(node, (BooleanHolder)object2, false, typeEntry.getNodeStack());
                if (object != null && (typeEntry2 = this.getTypeEntry((QName)object, ((BooleanHolder)object2).value)) != null) {
                    this.setTypeReferences(typeEntry2, document, bl, bl2);
                }
                typeEntry2 = typeEntry.getRefType();
                while (typeEntry2 instanceof Element) {
                    typeEntry2 = typeEntry2.getRefType();
                }
                if (typeEntry2 != null && ((Type)typeEntry2).isAnonType()) {
                    this.setTypeReferences(typeEntry2, document, bl, bl2);
                    return;
                }
            }
        }
        if (!bl2) {
            object2 = Utils.getNestedTypes(typeEntry, this, true);
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                typeEntry2 = (TypeEntry)object.next();
                if (typeEntry2.isReferenced()) continue;
                this.setTypeReferences(typeEntry2, document, false, true);
            }
        }
    }

    private void setMessageReferences(MessageEntry messageEntry, Definition definition, Document document, boolean bl) {
        Object object;
        Message message = messageEntry.getMessage();
        if (this.addImports) {
            messageEntry.setIsReferenced(true);
        } else {
            object = definition.getMessages();
            if (object.containsValue(message)) {
                messageEntry.setIsReferenced(true);
            }
        }
        object = message.getParts().values().iterator();
        while (object.hasNext()) {
            Part part = (Part)object.next();
            TypeEntry typeEntry = this.getType(part.getTypeName());
            if (typeEntry != null) {
                this.setTypeReferences(typeEntry, document, bl);
            }
            if ((typeEntry = this.getElement(part.getElementName())) == null) continue;
            this.setTypeReferences(typeEntry, document, bl);
            TypeEntry typeEntry2 = typeEntry.getRefType();
            if (typeEntry2 == null) continue;
            this.setTypeReferences(typeEntry2, document, bl);
        }
    }

    private void setPortTypeReferences(PortTypeEntry portTypeEntry, BindingEntry bindingEntry, Definition definition, Document document) {
        Object object;
        PortType portType = portTypeEntry.getPortType();
        if (this.addImports) {
            portTypeEntry.setIsReferenced(true);
        } else {
            object = definition.getPortTypes();
            if (object.containsValue(portType)) {
                portTypeEntry.setIsReferenced(true);
            }
        }
        object = portType.getOperations().iterator();
        while (object.hasNext()) {
            MessageEntry messageEntry;
            Object object2;
            Operation operation = (Operation)object.next();
            Input input = operation.getInput();
            Output output = operation.getOutput();
            boolean bl = false;
            boolean bl2 = false;
            if (bindingEntry != null) {
                object2 = bindingEntry.getOperation(operation);
                bl = ((BindingOperationEntry)object2).getInputBodyUse() == Use.LITERAL && ((BindingOperationEntry)object2).isWrapped();
                boolean bl3 = bl2 = ((BindingOperationEntry)object2).getOutputBodyUse() == Use.LITERAL && ((BindingOperationEntry)object2).isWrapped();
            }
            if (input != null && (object2 = input.getMessage()) != null && (messageEntry = this.getMessageEntry(object2.getQName())) != null) {
                this.setMessageReferences(messageEntry, definition, document, bl);
            }
            if (output != null && (object2 = output.getMessage()) != null && (messageEntry = this.getMessageEntry(object2.getQName())) != null) {
                this.setMessageReferences(messageEntry, definition, document, bl2);
            }
            object2 = operation.getFaults().values().iterator();
            while (object2.hasNext()) {
                MessageEntry messageEntry2;
                messageEntry = ((Fault)object2.next()).getMessage();
                if (messageEntry == null || (messageEntry2 = this.getMessageEntry(messageEntry.getQName())) == null) continue;
                this.setMessageReferences(messageEntry2, definition, document, false);
            }
        }
    }

    private void setBindingReferences(BindingEntry bindingEntry, Definition definition, Document document) {
        if (bindingEntry.getBindingType() == 0 || bindingEntry.getBindingType() == 4) {
            Map map;
            Binding binding = bindingEntry.getBinding();
            if (this.addImports) {
                bindingEntry.setIsReferenced(true);
            } else {
                map = definition.getBindings();
                if (map.containsValue(binding)) {
                    bindingEntry.setIsReferenced(true);
                }
            }
            map = binding.getPortType();
            PortTypeEntry portTypeEntry = this.getPortTypeEntry(map.getQName());
            if (portTypeEntry != null) {
                this.setPortTypeReferences(portTypeEntry, bindingEntry, definition, document);
            }
        }
    }

    private void setServiceReferences(ServiceEntry serviceEntry, Definition definition, Document document) {
        Object object;
        Service service = serviceEntry.getService();
        if (this.addImports) {
            serviceEntry.setIsReferenced(true);
        } else {
            object = definition.getServices();
            if (object.containsValue(service)) {
                serviceEntry.setIsReferenced(true);
            }
        }
        object = service.getPorts().values().iterator();
        while (object.hasNext()) {
            Port port2 = (Port)object.next();
            Binding binding = port2.getBinding();
            BindingEntry bindingEntry = this.getBindingEntry(binding.getQName());
            if (bindingEntry == null) continue;
            this.setBindingReferences(bindingEntry, definition, document);
        }
    }

    private void symbolTablePut(SymTabEntry symTabEntry) throws IOException {
        QName qName = symTabEntry.getQName();
        if (this.get(qName, symTabEntry.getClass()) == null) {
            if (symTabEntry instanceof Type && this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.UndefinedType")) : class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType) != null) {
                if (((Type)this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.UndefinedType")) : class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedType)).isSimpleType() && !((Type)symTabEntry).isSimpleType()) {
                    throw new IOException(Messages.getMessage("AttrNotSimpleType01", qName.toString()));
                }
                Vector vector = (Vector)this.symbolTable.get(qName);
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (!(e instanceof UndefinedType)) continue;
                    vector.setElementAt(symTabEntry, i);
                    for (int j = 0; j < this.types.size(); ++j) {
                        if (this.types.elementAt(j) != e) continue;
                        this.types.setElementAt(symTabEntry, j);
                    }
                    ((UndefinedType)e).update((Type)symTabEntry);
                }
            } else if (symTabEntry instanceof Element && this.get(qName, class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedElement == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedElement = SymbolTable.class$("com.ibm.ws.webservices.wsdl.symbolTable.UndefinedElement")) : class$com$ibm$ws$webservices$wsdl$symbolTable$UndefinedElement) != null) {
                Vector vector = (Vector)this.symbolTable.get(qName);
                for (int i = 0; i < vector.size(); ++i) {
                    Object e = vector.elementAt(i);
                    if (!(e instanceof UndefinedElement)) continue;
                    vector.setElementAt(symTabEntry, i);
                    for (int j = 0; j < this.types.size(); ++j) {
                        if (this.types.elementAt(j) != e) continue;
                        this.types.setElementAt(symTabEntry, j);
                    }
                    ((Undefined)e).update((Element)symTabEntry);
                }
            } else {
                Vector<SymTabEntry> vector = (Vector<SymTabEntry>)this.symbolTable.get(qName);
                if (vector == null) {
                    vector = new Vector<SymTabEntry>();
                    this.symbolTable.put(qName, vector);
                }
                vector.add(symTabEntry);
                if (symTabEntry instanceof TypeEntry) {
                    this.types.add(symTabEntry);
                }
            }
        } else {
            this.env.report(Messages.getMessage("alreadyExists00", "" + qName));
        }
    }

    public void addTypeEntry(TypeEntry typeEntry) {
        Vector<TypeEntry> vector = (Vector<TypeEntry>)this.symbolTable.get(typeEntry.getQName());
        if (vector == null) {
            vector = new Vector<TypeEntry>();
            this.symbolTable.put(typeEntry.getQName(), vector);
        }
        vector.add(typeEntry);
        this.types.add(typeEntry);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

