/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Undefined;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public abstract class TypeEntry
extends SymTabEntry
implements Serializable {
    protected Node node;
    protected List nodeStack;
    protected TypeEntry refType;
    protected String dims = "";
    protected boolean undefined;
    protected boolean onlyWrappedLiteralReferenced = false;
    private boolean isAbstract = false;

    protected TypeEntry(QName qName, Node node, List list) {
        super(qName);
        this.node = node;
        this.nodeStack = list;
        this.refType = null;
        this.undefined = false;
        this.dims = "";
    }

    public void setRefType(TypeEntry typeEntry, String string) {
        this.undefined = typeEntry.undefined;
        this.refType = typeEntry;
        if (string == null) {
            string = "";
        }
        this.dims = string;
        if (typeEntry.undefined) {
            TypeEntry typeEntry2 = typeEntry;
            while (!(typeEntry2 instanceof Undefined)) {
                typeEntry2 = typeEntry2.refType;
            }
            ((Undefined)((Object)typeEntry2)).register(this);
        }
    }

    public Node getNode() {
        return this.node;
    }

    public List getNodeStack() {
        return this.nodeStack;
    }

    public boolean isOnlyWrappedLiteralReferenced() {
        return this.onlyWrappedLiteralReferenced;
    }

    void setOnlyWrappedLiteralReference(boolean bl) {
        this.onlyWrappedLiteralReferenced = bl;
    }

    protected TypeEntry getUndefinedTypeRef() {
        if (this instanceof Undefined) {
            return this;
        }
        if (this.undefined && this.refType != null && this.refType.undefined) {
            TypeEntry typeEntry = this.refType;
            while (!(typeEntry instanceof Undefined)) {
                typeEntry = typeEntry.refType;
            }
            return typeEntry;
        }
        return null;
    }

    protected boolean updateUndefined(TypeEntry typeEntry, TypeEntry typeEntry2) throws IOException {
        boolean bl = false;
        if (this.refType == typeEntry) {
            this.refType = typeEntry2;
            bl = true;
            TypeEntry typeEntry3 = this.refType;
            while (typeEntry3 != null && typeEntry3 != this) {
                typeEntry3 = typeEntry3.refType;
            }
            if (typeEntry3 == this) {
                this.undefined = false;
                this.node = null;
                throw new IOException(Messages.getMessage("undefinedloop00", this.getQName().toString()));
            }
        }
        if (this.refType != null && this.undefined && !this.refType.undefined) {
            this.undefined = false;
            bl = true;
        }
        return bl;
    }

    public TypeEntry getRefType() {
        return this.refType;
    }

    public String getDimensions() {
        return this.dims;
    }

    public boolean isBaseType() {
        if (this.dims.length() > 0) {
            return false;
        }
        if (this.refType != null) {
            return this.refType.isBaseType();
        }
        return this.node == null;
    }

    public boolean isCollectionTypeEntry() {
        return this.qname.getLocalPart().indexOf(93) > 0;
    }

    void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        String string2 = string + "RefType:       null \n";
        if (this.refType != null) {
            string2 = string + "RefType:\n" + this.refType.toString(string + "  ") + "\n";
        }
        return super.toString(string) + string + "Class:         " + this.getClass().getName() + "\n" + string + "Undefined?:    " + this.undefined + "\n" + string + "isBaseType     " + this.isBaseType() + "\n" + string + "Node:          " + this.getNode() + "\n" + string + "NodeStack:     " + this.getNodeStack() + "\n" + string + "Dims:          " + this.dims + "\n" + string + "isAbstract     " + this.isAbstract + "\n" + string + "OnlyWrappedLitRef " + this.onlyWrappedLiteralReferenced + "\n" + string2;
    }
}

