/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.DefinedType;
import com.ibm.ws.webservices.wsdl.symbolTable.SchemaUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.BooleanHolder;
import org.apache.commons.logging.Log;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    protected static Log log = LogFactory.getLog("com.ibm.ws.webservices.wsdl.symbolTable.Utils");

    public static QName getNillableQName(QName qName) {
        QName qName2 = qName;
        if (Constants.isSchemaXSD(qName2.getNamespaceURI())) {
            String string = qName2.getLocalPart();
            if (string.equals("int") || string.equals("long") || string.equals("short") || string.equals("float") || string.equals("double") || string.equals("boolean") || string.equals("byte")) {
                qName2 = QNameTable.createQName(Constants.URI_DEFAULT_SOAP_ENC, qName.getLocalPart());
            } else if (string.equals("base64Binary")) {
                qName2 = QNameTable.createQName(Constants.URI_DEFAULT_SOAP_ENC, "base64");
            } else if (string.equals("hexBinary")) {
                qName2 = QNameTable.createQName("http://www.w3.org/2001/XMLSchema", "hexBinary");
            }
        }
        return qName2;
    }

    public static String getScopedAttribute(Node node, String string, List list) {
        if (node == null) {
            if (list != null && list.size() > 0) {
                node = (Node)list.get(list.size() - 1);
                list = list.subList(0, list.size() - 1);
            } else {
                return null;
            }
        }
        if (node.getAttributes() == null) {
            return Utils.getScopedAttribute(node.getParentNode(), string, list);
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return Utils.getScopedAttribute(node.getParentNode(), string, list);
    }

    public static String getAttribute(Node node, String string) {
        if (node == null || node.getAttributes() == null) {
            return null;
        }
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    public static Vector getAttributesWithLocalName(Node node, String string) {
        Vector<Node> vector = new Vector<Node>();
        if (node == null) {
            return vector;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null || !node2.getLocalName().equals(string)) continue;
                vector.add(node2);
            }
        }
        return vector;
    }

    public static QName getNodeQName(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getLocalName();
        if (string == null) {
            return null;
        }
        String string2 = node.getNamespaceURI();
        return QNameTable.createQName(string2, string);
    }

    public static QName getNodeNameQName(Node node, List list) {
        Object object;
        if (node == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        string = Utils.getAttribute(node, "name");
        if (string == null && (object = Utils.getTypeQNameFromAttr(node, "ref", list)) != null) {
            string = ((QName)object).getLocalPart();
            string2 = ((QName)object).getNamespaceURI();
        }
        if (string == null) {
            string = "";
            object = node.getParentNode();
            while (object != null) {
                QName qName = Utils.getNodeQName((Node)object);
                if (qName.getLocalPart().equals("schema")) {
                    object = null;
                    continue;
                }
                if (qName.getLocalPart().equals("element") || qName.getLocalPart().equals("attribute")) {
                    string = ">" + Utils.getNodeNameQName((Node)object, list).getLocalPart();
                    object = object.getParentNode();
                    continue;
                }
                if (qName.getLocalPart().equals("complexType") || qName.getLocalPart().equals("simpleType")) {
                    string = Utils.getNodeNameQName((Node)object, list).getLocalPart() + string;
                    object = null;
                    continue;
                }
                object = object.getParentNode();
            }
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = Utils.getScopedAttribute(node, "targetNamespace", list);
        }
        return QNameTable.createQName(string2, string);
    }

    public static QName getTypeQName(Node node, BooleanHolder booleanHolder, boolean bl, List list) {
        if (node == null) {
            return null;
        }
        booleanHolder.value = false;
        QName qName = Utils.getTypeQNameFromAttr(node, "type", list);
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "ref", list);
            if (qName == null && Utils.getNodeQName(node).equals(Constants.XSD_ANY)) {
                qName = Constants.XSD_ANY;
                return qName;
            }
        }
        if (!bl && qName != null) {
            String string = Utils.getAttribute(node, "maxOccurs");
            String string2 = Utils.getAttribute(node, "minOccurs");
            if (string == null) {
                string = "1";
            }
            if (string2 == null) {
                string2 = "1";
            }
            if (string2.equals("0") && string.equals("1")) {
                qName = Utils.getNillableQName(qName);
            } else if (!string.equals("1") || !string2.equals("1")) {
                String string3 = qName.getLocalPart();
                string3 = string3 + "[" + string + "]";
                qName = QNameTable.createQName(qName.getNamespaceURI(), string3);
            }
        }
        if (qName == null) {
            booleanHolder.value = true;
            qName = Utils.getTypeQNameFromAttr(node, "element", list);
        }
        if (qName == null) {
            booleanHolder.value = false;
            qName = Utils.getTypeQNameFromAttr(node, "base", list);
        }
        return qName;
    }

    private static QName getTypeQNameFromAttr(Node node, String string, List list) {
        QName qName;
        if (node == null) {
            return null;
        }
        String string2 = Utils.getAttribute(node, string);
        if (string2 == null && string.equals("type") && Utils.getAttribute(node, "ref") == null && Utils.getAttribute(node, "base") == null && Utils.getAttribute(node, "element") == null) {
            qName = SchemaUtils.getElementAnonQName(node, list);
            if (qName == null) {
                qName = SchemaUtils.getAttributeAnonQName(node, list);
            }
            if (qName != null) {
                return qName;
            }
            QName qName2 = Utils.getNodeQName(node);
            if (qName2 != null && Constants.isSchemaXSD(qName2.getNamespaceURI()) && (qName2.getLocalPart().equals("element") || qName2.getLocalPart().equals("attribute"))) {
                return Constants.XSD_ANYTYPE;
            }
        }
        if (string2 == null) {
            return null;
        }
        qName = Utils.getQNameFromPrefixedName(node, string2, list);
        if (string.equals("type") && JavaUtils.isTrueExplicitly(Utils.getAttribute(node, "nillable"))) {
            qName = Utils.getNillableQName(qName);
        }
        return qName;
    }

    public static QName getQNameFromPrefixedName(Node node, String string, List list) {
        String string2 = string.substring(string.lastIndexOf(":") + 1);
        String string3 = null;
        if (string.length() == string2.length()) {
            string3 = Utils.getScopedAttribute(node, "xmlns", list);
        } else {
            String string4 = string.substring(0, string.lastIndexOf(":"));
            string3 = Utils.getScopedAttribute(node, "xmlns:" + string4, list);
            if (string3 == null && "xml".equals(string4)) {
                string3 = "http://www.w3.org/XML/1998/namespace";
            }
        }
        return QNameTable.createQName(string3, string2);
    }

    public static HashSet getDerivedTypes(TypeEntry typeEntry, SymbolTable symbolTable) {
        HashSet hashSet = new HashSet();
        if (typeEntry != null && typeEntry.getNode() != null) {
            Utils.getDerivedTypes(typeEntry, hashSet, symbolTable);
        } else if (Constants.isSchemaXSD(typeEntry.getQName().getNamespaceURI()) && (typeEntry.getQName().getLocalPart().equals("anyType") || typeEntry.getQName().getLocalPart().equals("any"))) {
            hashSet.addAll(symbolTable.getTypes());
        }
        return hashSet;
    }

    private static void getDerivedTypes(TypeEntry typeEntry, HashSet hashSet, SymbolTable symbolTable) {
        if (hashSet.size() == symbolTable.getTypes().size()) {
            return;
        }
        Vector vector = symbolTable.getTypes();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            TypeEntry typeEntry2 = (TypeEntry)iterator.next();
            if (!(typeEntry2 instanceof DefinedType) || hashSet.contains(typeEntry2) || ((DefinedType)typeEntry2).getExtensionBase() != typeEntry && ((DefinedType)typeEntry2).getRestrictionBase() != typeEntry) continue;
            hashSet.add(typeEntry2);
            Utils.getDerivedTypes(typeEntry2, hashSet, symbolTable);
        }
    }

    public static HashSet getNestedTypes(TypeEntry typeEntry, SymbolTable symbolTable, boolean bl) {
        HashSet hashSet = new HashSet();
        Utils.getNestedTypes(typeEntry, hashSet, symbolTable, bl);
        return hashSet;
    }

    private static void getNestedTypes(TypeEntry typeEntry, HashSet hashSet, SymbolTable symbolTable, boolean bl) {
        Object object;
        Object object2;
        if (typeEntry == null) {
            return;
        }
        if (hashSet.size() == symbolTable.getTypes().size()) {
            return;
        }
        if (bl) {
            object2 = Utils.getDerivedTypes(typeEntry, symbolTable);
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                TypeEntry typeEntry2 = (TypeEntry)object.next();
                if (hashSet.contains(typeEntry2)) continue;
                hashSet.add(typeEntry2);
                Utils.getNestedTypes(typeEntry2, hashSet, symbolTable, bl);
            }
        }
        if (typeEntry.getNode() == null) {
            return;
        }
        object2 = typeEntry.getNode();
        object = null;
        if (typeEntry instanceof Type) {
            object = ((Type)typeEntry).getChildren();
        }
        if (object != null) {
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                ChildEntry childEntry;
                if (((Vector)object).get(i) instanceof ChildElement && !hashSet.contains((childEntry = (ChildElement)((Vector)object).get(i)).getType())) {
                    hashSet.add(childEntry.getType());
                    Utils.getNestedTypes(childEntry.getType(), hashSet, symbolTable, bl);
                }
                if (!(((Vector)object).get(i) instanceof ChildAttribute) || hashSet.contains((childEntry = (ChildAttribute)((Vector)object).get(i)).getType())) continue;
                hashSet.add(childEntry.getType());
                Utils.getNestedTypes(childEntry.getType(), hashSet, symbolTable, bl);
            }
        }
        if (typeEntry.getRefType() != null && !hashSet.contains(typeEntry.getRefType())) {
            hashSet.add(typeEntry.getRefType());
            Utils.getNestedTypes(typeEntry.getRefType(), hashSet, symbolTable, bl);
        }
        Type type = null;
        if (typeEntry instanceof Type && (type = ((Type)typeEntry).getExtensionBase()) == null) {
            type = ((Type)typeEntry).getRestrictionBase();
        }
        if (type != null && !hashSet.contains(type)) {
            hashSet.add(type);
            Utils.getNestedTypes(type, hashSet, symbolTable, bl);
        }
    }

    public static String genQNameAttributeString(QName qName, String string) {
        if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
            return qName.getLocalPart();
        }
        return string + ":" + qName.getLocalPart() + "\" xmlns:" + string + "=\"" + qName.getNamespaceURI();
    }

    public static boolean isSimpleSchemaType(QName qName) {
        return SchemaUtils.isSimpleSchemaType(qName);
    }

    public static URL getURL(URL uRL, String string) throws IOException {
        String string2 = string.replace('\\', '/');
        URL uRL2 = null;
        try {
            uRL2 = new URL(uRL, string2);
            if (uRL != null && uRL2.getProtocol().equals("file") && uRL.getProtocol().equals("file")) {
                uRL2 = Utils.getFileURL(uRL, string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            log.debug((Object)("Exception Logged: url contained no valid protocol information: " + malformedURLException.getMessage()));
            uRL2 = Utils.getFileURL(uRL, string2);
        }
        return uRL2;
    }

    private static URL getFileURL(URL uRL, String string) throws IOException {
        String string2;
        File file;
        if (uRL != null && (file = new File(string2 = uRL.getFile())) != null) {
            return new URL(file.toURL(), string);
        }
        return new URL("file", "", string);
    }
}

