/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.protocol.Protocols;
import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.encoding.DefaultSOAP12TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.enum.Scope;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.tools.resource.DefaultToolEnv;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.Parser;
import com.ibm.ws.webservices.wsdl.mapping.MappingMetaData;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.GeneratedFileInfo;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Namespaces;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Emitter
extends Parser {
    private static String binaryCopyright = Version.getBinaryCopyright();
    protected HashMap namespaceMap = new HashMap();
    protected String typeMappingVersion = "1.1";
    protected BaseTypeMapping baseTypeMapping = null;
    protected Namespaces namespaces = null;
    protected String NStoPkgFilename = "NStoPkg.properties";
    protected File NStoPkgFile = null;
    MappingMetaData inputMMD = null;
    MappingMetaData outputMMD = null;
    private String inputMappingFile = null;
    private String altOutputMappingFile = null;
    private Role role = Role.DEVELOP_CLIENT;
    private Container container = Container.NONE;
    private GenCriteria genJava = GenCriteria.IFNOTEXISTS;
    private GenCriteria genXML = GenCriteria.IFNOTEXISTS;
    private boolean bEmitTestCase = false;
    private boolean bResolver = false;
    private boolean bGenerateAll = false;
    private Scope scope = null;
    private GeneratedFileInfo fileInfo = null;
    private HashMap delayedNamespacesMap = new HashMap();
    private String outputDir = null;
    private String javaOutputDir = null;
    private boolean noDataBinding = false;
    private boolean noWrappedOperations = false;
    private HashMap dynamicVars = new HashMap();

    public Emitter() {
        this.outputMMD = new MappingMetaData();
        this.fileInfo = new GeneratedFileInfo();
        this.setFactory(new JavaGeneratorFactory(this));
    }

    public Emitter(boolean bl) {
        if (!bl) {
            this.outputMMD = new MappingMetaData();
            this.fileInfo = new GeneratedFileInfo();
            this.setFactory(new JavaGeneratorFactory(this));
        }
    }

    public Object getDynamicVar(Object object) {
        return this.dynamicVars.get(object);
    }

    public void setDynamicVar(Object object, Object object2) {
        this.dynamicVars.put(object, object2);
    }

    public void setMETA_INF_Only(boolean bl) {
        if (bl) {
            this.setGenJava("No");
            this.setGenXML("IfNotExists");
        }
    }

    public boolean getMETA_INF_Only() {
        return this.getGenJava() == GenCriteria.NO && this.getGenXML() == GenCriteria.IFNOTEXISTS;
    }

    public void setTestCaseWanted(boolean bl) {
        this.bEmitTestCase = bl;
    }

    public boolean isTestCaseWanted() {
        return this.bEmitTestCase;
    }

    public void setGenerateResolver(boolean bl) {
        if (this.getResolver() == null) {
            this.bResolver = bl;
        }
    }

    public boolean generateResolver() {
        return this.bResolver;
    }

    public void setResolver(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!this.bResolver) {
            super.setResolver(string);
        }
    }

    public void setAllWanted(boolean bl) {
        this.bGenerateAll = bl;
    }

    public boolean isAllWanted() {
        return this.bGenerateAll;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public void setJavaOutputDir(String string) {
        this.javaOutputDir = string;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getJavaOutputDir() {
        if (this.javaOutputDir != null) {
            return this.javaOutputDir;
        }
        return this.outputDir;
    }

    public void setNoDataBinding(boolean bl) {
        this.noDataBinding = bl;
    }

    public boolean getNoDataBinding() {
        return this.noDataBinding;
    }

    public void setNoWrappedOperations(boolean bl) {
        this.noWrappedOperations = bl;
    }

    public boolean getNoWrappedOperations() {
        return this.noWrappedOperations;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setNStoPkg(String string) {
        if (string != null) {
            this.NStoPkgFilename = string;
        }
    }

    public void setNStoPkg(File file) {
        this.NStoPkgFile = file;
    }

    public void setNamespaceMap(HashMap hashMap) {
        this.delayedNamespacesMap = hashMap;
    }

    public HashMap getNamespaceMap() {
        return this.delayedNamespacesMap;
    }

    public void setFactory(String string) {
        try {
            this.setFactory((GeneratorFactory)ClassUtils.forName(string).newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean setContainer(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (string.equalsIgnoreCase("Bean") || string.equalsIgnoreCase("servlet")) {
            string = "WEB";
        }
        boolean bl = Container.isValid(string);
        this.container = Container.getContainer(string, Container.NONE);
        return bl;
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean setRole(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = Role.isValid(string);
        this.role = Role.getRole(string, Role.DEVELOP_CLIENT);
        return bl;
    }

    public Role getRole() {
        return this.role;
    }

    public boolean setGenJava(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = GenCriteria.isValid(string);
        this.genJava = GenCriteria.getGenCriteria(string, GenCriteria.IFNOTEXISTS);
        return bl;
    }

    public GenCriteria getGenJava() {
        return this.genJava;
    }

    public boolean setGenXML(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        boolean bl = GenCriteria.isValid(string);
        this.genXML = GenCriteria.getGenCriteria(string, GenCriteria.IFNOTEXISTS);
        return bl;
    }

    public GenCriteria getGenXML() {
        return this.genXML;
    }

    public void setInputMappingFile(String string) {
        if (string != null && string.length() > 0) {
            this.inputMappingFile = string;
        }
    }

    public void setInputMapping(MappingMetaData mappingMetaData) {
        this.inputMMD = mappingMetaData;
    }

    public void setAltOutputMappingFile(String string) {
        if (string != null && string.length() > 0) {
            this.altOutputMappingFile = string;
        }
    }

    public String getAltOutputMappingFile() {
        return this.altOutputMappingFile;
    }

    public GeneratedFileInfo getGeneratedFileInfo() {
        return this.fileInfo;
    }

    public List getGeneratedClassNames() {
        return this.fileInfo.getClassNames();
    }

    public List getGeneratedFileNames() {
        return this.fileInfo.getFileNames();
    }

    public String getPackage(String string) {
        return this.namespaces.getCreate(string);
    }

    public String getPackage(QName qName) {
        return this.getPackage(qName.getNamespaceURI());
    }

    public String getJavaName(QName qName) {
        if (qName.getLocalPart().indexOf("[") > 0) {
            String string = qName.getLocalPart().substring(0, qName.getLocalPart().indexOf("["));
            QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), string);
            return this.getJavaName(qName2) + "[]";
        }
        if (qName.getNamespaceURI().equalsIgnoreCase("java")) {
            return qName.getLocalPart();
        }
        String string = this.getFactory().getBaseTypeMapping().getBaseName(qName);
        if (string != null) {
            return string;
        }
        if (this.noDataBinding) {
            return "javax.xml.soap.SOAPElement";
        }
        String string2 = this.getPackage(qName.getNamespaceURI());
        string = string2 != null ? string2 + "." + JavaUtils.xmlNameToJavaClass(qName.getLocalPart()) : JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        return string;
    }

    public void run(String string) throws Exception {
        this.setup();
        super.run(string);
    }

    public void run(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup();
        super.run(string, document);
    }

    public void run(String string, Document document, Definition definition) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup();
        super.run(string, document, definition);
    }

    private void setup() throws IOException {
        if (!(this.getRole() != Role.DEVELOP_SERVER && this.getRole() != Role.SERVER || this.getContainer() != Container.CLIENT && this.getContainer() != Container.NONE)) {
            this.getToolEnv().report(Messages.getMessage("badRoleContainer00"));
            this.container = Container.WEB;
        }
        if (this.env == null) {
            this.env = DefaultToolEnv.create();
        }
        if (this.baseTypeMapping == null) {
            this.setTypeMappingVersion(this.typeMappingVersion);
        }
        this.getFactory().setBaseTypeMapping(this.baseTypeMapping);
        this.namespaces = new Namespaces(this.getJavaOutputDir(), this.env);
        this.getNStoPkgFromPropsFile(this.namespaces);
        if (this.delayedNamespacesMap != null) {
            this.namespaces.putAll((Map)this.delayedNamespacesMap);
        }
        if (this.inputMappingFile != null) {
            this.inputMMD = MappingMetaData.loadFromFile(this.inputMappingFile, this.getToolEnv());
        }
        if (this.inputMMD != null) {
            this.namespaces.putAll((Map)this.inputMMD.getPackageMappings());
            this.inputMMD.preSymbolTable(this.metaInfo);
        }
        if (this.getNoDataBinding()) {
            this.metaInfo.setProperty("noDataBinding", Boolean.TRUE);
        }
        if (this.getNoWrappedOperations()) {
            this.metaInfo.setProperty("noWrappedOperations", Boolean.TRUE);
        }
    }

    private void getNStoPkgFromPropsFile(HashMap hashMap) {
        try {
            Properties properties = new Properties();
            if (this.NStoPkgFile != null) {
                properties.load(new FileInputStream(this.NStoPkgFile));
            } else {
                properties.load(this.env.getInputStream(this.NStoPkgFilename));
            }
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                try {
                    String string = (String)enumeration.nextElement();
                    hashMap.put(string, properties.getProperty(string));
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setTypeMappingVersion(String string) {
        this.baseTypeMapping = string.equals("1.1") ? new BaseTypeMapping(){
            final TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

            public String getBaseName(QName qName) {
                QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
                Class clazz = this.defaultTM.getClassForQName(qName2);
                if (clazz == null) {
                    return null;
                }
                if (!Emitter.this.noDataBinding) {
                    return JavaUtils.getTextClassName(clazz.getName());
                }
                return "javax.xml.soap.SOAPElement";
            }
        } : new BaseTypeMapping(){
            final TypeMapping defaultTM = DefaultSOAP12TypeMappingImpl.create();

            public String getBaseName(QName qName) {
                QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
                Class clazz = this.defaultTM.getClassForQName(qName2);
                if (clazz == null) {
                    return null;
                }
                if (!Emitter.this.noDataBinding) {
                    return JavaUtils.getTextClassName(clazz.getName());
                }
                return "javax.xml.soap.SOAPElement";
            }
        };
    }

    public GeneratorFactory getWriterFactory() {
        return this.getFactory();
    }

    public void emit(String string) throws Exception {
        this.run(string);
    }

    public void emit(String string, Document document) throws IOException, SAXException, WSDLException, ParserConfigurationException {
        this.run(string, document);
    }

    public void debug(boolean bl) {
        this.setDebug(bl);
    }

    public boolean getDebug() {
        return this.isDebug();
    }

    public void verbose(boolean bl) {
        this.setVerbose(bl);
    }

    public boolean getVerbose() {
        return this.isVerbose();
    }

    public void generateTestCase(boolean bl) {
        this.setTestCaseWanted(bl);
    }

    public void generateAll(boolean bl) {
        this.setAllWanted(bl);
    }

    static {
        Protocols.init();
    }
}

