/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.Node;

public class JavaBeanWriter
extends JavaClassWriter {
    protected Type type;
    private Type extendType;
    private Type baseSimpleType = null;
    protected PrintWriter pw;
    private Vector children;
    protected boolean enableDefaultConstructor = true;
    protected boolean enableFullConstructor = false;
    protected boolean enableSimpleConstructors = false;
    protected boolean enableToString = false;
    protected boolean enableSetters = true;
    protected boolean enableGetters = true;
    protected boolean enableEquals = true;
    protected boolean enableHashCode = true;

    protected JavaBeanWriter(Emitter emitter, Type type) {
        this(emitter, type, type.getName(), "complexType");
    }

    protected JavaBeanWriter(Emitter emitter, Type type, String string, String string2) {
        super(emitter, string, string2);
        this.type = type;
        this.children = type.getChildren();
        if (this.children == null) {
            this.children = new Vector();
        }
        this.extendType = type.getExtensionBase();
        if (this.extendType == null) {
            this.extendType = type.getRestrictionBase();
        }
        if (type.isSimpleType()) {
            this.enableSimpleConstructors = true;
            this.enableToString = true;
            if (this.extendType != null) {
                this.baseSimpleType = this.extendType;
                while (this.baseSimpleType.getRestrictionBase() != null || this.baseSimpleType.getExtensionBase() != null) {
                    if (this.baseSimpleType.getRestrictionBase() != null) {
                        this.baseSimpleType = this.baseSimpleType.getRestrictionBase();
                        continue;
                    }
                    this.baseSimpleType = this.baseSimpleType.getExtensionBase();
                }
            }
        }
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        this.pw = printWriter;
        this.writeMemberFields();
        if (this.enableDefaultConstructor) {
            this.writeDefaultConstructor();
        }
        if (this.enableFullConstructor) {
            this.writeFullConstructor();
        }
        if (this.enableSimpleConstructors) {
            this.writeSimpleConstructors();
        }
        if (this.enableToString) {
            this.writeToStringMethod();
        }
        this.writeAccessMethods();
        if (this.enableEquals) {
            this.writeEqualsMethod();
        }
        if (this.enableHashCode) {
            this.writeHashCodeMethod();
        }
    }

    protected String getClassModifiers() {
        Node node = this.type.getNode();
        if (node != null && this.type.isAbstract()) {
            return super.getClassModifiers() + "abstract ";
        }
        return super.getClassModifiers();
    }

    protected String getExtendsText() {
        String string = "";
        if (!this.isBaseClass()) {
            string = " extends " + this.extendType.getName() + " ";
        }
        return string;
    }

    protected String getImplementsText() {
        String string = " implements java.io.Serializable";
        if (this.type.isSimpleType()) {
            string = string + ", com.ibm.ws.webservices.engine.encoding.SimpleType";
        }
        string = string + " ";
        return string;
    }

    protected void writeMemberFields() {
        for (int i = 0; i < this.children.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)this.children.get(i);
            String string = "private";
            if (JavaBeanWriter.isDataMember(childEntry)) {
                string = "public";
            }
            this.pw.print("    " + string + " " + childEntry.getType().getName() + " " + childEntry.getName() + ";");
            if (childEntry instanceof ChildAttribute) {
                this.pw.println("  // attribute");
                continue;
            }
            this.pw.println();
        }
        this.pw.println();
    }

    protected void writeDefaultConstructor() {
        this.pw.println("    public " + this.className + "() {");
        this.pw.println("    }");
        this.pw.println();
    }

    protected void writeFullConstructor() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.getTypesAndNames(this.type, vector, vector2, false, true, false);
        if (vector.size() > 0) {
            int n;
            Vector vector3;
            this.pw.println("    public " + this.className + "(");
            for (int i = 0; i < vector.size(); ++i) {
                this.pw.print("           " + vector.elementAt(i) + " " + vector2.elementAt(i));
                if (i + 1 < vector.size()) {
                    this.pw.println(",");
                    continue;
                }
                this.pw.println(") {");
            }
            if (this.extendType != null) {
                Vector vector4 = new Vector();
                vector3 = new Vector();
                this.getTypesAndNames(this.extendType, vector4, vector3, true, true, false);
                this.pw.println("        super(");
                for (n = 0; n < vector4.size(); ++n) {
                    this.pw.print("            " + vector3.elementAt(n));
                    if (n + 1 < vector4.size()) {
                        this.pw.println(",");
                        continue;
                    }
                    this.pw.println(");");
                }
            }
            Vector vector5 = new Vector();
            vector3 = new Vector();
            this.getTypesAndNames(this.type, vector5, vector3, false, true, true);
            for (n = 0; n < vector3.size(); ++n) {
                this.pw.println("        this." + vector3.elementAt(n) + " = " + vector3.elementAt(n) + ";");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void getTypesAndNames(Type type, Vector vector, Vector vector2, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        Vector<Type> vector3 = new Vector<Type>();
        if (bl3) {
            vector3.add(type);
        } else {
            serializable = type;
            while (serializable != null) {
                vector3.add((Type)serializable);
                if (((Type)serializable).getExtensionBase() != null) {
                    serializable = ((Type)serializable).getExtensionBase();
                    continue;
                }
                serializable = ((Type)serializable).getRestrictionBase();
            }
        }
        serializable = new HashMap();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = vector3.size() - 1; i >= 0; --i) {
            Object object;
            Type type2 = (Type)vector3.elementAt(i);
            String string = "";
            if (i > 0 && bl2 || i == 0 && bl) {
                object = type2.getName();
                object = ((String)object).substring(((String)object).lastIndexOf(".") + 1);
                string = "_" + (String)object + "_";
            }
            if ((object = type2.getChildren()) == null) continue;
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                ChildEntry childEntry = (ChildEntry)((Vector)object).get(j);
                String string2 = childEntry.getQName().getLocalPart();
                ((HashMap)serializable).put(string2, childEntry.getType().getName());
                hashMap.put(string2, string + childEntry.getName());
            }
        }
        ArrayList arrayList = (ArrayList)type.getDynamicVar("constructorOrder");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (((HashMap)serializable).get(arrayList.get(i)) == null) continue;
            vector.add(((HashMap)serializable).get(arrayList.get(i)));
            vector2.add(hashMap.get(arrayList.get(i)));
        }
    }

    protected void writeSimpleConstructors() {
        if (this.type.isSimpleType() && this.baseSimpleType != null) {
            if (!this.baseSimpleType.getName().equals("java.lang.String")) {
                if (this.extendType != null && this.extendType.isEnumeration()) {
                    this.pw.println("    public " + this.className + "(" + this.baseSimpleType.getName() + " value) {");
                    this.pw.println("        this.value = " + this.extendType.getName() + ".fromValue(value);");
                    this.pw.println("    }");
                    this.pw.println();
                } else {
                    this.pw.println("    public " + this.className + "(" + this.baseSimpleType.getName() + " value) {");
                    if (this.extendType == this.baseSimpleType) {
                        this.pw.println("        this.value = value;");
                    } else {
                        this.pw.println("        super(value);");
                    }
                    this.pw.println("    }");
                    this.pw.println();
                }
            }
            this.pw.println("    // " + Messages.getMessage("needStringCtor"));
            this.pw.println("    public " + this.className + "(java.lang.String value) {");
            if (this.extendType != this.baseSimpleType) {
                if (this.extendType != null && this.extendType.isEnumeration()) {
                    this.pw.println("        this.value = " + this.extendType.getName() + ".fromString(value);");
                } else {
                    this.pw.println("        super(value);");
                }
            } else {
                String string = JavaUtils.getWrapper(this.baseSimpleType.getName());
                if (string != null) {
                    this.pw.println("        this.value = new " + string + "(value)." + this.baseSimpleType.getName() + "Value();");
                } else if (this.baseSimpleType.getName().equals("byte[]")) {
                    this.pw.println("        this.value = com.ibm.ws.webservices.engine.types.HexBinary.decode(value);");
                } else if (this.baseSimpleType.getName().equals("com.ibm.ws.webservices.engine.types.URI")) {
                    this.pw.println("        try {");
                    this.pw.println("            this.value = new com.ibm.ws.webservices.engine.types.URI(value);");
                    this.pw.println("        }");
                    this.pw.println("        catch (com.ibm.ws.webservices.engine.types.URI.MalformedURIException mue) {");
                    this.pw.println("            this.value = new com.ibm.ws.webservices.engine.types.URI();");
                    this.pw.println("       }");
                } else if (this.baseSimpleType.getName().equals("java.util.Date")) {
                    this.pw.println("        try {");
                    this.pw.println("            this.value = (java.text.DateFormat.getDateTimeInstance()).parse(value);");
                    this.pw.println("        }");
                    this.pw.println("        catch (java.text.ParseException e){");
                    this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
                    this.pw.println("        }");
                } else if (this.baseSimpleType.getName().equals("java.util.Calendar")) {
                    this.pw.println("        java.util.Calendar cal = java.util.Calendar.getInstance();");
                    this.pw.println("        try {");
                    this.pw.println("          java.util.Date dt = (java.text.DateFormat.getDateTimeInstance()).parse(value);");
                    this.pw.println("          cal.setTime(dt);");
                    this.pw.println("          this.value = cal;");
                    this.pw.println("        }");
                    this.pw.println("        catch (java.text.ParseException e){");
                    this.pw.println("            throw new java.lang.RuntimeException(e.toString());");
                    this.pw.println("        }");
                } else {
                    this.pw.println("        this.value = new " + this.baseSimpleType.getName() + "(value);");
                }
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeToStringMethod() {
        if (this.type.isSimpleType() && this.isBaseClass()) {
            this.pw.println("    // " + Messages.getMessage("needToString"));
            String string = JavaUtils.getWrapper(this.baseSimpleType.getName());
            this.pw.println("    public java.lang.String toString() {");
            if (!(string == null || this.extendType != null && this.extendType.isEnumeration())) {
                this.pw.println("        return new " + string + "(value).toString();");
            } else if (this.baseSimpleType.getName().equals("byte[]")) {
                this.pw.println("        return value == null ? null : com.ibm.ws.webservices.engine.types.HexBinary.encode(value);");
            } else if (this.baseSimpleType.getName().equals("java.util.Calendar")) {
                this.pw.println("        java.text.DateFormat dateFormat = java.text.DateFormat.getDateTimeInstance();");
                this.pw.println("        java.util.Date date = value.getTime();");
                this.pw.println("        return dateFormat.format(date);");
            } else if (this.baseSimpleType.getName().equals("java.util.Date")) {
                this.pw.println("        java.text.DateFormat dateFormat = java.text.DateFormat.getDateTimeInstance();");
                this.pw.println("        return dateFormat.format(value);");
            } else {
                this.pw.println("        return value == null ? null : value.toString();");
            }
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected void writeAccessMethods() {
        for (int i = 0; i < this.children.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)this.children.get(i);
            if (JavaBeanWriter.isDataMember(childEntry)) continue;
            String string = childEntry.getType().getName();
            String string2 = childEntry.getName();
            if (this.enableGetters) {
                this.pw.println("    public " + string + " " + this.getterMethodName(childEntry.getName(), string) + "() {");
                this.pw.println("        return " + string2 + ";");
                this.pw.println("    }");
                this.pw.println();
            }
            if (this.enableSetters) {
                this.pw.println("    public void " + this.setterMethodName(childEntry.getName(), string) + "(" + string + " " + string2 + ") {");
                this.pw.println("        this." + string2 + " = " + string2 + ";");
                this.pw.println("    }");
                this.pw.println();
            }
            if (!(childEntry instanceof ChildElement) || !childEntry.getType().isCollectionTypeEntry()) continue;
            ChildElement childElement = (ChildElement)childEntry;
            String string3 = string.substring(0, string.lastIndexOf("["));
            if (this.enableGetters) {
                this.pw.println("    public " + string3 + " " + this.getterMethodName(childEntry.getName(), string) + "(int i) {");
                this.pw.println("        return " + string2 + "[i];");
                this.pw.println("    }");
                this.pw.println();
            }
            if (!this.enableSetters) continue;
            this.pw.println("    public void " + this.setterMethodName(childEntry.getName(), string) + "(int i, " + string3 + " value) {");
            this.pw.println("        this." + string2 + "[i] = value;");
            this.pw.println("    }");
            this.pw.println();
        }
    }

    protected String getterMethodName(String string, String string2) {
        String string3 = JavaUtils.capitalizeFirstChar(string);
        String string4 = "get";
        if (string2.equals("boolean")) {
            string4 = "is";
        }
        return string4 + string3;
    }

    protected String setterMethodName(String string, String string2) {
        String string3 = JavaUtils.capitalizeFirstChar(string);
        return "set" + string3;
    }

    protected void writeEqualsMethod() {
        String string;
        String string2;
        String string3;
        String string4;
        ChildEntry childEntry;
        int n;
        boolean bl;
        if (this.isBaseClass()) {
            this.pw.println("    private transient java.lang.ThreadLocal __history;");
        }
        this.pw.println("    public boolean equals(java.lang.Object obj) {");
        this.pw.println("        if (obj == null) { return false; }");
        this.pw.println("        if (obj.getClass() != this.getClass()) { return false;}");
        boolean bl2 = false;
        if (this.children.size() != 0) {
            bl = false;
            for (n = 0; n < this.children.size(); ++n) {
                childEntry = (ChildEntry)this.children.get(n);
                string4 = childEntry.getType().getName();
                string3 = childEntry.getName();
                string2 = "get";
                string = "other." + JavaBeanWriter.readAccess(childEntry);
                if (string4.equals("int") || string4.equals("long") || string4.equals("short") || string4.equals("float") || string4.equals("double") || string4.equals("boolean") || string4.equals("char") || string4.equals("byte")) {
                    if (!bl2) {
                        this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
                        this.pw.println("        boolean _equals;");
                        bl2 = true;
                    }
                    if (!bl) {
                        this.pw.println("        _equals = true");
                        bl = true;
                    } else {
                        this.pw.println("");
                    }
                    this.pw.print("            && this." + string3 + " == " + string);
                    continue;
                }
                if (!string4.startsWith("java.lang.")) continue;
                if (!bl2) {
                    this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
                    this.pw.println("        boolean _equals;");
                    bl2 = true;
                }
                if (!bl) {
                    this.pw.println("        _equals = true");
                    bl = true;
                } else {
                    this.pw.println("");
                }
                if (string4.indexOf("[") >= 0) {
                    this.pw.println("            && ((this." + string3 + "==null && " + string + "==null) || ");
                    this.pw.println("             (this." + string3 + "!=null &&");
                    this.pw.print("              java.util.Arrays.equals(this." + string3 + ", " + string + ")))");
                    continue;
                }
                this.pw.println("            && ((this." + string3 + "==null && " + string + "==null) || ");
                this.pw.println("             (this." + string3 + "!=null &&");
                this.pw.print("              this." + string3 + ".equals(" + string + ")))");
            }
            if (bl) {
                this.pw.println(";");
                this.pw.println("        if (!_equals) { return false; }");
            }
        }
        if (this.isBaseClass()) {
            this.pw.println("        if (__history == null) {");
            this.pw.println("            synchronized (this) {");
            this.pw.println("                if (__history == null) {");
            this.pw.println("                    __history = new java.lang.ThreadLocal();");
            this.pw.println("                }");
            this.pw.println("            }");
            this.pw.println("        }");
            this.pw.println("        " + this.className + " history = (" + this.className + ") __history.get();");
            this.pw.println("        if (history != null) { return (history == obj); }");
            this.pw.println("        if (this == obj) return true;");
            this.pw.println("        __history.set(obj);");
        } else {
            this.pw.println("        if (!super.equals(obj)) { return false; }");
        }
        if (this.children.size() != 0) {
            bl = false;
            for (n = 0; n < this.children.size(); ++n) {
                childEntry = (ChildEntry)this.children.get(n);
                string4 = childEntry.getType().getName();
                string3 = childEntry.getName();
                string2 = "get";
                string = "other." + JavaBeanWriter.readAccess(childEntry);
                if (string4.equals("int") || string4.equals("long") || string4.equals("short") || string4.equals("float") || string4.equals("double") || string4.equals("boolean") || string4.equals("char") || string4.equals("byte") || string4.startsWith("java.lang.")) continue;
                if (!bl2) {
                    this.pw.println("        " + this.className + " other = (" + this.className + ") obj;");
                    this.pw.println("        boolean _equals;");
                    bl2 = true;
                }
                if (!bl) {
                    this.pw.println("        _equals = true");
                    bl = true;
                } else {
                    this.pw.println("");
                }
                if (string4.indexOf("[") >= 0) {
                    this.pw.println("            && ((this." + string3 + "==null && " + string + "==null) || ");
                    this.pw.println("             (this." + string3 + "!=null &&");
                    this.pw.print("              java.util.Arrays.equals(this." + string3 + ", " + string + ")))");
                    continue;
                }
                this.pw.println("            && ((this." + string3 + "==null && " + string + "==null) || ");
                this.pw.println("             (this." + string3 + "!=null &&");
                this.pw.print("              this." + string3 + ".equals(" + string + ")))");
            }
            if (bl) {
                this.pw.println(";");
                this.pw.println("        if (!_equals) {");
                if (this.isBaseClass()) {
                    this.pw.println("            __history.set(null);");
                }
                this.pw.println("            return false;");
                this.pw.println("        };");
            }
        }
        if (this.isBaseClass()) {
            this.pw.println("        __history.set(null);");
        }
        this.pw.println("        return true;");
        this.pw.println("    }");
        this.pw.println("");
    }

    protected void writeHashCodeMethod() {
        if (this.isBaseClass()) {
            this.pw.println("    private transient java.lang.ThreadLocal __hashHistory;");
        }
        this.pw.println("    public int hashCode() {");
        if (this.isBaseClass()) {
            this.pw.println("        if (__hashHistory == null) {");
            this.pw.println("            synchronized (this) {");
            this.pw.println("                if (__hashHistory == null) {");
            this.pw.println("                    __hashHistory = new java.lang.ThreadLocal();");
            this.pw.println("                }");
            this.pw.println("            }");
            this.pw.println("        }");
            this.pw.println("        " + this.className + " history = (" + this.className + ") __hashHistory.get();");
            this.pw.println("        if (history != null) { return 0; }");
            this.pw.println("        __hashHistory.set(this);");
        }
        String string = "1";
        if (!this.isBaseClass()) {
            string = "super.hashCode()";
        }
        this.pw.println("        int _hashCode = " + string + ";");
        for (int i = 0; i < this.children.size(); ++i) {
            ChildEntry childEntry = (ChildEntry)this.children.get(i);
            String string2 = childEntry.getType().getName();
            String string3 = JavaBeanWriter.readAccess(childEntry);
            if (string2.equals("int") || string2.equals("short") || string2.equals("byte")) {
                this.pw.println("        _hashCode += " + string3 + ";");
                continue;
            }
            if (string2.equals("boolean")) {
                this.pw.println("        _hashCode += new Boolean(" + string3 + ").hashCode();");
                continue;
            }
            if (string2.equals("char")) {
                this.pw.println("        _hashCode += new Character(" + string3 + ").hashCode();");
                continue;
            }
            if (string2.equals("long")) {
                this.pw.println("        _hashCode += new Long(" + string3 + ").hashCode();");
                continue;
            }
            if (string2.equals("float")) {
                this.pw.println("        _hashCode += new Float(" + string3 + ").hashCode();");
                continue;
            }
            if (string2.equals("double")) {
                this.pw.println("        _hashCode += new Double(" + string3 + ").hashCode();");
                continue;
            }
            if (string2.indexOf("[") >= 0) {
                this.pw.println("        if (" + string3 + " != null) {");
                this.pw.println("            for (int i=0;");
                this.pw.println("                 i<java.lang.reflect.Array.getLength(" + string3 + ");");
                this.pw.println("                 i++) {");
                this.pw.println("                java.lang.Object obj = java.lang.reflect.Array.get(" + string3 + ", i);");
                this.pw.println("                if (obj != null &&");
                this.pw.println("                    !obj.getClass().isArray()) {");
                this.pw.println("                    _hashCode += obj.hashCode();");
                this.pw.println("                }");
                this.pw.println("            }");
                this.pw.println("        }");
                continue;
            }
            this.pw.println("        if (" + string3 + " != null) {");
            this.pw.println("            _hashCode += " + string3 + ".hashCode();");
            this.pw.println("        }");
        }
        if (this.isBaseClass()) {
            this.pw.println("        __hashHistory.set(null);");
        }
        this.pw.println("        return _hashCode;");
        this.pw.println("    }");
        this.pw.println("");
    }

    static boolean isDataMember(ChildEntry childEntry) {
        Boolean bl = (Boolean)childEntry.getDynamicVar(JavaGeneratorFactory.IS_DATA_MEMBER);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    static String readAccess(ChildEntry childEntry) {
        String string = "";
        if (!JavaBeanWriter.isDataMember(childEntry)) {
            String string2 = JavaUtils.capitalizeFirstChar(childEntry.getName());
            String string3 = "get" + string2;
            if (childEntry.getType().getName().equals("boolean")) {
                string3 = "is" + string2;
            }
            string = string3 + "()";
        } else {
            string = childEntry.getName();
        }
        return string;
    }

    private boolean isBaseClass() {
        return this.extendType == null || this.extendType.isEnumeration() || this.baseSimpleType == this.extendType;
    }
}

