/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.AIRWriter;
import com.ibm.ws.webservices.wsdl.toJava.DuplicateFileException;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GenCriteria;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaFaultHelperWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaFaultWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;

public class JavaDefinitionWriter
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private HashSet importedFiles = new HashSet();

    public JavaDefinitionWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        if (this.emitter.getGenJava() != GenCriteria.NO) {
            this.writeFaults();
            if (this.emitter.generateResolver()) {
                new AIRWriter(this.emitter, this.definition, this.symbolTable).generate();
            }
        }
    }

    private void writeFaults() throws IOException {
        ArrayList arrayList = new ArrayList();
        this.collectFaults(this.definition, arrayList);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            BindingFaultRefEntry bindingFaultRefEntry = (BindingFaultRefEntry)iterator.next();
            MessageEntry messageEntry = bindingFaultRefEntry.getMessageEntry();
            SymTabEntry symTabEntry = (SymTabEntry)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
            String string = symTabEntry.getName();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            Boolean bl = (Boolean)messageEntry.getDynamicVar(JavaGeneratorFactory.COMPLEX_TYPE_FAULT);
            boolean bl2 = messageEntry.isFault() && (bl == null || bl == false);
            if (!bl2) continue;
            try {
                JavaClassWriter javaClassWriter;
                if (this.emitter.getRole() != Role.DEPLOY_CLIENT && this.emitter.getRole() != Role.DEPLOY_SERVER) {
                    javaClassWriter = new JavaFaultWriter(this.emitter, this.symbolTable, messageEntry);
                    javaClassWriter.generate();
                }
                if (this.emitter.getRole() == Role.DEVELOP_CLIENT || this.emitter.getRole() == Role.DEVELOP_SERVER) continue;
                javaClassWriter = new JavaFaultHelperWriter(this.emitter, this.symbolTable, messageEntry);
                javaClassWriter.generate();
            }
            catch (DuplicateFileException duplicateFileException) {
                FFDCFilter.processException((Throwable)duplicateFileException, (String)"com.ibm.ws.webservices.wsdl.toJava.JavaDefinitionWriter.writeFaults", (String)"159", (Object)this);
                System.err.println(Messages.getMessage("fileExistError00", duplicateFileException.getFileName()));
            }
        }
    }

    private void collectFaults(Definition definition, ArrayList arrayList) throws IOException {
        Iterator iterator;
        Object object;
        Object object2;
        Map map = definition.getImports();
        Object[] objectArray = map.values().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = (Vector)objectArray[i];
            for (int j = 0; j < ((Vector)object2).size(); ++j) {
                object = (Import)((Vector)object2).get(j);
                if (this.importedFiles.contains(object.getLocationURI())) continue;
                this.importedFiles.add(object.getLocationURI());
                iterator = object.getDefinition();
                if (iterator == null) continue;
                this.collectFaults((Definition)iterator, arrayList);
            }
        }
        Map map2 = definition.getBindings();
        object2 = map2.values().iterator();
        while (object2.hasNext()) {
            Binding binding = (Binding)object2.next();
            object = this.symbolTable.getBindingEntry(binding.getQName());
            if (!((SymTabEntry)object).isReferenced()) continue;
            iterator = ((BindingEntry)object).getOperations();
            while (iterator.hasNext()) {
                BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
                for (int i = 0; i < bindingOperationEntry.numFaults(); ++i) {
                    arrayList.add(bindingOperationEntry.getFault(i));
                }
            }
        }
    }
}

