/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDTypeMapping;
import com.ibm.ws.webservices.engine.description.OperationDesc;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaStubWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class JavaDeployGenerator
implements Generator {
    protected Emitter emitter;
    protected Definition definition;
    protected SymbolTable symbolTable;
    private Vector typeMappings;
    private Vector operations;
    private HashMap typeMappingsByPort = new HashMap();
    private HashMap operationsByPort = new HashMap();
    public static final String QUERY_TYPEMAPPINGS = "queryTypeMappings";
    public static final String QUERY_OPERATIONS = "queryOperations";

    public JavaDeployGenerator(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    public void generate() throws IOException {
        this.processServices();
    }

    private void processServices() throws IOException {
        Map map = this.definition.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            Iterator iterator2 = service.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                Port port2 = (Port)iterator2.next();
                BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port2.getBinding().getQName());
                if (bindingEntry.getBindingType() != 0) continue;
                this.processPort(port2, service, bindingEntry);
            }
        }
    }

    private void processPort(Port port2, Service service, BindingEntry bindingEntry) throws IOException {
        this.typeMappings = new Vector();
        this.operations = new Vector();
        PortType portType = bindingEntry.getBinding().getPortType();
        String string = port2.getName();
        this.typeMappingsByPort.put(string, this.typeMappings);
        this.operationsByPort.put(string, this.operations);
        this.emitter.setDynamicVar(QUERY_TYPEMAPPINGS, this.typeMappingsByPort);
        this.emitter.setDynamicVar(QUERY_OPERATIONS, this.operationsByPort);
        this.processTypes(bindingEntry);
        this.processBinding(bindingEntry);
    }

    private void processTypes(BindingEntry bindingEntry) throws IOException {
        Vector vector = this.symbolTable.getTypes();
        Binding binding = bindingEntry.getBinding();
        if (Utils.hasMIME(bindingEntry)) {
            QName qName = binding.getQName();
            this.generateTypeMapping(qName.getNamespaceURI(), "DataHandler", "javax.activation.DataHandler", "com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializerFactory", "com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializerFactory", Constants.URI_DEFAULT_SOAP_ENC);
        }
        for (int i = 0; i < vector.size(); ++i) {
            TypeEntry typeEntry = (TypeEntry)vector.elementAt(i);
            if (!JavaStubWriter.needTypeMapping(typeEntry, this.emitter)) continue;
            Type type = (Type)typeEntry;
            String string = type.getQName().getNamespaceURI();
            String string2 = type.getQName().getLocalPart();
            String string3 = JavaStubWriter.getSerializerFactoryName(type);
            String string4 = JavaStubWriter.getDeserializerFactoryName(type);
            String string5 = "";
            if (!bindingEntry.hasLiteral()) {
                string5 = Constants.URI_DEFAULT_SOAP_ENC;
            }
            this.generateTypeMapping(string, string2, type.getName(), string3, string4, string5);
        }
    }

    private void generateTypeMapping(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        WSDDTypeMapping wSDDTypeMapping = new WSDDTypeMapping();
        wSDDTypeMapping.setEncodingStyle(string6);
        wSDDTypeMapping.setLanguageSpecificType(string3);
        wSDDTypeMapping.setQName(new QName(string, string2));
        wSDDTypeMapping.setSerializer(string4);
        wSDDTypeMapping.setDeserializer(string5);
        this.typeMappings.add(wSDDTypeMapping);
    }

    private void processBinding(BindingEntry bindingEntry) throws IOException {
        Binding binding = bindingEntry.getBinding();
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext()) {
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE || bindingOperationEntry == null) continue;
            this.processOperation(bindingEntry, bindingOperationEntry);
        }
    }

    private void processOperation(BindingEntry bindingEntry, BindingOperationEntry bindingOperationEntry) {
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, bindingEntry, this.symbolTable);
        OperationDesc operationDesc = operationDescBuilder.getOperationDesc(false);
        this.operations.add(operationDesc);
    }

    private String getModeString(byte by) {
        if (by == 1) {
            return "IN";
        }
        if (by == 3) {
            return "INOUT";
        }
        return "OUT";
    }
}

