/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.encoding.DefaultTypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.Messages;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.wsdl.Generator;
import com.ibm.ws.webservices.wsdl.GeneratorFactory;
import com.ibm.ws.webservices.wsdl.NoopGenerator;
import com.ibm.ws.webservices.wsdl.symbolTable.BaseTypeMapping;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildAttribute;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildElement;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildEnumValueEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.PortTypeEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.GeneratorTable;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;

public class JavaGeneratorFactory
implements GeneratorFactory {
    protected Emitter emitter;
    protected GeneratorTable genTable = new GeneratorTable();
    protected static NoopGenerator noGenerator = new NoopGenerator();
    public static String INTERFACE_NAME = "interface name";
    public static String IMPL_NAME = "implName";
    public static String SIGNATURE = "signature";
    public static String COMPLEX_TYPE_FAULT = "ComplexTypeFault";
    public static String EXCEPTION_SYMTAB_ENTRY = "ExceptionSymTabEntry";
    public static String IS_DATA_MEMBER = "isDataMember";
    public static final String HOLDER_NAME = "HolderName";
    public static final String OLD_NAME = "oldName";
    public static final String PARAM_SIG_TYPE = "parameterSignatureType";
    public static final String PARAM_TYPE = "parameterType";
    public static final String PARAM_WIRE_QNAME = "parameterWireQName";
    public static final String CONSTRUCTOR_ORDER = "constructorOrder";
    public static final String ANON_TYPE_PREPEND = "anonTypePrepend";
    BaseTypeMapping btm = null;
    static /* synthetic */ Class class$javax$wsdl$Binding;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$JavaBindingWriter;
    static /* synthetic */ Class class$javax$wsdl$Service;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$JavaServiceWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$JavaTypeWriter;
    static /* synthetic */ Class class$javax$wsdl$Definition;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$JavaDefinitionWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesClientWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientBndWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientExtWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesBndWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesExtWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$XMLMappingWriter;
    static /* synthetic */ Class class$com$ibm$ws$webservices$wsdl$toJava$JavaDeployGenerator;
    static /* synthetic */ Class class$javax$wsdl$Message;
    static /* synthetic */ Class class$javax$wsdl$PortType;

    public JavaGeneratorFactory() {
        this.addGenerators();
    }

    public JavaGeneratorFactory(Emitter emitter) {
        this.setEmitter(emitter);
        this.addGenerators();
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public void addGenerator(Class clazz, Class clazz2) {
        this.genTable.addGenerator(clazz, clazz2);
    }

    public void removeGenerator(Class clazz, Class clazz2) {
        this.genTable.removeGenerator(clazz, clazz2);
    }

    public void removeAllGenerators() {
        this.genTable.clear();
    }

    public Iterator getGenerators(Class clazz) {
        return this.genTable.getGenerators(clazz);
    }

    private void addGenerators() {
        this.addMessageGenerators();
        this.addPortTypeGenerators();
        this.addBindingGenerators();
        this.addServiceGenerators();
        this.addTypeGenerators();
        this.addDefinitionGenerators();
    }

    private void addMessageGenerators() {
    }

    private void addPortTypeGenerators() {
    }

    private void addBindingGenerators() {
        this.genTable.addGenerator(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = JavaGeneratorFactory.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, class$com$ibm$ws$webservices$wsdl$toJava$JavaBindingWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$JavaBindingWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.JavaBindingWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$JavaBindingWriter);
    }

    private void addServiceGenerators() {
        this.genTable.addGenerator(class$javax$wsdl$Service == null ? (class$javax$wsdl$Service = JavaGeneratorFactory.class$("javax.wsdl.Service")) : class$javax$wsdl$Service, class$com$ibm$ws$webservices$wsdl$toJava$JavaServiceWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$JavaServiceWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.JavaServiceWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$JavaServiceWriter);
    }

    private void addTypeGenerators() {
        this.genTable.addGenerator(class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry")) : class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry, class$com$ibm$ws$webservices$wsdl$toJava$JavaTypeWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$JavaTypeWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.JavaTypeWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$JavaTypeWriter);
    }

    private void addDefinitionGenerators() {
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$JavaDefinitionWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$JavaDefinitionWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.JavaDefinitionWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$JavaDefinitionWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesClientWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesClientWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLWebServicesClientWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesClientWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientBndWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientBndWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesClientBndWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientBndWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientExtWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientExtWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesClientExtWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesClientExtWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLWebServicesWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLWebServicesWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesBndWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesBndWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesBndWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesBndWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesExtWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesExtWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLIBMWebServicesExtWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLIBMWebServicesExtWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$XMLMappingWriter == null ? (class$com$ibm$ws$webservices$wsdl$toJava$XMLMappingWriter = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.XMLMappingWriter")) : class$com$ibm$ws$webservices$wsdl$toJava$XMLMappingWriter);
        this.genTable.addGenerator(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, class$com$ibm$ws$webservices$wsdl$toJava$JavaDeployGenerator == null ? (class$com$ibm$ws$webservices$wsdl$toJava$JavaDeployGenerator = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.toJava.JavaDeployGenerator")) : class$com$ibm$ws$webservices$wsdl$toJava$JavaDeployGenerator);
    }

    public final Generator getGenerator(Message message, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(class$javax$wsdl$Message == null ? (class$javax$wsdl$Message = JavaGeneratorFactory.class$("javax.wsdl.Message")) : class$javax$wsdl$Message, this.emitter, message, symbolTable);
    }

    public final Generator getGenerator(PortType portType, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(class$javax$wsdl$PortType == null ? (class$javax$wsdl$PortType = JavaGeneratorFactory.class$("javax.wsdl.PortType")) : class$javax$wsdl$PortType, this.emitter, portType, symbolTable);
    }

    public final Generator getGenerator(Binding binding, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(class$javax$wsdl$Binding == null ? (class$javax$wsdl$Binding = JavaGeneratorFactory.class$("javax.wsdl.Binding")) : class$javax$wsdl$Binding, this.emitter, binding, symbolTable);
    }

    public final Generator getGenerator(Service service, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(class$javax$wsdl$Service == null ? (class$javax$wsdl$Service = JavaGeneratorFactory.class$("javax.wsdl.Service")) : class$javax$wsdl$Service, this.emitter, service, symbolTable);
    }

    public final Generator getGenerator(TypeEntry typeEntry, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry == null ? (class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry = JavaGeneratorFactory.class$("com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry")) : class$com$ibm$ws$webservices$wsdl$symbolTable$TypeEntry, this.emitter, typeEntry, symbolTable);
    }

    public final Generator getGenerator(Definition definition, SymbolTable symbolTable) {
        return this.genTable.constructGenerators(class$javax$wsdl$Definition == null ? (class$javax$wsdl$Definition = JavaGeneratorFactory.class$("javax.wsdl.Definition")) : class$javax$wsdl$Definition, this.emitter, definition, symbolTable);
    }

    public void generatorPass(Definition definition, SymbolTable symbolTable) {
        this.setFaultContext(symbolTable);
        this.javifyNames(symbolTable);
        this.resolveNameClashes(symbolTable);
        if (this.emitter.inputMMD != null) {
            this.emitter.inputMMD.postSymbolTable(symbolTable);
        }
        if (this.emitter.isAllWanted()) {
            this.setAllReferencesToTrue(symbolTable);
        } else {
            this.ignoreNonSOAPBindings(symbolTable);
        }
        this.constructSignatures(symbolTable);
        this.emitter.outputMMD.addPackageMappings(this.emitter.getNamespaces());
        this.emitter.outputMMD.fromSymbolTable(symbolTable);
    }

    protected void javifyNames(SymbolTable symbolTable) {
        this.markAnonTypeClashes(symbolTable);
        HashMap<QName, QName> hashMap = new HashMap<QName, QName>();
        int n = 0;
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                Object object2;
                SymTabEntry symTabEntry;
                SymTabEntry symTabEntry2 = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry2 instanceof Type) {
                    this.javifyChildNames(symbolTable, ((Type)symTabEntry2).getChildren());
                }
                if (symTabEntry2.getName() != null) continue;
                if (symTabEntry2 instanceof TypeEntry) {
                    symTabEntry = (TypeEntry)symTabEntry2;
                    String string = ((TypeEntry)symTabEntry).getDimensions();
                    object2 = ((TypeEntry)symTabEntry).getRefType();
                    while (object2 != null) {
                        symTabEntry = object2;
                        string = string + ((TypeEntry)symTabEntry).getDimensions();
                        object2 = ((TypeEntry)symTabEntry).getRefType();
                    }
                    if (symTabEntry.getName() == null) {
                        QName qName = symTabEntry.getQName();
                        if (!(symTabEntry instanceof Type) || !((Type)symTabEntry).isAnonType()) {
                            symTabEntry.setName(this.emitter.getJavaName(qName));
                        } else {
                            object = qName.getLocalPart();
                            object = ((String)object).substring(((String)object).lastIndexOf(">") + 1);
                            String string2 = (String)symTabEntry.getDynamicVar(ANON_TYPE_PREPEND);
                            if (string2 != null) {
                                object = string2 + (String)object;
                            }
                            qName = QNameTable.createQName(qName.getNamespaceURI(), (String)object);
                            symbolTable.getType(qName);
                            if (hashMap.get(qName) != null) {
                                object = (String)object + "Type" + n++;
                                qName = QNameTable.createQName(qName.getNamespaceURI(), (String)object);
                            }
                            hashMap.put(qName, qName);
                            symTabEntry.setName(this.emitter.getJavaName(qName));
                        }
                    }
                    symTabEntry2.setName(symTabEntry.getName() + string);
                    continue;
                }
                if (symTabEntry2 instanceof MessageEntry) {
                    symTabEntry = (MessageEntry)symTabEntry2;
                    if (!((MessageEntry)symTabEntry).isFault() || symTabEntry.getDynamicVar(COMPLEX_TYPE_FAULT) != null && ((Boolean)symTabEntry.getDynamicVar(COMPLEX_TYPE_FAULT)).booleanValue()) continue;
                    symTabEntry2.setName(this.createClassName(symTabEntry2.getQName()));
                    Vector vector2 = ((MessageEntry)symTabEntry).getFaultParts();
                    object2 = new ArrayList();
                    for (int j = 0; j < vector2.size(); ++j) {
                        object = (ChildFaultPartEntry)vector2.elementAt(j);
                        ((Entry)object).setName(JavaUtils.xmlNameToJava(((Entry)object).getQName().getLocalPart()));
                        ((ArrayList)object2).add(((Entry)object).getQName().getLocalPart());
                    }
                    symTabEntry.setDynamicVar(CONSTRUCTOR_ORDER, object2);
                    continue;
                }
                if (symTabEntry2 instanceof ServiceEntry) {
                    symTabEntry2.setName(this.createClassName(symTabEntry2.getQName()));
                    symTabEntry = (ServiceEntry)symTabEntry2;
                    for (int j = 0; j < ((ServiceEntry)symTabEntry).numPorts(); ++j) {
                        object2 = ((ServiceEntry)symTabEntry).getPort(j);
                        String string = ((PortEntry)object2).getPort().getName();
                        if (!JavaUtils.isJavaId(string)) {
                            string = JavaUtils.xmlNameToJavaClass(string);
                        }
                        ((Entry)object2).setName(string);
                    }
                    continue;
                }
                if (symTabEntry2 instanceof BindingEntry) {
                    this.javifyBindingEntry((BindingEntry)symTabEntry2);
                    continue;
                }
                symTabEntry2.setName(this.createClassName(symTabEntry2.getQName()));
            }
        }
    }

    private String createClassName(QName qName) {
        String string = this.emitter.getPackage(qName.getNamespaceURI());
        String string2 = JavaUtils.xmlNameToJavaClass(qName.getLocalPart());
        if (string != null) {
            string2 = string + "." + string2;
        }
        return string2;
    }

    protected void javifyChildNames(SymbolTable symbolTable, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        if (!(vector.get(0) instanceof ChildEnumValueEntry)) {
            for (int i = 0; i < vector.size(); ++i) {
                ChildEntry childEntry = (ChildEntry)vector.get(i);
                String string = JavaUtils.xmlNameToJava(childEntry.getQName().getLocalPart());
                childEntry.setName(this.getAsBeanPropertyName(string));
                if (!(childEntry instanceof ChildElement) || !((ChildElement)childEntry).getAnyElement()) continue;
                childEntry.setName("_any");
            }
        } else {
            ChildEnumValueEntry childEnumValueEntry;
            int n;
            boolean bl = true;
            for (n = 0; n < vector.size() && bl; ++n) {
                childEnumValueEntry = (ChildEnumValueEntry)vector.get(n);
                bl = JavaUtils.isJavaId(childEnumValueEntry.getEnumValue());
            }
            for (n = 0; n < vector.size(); ++n) {
                childEnumValueEntry = (ChildEnumValueEntry)vector.get(n);
                if (bl) {
                    childEnumValueEntry.setName(childEnumValueEntry.getEnumValue());
                    continue;
                }
                childEnumValueEntry.setName("value" + (n + 1));
            }
        }
    }

    protected void javifyBindingEntry(BindingEntry bindingEntry) {
        bindingEntry.setName(this.createClassName(bindingEntry.getQName()));
        Iterator iterator = bindingEntry.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            bindingOperationEntry.setName(JavaUtils.xmlNameToJava(bindingOperationEntry.getQName().getLocalPart()));
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                bindingParamEntry.setName(JavaUtils.xmlNameToJava(bindingParamEntry.getQName().getLocalPart()));
            }
            Vector<String> vector = new Vector<String>(bindingOperationEntry.numParameters());
            for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                int n = 2;
                while (vector.contains(bindingParamEntry.getName())) {
                    bindingParamEntry.setName(bindingParamEntry.getName() + Integer.toString(n++));
                }
                vector.add(bindingParamEntry.getName());
            }
        }
    }

    private String getAsBeanPropertyName(String string) {
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1))) {
            return JavaUtils.capitalizeFirstChar(string);
        }
        return string;
    }

    protected void setFaultContext(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Iterator iterator2 = bindingEntry.getOperations();
                while (iterator2.hasNext()) {
                    BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator2.next();
                    for (int j = 0; j < bindingOperationEntry.numFaults(); ++j) {
                        this.setFaultContext(bindingOperationEntry.getFault(j), symbolTable);
                    }
                }
            }
        }
    }

    private void setFaultContext(BindingFaultRefEntry bindingFaultRefEntry, SymbolTable symbolTable) {
        MessageEntry messageEntry = bindingFaultRefEntry.getMessageEntry();
        if (messageEntry.getFaultParts().size() == 0) {
            messageEntry.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, messageEntry);
            messageEntry.setDynamicVar(CONSTRUCTOR_ORDER, new ArrayList());
            return;
        }
        ChildFaultPartEntry childFaultPartEntry = (ChildFaultPartEntry)messageEntry.getFaultParts().elementAt(0);
        TypeEntry typeEntry = childFaultPartEntry.getType();
        if (typeEntry instanceof Element) {
            typeEntry = typeEntry.getRefType();
        }
        Type type = (Type)typeEntry;
        if (messageEntry.getFaultParts().size() > 1 || type.isSimpleType() || type.getDimensions().length() > 0 && ((Type)type.getRefType()).isSimpleType()) {
            messageEntry.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, messageEntry);
            ArrayList<String> arrayList = new ArrayList<String>();
            Vector vector = messageEntry.getFaultParts();
            for (int i = 0; i < vector.size(); ++i) {
                ChildFaultPartEntry childFaultPartEntry2 = (ChildFaultPartEntry)vector.elementAt(i);
                arrayList.add(childFaultPartEntry2.getQName().getLocalPart());
            }
            messageEntry.setDynamicVar(CONSTRUCTOR_ORDER, arrayList);
        } else {
            messageEntry.setDynamicVar(EXCEPTION_SYMTAB_ENTRY, type);
            messageEntry.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
            Boolean bl = (Boolean)type.getDynamicVar(COMPLEX_TYPE_FAULT);
            if (bl == null || !bl.booleanValue()) {
                Type type2 = type;
                while (type2.getExtensionBase() != null) {
                    type2 = type2.getExtensionBase();
                }
                HashSet hashSet = com.ibm.ws.webservices.wsdl.symbolTable.Utils.getDerivedTypes(type2, symbolTable);
                hashSet.add(type2);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    TypeEntry typeEntry2 = (TypeEntry)iterator.next();
                    typeEntry2.setDynamicVar(COMPLEX_TYPE_FAULT, Boolean.TRUE);
                    this.setConstructorOrder((Type)typeEntry2);
                }
            }
        }
    }

    private void setConstructorOrder(Type type) {
        Vector<Type> vector = new Vector<Type>();
        Type type2 = type;
        while (type2 != null) {
            vector.add(type2);
            if (type2.getExtensionBase() != null) {
                type2 = type2.getExtensionBase();
                continue;
            }
            type2 = type2.getRestrictionBase();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = vector.size() - 1; i >= 0; --i) {
            ChildEntry childEntry;
            int n;
            Type type3 = (Type)vector.elementAt(i);
            Vector vector2 = type3.getChildren();
            if (vector2 == null) continue;
            for (n = 0; n < vector2.size(); ++n) {
                if (!(vector2.get(n) instanceof ChildAttribute)) continue;
                childEntry = (ChildAttribute)vector2.get(n);
                arrayList.add(childEntry.getQName().getLocalPart());
            }
            for (n = 0; n < vector2.size(); ++n) {
                if (!(vector2.get(n) instanceof ChildElement)) continue;
                childEntry = (ChildElement)vector2.get(n);
                arrayList.add(childEntry.getQName().getLocalPart());
            }
        }
        type.setDynamicVar(CONSTRUCTOR_ORDER, arrayList);
    }

    protected void resolveNameClashes(SymbolTable symbolTable) {
        HashSet<Type> hashSet = new HashSet<Type>();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            SymTabEntry symTabEntry;
            boolean bl;
            Object object;
            Vector<TypeEntry> vector = new Vector<TypeEntry>((Vector)iterator.next());
            int n = 0;
            while (n < vector.size()) {
                SymTabEntry symTabEntry2 = (SymTabEntry)vector.elementAt(n);
                if (symTabEntry2 instanceof MessageEntry) {
                    object = (MessageEntry)symTabEntry2;
                    Boolean bl2 = (Boolean)((Entry)object).getDynamicVar(COMPLEX_TYPE_FAULT);
                    if (!((MessageEntry)object).isFault() || bl2 != null && bl2.booleanValue()) {
                        vector.removeElementAt(n);
                        continue;
                    }
                    ++n;
                    continue;
                }
                ++n;
            }
            if (vector.size() <= 1) continue;
            boolean bl3 = bl = !this.sameTypeEntryClasses(vector);
            if (this.emitter.getNoDataBinding()) {
                bl = false;
            }
            if (bl) {
                bl = false;
                object = null;
                for (int i = 0; i < vector.size() && !bl; ++i) {
                    symTabEntry = (SymTabEntry)vector.elementAt(i);
                    if (symTabEntry instanceof MessageEntry || symTabEntry instanceof BindingEntry) continue;
                    if (object == null) {
                        object = symTabEntry.getName();
                        continue;
                    }
                    if (!((String)object).equals(symTabEntry.getName())) continue;
                    bl = true;
                }
            }
            if (!bl) continue;
            boolean bl4 = true;
            for (int i = 0; i < vector.size(); ++i) {
                Object object2;
                symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry instanceof Element) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_ElemType"));
                    object2 = QNameTable.createQName(symTabEntry.getQName().getNamespaceURI(), ">" + symTabEntry.getQName().getLocalPart());
                    Type type = symbolTable.getType((QName)object2);
                    if (type == null) continue;
                    type.setName(symTabEntry.getName());
                    hashSet.add(type);
                    continue;
                }
                if (symTabEntry instanceof TypeEntry) {
                    if (bl4) {
                        bl4 = false;
                        object2 = symbolTable.getTypes();
                        for (int j = 0; j < ((Vector)object2).size(); ++j) {
                            TypeEntry typeEntry = (TypeEntry)((Vector)object2).elementAt(j);
                            if (typeEntry == symTabEntry || typeEntry instanceof Element || typeEntry.isBaseType() || !this.sameJavaClass(((Type)symTabEntry).getName(), typeEntry.getName())) continue;
                            vector.add(typeEntry);
                        }
                    }
                    if (hashSet.contains(symTabEntry)) continue;
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Type"));
                    continue;
                }
                if (symTabEntry instanceof PortTypeEntry) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Port"));
                    continue;
                }
                if (symTabEntry instanceof ServiceEntry) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Service"));
                    continue;
                }
                if (symTabEntry instanceof MessageEntry) {
                    symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Exception"));
                    continue;
                }
                if (!(symTabEntry instanceof BindingEntry) || !((BindingEntry)(object2 = (BindingEntry)symTabEntry)).hasLiteral()) continue;
                symTabEntry.setName(this.mangleName(symTabEntry.getName(), "_Binding"));
            }
        }
        this.resolveJavaNameClashes(symbolTable);
    }

    private boolean sameTypeEntryClasses(Vector vector) {
        SymTabEntry symTabEntry;
        boolean bl = false;
        Vector vector2 = new Vector(vector);
        int n = 0;
        while (n < vector2.size()) {
            symTabEntry = (SymTabEntry)vector2.elementAt(n);
            if (symTabEntry instanceof TypeEntry && ((TypeEntry)symTabEntry).isCollectionTypeEntry()) {
                vector2.remove(n);
                continue;
            }
            ++n;
        }
        if (vector2.size() == 2 && (vector2.elementAt(0) instanceof Element && vector2.elementAt(1) instanceof Type || vector2.elementAt(1) instanceof Element && vector2.elementAt(0) instanceof Type)) {
            TypeEntry typeEntry;
            Element element = null;
            symTabEntry = null;
            if (vector2.elementAt(0) instanceof Element) {
                element = (Element)vector2.elementAt(0);
                symTabEntry = (Type)vector2.elementAt(1);
            } else {
                element = (Element)vector2.elementAt(1);
                symTabEntry = (Type)vector2.elementAt(0);
            }
            for (typeEntry = element.getRefType(); typeEntry != null && typeEntry != symTabEntry; typeEntry = typeEntry.getRefType()) {
            }
            bl = typeEntry == symTabEntry;
        }
        return bl;
    }

    private String mangleName(String string, String string2) {
        int n = string.indexOf("[");
        if (n >= 0) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n);
            return string3 + string2 + string4;
        }
        return string + string2;
    }

    private boolean sameJavaClass(String string, String string2) {
        int n = string.indexOf("[");
        int n2 = string2.indexOf("[");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        return string.equals(string2);
    }

    protected void resolveJavaNameClashes(SymbolTable symbolTable) {
        Object object;
        Object object2;
        HashMap<String, ArrayList<Object>> hashMap = new HashMap<String, ArrayList<Object>>();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            object2 = (Vector)iterator.next();
            for (int i = 0; i < ((Vector)object2).size(); ++i) {
                object = (SymTabEntry)((Vector)object2).elementAt(i);
                String string = ((Entry)object).getName();
                if (!(object instanceof BindingEntry)) continue;
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(string, arrayList);
                }
                arrayList.add(object);
            }
        }
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (string == null || string.equals("") || ((ArrayList)(object = (ArrayList)hashMap.get(string))).size() <= 1) continue;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                this.createNonJAXRPCName((SymTabEntry)((ArrayList)object).get(i));
            }
        }
    }

    private void createNonJAXRPCName(SymTabEntry symTabEntry) {
        String string = symTabEntry.getQName().getLocalPart();
        string = JavaUtils.createNonJAXRPCName(string);
        String string2 = symTabEntry.getName();
        int n = string2.lastIndexOf(46);
        if (n < 0) {
            n = string2.length() - 1;
        }
        string2 = string2.substring(0, n + 1);
        symTabEntry.setName(string2 + string);
    }

    protected void setAllReferencesToTrue(SymbolTable symbolTable) {
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            for (int i = 0; i < vector.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector.elementAt(i);
                if (symTabEntry instanceof BindingEntry) {
                    int n = ((BindingEntry)symTabEntry).getBindingType();
                    if (n == 0 || n == 4) {
                        symTabEntry.setIsReferenced(true);
                        continue;
                    }
                    symTabEntry.setIsReferenced(false);
                    continue;
                }
                symTabEntry.setIsReferenced(true);
            }
        }
    }

    protected void ignoreNonSOAPBindings(SymbolTable symbolTable) {
        Vector<PortTypeEntry> vector = new Vector<PortTypeEntry>();
        Vector<PortTypeEntry> vector2 = new Vector<PortTypeEntry>();
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            Vector vector3 = (Vector)iterator.next();
            for (int i = 0; i < vector3.size(); ++i) {
                SymTabEntry symTabEntry = (SymTabEntry)vector3.elementAt(i);
                if (!(symTabEntry instanceof BindingEntry)) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Binding binding = bindingEntry.getBinding();
                PortType portType = binding.getPortType();
                PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(portType.getQName());
                if (bindingEntry.getBindingType() == 0 || bindingEntry.getBindingType() == 4) {
                    vector2.add(portTypeEntry);
                    if (!vector.contains(portTypeEntry)) continue;
                    vector.remove(portTypeEntry);
                    continue;
                }
                bindingEntry.setIsReferenced(false);
                if (vector2.contains(portTypeEntry)) continue;
                vector.add(portTypeEntry);
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            PortTypeEntry portTypeEntry = (PortTypeEntry)vector.get(i);
            portTypeEntry.setIsReferenced(false);
        }
    }

    protected void constructSignatures(SymbolTable symbolTable) {
        SymTabEntry symTabEntry;
        int n;
        Vector vector;
        Iterator iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            vector = (Vector)iterator.next();
            for (n = 0; n < vector.size(); ++n) {
                symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (!(symTabEntry instanceof BindingEntry) || !symTabEntry.isReferenced()) continue;
                BindingEntry bindingEntry = (BindingEntry)symTabEntry;
                Binding binding = bindingEntry.getBinding();
                PortTypeEntry portTypeEntry = symbolTable.getPortTypeEntry(binding.getPortType().getQName());
                PortType portType = portTypeEntry.getPortType();
                if (bindingEntry.getDynamicVar(INTERFACE_NAME) == null) {
                    bindingEntry.setDynamicVar(INTERFACE_NAME, portTypeEntry.getName());
                }
                if (portTypeEntry.getDynamicVar(IMPL_NAME) == null) {
                    portTypeEntry.setDynamicVar(IMPL_NAME, bindingEntry.getName() + "Impl");
                } else {
                    portTypeEntry.setDynamicVar(IMPL_NAME, (String)bindingEntry.getDynamicVar(INTERFACE_NAME) + "Impl");
                }
                Iterator iterator2 = portType.getOperations().iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Operation operation = (Operation)iterator2.next();
                    OperationType operationType = operation.getStyle();
                    String string2 = operation.getName();
                    BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
                    if (operationType == OperationType.SOLICIT_RESPONSE) {
                        string = "    // " + Messages.getMessage("invalidSolResp00", string2);
                        bindingOperationEntry.setDynamicVar(SIGNATURE, string);
                        this.emitter.getToolEnv().reporterr(Messages.getMessage("invalidSolResp00", string2));
                        continue;
                    }
                    if (operationType == OperationType.NOTIFICATION) {
                        string = "    // " + Messages.getMessage("invalidNotif00", string2);
                        bindingOperationEntry.setDynamicVar(SIGNATURE, string);
                        this.emitter.getToolEnv().reporterr(Messages.getMessage("invalidNotif00", string2));
                        continue;
                    }
                    bindingOperationEntry.setDynamicVar(SIGNATURE, this.constructSignature(symbolTable, bindingOperationEntry));
                }
            }
        }
        iterator = symbolTable.getHashMap().values().iterator();
        while (iterator.hasNext()) {
            vector = (Vector)iterator.next();
            for (n = 0; n < vector.size(); ++n) {
                symTabEntry = (SymTabEntry)vector.elementAt(n);
                if (!(symTabEntry instanceof PortTypeEntry)) continue;
                symTabEntry.setName("");
            }
        }
    }

    private String constructSignature(SymbolTable symbolTable, BindingOperationEntry bindingOperationEntry) {
        Entry entry;
        int n;
        String string = bindingOperationEntry.getName();
        String string2 = "void";
        if (bindingOperationEntry.getReturn() != null) {
            string2 = this.constructParamSigType(bindingOperationEntry.getReturn(), true);
        }
        String string3 = "    public " + string2 + " " + string + "(";
        boolean bl = false;
        for (n = 0; n < bindingOperationEntry.numParameters(); ++n) {
            entry = bindingOperationEntry.getParameter(n);
            if (bl) {
                string3 = string3 + ", ";
            } else {
                bl = true;
            }
            string3 = string3 + this.constructParamSigType((BindingParamEntry)entry, false) + " " + entry.getName();
        }
        string3 = string3 + ") throws java.rmi.RemoteException";
        if (bindingOperationEntry.numFaults() > 0) {
            for (n = 0; n < bindingOperationEntry.numFaults(); ++n) {
                entry = bindingOperationEntry.getFault(n).getMessageEntry();
                SymTabEntry symTabEntry = (SymTabEntry)entry.getDynamicVar(EXCEPTION_SYMTAB_ENTRY);
                String string4 = symTabEntry.getName();
                string3 = string3 + ", " + string4;
            }
        }
        return string3;
    }

    protected String constructHolderName(BindingParamEntry bindingParamEntry) {
        String string = null;
        if (bindingParamEntry.getMode() != 1) {
            TypeEntry typeEntry;
            String string2 = bindingParamEntry.getMIMEType();
            if (string2 != null) {
                if (string2.equals("image/gif") || string2.equals("image/jpeg")) {
                    return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
                }
                if (string2.equals("text/plain")) {
                    return "javax.xml.rpc.holders.StringHolder";
                }
                if (string2.startsWith("multipart/")) {
                    return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
                }
                if (string2.equals("text/xml") || string2.equals("application/xml")) {
                    return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
                }
            }
            if ((string = (String)(typeEntry = bindingParamEntry.getType()).getDynamicVar(HOLDER_NAME)) == null && (string = (String)typeEntry.getDynamicVar(PARAM_SIG_TYPE)) == null) {
                string = this.defaultHolderName(bindingParamEntry);
            }
            typeEntry.setDynamicVar(HOLDER_NAME, string);
            if (typeEntry instanceof Element && !typeEntry.isCollectionTypeEntry() && typeEntry.getRefType() != null) {
                typeEntry.getRefType().setDynamicVar(HOLDER_NAME, string);
            }
        }
        return string;
    }

    protected String constructParamSigType(BindingParamEntry bindingParamEntry, boolean bl) {
        Object object;
        Object object2;
        QName qName = bindingParamEntry.getQName();
        if (bindingParamEntry.getType() instanceof Element) {
            object2 = bindingParamEntry.getType();
            qName = ((Entry)object2).getQName();
            while (object2 instanceof Element && ((TypeEntry)object2).isCollectionTypeEntry()) {
                object2 = ((TypeEntry)object2).getRefType();
            }
            if (object2 instanceof Element) {
                qName = ((Entry)object2).getQName();
            }
        }
        bindingParamEntry.setDynamicVar(PARAM_WIRE_QNAME, qName);
        object2 = (String)bindingParamEntry.getDynamicVar(PARAM_TYPE);
        if (object2 == null) {
            object = bindingParamEntry.getMIMEType();
            if (object == null) {
                object2 = bindingParamEntry.getType().getName();
            } else {
                object2 = JavaUtils.mimeToJava((String)object);
                if (object2 == null) {
                    object2 = bindingParamEntry.getType().getName();
                }
            }
        }
        bindingParamEntry.setDynamicVar(PARAM_TYPE, object2);
        object = object2;
        if (bindingParamEntry.getMode() != 1 && !bl) {
            object = this.constructHolderName(bindingParamEntry);
        }
        bindingParamEntry.setDynamicVar(PARAM_SIG_TYPE, object);
        return object;
    }

    private String defaultHolderName(BindingParamEntry bindingParamEntry) {
        String string;
        String string2 = bindingParamEntry.getMIMEType();
        if (string2 != null) {
            if (string2.equals("image/gif") || string2.equals("image/jpeg")) {
                return "com.ibm.ws.webservices.engine.types.holders.ImageHolder";
            }
            if (string2.equals("text/plain")) {
                return "javax.xml.rpc.holders.StringHolder";
            }
            if (string2.startsWith("multipart/")) {
                return "com.ibm.ws.webservices.engine.types.holders.MimeMultipartHolder";
            }
            if (string2.equals("text/xml") || string2.equals("application/xml")) {
                return "com.ibm.ws.webservices.engine.types.holders.SourceHolder";
            }
        }
        if ((string = (String)bindingParamEntry.getDynamicVar(PARAM_TYPE)).equals("byte[]")) {
            return "javax.xml.rpc.holders.ByteArrayHolder";
        }
        if (string.endsWith("[]")) {
            string = this.emitter.getJavaName(bindingParamEntry.getType().getQName());
            if (string.startsWith("java.")) {
                QName qName = bindingParamEntry.getQName();
                String string3 = qName.getNamespaceURI();
                if (string3 == null || string3.equals("")) {
                    string3 = bindingParamEntry.getParentNamespace();
                    qName = QNameTable.createQName(string3, qName.getLocalPart());
                }
                string = this.emitter.getJavaName(qName);
            }
            string = JavaUtils.replace(string, "[]", "Array");
            string = Utils.addPackageName(string, "holders");
            return string + "Holder";
        }
        if (string.equals("String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string.equals("java.lang.String")) {
            return "javax.xml.rpc.holders.StringHolder";
        }
        if (string.equals("Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (string.equals("java.lang.Object")) {
            return "javax.xml.rpc.holders.ObjectHolder";
        }
        if (string.equals("javax.xml.soap.SOAPElement") || string.equals("com.ibm.ws.webservices.engine.xmlsoap.SOAPElement")) {
            return "com.ibm.ws.webservices.engine.types.holders.SOAPElementHolder";
        }
        if (string.equals("org.w3c.dom.Element")) {
            return "com.ibm.ws.webservices.engine.types.holders.ElementHolder";
        }
        if (string.equals("javax.activation.DataHandler")) {
            return "com.ibm.ws.webservices.engine.types.holders.DataHandlerHolder";
        }
        if (string.equals("int") || string.equals("long") || string.equals("short") || string.equals("float") || string.equals("double") || string.equals("boolean") || string.equals("byte")) {
            return "javax.xml.rpc.holders." + JavaUtils.capitalizeFirstChar(string) + "Holder";
        }
        if (string.startsWith("java.lang.")) {
            return "javax.xml.rpc.holders" + string.substring(string.lastIndexOf(".")) + "WrapperHolder";
        }
        if (string.indexOf(".") < 0) {
            return "javax.xml.rpc.holders" + string + "WrapperHolder";
        }
        if (string.equals("java.math.BigDecimal")) {
            return "javax.xml.rpc.holders.BigDecimalHolder";
        }
        if (string.equals("java.math.BigInteger")) {
            return "javax.xml.rpc.holders.BigIntegerHolder";
        }
        if (string.equals("java.util.Date")) {
            return "com.ibm.ws.webservices.engine.types.holders.DateHolder";
        }
        if (string.equals("java.util.Calendar")) {
            return "javax.xml.rpc.holders.CalendarHolder";
        }
        if (string.equals("javax.xml.namespace.QName")) {
            return "javax.xml.rpc.holders.QNameHolder";
        }
        if (string.startsWith("com.ibm.ws.webservices.engine.types.")) {
            int n = string.lastIndexOf(46);
            String string4 = string.substring(n + 1);
            return "com.ibm.ws.webservices.engine.types.holders." + string4 + "Holder";
        }
        return Utils.addPackageName(string, "holders") + "Holder";
    }

    public void setBaseTypeMapping(BaseTypeMapping baseTypeMapping) {
        this.btm = baseTypeMapping;
    }

    public BaseTypeMapping getBaseTypeMapping() {
        if (this.btm == null) {
            this.btm = new BaseTypeMapping(){
                TypeMapping defaultTM = DefaultTypeMappingImpl.getSingleton();

                public String getBaseName(QName qName) {
                    QName qName2 = QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart());
                    Class clazz = this.defaultTM.getClassForQName(qName2);
                    if (clazz == null) {
                        return null;
                    }
                    return JavaUtils.getTextClassName(clazz.getName());
                }
            };
        }
        return this.btm;
    }

    private void markAnonTypeClashes(SymbolTable symbolTable) {
        Serializable serializable;
        int n;
        Serializable serializable2;
        Serializable serializable3;
        HashMap<Serializable, Serializable> hashMap = new HashMap<Serializable, Serializable>();
        Vector vector = symbolTable.getTypes();
        for (int i = 0; i < vector.size(); ++i) {
            serializable3 = (TypeEntry)vector.elementAt(i);
            serializable2 = ((Entry)((Object)serializable3)).getQName();
            String string = ((QName)serializable2).getLocalPart();
            n = (string = string.substring(string.lastIndexOf(">") + 1)).indexOf(93);
            if (n > 0) {
                string = string.substring(0, n);
            }
            string = JavaUtils.xmlNameToJavaClass(string);
            serializable = (Vector)hashMap.get(serializable2 = QNameTable.createQName(((QName)serializable2).getNamespaceURI(), string));
            if (serializable == null) {
                serializable = new Vector();
                hashMap.put(serializable2, serializable);
            }
            ((Vector)serializable).add(serializable3);
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            String string;
            serializable3 = (Vector)iterator.next();
            serializable2 = new Vector();
            boolean bl = false;
            for (n = 0; n < ((Vector)serializable3).size() && !bl; ++n) {
                serializable = (TypeEntry)((Vector)serializable3).elementAt(n);
                string = "";
                n2 = ((Entry)((Object)serializable)).getQName().getLocalPart().lastIndexOf(">");
                if (n2 > 0) {
                    string = ((Entry)((Object)serializable)).getQName().getLocalPart().substring(0, n2);
                }
                if (!((Vector)serializable2).contains(string)) {
                    ((Vector)serializable2).add(string);
                }
                bl = ((Vector)serializable2).size() > 1;
            }
            if (!bl) continue;
            for (n = 0; n < ((Vector)serializable3).size(); ++n) {
                serializable = (TypeEntry)((Vector)serializable3).elementAt(n);
                string = "";
                n2 = ((Entry)((Object)serializable)).getQName().getLocalPart().lastIndexOf(">");
                if (n2 > 0) {
                    string = ((Entry)((Object)serializable)).getQName().getLocalPart().substring(0, n2);
                }
                if (string.length() <= 0) continue;
                string = JavaUtils.replace(string, ">", "_");
                string = string + '_';
                ((Entry)((Object)serializable)).setDynamicVar(ANON_TYPE_PREPEND, string);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

