/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.xml.rpc.holders.BooleanHolder;

public class JavaImplWriter
extends JavaClassWriter {
    protected Binding binding;
    protected SymbolTable symbolTable;
    protected BindingEntry bEntry;

    protected JavaImplWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, (String)symbolTable.getPortTypeEntry(bindingEntry.getBinding().getPortType().getQName()).getDynamicVar(JavaGeneratorFactory.IMPL_NAME), "templateImpl");
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
        this.bEntry = bindingEntry;
    }

    public void generate() throws IOException {
        if (!this.isFileGenerated(this.getFileName())) {
            super.generate();
        }
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            Operation operation = bindingOperation.getOperation();
            OperationType operationType = operation.getStyle();
            BindingOperationEntry bindingOperationEntry = this.bEntry.getOperation(operation);
            if (operationType == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                printWriter.println();
                continue;
            }
            this.writeOperation(printWriter, bindingOperationEntry);
        }
    }

    protected String getImplementsText() {
        String string = (String)this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
        String string2 = "implements " + string;
        return string2;
    }

    protected void writeOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) throws IOException {
        Object object;
        printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE) + " {");
        for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
            object = bindingOperationEntry.getParameter(i);
            if (((BindingParamEntry)object).getMode() != 2) continue;
            BooleanHolder booleanHolder = new BooleanHolder(false);
            String string = Utils.getConstructorForParam((BindingParamEntry)object, this.symbolTable, booleanHolder);
            if (booleanHolder.value) {
                printWriter.println("        try {");
            }
            printWriter.println("        " + ((Entry)object).getName() + ".value = " + string + ";");
            if (!booleanHolder.value) continue;
            printWriter.println("        } catch (Exception e) {");
            printWriter.println("        }");
        }
        if (bindingOperationEntry.getReturn() != null) {
            TypeEntry typeEntry = bindingOperationEntry.getReturn().getType();
            printWriter.print("        return ");
            if (Utils.isPrimitiveType(typeEntry)) {
                object = typeEntry.getName();
                if ("boolean".equals(object)) {
                    printWriter.println("false;");
                } else if ("byte".equals(object)) {
                    printWriter.println("(byte)-3;");
                } else if ("short".equals(object)) {
                    printWriter.println("(short)-3;");
                } else {
                    printWriter.println("-3;");
                }
            } else {
                printWriter.println("null;");
            }
        }
        printWriter.println("    }");
        printWriter.println();
    }
}

