/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.engine.enum.Style;
import com.ibm.ws.webservices.engine.enum.Use;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.multiprotocol.provider.StubGenerator;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingFaultRefEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingParamEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ChildFaultPartEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.Element;
import com.ibm.ws.webservices.wsdl.symbolTable.Entry;
import com.ibm.ws.webservices.wsdl.symbolTable.MessageEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.symbolTable.Type;
import com.ibm.ws.webservices.wsdl.symbolTable.TypeEntry;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.utils.OperationDescBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;

public class JavaStubWriter
extends JavaClassWriter
implements StubGenerator {
    private BindingEntry bEntry;
    private Binding binding;
    private SymbolTable symbolTable;
    private ArrayList minOccurs0QNames;
    private ArrayList maxOccursNot1QNames;
    private int suffixId = 0;
    private int methodNumber = 0;

    public JavaStubWriter(Emitter emitter, BindingEntry bindingEntry, SymbolTable symbolTable) {
        super(emitter, bindingEntry.getName() + "Stub", "stub");
        this.bEntry = bindingEntry;
        this.binding = bindingEntry.getBinding();
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends com.ibm.ws.webservices.engine.client.Stub ";
    }

    protected String getImplementsText() {
        return "implements " + this.bEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME) + " ";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        PortType portType = this.binding.getPortType();
        HashSet hashSet = JavaStubWriter.getTypesInPortType(portType, this.bEntry, this.symbolTable);
        boolean bl = Utils.hasMIME(this.bEntry);
        boolean bl2 = hashSet.size() > 0 || bl;
        this.writeConstructors(printWriter, bl2);
        if (bl2) {
            this.writeInitTypeMapping(printWriter, hashSet, bl);
        }
        List list = this.binding.getBindingOperations();
        for (int i = 0; i < list.size(); ++i) {
            OperationType operationType;
            Object object;
            BindingOperation bindingOperation = (BindingOperation)list.get(i);
            BindingOperationEntry bindingOperationEntry = this.bEntry.getOperation(bindingOperation.getOperation());
            String string = "";
            String string2 = null;
            Iterator iterator = bindingOperation.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof SOAPOperation)) continue;
                string = ((SOAPOperation)object).getSoapActionURI();
                string2 = ((SOAPOperation)object).getStyle();
                break;
            }
            if ((operationType = (object = bindingOperation.getOperation()).getStyle()) == OperationType.NOTIFICATION || operationType == OperationType.SOLICIT_RESPONSE) {
                printWriter.println(bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE));
                printWriter.println();
                continue;
            }
            this.minOccurs0QNames = new ArrayList();
            this.maxOccursNot1QNames = new ArrayList();
            this.writeGetOperation(printWriter, bindingOperationEntry, string);
            this.writeGetInvoke(printWriter, bindingOperationEntry, string, bl);
            this.writeOperation(printWriter, bindingOperationEntry, string2, operationType == OperationType.ONE_WAY);
            ++this.methodNumber;
        }
    }

    protected void writeConstructors(PrintWriter printWriter, boolean bl) {
        printWriter.println("    public " + this.className + "(java.net.URL endpointURL, javax.xml.rpc.Service service) throws com.ibm.ws.webservices.engine.WebServicesFault {");
        printWriter.println("        if (service == null) {");
        printWriter.println("            super.service = new com.ibm.ws.webservices.engine.client.Service();");
        printWriter.println("        }");
        printWriter.println("        else {");
        printWriter.println("            super.service = service;");
        printWriter.println("        }");
        printWriter.println("        super.engine = ((com.ibm.ws.webservices.engine.client.Service) super.service).getEngine();");
        if (bl) {
            printWriter.println("        initTypeMapping();");
        }
        printWriter.println("        super.cachedEndpoint = endpointURL;");
        printWriter.println("        super.connection = ((com.ibm.ws.webservices.engine.client.Service) super.service).getConnection(endpointURL);");
        printWriter.println("        super.messageContexts = new com.ibm.ws.webservices.engine.MessageContext[" + this.binding.getBindingOperations().size() + "];");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeInitTypeMapping(PrintWriter printWriter, HashSet hashSet, boolean bl) throws IOException {
        Serializable serializable;
        String string = this.bEntry.hasLiteral() ? "com.ibm.ws.webservices.engine.Constants.URI_LITERAL_ENC" : "com.ibm.ws.webservices.engine.Constants.URI_SOAP11_ENC";
        printWriter.println("    private void initTypeMapping() {");
        printWriter.println("        javax.xml.rpc.encoding.TypeMapping tm = super.getTypeMapping(" + string + ");");
        printWriter.println("        java.lang.Class javaType = null;");
        printWriter.println("        javax.xml.namespace.QName xmlType = null;");
        printWriter.println("        com.ibm.ws.webservices.engine.encoding.SerializerFactory sf = null;");
        printWriter.println("        com.ibm.ws.webservices.engine.encoding.DeserializerFactory df = null;");
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            serializable = (TypeEntry)iterator.next();
            if (!JavaStubWriter.needTypeMapping((TypeEntry)serializable, this.emitter)) continue;
            this.writeSerializationInit(printWriter, (Type)serializable);
        }
        if (bl) {
            printWriter.println("        javaType = javax.activation.DataHandler.class;");
            serializable = QNameTable.createQName(this.binding.getQName().getNamespaceURI(), "DataHandler");
            printWriter.println("        xmlType = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + ((QName)serializable).getNamespaceURI() + "\", \"" + ((QName)serializable).getLocalPart() + "\");");
            printWriter.println("        sf = com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory.createFactory(com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerSerializerFactory.class, javaType, xmlType);");
            printWriter.println("        df = com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory.createFactory(com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializerFactory.class, javaType, xmlType);");
            printWriter.println("        if (sf != null || df != null) {");
            printWriter.println("            tm.register(javaType, xmlType, sf, df);");
            printWriter.println("        }");
        }
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, String string) throws IOException {
        String string2 = bindingOperationEntry.getName();
        String string3 = "_" + string2 + "Operation" + this.methodNumber;
        printWriter.println("    private com.ibm.ws.webservices.engine.description.OperationDesc " + string3 + " = null;");
        printWriter.println("    private com.ibm.ws.webservices.engine.description.OperationDesc _get" + string2 + "Operation" + this.methodNumber + "() {");
        printWriter.println("        if (" + string3 + " == null) {");
        OperationDescBuilder operationDescBuilder = OperationDescBuilder.create(bindingOperationEntry, this.bEntry, this.symbolTable);
        operationDescBuilder.writeOperationDesc(printWriter, false, "        ", string3, this.suffixId++);
        this.minOccurs0QNames = operationDescBuilder.getMinOccurs0QNames();
        this.maxOccursNot1QNames = operationDescBuilder.getMaxOccursNot1QNames();
        printWriter.println("        }");
        printWriter.println("        return " + string3 + ";");
        printWriter.println("    }");
        printWriter.println();
    }

    protected void writeGetInvoke(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, String string, boolean bl) throws IOException {
        int n;
        String string2 = bindingOperationEntry.getName();
        String string3 = "_" + string2 + "Index" + this.methodNumber;
        printWriter.println("    private int " + string3 + " = " + this.methodNumber + ";");
        printWriter.println("    private synchronized com.ibm.ws.webservices.engine.client.Stub.Invoke _get" + string2 + "Invoke" + this.methodNumber + "(Object[] parameters) throws com.ibm.ws.webservices.engine.WebServicesFault  {");
        printWriter.println("        com.ibm.ws.webservices.engine.MessageContext mc = super.messageContexts[" + string3 + "];");
        printWriter.println("        if (mc == null) {");
        printWriter.println("            mc = new com.ibm.ws.webservices.engine.MessageContext(super.engine);");
        printWriter.println("            mc.setOperation(_get" + string2 + "Operation" + this.methodNumber + "());");
        if (string == null) {
            string = "";
        }
        printWriter.println("            mc.setUseSOAPAction(true);");
        printWriter.println("            mc.setSOAPActionURI(\"" + string + "\");");
        Use use = bindingOperationEntry.getInputBodyUse();
        Style style = this.bEntry.getBindingStyle();
        if (style == Style.DOCUMENT && bindingOperationEntry.isWrapped()) {
            style = Style.WRAPPED;
        }
        printWriter.println("            mc.setOperationStyle(\"" + style.getName() + "\");");
        printWriter.println("            mc.setOperationUse(\"" + use.getName() + "\");");
        if (use == Use.LITERAL) {
            printWriter.println("            mc.setEncodingStyle(com.ibm.ws.webservices.engine.Constants.URI_LITERAL_ENC);");
            printWriter.println("            mc.setProperty(com.ibm.ws.webservices.engine.client.Call.SEND_TYPE_ATTR, Boolean.FALSE);");
        }
        if (bl || use == Use.LITERAL) {
            printWriter.println("            mc.setProperty(com.ibm.ws.webservices.engine.WebServicesEngine.PROP_DOMULTIREFS, Boolean.FALSE);");
        }
        if (this.minOccurs0QNames.size() > 0) {
            printWriter.println("            java.util.HashSet _set = new java.util.HashSet();");
            for (n = 0; n < this.minOccurs0QNames.size(); ++n) {
                printWriter.println("            _set.add(" + Utils.getNewQName((QName)this.minOccurs0QNames.get(n)) + ");");
            }
            printWriter.println("            mc.setProperty(com.ibm.ws.webservices.engine.MessageContext.PARAM_MINOCCURS_0, _set);");
        }
        if (this.maxOccursNot1QNames.size() > 0) {
            printWriter.println("            java.util.HashSet _set2 = new java.util.HashSet();");
            for (n = 0; n < this.maxOccursNot1QNames.size(); ++n) {
                printWriter.println("            _set2.add(" + Utils.getNewQName((QName)this.maxOccursNot1QNames.get(n)) + ");");
            }
            printWriter.println("            mc.setProperty(com.ibm.ws.webservices.engine.MessageContext.PARAM_MAXOCCURS_NOT1, _set2);");
        }
        printWriter.println("            super.primeMessageContext(mc);");
        printWriter.println("            super.messageContexts[" + string3 + "] = mc;");
        printWriter.println("        }");
        printWriter.println("        try {");
        printWriter.println("            mc = (com.ibm.ws.webservices.engine.MessageContext) mc.clone();");
        printWriter.println("        }");
        printWriter.println("        catch (CloneNotSupportedException cnse) {");
        printWriter.println("            throw com.ibm.ws.webservices.engine.WebServicesFault.makeFault(cnse);");
        printWriter.println("        }");
        printWriter.println("        return new com.ibm.ws.webservices.engine.client.Stub.Invoke(connection, mc, parameters);");
        printWriter.println("    }");
        printWriter.println();
    }

    public static HashSet getTypesInPortType(PortType portType, BindingEntry bindingEntry, SymbolTable symbolTable) {
        Object object;
        HashSet<Operation> hashSet = new HashSet<Operation>();
        HashSet hashSet2 = new HashSet();
        List list = portType.getOperations();
        for (int i = 0; i < list.size(); ++i) {
            object = (Operation)list.get(i);
            hashSet2.addAll(JavaStubWriter.getTypesInOperation(object, bindingEntry));
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object = (TypeEntry)iterator.next();
            if (hashSet.contains(object)) continue;
            hashSet.add((Operation)object);
            hashSet.addAll(Utils.getNestedTypes((TypeEntry)object, symbolTable, true));
        }
        return hashSet;
    }

    public static HashSet getTypesInOperation(Operation operation, BindingEntry bindingEntry) {
        Entry entry;
        int n;
        HashSet hashSet = new HashSet();
        Vector<TypeEntry> vector = new Vector<TypeEntry>();
        BindingOperationEntry bindingOperationEntry = bindingEntry.getOperation(operation);
        for (n = 0; n < bindingOperationEntry.numParameters(); ++n) {
            entry = bindingOperationEntry.getParameter(n);
            vector.add(((BindingParamEntry)entry).getType());
        }
        if (bindingOperationEntry.getReturn() != null) {
            vector.add(bindingOperationEntry.getReturn().getType());
        }
        if (bindingOperationEntry.numFaults() > 0) {
            for (n = 0; n < bindingOperationEntry.numFaults(); ++n) {
                entry = bindingOperationEntry.getFault(n).getMessageEntry();
                for (int i = 0; i < ((MessageEntry)entry).getFaultParts().size(); ++i) {
                    ChildFaultPartEntry childFaultPartEntry = (ChildFaultPartEntry)((MessageEntry)entry).getFaultParts().elementAt(i);
                    vector.add(childFaultPartEntry.getType());
                }
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            hashSet.add(vector.get(n));
        }
        return hashSet;
    }

    private void writeSerializationInit(PrintWriter printWriter, Type type) throws IOException {
        QName qName = type.getQName();
        printWriter.println("        javaType = " + type.getName() + ".class;");
        printWriter.println("        xmlType = com.ibm.ws.webservices.engine.utils.QNameTable.createQName(\"" + qName.getNamespaceURI() + "\", \"" + qName.getLocalPart() + "\");");
        String string = JavaStubWriter.getSerializerFactoryName(type) + ".class";
        String string2 = JavaStubWriter.getDeserializerFactoryName(type) + ".class";
        printWriter.println("        sf = com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory.createFactory(" + string + ", javaType, xmlType);");
        printWriter.println("        df = com.ibm.ws.webservices.engine.encoding.ser.BaseDeserializerFactory.createFactory(" + string2 + ", javaType, xmlType);");
        printWriter.println("        if (sf != null || df != null) {");
        printWriter.println("            tm.register(javaType, xmlType, sf, df);");
        printWriter.println("        }");
        printWriter.println();
    }

    private void writeOperation(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry, String string, boolean bl) throws IOException {
        this.writeComment(printWriter, bindingOperationEntry.getBindingOperation().getOperation().getDocumentationElement());
        String string2 = (String)bindingOperationEntry.getDynamicVar(JavaGeneratorFactory.SIGNATURE);
        printWriter.println(string2 + " {");
        printWriter.println("        if (super.cachedEndpoint == null) {");
        printWriter.println("            throw new com.ibm.ws.webservices.engine.NoEndPointException();");
        printWriter.println("        }");
        if (bindingOperationEntry.numOuts() > 0 || bindingOperationEntry.numInOuts() > 0) {
            printWriter.println("        java.util.Vector _resp = null;");
        }
        String string3 = bindingOperationEntry.getName();
        String string4 = "_get" + string3 + "Invoke" + this.methodNumber;
        printWriter.println("        try {");
        printWriter.print("            ");
        if (bindingOperationEntry.numOuts() > 0 || bindingOperationEntry.numInOuts() > 0) {
            printWriter.print("_resp = ");
        }
        printWriter.print(string4 + "(new java.lang.Object[] {");
        this.writeParameters(printWriter, bindingOperationEntry);
        printWriter.println("}).invoke();");
        printWriter.println();
        printWriter.println("        } catch (com.ibm.ws.webservices.engine.WebServicesFault wsf) {");
        if (bindingOperationEntry.numFaults() > 0) {
            printWriter.println("            Exception e = wsf.getUserException();");
            printWriter.println("            if (e != null) {");
            for (int i = 0; i < bindingOperationEntry.numFaults(); ++i) {
                BindingFaultRefEntry bindingFaultRefEntry = bindingOperationEntry.getFault(i);
                MessageEntry messageEntry = bindingFaultRefEntry.getMessageEntry();
                SymTabEntry symTabEntry = (SymTabEntry)messageEntry.getDynamicVar(JavaGeneratorFactory.EXCEPTION_SYMTAB_ENTRY);
                String string5 = symTabEntry.getName();
                printWriter.println("                if (e instanceof " + string5 + ") {");
                printWriter.println("                    throw (" + string5 + ") e;");
                printWriter.println("                }");
            }
            printWriter.println("            }");
        }
        printWriter.println("            throw wsf;");
        printWriter.println("        } ");
        if (!bl) {
            this.writeResponseHandling(printWriter, bindingOperationEntry);
        }
        printWriter.println("    }");
        printWriter.println();
    }

    private void writeParameters(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) {
        boolean bl = false;
        for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
            BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
            if (bindingParamEntry.getMode() == 2) continue;
            if (bl) {
                printWriter.print(", ");
            } else {
                bl = true;
            }
            String string = bindingParamEntry.getName();
            if (bindingParamEntry.getMode() != 1) {
                string = string + ".value";
            }
            if (bindingParamEntry.getMIMEType() == null) {
                string = Utils.wrapPrimitiveType(bindingParamEntry.getType(), string);
            }
            printWriter.print(string);
        }
    }

    private void writeResponseHandling(PrintWriter printWriter, BindingOperationEntry bindingOperationEntry) {
        int n = bindingOperationEntry.numOuts() + bindingOperationEntry.numInOuts();
        if (n > 0) {
            if (n == 1) {
                if (bindingOperationEntry.getReturn() != null) {
                    this.writeOutputAssign(printWriter, "        ", "return ", bindingOperationEntry.getReturn().getType(), bindingOperationEntry.getReturn().getMIMEType(), "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                } else {
                    int n2 = 0;
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(n2);
                    while (bindingParamEntry.getMode() == 1) {
                        bindingParamEntry = bindingOperationEntry.getParameter(++n2);
                    }
                    String string = bindingParamEntry.getName();
                    this.writeOutputAssign(printWriter, "            ", string + ".value = ", bindingParamEntry.getType(), bindingParamEntry.getMIMEType(), "((com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(0)).getValue()");
                }
            } else {
                if (bindingOperationEntry.getReturn() != null) {
                    printWriter.println("        Object _return = null;");
                }
                printWriter.println("        for (int _i = 0; _i < _resp.size(); ++_i) {");
                printWriter.println("            com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue _param = (com.ibm.ws.webservices.engine.xmlsoap.ext.ParamValue) _resp.get(_i);");
                String string = "if";
                for (int i = 0; i < bindingOperationEntry.numParameters(); ++i) {
                    BindingParamEntry bindingParamEntry = bindingOperationEntry.getParameter(i);
                    if (bindingParamEntry.getMode() == 1) continue;
                    String string2 = bindingParamEntry.getName();
                    String string3 = Utils.getNewQName((QName)bindingParamEntry.getDynamicVar("parameterWireQName"));
                    printWriter.println("            " + string + " (" + string3 + ".equals(_param.getQName())) {");
                    this.writeOutputAssign(printWriter, "                ", string2 + ".value = ", bindingParamEntry.getType(), bindingParamEntry.getMIMEType(), "_param.getValue()");
                    printWriter.println("            }");
                    string = "else if";
                }
                if (bindingOperationEntry.getReturn() != null) {
                    printWriter.println("            else {");
                    printWriter.println("                _return = _param.getValue();");
                    printWriter.println("            }");
                }
                printWriter.println("        }");
                if (bindingOperationEntry.getReturn() != null) {
                    this.writeOutputAssign(printWriter, "        ", "return ", bindingOperationEntry.getReturn().getType(), bindingOperationEntry.getReturn().getMIMEType(), "_return");
                }
            }
        }
    }

    private void writeOutputAssign(PrintWriter printWriter, String string, String string2, TypeEntry typeEntry, String string3, String string4) {
        if (typeEntry != null && typeEntry.getName() != null) {
            printWriter.println(string + "try {");
            printWriter.println(string + "    " + string2 + Utils.getResponseString(typeEntry, string3, string4));
            printWriter.println(string + "} catch (java.lang.Exception _exception) {");
            printWriter.println(string + "    " + string2 + Utils.getResponseString(typeEntry, string3, "super.convert(" + string4 + ", " + typeEntry.getName() + ".class)"));
            printWriter.println(string + "}");
        } else {
            printWriter.println(string + string2 + Utils.getResponseString(typeEntry, string3, string4));
        }
    }

    static boolean needTypeMapping(TypeEntry typeEntry, Emitter emitter) {
        boolean bl = true;
        if (typeEntry.isBaseType() && typeEntry.getRefType() == null && !emitter.getNoDataBinding() || typeEntry.isCollectionTypeEntry() || typeEntry instanceof Element || !typeEntry.isReferenced() || typeEntry.isOnlyWrappedLiteralReferenced()) {
            bl = false;
        }
        return bl;
    }

    static String getSerializerFactoryName(Type type) {
        String string = null;
        string = type.getName().equals("org.w3c.dom.Element") ? "com.ibm.ws.webservices.engine.encoding.ser.ElementSerializerFactory" : (type.getName().equals("javax.xml.soap.SOAPElement") ? "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementSerializerFactory" : (type.getName().endsWith("[]") ? "com.ibm.ws.webservices.engine.encoding.ser.ArraySerializerFactory" : (type.getNode() != null && type.isEnumeration() ? "com.ibm.ws.webservices.engine.encoding.ser.EnumSerializerFactory" : (type.isSimpleType() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleSerializerFactory" : "com.ibm.ws.webservices.engine.encoding.ser.BeanSerializerFactory"))));
        return string;
    }

    static String getDeserializerFactoryName(Type type) {
        String string = null;
        string = type.getName().equals("org.w3c.dom.Element") ? "com.ibm.ws.webservices.engine.encoding.ser.ElementDeserializerFactory" : (type.getName().equals("javax.xml.soap.SOAPElement") ? "com.ibm.ws.webservices.engine.encoding.ser.SOAPElementDeserializerFactory" : (type.getName().endsWith("[]") ? "com.ibm.ws.webservices.engine.encoding.ser.ArrayDeserializerFactory" : (type.getNode() != null && type.isEnumeration() ? "com.ibm.ws.webservices.engine.encoding.ser.EnumDeserializerFactory" : (type.isSimpleType() ? "com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializerFactory" : "com.ibm.ws.webservices.engine.encoding.ser.BeanDeserializerFactory"))));
        return string;
    }
}

