/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.ServiceEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.toJava.XMLClientWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLMappingWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;

public class XMLWebServicesClientWriter
extends XMLClientWriter {
    private String DOCTYPE = "<!DOCTYPE webservicesclient PUBLIC \"-//IBM Corporation, Inc.//DTD J2EE Web services client 1.0//EN\" \"http://www.ibm.com/webservices/dtd/j2ee_web_services_client_1_0.dtd\">";

    public XMLWebServicesClientWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, definition, symbolTable);
    }

    protected String getFileName() {
        return this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + "webservicesclient.xml";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        XMLMappingWriter xMLMappingWriter = new XMLMappingWriter(this.emitter, this.definition, this.symbolTable);
        String string = Utils.getName(this.INFdir) + '/';
        String string2 = string + "wsdl/" + Utils.getWSDLName(this.emitter.getWSDLURI());
        this.emitter.getToolEnv().mkdir(this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + "wsdl");
        String string3 = string + Utils.getName(xMLMappingWriter.getFileName());
        printWriter.println(this.DOCTYPE);
        printWriter.println("<webservicesclient>");
        Map map = this.definition.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object object;
            Service service = (Service)iterator.next();
            ServiceEntry serviceEntry = this.symbolTable.getServiceEntry(service.getQName());
            String string4 = service.getQName().getLocalPart();
            String string5 = service.getQName().getNamespaceURI();
            String string6 = serviceEntry.getName();
            String string7 = "service/" + string4;
            if ((this.emitter.getRole() == Role.CLIENT || this.emitter.getRole() == Role.DEVELOP_CLIENT) && this.emitter.getContainer() == Container.EJB) {
                object = "??SET THIS TO component-name??";
                printWriter.println("  <component-scoped-refs>");
                printWriter.println("    <component-name>" + (String)object + "</component-name>");
            }
            printWriter.println("    <service-ref>");
            printWriter.println("\t<description>WSDL Service " + string4 + "</description>");
            printWriter.println("\t<service-ref-name>" + string7 + "</service-ref-name>");
            printWriter.println("\t<service-interface>" + string6 + "</service-interface>");
            printWriter.println("        <wsdl-file>" + string2 + "</wsdl-file>");
            printWriter.println("        <jaxrpc-mapping-file>" + string3 + "</jaxrpc-mapping-file>");
            printWriter.println("        <service-qname>");
            printWriter.println("            <namespaceURI>" + string5 + "</namespaceURI>");
            printWriter.println("            <localpart>" + string4 + "</localpart>");
            printWriter.println("        </service-qname>");
            object = service.getPorts().values().iterator();
            while (object.hasNext()) {
                Port port2 = (Port)object.next();
                BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port2.getBinding().getQName());
                String string8 = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
                printWriter.println("        <port-component-ref>");
                printWriter.println("            <service-endpoint-interface>" + string8 + "</service-endpoint-interface>");
                printWriter.println("        </port-component-ref>");
            }
            printWriter.println("    </service-ref>");
            if (this.emitter.getRole() != Role.CLIENT && this.emitter.getRole() != Role.DEVELOP_CLIENT || this.emitter.getContainer() != Container.EJB) continue;
            printWriter.println("  </component-scoped-refs>");
        }
        printWriter.println("</webservicesclient>");
    }
}

