/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.webservices.wsdl.symbolTable.BindingEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Container;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaGeneratorFactory;
import com.ibm.ws.webservices.wsdl.toJava.Role;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import com.ibm.ws.webservices.wsdl.toJava.XMLMappingWriter;
import com.ibm.ws.webservices.wsdl.toJava.XMLServerWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;

public class XMLWebServicesWriter
extends XMLServerWriter {
    private String DOCTYPE = "<!DOCTYPE webservices PUBLIC \"-//IBM Corporation, Inc.//DTD J2EE Web services 1.0//EN\" \"http://www.ibm.com/webservices/dtd/j2ee_web_services_1_0.dtd\">";

    public XMLWebServicesWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, definition, symbolTable);
    }

    protected String getFileName() {
        return this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + "webservices.xml";
    }

    protected void writeFileBody(PrintWriter printWriter) throws IOException {
        XMLMappingWriter xMLMappingWriter = new XMLMappingWriter(this.emitter, this.definition, this.symbolTable);
        String string = Utils.getName(this.INFdir) + '/';
        String string2 = string + "wsdl/" + Utils.getWSDLName(this.emitter.getWSDLURI());
        this.emitter.getToolEnv().mkdir(this.INFdir + this.emitter.getToolEnv().getSeparatorChar() + "wsdl");
        String string3 = string + Utils.getName(xMLMappingWriter.getFileName());
        printWriter.println(this.DOCTYPE);
        printWriter.println("<webservices>");
        Map map = this.definition.getServices();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Service service = (Service)iterator.next();
            String string4 = service.getQName().getLocalPart();
            printWriter.println("  <webservice-description>");
            printWriter.println("    <webservice-description-name>" + string4 + "</webservice-description-name>");
            printWriter.println("    <wsdl-file>" + string2 + "</wsdl-file>");
            printWriter.println("    <jaxrpc-mapping-file>" + string3 + "</jaxrpc-mapping-file>");
            Iterator iterator2 = service.getPorts().values().iterator();
            while (iterator2.hasNext()) {
                String string5;
                String string6;
                Port port2 = (Port)iterator2.next();
                BindingEntry bindingEntry = this.symbolTable.getBindingEntry(port2.getBinding().getQName());
                String string7 = (String)bindingEntry.getDynamicVar(JavaGeneratorFactory.INTERFACE_NAME);
                String string8 = port2.getName();
                String string9 = this.definition.getTargetNamespace();
                String string10 = string8;
                if ((this.emitter.getRole() == Role.SERVER || this.emitter.getRole() == Role.DEVELOP_SERVER) && this.emitter.getContainer() == Container.EJB) {
                    string6 = "ejb-link";
                    string5 = "??SET THIS TO ejb-name ELEMENT OF ejb-jar.xml??";
                } else {
                    string6 = "servlet-link";
                    string5 = "??SET THIS TO servlet-name ELEMENT OF web.xml??";
                }
                printWriter.println("    <port-component>");
                printWriter.println("      <port-component-name>" + string10 + "</port-component-name>");
                printWriter.println("      <wsdl-port>");
                printWriter.println("        <namespaceURI>" + string9 + "</namespaceURI>");
                printWriter.println("        <localpart>" + string8 + "</localpart>");
                printWriter.println("      </wsdl-port>");
                printWriter.println("      <service-endpoint-interface>" + string7 + "</service-endpoint-interface>");
                printWriter.println("      <service-impl-bean>");
                printWriter.println("        <" + string6 + ">" + string5 + "</" + string6 + ">");
                printWriter.println("      </service-impl-bean>");
                printWriter.println("    </port-component>");
            }
            printWriter.println("  </webservice-description>");
        }
        printWriter.println("</webservices>");
    }
}

