/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.soap.SOAPException;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws SOAPException {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"javax.xml.soap.FactoryFinder.newInstance", (String)"101");
            throw new SOAPException("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.FactoryFinder.newInstance", (String)"105");
            throw new SOAPException("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string, String string2) throws SOAPException {
        InputStream inputStream;
        String string3;
        ClassLoader classLoader;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.FactoryFinder.find", (String)"131");
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            string3 = System.getProperty(string);
            if (string3 != null) {
                return FactoryFinder.newInstance(string3, classLoader);
            }
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, (String)"javax.xml.soap.FactoryFinder.find", (String)"142");
        }
        try {
            string3 = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jaxm.properties";
            inputStream = (FileInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    File file = new File(string3);
                    if (file.exists()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
            });
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                ((FileInputStream)inputStream).close();
                String string4 = properties.getProperty(string);
                return FactoryFinder.newInstance(string4, classLoader);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.FactoryFinder.find", (String)"164");
        }
        string3 = "META-INF/services/" + string;
        try {
            inputStream = null;
            inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
            if (inputStream != null) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String string5 = bufferedReader.readLine();
                bufferedReader.close();
                if (string5 != null && !"".equals(string5)) {
                    return FactoryFinder.newInstance(string5, classLoader);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.FactoryFinder.find", (String)"192");
        }
        if (string2 == null) {
            throw new SOAPException("Provider for " + string + " cannot be found", null);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }
}

