/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;

public class ContentFormatter
implements IContentFormatter {
    private static final String PARTITIONING = "__formatter_partitioning";
    private Map fStrategies;
    private boolean fIsPartitionAware = true;
    private String[] fPartitionManagingCategories;
    private List fOverlappingPositionReferences;
    private IPositionUpdater fPartitioningUpdater;

    public void setFormattingStrategy(IFormattingStrategy strategy, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            this.fStrategies = new HashMap();
        }
        if (strategy == null) {
            this.fStrategies.remove(contentType);
        } else {
            this.fStrategies.put(contentType, strategy);
        }
    }

    public void setPartitionManagingPositionCategories(String[] categories) {
        this.fPartitionManagingCategories = categories;
    }

    public void enablePartitionAwareFormatting(boolean enable) {
        this.fIsPartitionAware = enable;
    }

    public IFormattingStrategy getFormattingStrategy(String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fStrategies == null) {
            return null;
        }
        return (IFormattingStrategy)this.fStrategies.get(contentType);
    }

    public void format(IDocument document, IRegion region) {
        if (this.fIsPartitionAware) {
            this.formatPartitions(document, region);
        } else {
            this.formatRegion(document, region);
        }
    }

    private void formatPartitions(IDocument document, IRegion region) {
        this.addPartitioningUpdater(document);
        try {
            TypedPosition[] ranges = this.getPartitioning(document, region);
            if (ranges != null) {
                this.start(ranges, this.getIndentation(document, region.getOffset()));
                this.format(document, ranges);
                this.stop(ranges);
            }
        }
        catch (BadLocationException badLocationException) {}
        this.removePartitioningUpdater(document);
    }

    private void formatRegion(IDocument document, IRegion region) {
        IFormattingStrategy strategy = this.getFormattingStrategy("__dftl_partition_content_type");
        if (strategy != null) {
            strategy.formatterStarts(this.getIndentation(document, region.getOffset()));
            this.format(document, strategy, new TypedPosition(region.getOffset(), region.getLength(), "__dftl_partition_content_type"));
            strategy.formatterStops();
        }
    }

    private TypedPosition[] getPartitioning(IDocument document, IRegion region) throws BadLocationException {
        ITypedRegion[] regions = document.computePartitioning(region.getOffset(), region.getLength());
        TypedPosition[] positions = new TypedPosition[regions.length];
        int i = 0;
        while (i < regions.length) {
            positions[i] = new TypedPosition(regions[i]);
            try {
                document.addPosition(PARTITIONING, (Position)positions[i]);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            ++i;
        }
        return positions;
    }

    private void start(TypedPosition[] regions, String indentation) {
        int i = 0;
        while (i < regions.length) {
            IFormattingStrategy s = this.getFormattingStrategy(regions[i].getType());
            if (s != null) {
                s.formatterStarts(indentation);
            }
            ++i;
        }
    }

    private void format(IDocument document, TypedPosition[] ranges) {
        int i = 0;
        while (i < ranges.length) {
            IFormattingStrategy s = this.getFormattingStrategy(ranges[i].getType());
            if (s != null) {
                this.format(document, s, ranges[i]);
            }
            ++i;
        }
    }

    private void format(IDocument document, IFormattingStrategy strategy, TypedPosition region) {
        try {
            int offset = region.getOffset();
            int length = region.getLength();
            String content = document.get(offset, length);
            int[] positions = this.getAffectedPositions(document, offset, length);
            String formatted = strategy.format(content, this.isLineStart(document, offset), this.getIndentation(document, offset), positions);
            RemoveAffectedPositions first = new RemoveAffectedPositions();
            document.insertPositionUpdater((IPositionUpdater)first, 0);
            UpdateAffectedPositions last = new UpdateAffectedPositions(positions, offset);
            document.addPositionUpdater((IPositionUpdater)last);
            document.replace(offset, length, formatted);
            document.removePositionUpdater((IPositionUpdater)first);
            document.removePositionUpdater((IPositionUpdater)last);
        }
        catch (BadLocationException badLocationException) {}
    }

    private void stop(TypedPosition[] regions) {
        int i = 0;
        while (i < regions.length) {
            IFormattingStrategy s = this.getFormattingStrategy(regions[i].getType());
            if (s != null) {
                s.formatterStops();
            }
            ++i;
        }
    }

    private void addPartitioningUpdater(IDocument document) {
        this.fPartitioningUpdater = new NonDeletingPositionUpdater(PARTITIONING);
        document.addPositionCategory(PARTITIONING);
        document.addPositionUpdater(this.fPartitioningUpdater);
    }

    private void removePartitioningUpdater(IDocument document) {
        try {
            document.removePositionUpdater(this.fPartitioningUpdater);
            document.removePositionCategory(PARTITIONING);
            this.fPartitioningUpdater = null;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    private boolean ignoreCategory(String category) {
        if (PARTITIONING.equals(category)) {
            return true;
        }
        if (this.fPartitionManagingCategories != null) {
            int i = 0;
            while (i < this.fPartitionManagingCategories.length) {
                if (this.fPartitionManagingCategories[i].equals(category)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void determinePositionsToUpdate(IDocument document, int offset, int length) {
        String[] categories = document.getPositionCategories();
        if (categories != null) {
            int i = 0;
            while (i < categories.length) {
                if (!this.ignoreCategory(categories[i])) {
                    try {
                        Position[] positions = document.getPositions(categories[i]);
                        int j = 0;
                        while (j < positions.length) {
                            Position p = positions[j];
                            if (p.overlapsWith(offset, length)) {
                                if (offset < p.getOffset()) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(p, true, categories[i]));
                                }
                                if (p.getOffset() + p.getLength() < offset + length) {
                                    this.fOverlappingPositionReferences.add(new PositionReference(p, false, categories[i]));
                                }
                            }
                            ++j;
                        }
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {}
                }
                ++i;
            }
        }
    }

    private int[] getAffectedPositions(IDocument document, int offset, int length) {
        this.fOverlappingPositionReferences = new ArrayList();
        this.determinePositionsToUpdate(document, offset, length);
        Collections.sort(this.fOverlappingPositionReferences);
        int[] positions = new int[this.fOverlappingPositionReferences.size()];
        int i = 0;
        while (i < positions.length) {
            PositionReference r = (PositionReference)this.fOverlappingPositionReferences.get(i);
            positions[i] = r.getCharacterPosition() - offset;
            ++i;
        }
        return positions;
    }

    private void removeAffectedPositions(IDocument document) {
        int size = this.fOverlappingPositionReferences.size();
        int i = 0;
        while (i < size) {
            PositionReference r = (PositionReference)this.fOverlappingPositionReferences.get(i);
            try {
                document.removePosition(r.getCategory(), r.getPosition());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            ++i;
        }
    }

    protected void updateAffectedPositions(IDocument document, int[] positions, int offset) {
        if (positions.length == 0) {
            return;
        }
        int i = 0;
        while (i < positions.length) {
            PositionReference r = (PositionReference)this.fOverlappingPositionReferences.get(i);
            if (r.refersToOffset()) {
                r.setOffset(offset + positions[i]);
            } else {
                r.setLength(offset + positions[i] - r.getOffset());
            }
            Position p = r.getPosition();
            String category = r.getCategory();
            if (!document.containsPosition(category, p.offset, p.length)) {
                try {
                    if (this.positionAboutToBeAdded(document, category, p)) {
                        document.addPosition(r.getCategory(), p);
                    }
                }
                catch (BadPositionCategoryException badPositionCategoryException) {
                }
                catch (BadLocationException badLocationException) {}
            }
            ++i;
        }
        this.fOverlappingPositionReferences = null;
    }

    protected boolean positionAboutToBeAdded(IDocument document, String category, Position position) {
        if ("__childdocuments".equals(category)) {
            try {
                int lineOffset = document.getLineInformationOfOffset(position.offset).getOffset();
                position.setLength(position.length + position.offset - lineOffset);
                position.setOffset(lineOffset);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return true;
    }

    private String getIndentation(IDocument document, int offset) {
        try {
            int start = document.getLineOfOffset(offset);
            int end = start = document.getLineOffset(start);
            char c = document.getChar(end);
            while ('\t' == c || ' ' == c) {
                c = document.getChar(++end);
            }
            return document.get(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private boolean isLineStart(IDocument document, int offset) throws BadLocationException {
        int start = document.getLineOfOffset(offset);
        return (start = document.getLineOffset(start)) == offset;
    }

    static class PositionReference
    implements Comparable {
        protected Position fPosition;
        protected boolean fRefersToOffset;
        protected String fCategory;

        protected PositionReference(Position position, boolean refersToOffset, String category) {
            this.fPosition = position;
            this.fRefersToOffset = refersToOffset;
            this.fCategory = category;
        }

        protected int getOffset() {
            return this.fPosition.getOffset();
        }

        protected void setOffset(int offset) {
            this.fPosition.setOffset(offset);
        }

        protected int getLength() {
            return this.fPosition.getLength();
        }

        protected void setLength(int length) {
            this.fPosition.setLength(length);
        }

        protected boolean refersToOffset() {
            return this.fRefersToOffset;
        }

        protected String getCategory() {
            return this.fCategory;
        }

        protected Position getPosition() {
            return this.fPosition;
        }

        protected int getCharacterPosition() {
            if (this.fRefersToOffset) {
                return this.getOffset();
            }
            return this.getOffset() + this.getLength();
        }

        public int compareTo(Object obj) {
            if (obj instanceof PositionReference) {
                PositionReference r = (PositionReference)obj;
                return this.getCharacterPosition() - r.getCharacterPosition();
            }
            throw new ClassCastException();
        }
    }

    class NonDeletingPositionUpdater
    extends DefaultPositionUpdater {
        protected NonDeletingPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }
    }

    class RemoveAffectedPositions
    implements IPositionUpdater {
        RemoveAffectedPositions() {
        }

        public void update(DocumentEvent event) {
            ContentFormatter.this.removeAffectedPositions(event.getDocument());
        }
    }

    class UpdateAffectedPositions
    implements IPositionUpdater {
        private int[] fPositions;
        private int fOffset;

        public UpdateAffectedPositions(int[] positions, int offset) {
            this.fPositions = positions;
            this.fOffset = offset;
        }

        public void update(DocumentEvent event) {
            ContentFormatter.this.updateAffectedPositions(event.getDocument(), this.fPositions, this.fOffset);
        }
    }
}

